/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.reports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BaseReport {
    private static String cellName = null;
    private static TraceComponent tc = Tr.register(BaseReport.class, "Admin", "com.ibm.ws.management.resources.configarchive");

    public static String getReport() throws Exception {
        throw new Exception("Implementation class must override the getReport method");
    }

    protected static String getCellName() {
        if (cellName == null) {
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            String[] stringArray = configRepository.listResourceNames("cells", 2, 1);
            cellName = stringArray[0].substring(stringArray[0].indexOf("/") + 1);
        }
        return cellName;
    }

    protected static String[] getNodes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodes");
        }
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        String[] stringArray = configRepository.listResourceNames("cells/" + BaseReport.getCellName() + "/nodes", 2, 1);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].substring(stringArray[i].indexOf("/nodes/") + 7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodes", stringArray);
        }
        return stringArray;
    }

    protected static boolean nodeExists(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nodeExists", string);
        }
        boolean bl = false;
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        String[] stringArray = configRepository.listResourceNames("cells/" + BaseReport.getCellName() + "/nodes/" + string, 2, 0);
        if (stringArray.length == 1) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nodeExists", new Object[]{string, bl});
        }
        return bl;
    }

    protected static String getFormattedMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, String string2) {
        try {
            String string3 = resourceBundle.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }
}

