/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.reports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.management.commands.reports.BaseReport;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class ReportConfigInconsistencies
extends BaseReport {
    private static TraceComponent tc = Tr.register(ReportConfigInconsistencies.class, "ReportConfigInconsistencies", "com.ibm.ws.management.commands.reports");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());
    private static String configRoot;

    public static String getReport(AbstractAdminCommand abstractAdminCommand) throws Exception {
        return ReportConfigInconsistencies.getReport();
    }

    public static String getReport() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReport");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.title", new Object[]{ReportConfigInconsistencies.getCellName()}, "Configuration consistency report for cell {0}\n\n"));
        n += ReportConfigInconsistencies.checkForEmptyDocs(stringBuffer);
        n += ReportConfigInconsistencies.checkForInvalidApps(stringBuffer);
        if ((n += ReportConfigInconsistencies.checkForInvalidNodes(stringBuffer)) > 0) {
            stringBuffer.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.summary2", new Object[]{new Integer(n)}, "\n\n{0} consistency problems were found.\n"));
        } else {
            stringBuffer.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.summary1", new Object[0], "\n\nNo consistency problems were found.\n"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReport", stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static int checkForEmptyDocs(StringBuffer stringBuffer) throws Exception {
        File file = ReportConfigInconsistencies.getConfigRootDir();
        int n = 0;
        n = ReportConfigInconsistencies.checkForEmptyDocs(file, n, stringBuffer);
        return n;
    }

    private static int checkForEmptyDocs(File file, int n, StringBuffer stringBuffer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForEmptyDocs", new Object[]{file, new Integer(n)});
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                n = ReportConfigInconsistencies.checkForEmptyDocs(fileArray[i], n, stringBuffer);
                continue;
            }
            if (fileArray[i].length() > 0L) continue;
            ++n;
            String string = fileArray[i].getPath().substring(configRoot.length() + 1);
            stringBuffer.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.zeroLength", new Object[]{string}, "   {0} is a zero byte length file.\n"));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Found zero length file", new Object[]{string, new Integer(n)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForEmptyDocs", new Object[]{file, new Integer(n)});
        }
        return n;
    }

    private static int checkForInvalidApps(StringBuffer stringBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForInvalidApps");
        }
        int n = 0;
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        String[] stringArray = configRepository.listResourceNames("cells/" + ReportConfigInconsistencies.getCellName() + "/applications", 2, 1);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking " + stringArray[i]);
            }
            if ((stringArray2 = configRepository.listResourceNames(stringArray[i] + "/deployments", 2, 1)).length == 0) {
                ++n;
                stringBuffer.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.emptyDeployment", new Object[]{stringArray[i]}, "   Missing contents from deployments folder {0}\n"));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Missing contents from deployments folder", new Object[]{stringArray[i], new Integer(n)});
                continue;
            }
            String string = stringArray2[0];
            if ((stringArray2 = configRepository.listResourceNames(string + "/deployment.xml", 1, 0)).length != 0) continue;
            ++n;
            stringBuffer.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.missingDeployment", new Object[]{stringArray[i]}, "   Missing deployment.xml from {0}\n"));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Missing deployment.xml from", new Object[]{string + "/deployment.xml", new Integer(n)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForInvalidApps", new Integer(n));
        }
        return n;
    }

    private static int checkForInvalidNodes(StringBuffer stringBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForInvalidNodes");
        }
        int n = 0;
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        String[] stringArray = configRepository.listResourceNames("cells/" + ReportConfigInconsistencies.getCellName() + "/nodes", 2, 1);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking " + stringArray[i]);
            }
            if ((stringArray2 = configRepository.listResourceNames(stringArray[i] + "/serverindex.xml", 1, 0)).length != 0) continue;
            ++n;
            stringBuffer.append(ReportConfigInconsistencies.getFormattedMessage(resourceBundle, "report.consistency.missingServerIndex", new Object[]{stringArray[i]}, "   Missing serverindex.xml from {0}\n"));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Missing serverindex.xml", new Object[]{stringArray[i], new Integer(n)});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForInvalidNodes", new Integer(n));
        }
        return n;
    }

    private static File getConfigRootDir() throws Exception {
        File file;
        String string;
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        Properties properties = configRepository.getConfig();
        configRoot = string = properties.getProperty("was.repository.root");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Repository root dir is " + string);
        }
        if (!(file = new File(string)).exists()) {
            throw new Exception(string + " is listed as the repository root directory but it either does not exist or cannot be accessed.");
        }
        if (!file.isDirectory()) {
            throw new Exception(string + " is listed as the repository root directory but it is not a directory.");
        }
        return file;
    }
}

