/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.reports;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.management.commands.reports.BaseReport;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ReportConfiguredPorts
extends BaseReport {
    private static TraceComponent tc = Tr.register(ReportConfiguredPorts.class, "Admin", "com.ibm.ws.management.resources.configarchive");
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.configservice", Locale.getDefault());

    public static String getReport(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = (String)abstractAdminCommand.getParameter("node");
        return ReportConfiguredPorts.getReport(string);
    }

    public static String getReport(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReport", string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ReportConfiguredPorts.getCellName();
        stringBuffer.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.title", new Object[]{string2}, "Ports configured in cell {0}\n\n"));
        if (string != null) {
            ReportConfiguredPorts.getPortsForNode(string, stringBuffer);
        } else {
            String[] stringArray = ReportConfiguredPorts.getNodes();
            for (int i = 0; i < stringArray.length; ++i) {
                ReportConfiguredPorts.getPortsForNode(stringArray[i], stringBuffer);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReport");
        }
        return stringBuffer.toString();
    }

    private static void getPortsForNode(String string, StringBuffer stringBuffer) throws Exception {
        ServerIndex serverIndex;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortsForNode", string);
        }
        if ((serverIndex = ReportConfiguredPorts.getServerIndex(string, stringBuffer)) != null) {
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                String string2 = serverEntry.getServerName();
                stringBuffer.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.nodeAndServer", new Object[]{string, string2}, "\n\nNode {0} / Server {1}\n"));
                EList eList2 = serverEntry.getSpecialEndpoints();
                for (int j = 0; j < eList2.size(); ++j) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(j);
                    String string3 = namedEndPoint.getEndPointName();
                    EndPoint endPoint = namedEndPoint.getEndPoint();
                    String string4 = endPoint.getHost();
                    int n = endPoint.getPort();
                    stringBuffer.append("    " + string4 + ":" + n + " " + string3 + "\n");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPortsForNode", string);
        }
    }

    private static ServerIndex getServerIndex(String string, StringBuffer stringBuffer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndex", string);
        }
        String string2 = "cells/" + ReportConfiguredPorts.getCellName() + "/nodes/" + string + "/serverindex.xml";
        ServerIndex serverIndex = null;
        Resource resource = null;
        WASResourceSetImpl wASResourceSetImpl = null;
        DocumentContentSource documentContentSource = null;
        try {
            documentContentSource = ConfigRepositoryFactory.getConfigRepository().extract(string2);
            wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
            resource = wASResourceSetImpl.createResource(uRI);
            if (resource != null) {
                resource.load(documentContentSource.getSource(), new HashMap());
                serverIndex = (ServerIndex)resource.getContents().get(0);
            }
        }
        catch (Exception exception) {
            if (ReportConfiguredPorts.nodeExists(string)) {
                stringBuffer.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.problemNode", new Object[]{string, exception.getMessage()}, "\n\nThere is a problem accessing the information for node {0}: {1}\n"));
            }
            stringBuffer.append(ReportConfiguredPorts.getFormattedMessage(resourceBundle, "report.ports.invalidNode", new Object[]{string}, "\n\n {0} is not a valid node name\n"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndex", string);
        }
        return serverIndex;
    }
}

