/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.HashSet;
import javax.management.ObjectName;

public class GetServerType
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GetServerType.class, "GetServerType", "com.ibm.ws.management.commands.server");
    private ObjectName server = null;

    public GetServerType(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GetServerType(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        if (this.getParameter("serverName") == null) {
            this.setServerAndNode(session);
        }
        if (this.getParameter("nodeName") == null) {
            this.setNode(session);
        }
        super.validate();
        String string = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", string);
        }
        String string2 = (String)this.getParameter("serverName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName", string2);
        }
        try {
            ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=" + string2);
            if (objectNameArray.length != 1) {
                String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0005E", new Object[]{string, string2}, null);
                throw new CommandValidationException(string3);
            }
            this.server = objectNameArray[0];
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.server.validate", "77");
            throw new CommandValidationException(throwable, "validation for command GetServerType failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            String string = this.getServerType();
            taskCommandResultImpl.setResult(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.server.validate", "94");
            taskCommandResultImpl.setException(new CommandException(throwable, "GetServerType command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", string);
        }
        Object[] objectArray = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (string.equals("serverName")) {
                ObjectName[] objectNameArray = configService.resolve(session, "Cell=:Node=:Server=");
                objectArray = new String[objectNameArray.length];
                for (int i = 0; i < objectNameArray.length; ++i) {
                    objectArray[i] = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                }
            } else if (string.equals("nodeName")) {
                HashSet<String> hashSet = new HashSet<String>();
                ObjectName[] objectNameArray = configService.resolve(session, "Cell=:Node=:Server=" + (String)this.getParameter("serverName"));
                for (int i = 0; i < objectNameArray.length; ++i) {
                    String string2 = ConfigServiceHelper.getObjectLocation(objectNameArray[i]).getProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeName", string2);
                    }
                    hashSet.add(string2);
                }
                objectArray = hashSet.toArray();
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.GetServerType.getChoices", "111");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return objectArray;
    }

    private void setServerAndNode(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerAndNode", session);
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] objectNameArray = configService.resolve(session, "Cell=:Node=");
            if (objectNameArray.length == 1) {
                this.setParameter("nodeName", ConfigServiceHelper.getDisplayName(objectNameArray[0]));
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server");
                objectNameArray = configService.queryConfigObjects(session, objectNameArray[0], objectName, null);
                if (objectNameArray.length == 1) {
                    this.setParameter("serverName", ConfigServiceHelper.getDisplayName(objectNameArray[0]));
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.server.setConfigSession", "160");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerAndNode");
        }
    }

    private void setNode(Session session) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setNode", session);
            }
            try {
                ConfigService configService;
                ObjectName[] objectNameArray;
                if (this.getParameter("nodeName") == null && (objectNameArray = (configService = ConfigServiceFactory.getConfigService()).resolve(session, "Cell=:Node=:Server=" + (String)this.getParameter("serverName"))).length == 1) {
                    String string = ConfigServiceHelper.getObjectLocation(objectNameArray[0]).getProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeName", string);
                    }
                    this.setParameter("nodeName", string);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNode");
        }
    }

    private String getServerType() throws Exception {
        WorkSpace workSpace;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GetServerType", this.server);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String string = (String)configService.getAttribute(session, this.server, "serverType");
        String string2 = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", string2);
        }
        if ((bl = (workSpace = WorkspaceHelper.getWorkspace(session)).getMetadataHelper().getNodeMajorVersion(string2).equals("5")) && "APPLICATION_SERVER".equals(string) && this.is5XGenericServer(this.server)) {
            string = "GENERIC_SERVER";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GetServerType", string);
        }
        return string;
    }

    private boolean is5XGenericServer(ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is5XGenericServer", objectName);
        }
        boolean bl = false;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName2 = (ObjectName)configService.getAttribute(session, objectName, "processDefinition", false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processDef", objectName2);
        }
        if (objectName2 != null) {
            String string = ConfigServiceHelper.getConfigDataType(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processDefType", string);
            }
            if (string.equals("ProcessDef")) {
                bl = true;
            } else {
                String string2 = (String)configService.getAttribute(session, objectName2, "executableName");
                if (string2 != null && string2.indexOf("java") < 0 && !string2.equals("/QSYS.LIB/QEJBAS5.LIB/QEJBSVR.PGM")) {
                    bl = true;
                } else {
                    String string3 = (String)configService.getAttribute(session, objectName2, "executableTarget");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "executableTarget", string3);
                    }
                    if (string3 != null && !string3.equals("com.ibm.ws.runtime.WsServer")) {
                        bl = true;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is5XGenericServer" + bl);
        }
        return bl;
    }
}

