/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.ObjectName;

public class ListServers
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListServers.class, "ListServers", "com.ibm.ws.management.commands.server");
    private ObjectName scope = null;

    public ListServers(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ListServers(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String string = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", string);
        }
        String string2 = (String)this.getParameter("serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", string2);
        }
        try {
            if (string != null) {
                ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string);
                if (objectNameArray.length != 1) {
                    throw new InvalidParameterValueException(this.getName(), "nodeName", string);
                }
                this.scope = objectNameArray[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scope", this.scope);
                }
            }
            if (string2 != null && !this.listServerTypes().contains(string2)) {
                throw new InvalidParameterValueException(this.getName(), "serverType", string2);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.server.validate", "83");
            throw new CommandValidationException(throwable, "validation for command listServers failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, this.scope, objectName, null);
            String string = (String)this.getParameter("serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expectedServerType", string);
            }
            List<Object> list = new ArrayList(objectNameArray.length);
            if (string != null) {
                for (int i = 0; i < objectNameArray.length; ++i) {
                    String string2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "servers[" + i + "]", objectNameArray[i]);
                    }
                    if ((string2 = this.getServerType(objectNameArray[i])) == null || !string.equals(string2)) continue;
                    list.add(objectNameArray[i]);
                }
            } else {
                list = Arrays.asList(objectNameArray);
            }
            taskCommandResultImpl.setResult(list);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.server.validate", "94");
            taskCommandResultImpl.setException(new CommandException(throwable, "getServerType command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", string);
        }
        Object[] objectArray = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (string.equals("nodeName")) {
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
                objectArray = new String[objectNameArray.length];
                for (int i = 0; i < objectNameArray.length; ++i) {
                    objectArray[i] = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                }
            } else if (string.equals("serverType")) {
                List list = this.listServerTypes();
                objectArray = list.toArray();
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ListServer.getChoices", "147");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return objectArray;
    }

    private List listServerTypes() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTypes");
        }
        AdminCommand adminCommand = CommandMgr.getCommandMgr().createCommand("listServerTypes");
        adminCommand.setConfigSession(this.getConfigSession());
        if (this.getParameter("nodeName") != null) {
            adminCommand.setTargetObject(this.getParameter("nodeName"));
        }
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (!commandResult.isSuccessful()) {
            throw commandResult.getException();
        }
        List list = (List)commandResult.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTypes", list);
        }
        return list;
    }

    private String getServerType(ObjectName objectName) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerType", objectName);
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = properties.getProperty("node");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", string);
        }
        if (string == null || string.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No node present.  Return now");
            }
            return null;
        }
        String string2 = properties.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "svrName", string2);
        }
        AdminCommand adminCommand = CommandMgr.getCommandMgr().createCommand("getServerType");
        adminCommand.setConfigSession(this.getConfigSession());
        adminCommand.setParameter("nodeName", string);
        adminCommand.setParameter("serverName", string2);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (!commandResult.isSuccessful()) {
            throw commandResult.getException();
        }
        String string3 = (String)commandResult.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", string3);
        }
        return string3;
    }
}

