/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.management.commands.server.CreateApplicationServer;
import com.ibm.ws.management.commands.server.CreateApplicationServerTemplate;
import com.ibm.ws.management.commands.server.GetServerType;
import com.ibm.ws.management.commands.server.ListServers;
import com.ibm.ws.management.commands.server.ServerConfigHelper;
import com.ibm.ws.management.commands.server.ShowServerInfo;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.management.util.PlatformClusterConfigHelper;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.wsspi.management.commands.server.CreateServerTemplate;
import com.ibm.wsspi.management.commands.server.DeleteServer;
import com.ibm.wsspi.management.commands.server.DeleteServerTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ServerConfigCommands
extends SimpleCommandProvider {
    private static TraceComponent tc = Tr.register(ServerConfigCommands.class, "management", "com.ibm.ws.management.resources.configservice");

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        String string = commandMetadata.getName();
        if (string.equals("createApplicationServerTemplate")) {
            return new CreateApplicationServerTemplate((TaskCommandMetadata)commandMetadata);
        }
        if (string.equals("createApplicationServer")) {
            return new CreateApplicationServer((TaskCommandMetadata)commandMetadata);
        }
        if (string.equals("deleteServerTemplate")) {
            return new DeleteServerTemplate((TaskCommandMetadata)commandMetadata);
        }
        if (string.equals("deleteServer")) {
            return new DeleteServer((TaskCommandMetadata)commandMetadata);
        }
        if (string.equals("getServerType")) {
            return new GetServerType((TaskCommandMetadata)commandMetadata);
        }
        if (string.equals("listServers")) {
            return new ListServers((TaskCommandMetadata)commandMetadata);
        }
        if (string.equals("showServerInfo")) {
            return new ShowServerInfo((TaskCommandMetadata)commandMetadata);
        }
        return super.createCommand(commandMetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        String string = commandData.getName();
        if (string.equals("createApplicationServerTemplate")) {
            return new CreateServerTemplate(commandData);
        }
        if (string.equals("deleteServerTemplate")) {
            return new DeleteServerTemplate(commandData);
        }
        if (string.equals("createApplicationServer")) {
            return new CreateApplicationServer(commandData);
        }
        if (string.equals("deleteServer")) {
            return new DeleteServer(commandData);
        }
        if (string.equals("getServerType")) {
            return new GetServerType(commandData);
        }
        if (string.equals("listServers")) {
            return new ListServers(commandData);
        }
        if (string.equals("showServerInfo")) {
            return new ShowServerInfo(commandData);
        }
        return super.loadCommand(commandData);
    }

    public AttributeList showTemplateInfo(AdminCommand adminCommand) throws Exception {
        RepositoryContext repositoryContext;
        Object object;
        WorkSpace workSpace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showTemplateInfo", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)adminCommand.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Target: " + objectName);
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = properties.getProperty("servertype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerType: " + string);
        }
        String string2 = properties.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + string2);
        }
        if (string2.endsWith("|server.xml")) {
            string2 = string2.substring(0, string2.indexOf("|server.xml"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server: " + string2);
            }
        }
        AttributeList attributeList = new AttributeList();
        PropertySet propertySet = null;
        if (string != null) {
            propertySet = ServerConfigHelper.getMetadata(session, configService, string, string2);
        } else {
            workSpace = WorkspaceHelper.getWorkspace(session);
            object = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
            repositoryContext = workSpace.findContext((String)object);
            propertySet = TemplateConfigHelper.getPropertySetFromServerType(configService, session, repositoryContext);
        }
        if (propertySet == null) {
            throw new ConfigServiceException("No metadata associated with template: " + objectName);
        }
        workSpace = propertySet.getProperties();
        object = workSpace.iterator();
        while (object.hasNext()) {
            repositoryContext = (Property)object.next();
            attributeList.add(new Attribute(repositoryContext.getName(), repositoryContext.getValue()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showTemplateInfo", attributeList);
        }
        return attributeList;
    }

    public List listServerTypes(AdminCommand adminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTypes", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = (String)adminCommand.getTargetObject();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        try {
            Collection collection = ServerConfigHelper.getServertypesContexts(workSpace);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
                if (repositoryContext.getName().trim().equals("")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding ServerType: " + repositoryContext.getName());
                }
                arrayList.add(repositoryContext.getName());
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTypes", new Object[]{arrayList});
        }
        return arrayList;
    }

    public List listServerTemplates(AdminCommand adminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTemplates", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        List list = new ArrayList();
        String string = (String)adminCommand.getParameter("serverType");
        String string2 = (String)adminCommand.getParameter("name");
        String string3 = (String)adminCommand.getParameter("version");
        String[] stringArray = (String[])adminCommand.getParameter("queryExp");
        String string4 = (String)adminCommand.getParameter("nodeName");
        if (string2 != null && string2.trim().length() > 0 || string3 != null && string3.length() > 0) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                linkedList.add(stringArray[i]);
            }
            if (string2 != null && string2.trim().length() > 0) {
                linkedList.add("name=" + string2);
            }
            if (string3 != null && string3.length() > 0 && string3.startsWith("6.1")) {
                linkedList.add("com.ibm.websphere.baseProductMajorVersion=6.1");
            } else if (string3 != null && string3.length() > 0) {
                if (string3.indexOf(".") > 0) {
                    string3 = string3.substring(0, string3.indexOf("."));
                }
                linkedList.add("com.ibm.websphere.baseProductMajorVersion=" + string3);
            }
            stringArray = linkedList.toArray(new String[0]);
        }
        list = ServerConfigHelper.listServerTemplates(configService, session, string, stringArray, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTemplates");
        }
        return list;
    }

    public String createServerType(AdminCommand adminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerType", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        String string = (String)adminCommand.getParameter("serverType");
        String string2 = (String)adminCommand.getParameter("createTemplateCommand");
        String string3 = (String)adminCommand.getParameter("createCommand");
        String string4 = (String)adminCommand.getParameter("version");
        String string5 = (String)adminCommand.getParameter("defaultTemplateName");
        String string6 = (String)adminCommand.getParameter("defaultzOSTemplateName");
        String string7 = (String)adminCommand.getParameter("configValidator");
        if (ServerConfigHelper.doesServerTypeExist(configService, session, string)) {
            throw new ConfigServiceException("Server Type: " + string + " already exists");
        }
        ObjectName objectName = ServerConfigHelper.buildServerType(configService, session, string);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(objectName));
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "name");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string);
        docAccessor.createRootConfigObject(session, "Property", attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "createCommand");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string2);
        docAccessor.createRootConfigObject(session, "Property", attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "createTemplateCommand");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string3);
        docAccessor.createRootConfigObject(session, "Property", attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "version");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string4);
        docAccessor.createRootConfigObject(session, "Property", attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "defaultTemplateName");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string5);
        docAccessor.createRootConfigObject(session, "Property", attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "defaultzOSTemplateName");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string6);
        docAccessor.createRootConfigObject(session, "Property", attributeList);
        attributeList.clear();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "configValidator");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", string7);
        docAccessor.createRootConfigObject(session, "Property", attributeList);
        attributeList.clear();
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerType");
        }
        return "";
    }

    public AttributeList showServerTypeInfo(AdminCommand adminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showServerTypeInfo", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        String string = (String)adminCommand.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType ", string);
        }
        AttributeList attributeList = new AttributeList();
        ObjectName objectName = ServerConfigHelper.buildServerType(configService, session, string);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(objectName));
        ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
            Object object = configService.getAttribute(session, objectNameArray[i], "value");
            attributeList.add(new Attribute(string2, object));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showServerTypeInfo", attributeList);
        }
        return attributeList;
    }

    public void changeServerSpecificShortName(AdminCommand adminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerSpecificShortName", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        String string = (String)adminCommand.getParameter("nodeName");
        String string2 = (String)adminCommand.getParameter("serverName");
        String string3 = (String)adminCommand.getParameter("specificShortName");
        if (!ServerConfigCommands.isNodeZOS(session, string)) {
            throw new InvalidParameterValueException(adminCommand.getName(), "nodeName", string + " is not zOS");
        }
        if (!ServerConfigCommands.isValidShortName(string3)) {
            throw new InvalidParameterValueException(adminCommand.getName(), "specificShortName", string3);
        }
        String string4 = "Node=" + string;
        ObjectName[] objectNameArray = configService.resolve(session, string4);
        ObjectName objectName = null;
        if (objectNameArray.length <= 0) {
            throw new InvalidParameterValueException(adminCommand.getName(), "nodeName", string);
        }
        objectName = objectNameArray[0];
        String string5 = "Node=" + string + ":Server=" + string2;
        objectNameArray = configService.resolve(session, string5);
        ObjectName objectName2 = null;
        if (objectNameArray.length <= 0) {
            throw new InvalidParameterValueException(adminCommand.getName(), "serverName", string2);
        }
        objectName2 = objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + objectName2);
        }
        PlatformServerConfigHelper platformServerConfigHelper = ConfigHelperFactory.getPlatformServerConfigHelper((Node)MOFUtil.convertToEObject(session, objectName));
        Server server2 = (Server)MOFUtil.convertToEObject(session, objectName2);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "shortName", string3);
        configService.setAttributes(session, objectName2, attributeList);
        platformServerConfigHelper.modifyShortName(server2, "Server");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerSpecificShortName");
        }
    }

    public void changeServerGenericShortName(AdminCommand adminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerGenericShortName", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        String string = (String)adminCommand.getParameter("nodeName");
        String string2 = (String)adminCommand.getParameter("serverName");
        String string3 = (String)adminCommand.getParameter("genericShortName");
        if (!ServerConfigCommands.isNodeZOS(session, string)) {
            throw new InvalidParameterValueException(adminCommand.getName(), "nodeName", string + " is not zOS");
        }
        if (!ServerConfigCommands.isValidShortName(string3)) {
            throw new InvalidParameterValueException(adminCommand.getName(), "specificShortName", string3);
        }
        String string4 = "Node=" + string;
        ObjectName[] objectNameArray = configService.resolve(session, string4);
        ObjectName objectName = null;
        if (objectNameArray.length <= 0) {
            throw new InvalidParameterValueException(adminCommand.getName(), "nodeName", string);
        }
        objectName = objectNameArray[0];
        String string5 = "Node=" + string + ":Server=" + string2;
        objectNameArray = configService.resolve(session, string5);
        ObjectName objectName2 = null;
        if (objectNameArray.length <= 0) {
            throw new InvalidParameterValueException(adminCommand.getName(), "serverName", string2);
        }
        objectName2 = objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + objectName2);
        }
        PlatformServerConfigHelper platformServerConfigHelper = ConfigHelperFactory.getPlatformServerConfigHelper((Node)MOFUtil.convertToEObject(session, objectName));
        Server server2 = (Server)MOFUtil.convertToEObject(session, objectName2);
        platformServerConfigHelper.modifyClusterShortName(server2, "Server", string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerGenericShortName");
        }
    }

    public void changeClusterShortName(AdminCommand adminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeClusterShortName", new Object[]{adminCommand});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = adminCommand.getConfigSession();
        String string = (String)adminCommand.getParameter("clusterName");
        String string2 = (String)adminCommand.getParameter("shortName");
        if (!ServerConfigCommands.isAnyNodeZOS(configService, session)) {
            throw new Exception("The cluster is not zOS");
        }
        if (!ServerConfigCommands.isValidShortName(string2)) {
            throw new InvalidParameterValueException(adminCommand.getName(), "shortName", string2);
        }
        String string3 = "ServerCluster=" + string;
        ObjectName[] objectNameArray = configService.resolve(session, string3);
        ObjectName objectName = null;
        if (objectNameArray.length <= 0) {
            throw new InvalidParameterValueException(adminCommand.getName(), "clusterName", string);
        }
        objectName = objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster: " + objectName);
        }
        objectNameArray = configService.resolve(session, "Node");
        ObjectName objectName2 = objectNameArray[0];
        PlatformClusterConfigHelper platformClusterConfigHelper = ConfigHelperFactory.getPlatformClusterConfigHelper((Node)MOFUtil.convertToEObject(session, objectName2));
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "shortName", string2);
        configService.setAttributes(session, objectName, attributeList);
        ServerCluster serverCluster = (ServerCluster)MOFUtil.convertToEObject(session, objectName);
        platformClusterConfigHelper.modifyClusterShortName(serverCluster);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeClusterShortName");
        }
    }

    private static boolean isValidShortName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidShortName", string);
        }
        boolean bl = true;
        if (string == null || string.length() > 8) {
            bl = false;
        }
        for (int i = 0; string != null && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && Character.isDigit(c)) {
                bl = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "First char is digit ", string);
                break;
            }
            if (!Character.isLetterOrDigit(c)) {
                bl = false;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Not letter or digit ", string);
                break;
            }
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            bl = false;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Letter is not uppercase ", string);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidShortName", new Boolean(bl));
        }
        return bl;
    }

    protected static boolean isNodeZOS(Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeZOS", string);
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        boolean bl = managedObjectMetadataHelper.isNodeZOS(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeZOS", new Boolean(bl));
        }
        return bl;
    }

    private static boolean isAnyNodeZOS(ConfigService configService, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAnyNodeZOS");
        }
        boolean bl = false;
        ObjectName[] objectNameArray = configService.resolve(session, "Node");
        if (objectNameArray.length > 0) {
            ObjectName objectName = objectNameArray[0];
            String string = ConfigServiceHelper.getDisplayName(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NodeName: " + string);
            }
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
            bl = managedObjectMetadataHelper.isNodeZOS(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAnyNodeZOS", new Boolean(bl));
        }
        return bl;
    }
}

