/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.server.BestTemplates;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.ServerDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ServerConfigHelper {
    public static final String APPLICATION_SERVER_TYPE = "APPLICATION_SERVER";
    private static TraceComponent tc = Tr.register(ServerConfigHelper.class, "management", "com.ibm.ws.management.resources.configservice");

    public static List listServerTemplates(ConfigService configService, Session session, String string, String[] stringArray) throws Exception {
        return ServerConfigHelper.listServerTemplates(configService, session, string, stringArray, null);
    }

    public static List listServerTemplates(ConfigService configService, Session session, String string, String[] stringArray, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listServerTemplates", new Object[]{configService, session, string, stringArray, string2});
        }
        ArrayList arrayList = new ArrayList();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        try {
            TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
            RepositoryContext repositoryContext = templateManager.getRootTemplateContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servertypes");
            RepositoryContextType repositoryContextType2 = repositoryMetaData.getContextType("servers");
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerType Specified: " + string);
                }
                RepositoryContext repositoryContext2 = repositoryContext.getChild(repositoryContextType, string);
                List list = ServerConfigHelper.getTemplatesFromServerType(session, configService, repositoryContext2, string, stringArray, string2);
                arrayList.addAll(list);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerType NOT Specified: ");
                }
                List list = repositoryContext.getChildren();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    RepositoryContext repositoryContext3 = (RepositoryContext)iterator.next();
                    if (repositoryContext3.getName().trim().equals("")) continue;
                    List list2 = ServerConfigHelper.getTemplatesFromServerType(session, configService, repositoryContext3, string, stringArray, string2);
                    arrayList.addAll(list2);
                }
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listServerTemplates");
        }
        return arrayList;
    }

    protected static List getTemplatesFromServerType(Session session, ConfigService configService, RepositoryContext repositoryContext, String string, String[] stringArray) throws Exception {
        return ServerConfigHelper.getTemplatesFromServerType(session, configService, repositoryContext, string, stringArray, null);
    }

    protected static List getTemplatesFromServerType(Session session, ConfigService configService, RepositoryContext repositoryContext, String string, String[] stringArray, String string2) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplatesFromServerType", new Object[]{session, configService, repositoryContext, string, stringArray, string2});
        }
        boolean bl = false;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3;
                if (stringArray[i] == null) continue;
                int n = stringArray[i].indexOf("=");
                int n2 = stringArray[i].indexOf("!=");
                if (n <= 0 && n2 <= 0) continue;
                if (n2 > 0) {
                    object = stringArray[i].substring(0, n2);
                    string3 = stringArray[i].substring(n2 + 2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding NOT to query list: ", new Object[]{object, string3});
                    }
                    properties2.setProperty((String)object, string3);
                    bl = true;
                    continue;
                }
                object = stringArray[i].substring(0, n);
                string3 = stringArray[i].substring(n + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding equal to query list: ", new Object[]{object, string3});
                }
                properties.setProperty((String)object, string3);
                bl = true;
            }
        }
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        List<ObjectName> list = new ArrayList();
        List list2 = repositoryContext.getChildren();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Context: " + list2);
        }
        if (list2 != null) {
            object = list2.iterator();
            int n = 0;
            BestTemplates bestTemplates = new BestTemplates();
            while (object.hasNext()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)object.next();
                ConfigDataId configDataId = new ConfigDataId(repositoryContext2.getURI(), repositoryMetaData.getContextType("servers").getRootDocumentType().getFilePattern());
                ObjectName objectName = ConfigServiceHelper.createObjectName(configDataId, null, repositoryContext2.getName());
                PropertySet propertySet = ServerConfigHelper.getMetadata(session, configService, repositoryContext.getName(), repositoryContext2.getName());
                if (propertySet == null) continue;
                EList eList = propertySet.getProperties();
                Iterator iterator = eList.iterator();
                boolean bl2 = true;
                if (bl) {
                    while (iterator.hasNext()) {
                        Property property = (Property)iterator.next();
                        String string4 = properties.getProperty(property.getName());
                        String string5 = properties2.getProperty(property.getName());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Comparing: " + property.getName() + "   " + property.getValue());
                        }
                        if (string5 != null) {
                            bl2 &= !string5.equals(property.getValue());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "AcceptTemp" + bl2);
                            }
                            if (bl2) continue;
                            break;
                        }
                        if (string4 == null) continue;
                        bl2 &= string4.equals(property.getValue());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "AcceptTemp - 2" + bl2);
                    }
                }
                if (!bl2) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding to list: " + objectName);
                }
                if (string2 == null) {
                    list.add(objectName);
                    continue;
                }
                int n3 = TemplateConfigHelper.getMatchCount(configService, session, propertySet, string2);
                if (TemplateConfigHelper.isSystemAndDefault(propertySet)) {
                    n = bestTemplates.setMatchCount(n3);
                    bestTemplates.addTemplate(objectName, n3);
                    continue;
                }
                if (n3 < n) continue;
                bestTemplates.addTemplate(objectName, n3);
            }
            if (string2 != null) {
                list = bestTemplates.getBestTemplates();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplatesFromServerType");
        }
        return list;
    }

    protected static ObjectName getTypeMetadataObjectName(Session session, ConfigService configService, String string) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataObjectName", new Object[]{session, configService, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        try {
            object2 = TemplateManagerFactory.getManager(workSpace);
            object = object2.getRootTemplateContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servertypes");
            repositoryContext = object.getChild(repositoryContextType, string);
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadataObjectName - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        object2 = new ConfigDataId(repositoryContext.getURI(), "servertype-metadata.xml");
        object = ConfigServiceHelper.createObjectName((ConfigDataId)object2, null, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataObjectName", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PropertySet getMetadata(Session session, ConfigService configService, String string, String string2) throws Exception {
        Object object;
        RepositoryContext repositoryContext;
        String string3;
        ObjectName[] objectNameArray;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMetadata", new Object[]{session, configService, string, string2});
            }
            objectNameArray = null;
            ObjectName objectName = ServerConfigHelper.getTypeMetadataObjectName(session, configService, string);
            try {
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                string3 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
                repositoryContext = workSpace.findContext(string3);
                object = WorkspaceHelper.getDocAccessor(repositoryContext, "template-metadata.xml");
                objectNameArray = ((DocAccessor)object).getRootObjects(session);
            }
            catch (ConfigDataNotFoundException configDataNotFoundException) {
                if (objectNameArray == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMetadata - none", null);
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.management.commands.server.ServerConfigHelper.getMetadata", "291");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured during getMetadata", exception);
                }
            }
            finally {
                if (objectNameArray != null) break block17;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata - none", null);
                }
                return null;
            }
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            string3 = (PropertySet)MOFUtil.convertToEObject(session, (ObjectName)objectNameArray[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + string3);
            }
            repositoryContext = string3.getProperties();
            object = repositoryContext.iterator();
            while (object.hasNext()) {
                Property property = (Property)object.next();
                if (!property.getName().equals("name") || !property.getValue().equals(string2)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata", string3);
                }
                return string3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadata", null);
        }
        return null;
    }

    protected static boolean doesServerTypeExist(ConfigService configService, Session session, String string) throws ConfigServiceException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesServerTypeExist", new Object[]{configService, session, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        try {
            TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
            RepositoryContext repositoryContext2 = templateManager.getRootTemplateContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servertypes");
            repositoryContext = repositoryContext2.getChild(repositoryContextType, string);
            bl = repositoryContext != null;
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesServerTypeExist", new Boolean(bl));
        }
        return bl;
    }

    protected static ObjectName buildServerType(ConfigService configService, Session session, String string) throws ConfigServiceException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildServerType", new Object[]{configService, session, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        try {
            object2 = TemplateManagerFactory.getManager(workSpace);
            object = object2.getRootTemplateContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servertypes");
            repositoryContext = object.getChild(repositoryContextType, string);
            repositoryContext = repositoryContext == null ? object.create(repositoryContextType, string) : object.getChild(repositoryContextType, string);
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        object2 = new ConfigDataId(repositoryContext.getURI(), "servertype-metadata.xml");
        object = ConfigServiceHelper.createObjectName((ConfigDataId)object2, null, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerType", object);
        }
        return object;
    }

    static Collection getServertypesContexts(WorkSpace workSpace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServertypesContexts", workSpace);
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
        RepositoryContext repositoryContext = templateManager.getRootTemplateContext();
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        Collection collection = repositoryContext.findContext(repositoryMetaData.getContextType("servertypes"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServertypesContexts", collection);
        }
        return collection;
    }

    private static ObjectName getMetadataOfTemplate(Session session, ObjectName objectName) throws Exception {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataOfTemplate", new Object[]{session, objectName});
        }
        ObjectName objectName2 = null;
        Session session2 = WorkspaceHelper.getConfigSession(objectName);
        if (session2 == null) {
            session2 = session;
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session2);
        String string = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        RepositoryContext repositoryContext = workSpace.findContext(string);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
        }
        catch (Exception exception) {
            docAccessor = null;
        }
        if (docAccessor != null && (objectNameArray = docAccessor.getRootObjects(session2)) != null && objectNameArray.length > 0) {
            objectName2 = objectNameArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataOfTemplate", objectName2);
        }
        return objectName2;
    }

    private static void copyMetadata(Session session, ObjectName objectName, ObjectName objectName2, String string) throws Exception {
        Object object;
        WorkSpace workSpace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyMetadata", new Object[]{session, objectName, objectName2, string});
        }
        PropertySet propertySet = (PropertySet)MOFUtil.convertToEObject(session, objectName2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            workSpace = (Property)iterator.next();
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", workSpace.getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " property ", workSpace.getName() + "=" + workSpace.getValue());
            }
            if (workSpace.getName().equals("name")) {
                ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", string);
            } else {
                ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", workSpace.getValue());
            }
            arrayList.add(object);
        }
        workSpace = WorkspaceHelper.getWorkspace(session);
        object = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        RepositoryContext repositoryContext = workSpace.findContext((String)object);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "template-metadata.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "docAccessor ", docAccessor);
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "properties", arrayList);
        ObjectName objectName3 = docAccessor.createRootConfigObject(session, "PropertySet", attributeList);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyMetadata");
        }
    }

    private static ObjectName createMetadata(Session session, ObjectName objectName, String string, String string2, String string3) throws Exception {
        AttributeList attributeList;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMetadata", new Object[]{session, objectName, string, string3});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Properties properties = ServerConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(string2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AttributeList attributeList2 = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList2, "name", "name");
        ConfigServiceHelper.setAttributeValue(attributeList2, "value", string);
        arrayList.add(attributeList2);
        Enumeration<?> enumeration = properties.propertyNames();
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", object);
            ConfigServiceHelper.setAttributeValue(attributeList, "value", properties.get(object));
            if (((String)object).equals("com.ibm.websphere.nodeOperatingSystem")) {
                bl2 = true;
            }
            if (((String)object).equals("com.ibm.websphere.baseProductMajorVersion")) {
                string5 = (String)properties.get(object);
                bl = true;
            }
            if (((String)object).equals("com.ibm.websphere.baseProductVersion")) {
                string4 = (String)properties.get(object);
                if (string4.startsWith("6.1")) {
                    string4 = "6.1";
                } else if (string4 != null && string4.length() > 0 && string4.indexOf(".") > 0) {
                    string4 = string4.substring(0, string4.indexOf("."));
                }
            }
            arrayList.add(attributeList);
        }
        if (!bl && string4 != null && string4.length() > 0) {
            object = new AttributeList();
            string5 = string4;
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", "com.ibm.websphere.baseProductMajorVersion");
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", string4);
            arrayList.add(object);
        }
        if (!bl2 && string5 != null && string5.length() > 0 && string5.startsWith("5")) {
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", "com.ibm.websphere.nodeOperatingSystem");
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", "windows");
            arrayList.add(object);
        }
        if (string3 == null || string3.trim().equals("")) {
            string3 = "";
        }
        object = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", "description");
        ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", string3);
        arrayList.add(object);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", "isSystemTemplate");
        ConfigServiceHelper.setAttributeValue(attributeList, "value", "false");
        arrayList.add(attributeList);
        AttributeList attributeList3 = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList3, "name", "isDefaultTemplate");
        ConfigServiceHelper.setAttributeValue(attributeList3, "value", "false");
        arrayList.add(attributeList3);
        AttributeList attributeList4 = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList4, "properties", arrayList);
        Session session2 = WorkspaceHelper.getConfigSession(objectName);
        if (session2 == null) {
            session2 = session;
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session2);
        String string6 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        RepositoryContext repositoryContext = workSpace.findContext(string6);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "template-metadata.xml");
        ObjectName objectName2 = docAccessor.createRootConfigObject(session2, "PropertySet", attributeList4);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMetadata", objectName2);
        }
        return objectName2;
    }

    public static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigServiceException {
        return WorkspaceHelper.getWorkspace(session).getMetadataHelper();
    }

    public static List getTemplate(Session session, ObjectName objectName, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplate", new Object[]{objectName, string});
        }
        List<ObjectName> list = Collections.EMPTY_LIST;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Server", string);
            Session session2 = WorkspaceHelper.getConfigSession(objectName);
            if (session2 == null) {
                session2 = session;
            }
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] objectNameArray = configService.queryConfigObjects(session2, objectName, objectName2, null);
            if (session2 != session) {
                for (int i = 0; i < objectNameArray.length; ++i) {
                    objectNameArray[i] = WorkspaceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(objectNameArray[i]), ConfigServiceHelper.getConfigDataType(objectNameArray[i]), ConfigServiceHelper.getDisplayName(objectNameArray[i]), session2);
                }
            }
            list = Arrays.asList(objectNameArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.commands.server.ServerConfigHelper.getTemplates", "403");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", list);
        }
        return list;
    }

    public static ObjectName createServer(Session session, ObjectName objectName, String string, ObjectName objectName2, boolean bl) throws Exception {
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", string);
        ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Template", objectName2);
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ServerDelegator serverDelegator = new ServerDelegator(ConfigServiceImpl.getInstance());
        if (!bl) {
            ConfigServiceHelper.setAttributeValue(attributeList, "adjustPort", new Boolean(false));
        }
        ObjectName objectName3 = serverDelegator.createBasicConfigObject(session, objectName, attributeList);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", objectName3);
        }
        return objectName3;
    }

    public static ObjectName createServerTemplate(Session session, String string, String string2, String string3, String string4, ObjectName objectName) throws Exception {
        ObjectName objectName2;
        BaseServerDelegator baseServerDelegator;
        ConfigService configService;
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerTemplate", new Object[]{session, string, string2, string3, string4, objectName});
        }
        if ((objectNameArray = (configService = ConfigServiceFactory.getConfigService()).resolve(session, "Node=" + string + ":Server=" + string2)).length == 0) {
            throw new ConfigServiceException("server is not found");
        }
        ObjectName objectName3 = objectNameArray[0];
        ObjectName objectName4 = null;
        String string5 = (String)configService.getAttribute(session, objectName3, "serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", string5);
        }
        if (objectName == null) {
            baseServerDelegator = ServerConfigHelper.getMetadata(session, configService, string5, string3);
            if (baseServerDelegator != null) {
                throw new ConfigServiceException("Template with name: " + string3 + " already exists");
            }
            objectName = ServerConfigHelper.buildServerType(configService, session, string5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "templateLoc", objectName);
            }
        }
        baseServerDelegator = new BaseServerDelegator(ConfigServiceImpl.getInstance());
        AttributeList attributeList = new AttributeList();
        objectName3 = WorkspaceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(objectName3), ConfigServiceHelper.getConfigDataType(objectName3), ConfigServiceHelper.getDisplayName(objectName3), session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", objectName3);
        }
        ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Template", objectName3);
        ConfigServiceHelper.setAttributeValue(attributeList, "name", string3);
        Session session2 = WorkspaceHelper.getConfigSession(objectName);
        if (session2 == null) {
            session2 = session;
        }
        if ((objectName2 = ServerConfigHelper.getMetadataOfTemplate(session, objectName4 = baseServerDelegator.createConfigObject(session2, objectName, null, attributeList))) != null) {
            ServerConfigHelper.copyMetadata(session, objectName, objectName2, string3);
            TemplateConfigHelper.updateTemplateMetadata(configService, session2, objectName4, string3);
        } else {
            ServerConfigHelper.createMetadata(session, objectName, string3, string, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerTemplate", objectName4);
        }
        return objectName4;
    }

    public static void deleteServer(Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServer", new Object[]{session, string, string2});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=" + string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Result from ConfigService: " + objectNameArray);
        }
        if (objectNameArray.length == 0) {
            throw new ConfigServiceException("server is not found");
        }
        ServerDelegator serverDelegator = new ServerDelegator(ConfigServiceImpl.getInstance());
        serverDelegator.deleteBasicConfigData(session, objectNameArray[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteServer");
        }
    }

    public static void deleteServerTemplate(Session session, ObjectName objectName) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerTemplate", new Object[]{session, objectName});
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = properties.getProperty("servertype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerType: " + string);
        }
        String string2 = properties.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server: " + string2);
        }
        if (string2.endsWith("|server.xml")) {
            string2 = string2.substring(0, string2.indexOf("|server.xml"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server: " + string2);
            }
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName2 = ServerConfigHelper.getTypeMetadataObjectName(session, configService, string);
        PropertySet propertySet = ServerConfigHelper.getMetadata(session, configService, string, string2);
        EList eList = propertySet.getProperties();
        Object object2 = eList.iterator();
        while (object2.hasNext()) {
            object = (Property)object2.next();
            if (!object.getName().equals("isSystemTemplate") || !object.getValue().equalsIgnoreCase("true")) continue;
            throw new ConfigServiceException("Can not delete a System Template");
        }
        object2 = new BaseServerDelegator(ConfigServiceImpl.getInstance());
        ((BaseServerDelegator)object2).deleteConfigData(session, objectName);
        object = MOFUtil.createObjectName((EObject)propertySet);
        configService.deleteConfigData(session, (ObjectName)object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteServerTemplate");
        }
    }
}

