/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.Properties;
import javax.management.ObjectName;

public class ShowServerInfo
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ShowServerInfo.class, "ShowServerInfo", "com.ibm.ws.management.commands.server");
    private ObjectName server = null;

    public ShowServerInfo(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ShowServerInfo(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "svr", objectName);
        }
        try {
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            if (objectNameArray.length != 1) {
                throw new InvalidParameterValueException(this.getName(), "TargetObject", objectName);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.server.validate", "80");
            throw new CommandValidationException(throwable, "validation for command ShowServerInfo failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            taskCommandResultImpl.setResult(this.showServerInfo());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.server.validate", "94");
            taskCommandResultImpl.setException(new CommandException(throwable, "ShowServerInfo command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private Properties showServerInfo() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ShowServerInfo", this.server);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName = (ObjectName)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "server", objectName);
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        AdminCommand adminCommand = CommandMgr.getCommandMgr().createCommand("getServerType");
        adminCommand.setConfigSession(session);
        String string = properties.getProperty("node");
        adminCommand.setParameter("nodeName", string);
        adminCommand.setParameter("serverName", properties.getProperty("server"));
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (!commandResult.isSuccessful()) {
            throw commandResult.getException();
        }
        String string2 = (String)commandResult.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServerType", string2);
        }
        properties.put("serverType", string2);
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        properties.put("com.ibm.websphere.baseProductVersion", managedObjectMetadataHelper.getNodeBaseProductVersion(string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showServerInfo", properties);
        }
        return properties;
    }
}

