/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.ObjectName;

public class AddFeaturesToServerCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(AddFeaturesToServerCommand.class, "TemplateConfig", BUNDLE_NAME);

    public AddFeaturesToServerCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public AddFeaturesToServerCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            Session session;
            CommandProviderHelper commandProviderHelper;
            ConfigService configService;
            List list;
            String string = (String)this.getParameter("featureTemplateName");
            String string2 = (String)this.getParameter("serverType");
            String string3 = (String)this.getParameter("serverName");
            String string4 = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", string4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateName", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", string2);
            }
            if ((list = TemplateConfigHelper.getFeatureNames(configService = (commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper()).getConfigService(), session = this.getConfigSession(), string2)) == null || list.size() == 0) {
                String string5 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0620E", new Object[]{this.getName(), string2});
                throw new CommandValidationException(string5);
            }
            if (!list.contains(string)) {
                String string6 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0622E", new Object[]{this.getName(), string});
                throw new CommandValidationException(string6);
            }
            String string7 = null;
            string7 = string3 == null || string3.equals("") ? "Node=" + string4 + ":Server=" : "Node=" + string4 + ":Server=" + string3;
            ObjectName[] objectNameArray = configService.resolve(session, string7);
            if (objectNameArray == null || objectNameArray.length < 1) {
                String string8 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0625E", new Object[]{this.getName(), string4, string3});
                throw new CommandValidationException(string8);
            }
            for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
                string3 = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                if (TemplateConfigHelper.isNodeAgentOrDmgr(configService, session, string4, string3, string2)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No action for ", string3);
                    continue;
                }
                if (!TemplateConfigHelper.isFeatureUsedByServer(configService, session, string, string2, string4, string3, false)) continue;
                String string9 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0627E", new Object[]{this.getName(), string});
                throw new CommandValidationException(string9);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Exception exception) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0623E", new Object[]{this.getName()});
            throw new CommandValidationException(exception, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResult taskCommandResult = this.getTaskCommandResult();
        try {
            String string = (String)this.getParameter("featureTemplateName");
            String string2 = (String)this.getParameter("serverType");
            String string3 = (String)this.getParameter("serverName");
            String string4 = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", string4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateName", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", string2);
            }
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.getConfigSession();
            String string5 = null;
            string5 = string3 == null || string3.equals("") ? "Node=" + string4 + ":Server=" : "Node=" + string4 + ":Server=" + string3;
            ObjectName[] objectNameArray = configService.resolve(session, string5);
            for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
                string3 = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                if (string3.equals("dmgr") || string3.equals("nodeagent")) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No action for ", string3);
                    continue;
                }
                this.addFeature(configService, session, string4, string3, string2, string);
            }
        }
        catch (Exception exception) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0624E", new Object[]{this.getName()});
            ((CommandResultImpl)((Object)taskCommandResult)).setException(exception);
            ((CommandResultImpl)((Object)taskCommandResult)).setResult(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult taskCommandResult = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private void addFeature(ConfigService configService, Session session, String string, String string2, String string3, String string4) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFeature", new Object[]{configService, session, string, string2, string3, string4});
        }
        RepositoryContext repositoryContext = TemplateConfigHelper.getServerTemplateContext(configService, session, string3, string4);
        RepositoryContext repositoryContext2 = TemplateConfigHelper.getServerContext(configService, session, string2, string);
        Set set = repositoryContext.getFiles();
        PropertySet propertySet = set.iterator();
        while (propertySet.hasNext()) {
            object = (String)propertySet.next();
            if (((String)object).equals("template-metadata.xml")) continue;
            TemplateConfigHelper.copyFile(repositoryContext2, repositoryContext, string2, (String)object);
        }
        propertySet = TemplateConfigHelper.getFeatureTemplateMetadata(configService, session, string3, string4);
        object = null;
        try {
            object = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext2, "template-metadata.xml");
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addFeature");
            }
            return;
        }
        if (object == null) {
            return;
        }
        ObjectName[] objectNameArray = ((DocAccessor)object).getRootObjects(session);
        if (objectNameArray == null || objectNameArray.length != 1) {
            return;
        }
        PropertySet propertySet2 = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[0]);
        TemplateConfigHelper.addToServerMetadata(configService, session, propertySet2, propertySet, repositoryContext2, repositoryContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFeature");
        }
    }
}

