/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class GenerateTemplatesCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(GenerateTemplatesCommand.class, "TemplateConfig", BUNDLE_NAME);

    public GenerateTemplatesCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GenerateTemplatesCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String[] stringArray = (String[])this.getParameter("featureTemplateNames");
            String string = (String)this.getParameter("serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", stringArray);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", stringArray[i]);
                }
            }
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.getConfigSession();
            List list = null;
            if (string != null && ((list = TemplateConfigHelper.getFeatureNames(configService, session, string)) == null || list.size() == 0)) {
                String string2 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0620E", new Object[]{this.getName(), string});
                throw new CommandValidationException(string2);
            }
            if (stringArray != null && stringArray.length > 0) {
                if (string == null) {
                    String string3 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0621E", new Object[]{this.getName()});
                    throw new CommandValidationException(string3);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (list.contains(stringArray[i])) continue;
                    String string4 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0622E", new Object[]{this.getName(), stringArray[i]});
                    throw new CommandValidationException(string4);
                }
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Exception exception) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0623E", new Object[]{this.getName()});
            throw new CommandValidationException(exception, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResult taskCommandResult = this.getTaskCommandResult();
        List list = null;
        try {
            String[] stringArray = (String[])this.getParameter("featureTemplateNames");
            String string = (String)this.getParameter("serverType");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", stringArray);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", stringArray[i]);
                }
            }
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.getConfigSession();
            list = string != null && stringArray != null && stringArray.length > 0 ? this.generateTemplates(configService, session, string, stringArray) : (string == null ? this.generateTemplates(configService, session) : this.generateTemplates(configService, session, string));
        }
        catch (Exception exception) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0624E", new Object[]{this.getName()});
            ((CommandResultImpl)((Object)taskCommandResult)).setException(exception);
            ((CommandResultImpl)((Object)taskCommandResult)).setResult(string);
        }
        ((CommandResultImpl)((Object)taskCommandResult)).setResult(list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted", list);
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult taskCommandResult = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private List generateTemplates(ConfigService configService, Session session) throws Exception {
        List list;
        ArrayList arrayList = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{configService, session});
        }
        if ((list = TemplateConfigHelper.getServerTypes(configService, session)) == null) {
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list2 = this.generateTemplates(configService, session, string);
            arrayList.addAll(list2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", arrayList);
        }
        return arrayList;
    }

    private List generateTemplates(ConfigService configService, Session session, String string) throws Exception {
        List list;
        ArrayList arrayList = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{configService, session, string});
        }
        if ((list = TemplateConfigHelper.getFeatureNames(configService, session, string)) == null || list.size() < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateTemplates", "no feature packs");
            }
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            List list2 = this.generateTemplates(configService, session, string, string2);
            arrayList.addAll(list2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", arrayList);
        }
        return arrayList;
    }

    private List generateTemplates(ConfigService configService, Session session, String string, String[] stringArray) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{configService, session, string, stringArray});
        }
        if (stringArray == null || stringArray.length < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateTemplates", "no feature packs");
            }
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            List list = this.generateTemplates(configService, session, string, string2);
            arrayList.addAll(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", arrayList);
        }
        return arrayList;
    }

    private List generateTemplates(ConfigService configService, Session session, String string, String string2) throws Exception {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateTemplates", new Object[]{configService, session, string, string2});
        }
        ObjectName[] objectNameArray = TemplateConfigHelper.getTemplateMetadataForServerType(configService, session, string);
        PropertySet propertySet = TemplateConfigHelper.getFeatureTemplateMetadata(configService, session, string, string2);
        for (int i = 0; i < objectNameArray.length; ++i) {
            PropertySet propertySet2 = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + propertySet2);
            }
            if (TemplateConfigHelper.alreadyExists(configService, session, propertySet2, propertySet, objectNameArray) || !TemplateConfigHelper.canCombine(configService, session, propertySet2, propertySet)) continue;
            ObjectName objectName = TemplateConfigHelper.createTemplate(configService, session, propertySet2, propertySet, string);
            arrayList.add(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateTemplates", arrayList);
        }
        return arrayList;
    }
}

