/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class RemoveTemplatesCommand
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(RemoveTemplatesCommand.class, "TemplateConfig", BUNDLE_NAME);

    public RemoveTemplatesCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public RemoveTemplatesCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        try {
            String[] stringArray = (String[])this.getParameter("featureTemplateNames");
            String string = (String)this.getParameter("serverType");
            Boolean bl = (Boolean)this.getParameter("removeDocuments");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", stringArray);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeDocuments", bl);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", stringArray[i]);
                }
            }
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.getConfigSession();
            List list = null;
            if (string != null && ((list = TemplateConfigHelper.getFeatureNames(configService, session, string)) == null || list.size() == 0)) {
                String string2 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0620E", new Object[]{this.getName(), string});
                throw new CommandValidationException(string2);
            }
            if (stringArray != null && stringArray.length > 0) {
                if (string == null) {
                    String string3 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0621E", new Object[]{this.getName()});
                    throw new CommandValidationException(string3);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (list.contains(stringArray[i])) continue;
                    String string4 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0622E", new Object[]{this.getName(), stringArray[i]});
                    throw new CommandValidationException(string4);
                }
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Exception exception) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0623E", new Object[]{this.getName()});
            throw new CommandValidationException(exception, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        TaskCommandResult taskCommandResult = this.getTaskCommandResult();
        List list = null;
        try {
            String[] stringArray = (String[])this.getParameter("featureTemplateNames");
            String string = (String)this.getParameter("serverType");
            Boolean bl = (Boolean)this.getParameter("removeDocuments");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverType", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "featureTemplateNames", stringArray);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeDocuments", bl);
            }
            if (tc.isDebugEnabled()) {
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    Tr.debug(tc, "featureTemplateName", stringArray[i]);
                }
            }
            CommandProviderHelper commandProviderHelper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            ConfigService configService = commandProviderHelper.getConfigService();
            Session session = this.getConfigSession();
            list = string != null && stringArray != null && stringArray.length > 0 ? this.removeTemplates(configService, session, string, stringArray, bl) : (string == null ? this.removeTemplates(configService, session, bl) : this.removeTemplates(configService, session, string, bl));
        }
        catch (Exception exception) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0624E", new Object[]{this.getName()});
            ((CommandResultImpl)((Object)taskCommandResult)).setException(exception);
            ((CommandResultImpl)((Object)taskCommandResult)).setResult(string);
        }
        ((CommandResultImpl)((Object)taskCommandResult)).setResult(list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted", list);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        TaskCommandResult taskCommandResult = this.getTaskCommandResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private List removeTemplates(ConfigService configService, Session session, Boolean bl) throws Exception {
        List list;
        ArrayList arrayList = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{configService, session, bl});
        }
        if ((list = TemplateConfigHelper.getServerTypes(configService, session)) == null) {
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list2 = this.removeTemplates(configService, session, string, bl);
            arrayList.addAll(list2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", arrayList);
        }
        return arrayList;
    }

    private List removeTemplates(ConfigService configService, Session session, String string, Boolean bl) throws Exception {
        List list;
        ArrayList arrayList = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{configService, session, string, bl});
        }
        if ((list = TemplateConfigHelper.getFeatureNames(configService, session, string)) == null || list.size() < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTemplates", "no feature packs");
            }
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            List list2 = this.removeTemplates(configService, session, string, string2, bl);
            arrayList.addAll(list2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", arrayList);
        }
        return arrayList;
    }

    private List removeTemplates(ConfigService configService, Session session, String string, String[] stringArray, Boolean bl) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{configService, session, string, stringArray});
        }
        if (stringArray == null || stringArray.length < 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTemplates", "no feature packs");
            }
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            List list = this.removeTemplates(configService, session, string, string2, bl);
            arrayList.addAll(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", arrayList);
        }
        return arrayList;
    }

    private List removeTemplates(ConfigService configService, Session session, String string, String string2, Boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTemplates", new Object[]{configService, session, string, string2});
        }
        ObjectName[] objectNameArray = TemplateConfigHelper.getTemplateMetadataForServerType(configService, session, string);
        PropertySet propertySet = TemplateConfigHelper.getFeatureTemplateMetadata(configService, session, string, string2);
        List list = TemplateConfigHelper.getMatchingProperties(propertySet);
        String string3 = null;
        String string4 = null;
        if (propertySet != null) {
            string3 = TemplateConfigHelper.getFpMatchingProperty(propertySet);
            string4 = TemplateConfigHelper.getPropValue(propertySet, string3);
        }
        if (objectNameArray == null || string4 == null || string3 == null) {
            return arrayList;
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            boolean bl2;
            String string5;
            PropertySet propertySet2 = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + propertySet2);
            }
            if ((string5 = TemplateConfigHelper.getPropValue(propertySet2, string3)) == null || !(bl2 = TemplateConfigHelper.checkFpVersionsForCompatibility(configService, session, string4, string5, string3))) continue;
            ObjectName objectName = TemplateConfigHelper.getServerTemplateObjectName(configService, session, string, TemplateConfigHelper.getPropValue(propertySet2, "name"));
            TemplateConfigHelper.removeTemplate(configService, session, objectName);
            TemplateConfigHelper.removeTemplateMetadata(configService, session, objectNameArray[i]);
            arrayList.add(TemplateConfigHelper.getPropValue(propertySet2, "name"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTemplates", arrayList);
        }
        return arrayList;
    }
}

