/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.templates;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.nodegroup.NodeGroupHelper;
import com.ibm.ws.management.commands.templates.TemplateConfigException;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class TemplateConfigHelper {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(TemplateConfigHelper.class, "TemplateConfigHelper", "com.ibm.ws.management.resources.configservice");
    private static final String PROD_VER_PREFIX = "com.ibm.websphere.";
    private static final String PROD_VER_SUFFIX = "ProductVersion";
    private static final String FEATURE_PROD_VER_SUFFIX = "FeaturePackProductVersion";

    public static String getFormattedMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
            if (string2 == null) {
                string2 = new String("Cannot find message key " + string + "in resource bundle" + resourceBundle.toString());
                Tr.event(tc, string2);
            }
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = new String("Cannot find message key " + string + "in resource bundle " + resourceBundle.toString());
            Tr.event(tc, string2);
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            string2 = new String("Null pointer exception caught trying to find message key " + string + " in resource bundle " + resourceBundle.toString());
            Tr.event(tc, string2);
        }
        return string2;
    }

    public static List getServerTemplatesObjNames(ConfigService configService, Session session, String string) throws TemplateConfigException {
        return TemplateConfigHelper.getTemplatesServertypes(configService, session, "listServerTemplates", string, null);
    }

    public static List getServerTypes(ConfigService configService, Session session) throws TemplateConfigException {
        return TemplateConfigHelper.getTemplatesServertypes(configService, session, "listServerTypes", null, null);
    }

    public static List getTemplatesServertypes(ConfigService configService, Session session, String string, String string2, String string3) throws TemplateConfigException {
        CommandResult commandResult;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplatesServertypes", new Object[]{configService, session, string, string2, string3});
        }
        List list = null;
        try {
            object2 = CommandMgr.getCommandMgr();
            object = null;
            object = ((CommandMgr)object2).createCommand(string);
            object.setConfigSession(session);
            if (string2 != null) {
                object.setParameter("serverType", string2);
            }
            if (string3 != null) {
                object.setParameter("nodeName", string3);
            }
            object.execute();
            commandResult = object.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Object object3 = commandResult.getResult();
                if (object3 != null && object3 instanceof String) {
                    throw new TemplateConfigException(commandResult.getException(), (String)object3);
                }
                throw new TemplateConfigException(commandResult.getException());
            }
            list = (List)commandResult.getResult();
        }
        catch (Exception exception) {
            throw new TemplateConfigException(exception, exception.getMessage());
        }
        if (tc.isDebugEnabled() && list != null) {
            object2 = new StringBuffer();
            object = list.iterator();
            while (object.hasNext()) {
                commandResult = object.next();
                String string4 = commandResult.toString();
                ((StringBuffer)object2).append(string4);
                ((StringBuffer)object2).append(" ");
            }
            Tr.debug(tc, "return list = " + ((StringBuffer)object2).toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplatesServertypes", list);
        }
        return list;
    }

    public static ObjectName getServerTemplateObjectName(ConfigService configService, Session session, String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTemplateObjectName", new Object[]{session, configService, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        ObjectName objectName = null;
        try {
            object3 = TemplateManagerFactory.getManager(workSpace);
            object2 = object3.getRootTemplateContext();
            object = repositoryMetaData.getContextType("servertypes");
            repositoryContext = object2.getChild((RepositoryContextType)object, string);
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTemplateObjectName - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        object3 = repositoryMetaData.getContextType("servers");
        object2 = repositoryContext.getChildren((RepositoryContextType)object3);
        object = object2.iterator();
        while (object.hasNext()) {
            RepositoryContext repositoryContext2 = (RepositoryContext)object.next();
            ConfigDataId configDataId = new ConfigDataId(repositoryContext2.getURI(), repositoryMetaData.getContextType("servers").getRootDocumentType().getFilePattern());
            if (!repositoryContext2.getName().equals(string2)) continue;
            objectName = ConfigServiceHelper.createObjectName(configDataId, null, repositoryContext2.getName());
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTemplateObjectName", objectName);
        }
        return objectName;
    }

    public static RepositoryContext getServerContext(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerContext", new Object[]{session, configService, string, string2});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = workSpace.getRootContext();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
        RepositoryContext repositoryContext2 = (RepositoryContext)repositoryContext.findContext(repositoryContextType).iterator().next();
        repositoryContextType = repositoryMetaData.getContextType("nodes");
        RepositoryContext repositoryContext3 = (RepositoryContext)repositoryContext2.findContext("nodes", string2).iterator().next();
        repositoryContextType = repositoryMetaData.getContextType("servers");
        RepositoryContext repositoryContext4 = (RepositoryContext)repositoryContext3.findContext("servers", string).iterator().next();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerContext", repositoryContext4);
        }
        return repositoryContext4;
    }

    public static List getServerTemplates(ConfigService configService, Session session, String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTemplates", new Object[]{session, configService, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        List list = null;
        try {
            object3 = TemplateManagerFactory.getManager(workSpace);
            object2 = object3.getRootTemplateContext();
            object = repositoryMetaData.getContextType("servertypes");
            repositoryContext = object2.getChild((RepositoryContextType)object, string);
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTemplates - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        object3 = repositoryMetaData.getContextType("servers");
        list = repositoryContext.getChildren((RepositoryContextType)object3);
        if (tc.isDebugEnabled() && list != null) {
            object2 = new StringBuffer();
            object = list.iterator();
            while (object.hasNext()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)object.next();
                String string2 = repositoryContext2.getName();
                ((StringBuffer)object2).append(string2);
                ((StringBuffer)object2).append(" ");
            }
            Tr.debug(tc, "return list = " + ((StringBuffer)object2).toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTemplates", list);
        }
        return list;
    }

    public static RepositoryContext getServerTemplateContext(ConfigService configService, Session session, String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTemplate", new Object[]{session, configService, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        RepositoryContext repositoryContext2 = null;
        try {
            object3 = TemplateManagerFactory.getManager(workSpace);
            object2 = object3.getRootTemplateContext();
            object = repositoryMetaData.getContextType("servertypes");
            repositoryContext = object2.getChild((RepositoryContextType)object, string);
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTemplate - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        object3 = repositoryMetaData.getContextType("servers");
        object2 = repositoryContext.getChildren((RepositoryContextType)object3);
        object = object2.iterator();
        while (object.hasNext()) {
            RepositoryContext repositoryContext3 = (RepositoryContext)object.next();
            if (!repositoryContext3.getName().equals(string2)) continue;
            repositoryContext2 = repositoryContext3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTemplate", repositoryContext2);
        }
        return repositoryContext2;
    }

    public static RepositoryContext getServerTypeContext(ConfigService configService, Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypeContext", new Object[]{session, configService, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        try {
            TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
            RepositoryContext repositoryContext2 = templateManager.getRootTemplateContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servertypes");
            repositoryContext = repositoryContext2.getChild(repositoryContextType, string);
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTypeMetadata - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        return repositoryContext;
    }

    public static ObjectName getServerTypeMetadata(ConfigService configService, Session session, String string) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypeMetadata", new Object[]{session, configService, string});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = null;
        try {
            object2 = TemplateManagerFactory.getManager(workSpace);
            object = object2.getRootTemplateContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servertypes");
            repositoryContext = object.getChild(repositoryContextType, string);
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerTypeMetadata - none", null);
                }
                return null;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        object2 = new ConfigDataId(repositoryContext.getURI(), "servertype-metadata.xml");
        object = ConfigServiceHelper.createObjectName((ConfigDataId)object2, null, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTypeMetadata", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectName[] getTemplateMetadataForServerType(ConfigService configService, Session session, String string) throws Exception {
        ObjectName[] objectNameArray;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTemplateMetadataForServerType", new Object[]{session, configService, string});
            }
            objectNameArray = null;
            ObjectName objectName = TemplateConfigHelper.getServerTypeMetadata(configService, session, string);
            try {
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                String string2 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
                RepositoryContext repositoryContext = workSpace.findContext(string2);
                DocAccessor docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
                objectNameArray = docAccessor.getRootObjects(session);
            }
            catch (ConfigDataNotFoundException configDataNotFoundException) {
                if (objectNameArray == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getTemplateMetadataForServerType - none", null);
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured during getMetadata", exception);
                }
            }
            finally {
                if (objectNameArray != null) break block13;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTemplateMetadataForServerType - none", null);
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplateMetadataForServerType", objectNameArray);
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertySet getTemplateMetadata(ConfigService configService, Session session, String string, String string2) throws Exception {
        Object object;
        RepositoryContext repositoryContext;
        String string3;
        ObjectName[] objectNameArray;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMetadata", new Object[]{session, configService, string, string2});
            }
            objectNameArray = null;
            ObjectName objectName = TemplateConfigHelper.getServerTypeMetadata(configService, session, string);
            try {
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                string3 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
                repositoryContext = workSpace.findContext(string3);
                object = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
                objectNameArray = ((DocAccessor)object).getRootObjects(session);
            }
            catch (ConfigDataNotFoundException configDataNotFoundException) {
                if (objectNameArray == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMetadata - none", null);
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", "291");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured during getMetadata", exception);
                }
            }
            finally {
                if (objectNameArray != null) break block17;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata - none", null);
                }
                return null;
            }
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            string3 = (PropertySet)MOFUtil.convertToEObject(session, (ObjectName)objectNameArray[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + string3);
            }
            repositoryContext = string3.getProperties();
            object = repositoryContext.iterator();
            while (object.hasNext()) {
                Property property = (Property)object.next();
                if (!property.getName().equals("name") || !property.getValue().equals(string2)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMetadata", string3);
                }
                return string3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadata", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertySet getTemplateMetadata(ConfigService configService, Session session, RepositoryContext repositoryContext) throws Exception {
        WorkSpace workSpace;
        ObjectName[] objectNameArray;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getTemplateMetadata", new Object[]{session, configService, repositoryContext});
            }
            objectNameArray = null;
            try {
                workSpace = WorkspaceHelper.getWorkspace(session);
                DocAccessor docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
                objectNameArray = docAccessor.getRootObjects(session);
            }
            catch (ConfigDataNotFoundException configDataNotFoundException) {
                if (objectNameArray == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getTemplateMetadata - none", null);
                    }
                    return null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", "291");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured during getTemplateMetadata", exception);
                }
            }
            finally {
                if (objectNameArray != null) break block17;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTemplateMetadata - none", null);
                }
                return null;
            }
        }
        if (objectNameArray.length > 1 && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTemplateMetadata - too many property sets", new Integer(objectNameArray.length));
        }
        if (objectNameArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTemplateMetadata - no property sets found ", new Integer(objectNameArray.length));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTemplateMetadata");
            }
            return null;
        }
        workSpace = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplateMetadata", workSpace);
        }
        return workSpace;
    }

    public static String getTemplateName(ConfigService configService, Session session, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplateName", new Object[]{session, configService, repositoryContext});
        }
        String string = null;
        PropertySet propertySet = TemplateConfigHelper.getTemplateMetadata(configService, session, repositoryContext);
        if (propertySet != null) {
            EList eList = propertySet.getProperties();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template property " + property.getName() + "=" + property.getValue());
                }
                if (!property.getName().equals("name")) continue;
                string = property.getValue();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplateName", string);
        }
        return string;
    }

    public static List getFeatureTemplateContexts(ConfigService configService, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateContexts", new Object[]{configService, session});
        }
        ArrayList arrayList = new ArrayList();
        List list = TemplateConfigHelper.getServerTypes(configService, session);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " servertype ", string);
            }
            List list2 = TemplateConfigHelper.getFeatureTemplateContexts(configService, session, string);
            arrayList.addAll(list2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateContexts", arrayList);
        }
        return arrayList;
    }

    public static List getFeatureTemplateContexts(ConfigService configService, Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateContexts", new Object[]{configService, session, string});
        }
        ArrayList<RepositoryContext> arrayList = new ArrayList<RepositoryContext>();
        List list = TemplateConfigHelper.getServerTemplates(configService, session, string);
        if (list == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureTemplateContexts", list);
            }
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            PropertySet propertySet = TemplateConfigHelper.getTemplateMetadata(configService, session, repositoryContext);
            if (propertySet == null || !TemplateConfigHelper.isFeatureTemplate(propertySet)) continue;
            String string2 = TemplateConfigHelper.getTemplateName(configService, session, repositoryContext);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate ", string2);
            }
            if (string2 == null) continue;
            arrayList.add(repositoryContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateContexts", arrayList);
        }
        return arrayList;
    }

    public static List getFeatureTemplateMetadata(ConfigService configService, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateMetadata", new Object[]{configService, session});
        }
        ArrayList arrayList = new ArrayList();
        List list = TemplateConfigHelper.getServerTypes(configService, session);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " servertype ", string);
            }
            List list2 = TemplateConfigHelper.getFeatureTemplateMetadata(configService, session, string);
            arrayList.addAll(list2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateMetadata", arrayList);
        }
        return arrayList;
    }

    public static List getFeatureTemplateMetadata(ConfigService configService, Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateMetadata", new Object[]{configService, session, string});
        }
        ArrayList<PropertySet> arrayList = new ArrayList<PropertySet>();
        List list = TemplateConfigHelper.getServerTemplates(configService, session, string);
        if (list == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureTemplateMetadata", arrayList);
            }
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate ", repositoryContext);
            }
            PropertySet propertySet = TemplateConfigHelper.getTemplateMetadata(configService, session, repositoryContext);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate metadata ", propertySet);
            }
            if (propertySet == null || !TemplateConfigHelper.isFeatureTemplate(propertySet)) continue;
            arrayList.add(propertySet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateMetadata", arrayList);
        }
        return arrayList;
    }

    public static PropertySet getFeatureTemplateMetadata(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureTemplateMetadata", new Object[]{configService, session, string, string2});
        }
        PropertySet propertySet = null;
        List list = TemplateConfigHelper.getServerTemplates(configService, session, string);
        if (list == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureTemplateMetadata", propertySet);
            }
            return propertySet;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate ", repositoryContext);
            }
            propertySet = TemplateConfigHelper.getTemplateMetadata(configService, session, repositoryContext);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " serverTemplate metadata ", propertySet);
            }
            boolean bl = false;
            if (propertySet != null && TemplateConfigHelper.isFeatureTemplate(propertySet)) {
                EList eList = propertySet.getProperties();
                Iterator iterator2 = eList.iterator();
                while (iterator2.hasNext()) {
                    String string3;
                    Property property = (Property)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "template property " + property.getName() + "=" + property.getValue());
                    }
                    if (!property.getName().equals("name") || !(string3 = property.getValue()).equals(string2)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) continue;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureTemplateMetadata", propertySet);
        }
        return propertySet;
    }

    public static List getFeatureNames(ConfigService configService, Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureNames", new Object[]{configService, session});
        }
        ArrayList arrayList = new ArrayList();
        List list = TemplateConfigHelper.getServerTypes(configService, session);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " servertype ", string);
            }
            List list2 = TemplateConfigHelper.getFeatureNames(configService, session, string);
            arrayList.addAll(list2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureNames", arrayList);
        }
        return arrayList;
    }

    public static List getFeatureNames(ConfigService configService, Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFeatureNames", new Object[]{configService, session, string});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = TemplateConfigHelper.getServerTemplates(configService, session, string);
        if (list == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFeatureNames", list);
            }
            return arrayList;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            PropertySet propertySet = TemplateConfigHelper.getTemplateMetadata(configService, session, repositoryContext);
            if (propertySet == null || !TemplateConfigHelper.isFeatureTemplate(propertySet)) continue;
            String string2 = TemplateConfigHelper.getTemplateName(configService, session, repositoryContext);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template name ", string2);
            }
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFeatureNames", arrayList);
        }
        return arrayList;
    }

    public void createTemplateMetadata(PropertySet propertySet, PropertySet propertySet2, String string) throws TemplateConfigException {
    }

    public void deleteTemplateMetadata() throws TemplateConfigException {
    }

    public static boolean canCombine(ConfigService configService, Session session, PropertySet propertySet, PropertySet propertySet2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canCombine", new Object[]{propertySet, propertySet2});
        }
        boolean bl = false;
        List list = TemplateConfigHelper.getMatchingProperties(propertySet2);
        List list2 = TemplateConfigHelper.getMatchingProperties(propertySet);
        String string = null;
        String string2 = null;
        if (list != null && list.size() > 0) {
            string = TemplateConfigHelper.getFpMatchingProperty(propertySet2);
        }
        if (list2 != null && list2.size() > 0) {
            string2 = TemplateConfigHelper.getMatchingProperty(propertySet);
        }
        String string3 = TemplateConfigHelper.getPropValue(propertySet2, string);
        String string4 = TemplateConfigHelper.getPropValue(propertySet, string2);
        boolean bl2 = TemplateConfigHelper.isSystemAndDefault(propertySet);
        if (bl2 && TemplateConfigHelper.canCombine(configService, session, string, string3, string2, string4)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "canCombine if additional properties also match");
            }
            bl = true;
        }
        for (int i = 1; bl && i < list.size(); ++i) {
            String string5 = (String)list.get(i);
            String string6 = TemplateConfigHelper.getPropValue(propertySet2, string5);
            String string7 = TemplateConfigHelper.getPropValue(propertySet, string5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " fprop, fvalue, bvalue ", new Object[]{string5, string6, string7});
            }
            if (string5.equals("com.ibm.websphere.nodeOperatingSystem") && string6.equals("os390")) {
                if (string7.equals("os390")) continue;
                return false;
            }
            if (string5.equals("com.ibm.websphere.nodeOperatingSystem") && !string6.equals("os390")) {
                if (!string7.equals("os390")) continue;
                return false;
            }
            if (string7 == null || string7.equals(string6)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canCombine", new Boolean(bl));
        }
        return bl;
    }

    public static boolean canCombine(ConfigService configService, Session session, String string, String string2, String string3, String string4) throws Exception {
        PropertySet propertySet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canCombine", new Object[]{string, string2, string3, string4});
        }
        if ((propertySet = TemplateConfigHelper.getCompatibilityInfo(configService, session, string, string2)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(false));
            }
            return false;
        }
        String string5 = TemplateConfigHelper.getPropValue(propertySet, "baseStart");
        String string6 = TemplateConfigHelper.getPropValue(propertySet, "baseEnd");
        String string7 = TemplateConfigHelper.getPropValue(propertySet, "basePropertyName");
        if (!string7.equals(string3)) {
            Tr.debug(tc, "matching property in template metadata does contain base product version as the first matching property");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(false));
            }
            return false;
        }
        if (TemplateConfigHelper.withInRange(string5, string6, string4)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(true));
            }
            return true;
        }
        String[] stringArray = TemplateConfigHelper.getBaseProductInfo(configService, session, "com.ibm.websphere.baseProductVersion", string4);
        if (TemplateConfigHelper.withInRange(stringArray[0], stringArray[1], string5)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCombine", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canCombine", new Boolean(false));
        }
        return false;
    }

    public static boolean isSystemAndDefault(PropertySet propertySet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSystemAndDefault", new Object[]{propertySet});
        }
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        String string = null;
        String string2 = null;
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.getName().equals("isDefaultTemplate")) {
                string = property.getValue();
            } else if (property.getName().equals("isSystemTemplate")) {
                string2 = property.getValue();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " name, value ", new Object[]{property.getName(), property.getValue()});
            }
            if (string == null || string2 == null) continue;
            break;
        }
        if (string != null && string.equals("true") && string2 != null && string2.equals("true")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isSystemAndDefault", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSystemAndDefault", new Boolean(false));
        }
        return false;
    }

    public static List getMatchingProperties(PropertySet propertySet) {
        List<String> list = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchingProperties", propertySet);
        }
        if ((list = TemplateConfigHelper.getMatchingPropertiesReal(propertySet)) == null || list.size() == 0) {
            EList eList = propertySet.getProperties();
            Iterator iterator = eList.iterator();
            String string = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                String string2 = property.getName();
                if (string2.startsWith(PROD_VER_PREFIX) && string2.endsWith(PROD_VER_SUFFIX) || string2.equals("com.ibm.websphere.nodeOperatingSystem")) {
                    list.add(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " matching property ", string2);
                    }
                }
                if (string2.equals("com.ibm.websphere.baseProductVersion")) {
                    string = property.getValue();
                }
                if (!string2.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
                bl = true;
            }
            if (!bl && string != null && string.length() > 0 && string.startsWith("5")) {
                list.add("com.ibm.websphere.nodeOperatingSystem");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingProperties", list);
        }
        return list;
    }

    public static List getMatchingPropertiesReal(PropertySet propertySet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = TemplateConfigHelper.getMatchingPropertiesAsString(propertySet);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    public static String getMatchingPropertiesAsString(PropertySet propertySet) {
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals("matchingProperties")) continue;
            return property.getValue();
        }
        return null;
    }

    public static boolean featureExistsInTemplate(PropertySet propertySet, PropertySet propertySet2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "featureExistsInTemplate", new Object[]{propertySet, propertySet2});
        }
        boolean bl = true;
        List list = TemplateConfigHelper.getMatchingProperties(propertySet);
        List list2 = TemplateConfigHelper.getMatchingProperties(propertySet2);
        if (list2.size() == 0 || list.size() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot generate templates if there is no matching properties ", list.size() + " " + list2.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "featureExistsInTemplate", new Boolean(bl));
            }
            return bl;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", string);
            }
            if (list2.contains(string)) {
                String string2 = TemplateConfigHelper.getPropValue(propertySet2, string);
                String string3 = TemplateConfigHelper.getPropValue(propertySet, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "values ", string3 + " " + string2);
                }
                if (string2.equals(string3)) continue;
                bl = false;
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Does not exist in template ", string);
            }
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "featureExistsInTemplate", new Boolean(bl));
        }
        return bl;
    }

    public static boolean alreadyExists(ConfigService configService, Session session, PropertySet propertySet, PropertySet propertySet2, ObjectName[] objectNameArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alreadyExists", new Object[]{configService, session, propertySet, propertySet2, objectNameArray});
        }
        boolean bl = false;
        if (TemplateConfigHelper.featureExistsInTemplate(propertySet2, propertySet)) {
            return true;
        }
        String string = TemplateConfigHelper.getCombinedTemplateName(propertySet2, propertySet);
        bl = TemplateConfigHelper.alreadyExists(configService, session, string, objectNameArray);
        if (!bl) {
            String string2;
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = TemplateConfigHelper.getMatchingProperties(propertySet);
            List list2 = TemplateConfigHelper.getMatchingProperties(propertySet2);
            if (list == null || list2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "alreadyExists", new Boolean(true));
                }
                return true;
            }
            for (n = 0; n < list.size(); ++n) {
                string2 = (String)list.get(n);
                arrayList.add(TemplateConfigHelper.getPropValue(propertySet, string2));
            }
            for (n = 0; n < list2.size(); ++n) {
                string2 = (String)list2.get(n);
                if (list.contains(string2)) continue;
                list.add(string2);
                arrayList.add(TemplateConfigHelper.getPropValue(propertySet2, string2));
            }
            bl = TemplateConfigHelper.matchingPropertyExists(session, list, arrayList, objectNameArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alreadyExists", new Boolean(bl));
        }
        return bl;
    }

    public static boolean matchingPropertyExists(Session session, List list, List list2, ObjectName[] objectNameArray) throws Exception {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchingPropertyExists", new Object[]{list, objectNameArray});
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string;
            PropertySet propertySet = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[i]);
            List list3 = TemplateConfigHelper.getMatchingProperties(propertySet);
            if (list3 == null || list == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "matchingPropertyExists", new Boolean(true));
                }
                return true;
            }
            int n = 0;
            for (n = 0; n < list.size() && list3.contains(string = (String)list.get(n)); ++n) {
                String string2 = TemplateConfigHelper.getPropValue(propertySet, string);
                String string3 = (String)list2.get(n);
                if (string2 != null && string3 != null && !string2.equals(string3)) break;
            }
            if (n != list.size() || list3.size() != n) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchingPropertyExists", new Boolean(bl));
        }
        return bl;
    }

    public static boolean alreadyExists(ConfigService configService, Session session, String string, ObjectName[] objectNameArray) throws Exception {
        for (int i = 0; i < objectNameArray.length; ++i) {
            PropertySet propertySet = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[i]);
            if (!TemplateConfigHelper.alreadyExists(configService, session, string, propertySet)) continue;
            return true;
        }
        return false;
    }

    public static boolean alreadyExists(ConfigService configService, Session session, String string, PropertySet propertySet) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alreadyExists", new Object[]{string, propertySet});
        }
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template property " + property.getName() + "=" + property.getValue());
            }
            if (!property.getName().equals("name") || !property.getValue().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "alreadyExists", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alreadyExists", new Boolean(false));
        }
        return false;
    }

    public static String getCombinedTemplateName(PropertySet propertySet, PropertySet propertySet2) {
        String string = TemplateConfigHelper.getPropValue(propertySet, "name");
        String string2 = TemplateConfigHelper.getPropValue(propertySet2, "name");
        return TemplateConfigHelper.getCombinedTemplateName(string, string2);
    }

    public static String getCombinedTemplateName(String string, String string2) {
        return string2 + "_" + string;
    }

    public static String getMatchingProperty(PropertySet propertySet) {
        return "com.ibm.websphere.baseProductVersion";
    }

    public static String getFpMatchingProperty(PropertySet propertySet) {
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            if (!string.startsWith(PROD_VER_PREFIX) || !string.endsWith(PROD_VER_SUFFIX) || string.equals("com.ibm.websphere.baseProductVersion")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " matching property ", string);
            }
            return string;
        }
        return null;
    }

    public static String getPropValue(PropertySet propertySet, String string) {
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template property " + property.getName() + "=" + property.getValue());
            }
            if (!property.getName().equals(string)) continue;
            return property.getValue();
        }
        return null;
    }

    public static boolean withInRange(String string, String string2, String string3) {
        String string4;
        String string5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "withInRange", new Object[]{string, string2, string3});
        }
        if (string3.equals(string)) {
            return true;
        }
        if (string2 == null) {
            string2 = "Infinite";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer3 = new StringTokenizer(string2, ".");
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
            if (!stringTokenizer2.hasMoreTokens()) break;
            string4 = stringTokenizer2.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Comparing ", string5 + "," + string4);
            }
            if (string5.compareTo(string4) < 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "withInRange 1", new Boolean(false));
                }
                return false;
            }
            if (string5.compareTo(string4) <= 0) continue;
            bl = true;
            break;
        }
        while (!bl && stringTokenizer2.hasMoreTokens()) {
            string5 = stringTokenizer2.nextToken();
            if (Integer.parseInt(string5) <= 0) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange 2", new Boolean(false));
            }
            return false;
        }
        if (string2.equals("Infinite")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange X", new Boolean(true));
            }
            return true;
        }
        stringTokenizer = new StringTokenizer(string3, ".");
        while (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
            if (!stringTokenizer3.hasMoreTokens()) break;
            string4 = stringTokenizer3.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Comparing ", string5 + "," + string4);
            }
            if (string5.compareTo(string4) < 0) {
                bl2 = true;
                break;
            }
            if (string5.compareTo(string4) <= 0) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange 3", new Boolean(false));
            }
            return false;
        }
        while (!bl2 && stringTokenizer3.hasMoreTokens()) {
            string5 = stringTokenizer3.nextToken();
            if (Integer.parseInt(string5) <= 0) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "withInRange 4", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "withInRange", new Boolean(bl2));
        }
        return bl2;
    }

    public static PropertySet getCompatibilityInfo(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCompatibilityInfo", new Object[]{string, string2});
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContext repositoryContext = workSpace.getRootContext();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
        RepositoryContext repositoryContext2 = (RepositoryContext)repositoryContext.findContext(repositoryContextType).iterator().next();
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext2, "product-info.xml");
        }
        catch (Exception exception) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompatibilityInfo", "No product-info.xml file");
            }
            return null;
        }
        ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
        for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
            PropertySet propertySet = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got PropertySet: " + propertySet);
            }
            if (!TemplateConfigHelper.isMatchingFpInfo(string, string2, propertySet)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCompatibilityInfo", propertySet);
            }
            return propertySet;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCompatibilityInfo");
        }
        return null;
    }

    public static boolean isMatchingFpInfo(String string, String string2, PropertySet propertySet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isMatchingFpInfo", new Object[]{string, string2, propertySet});
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "p = " + property);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name = " + property.getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value = " + property.getValue());
            }
            if (property.getName().equals("featurePropertyName")) {
                string3 = property.getValue();
                continue;
            }
            if (property.getName().equals("start")) {
                string4 = property.getValue();
                continue;
            }
            if (!property.getName().equals("end")) continue;
            string5 = property.getValue();
        }
        if (string3 != null && string3.equals(string) && TemplateConfigHelper.withInRange(string4, string5, string2)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isMatchingFpInfo", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchingFpInfo", new Boolean(false));
        }
        return false;
    }

    public static ObjectName createTemplate(ConfigService configService, Session session, PropertySet propertySet, PropertySet propertySet2, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemplate", new Object[]{propertySet, propertySet2, string});
        }
        try {
            Object object;
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            String string2 = TemplateConfigHelper.getCombinedTemplateName(propertySet2, propertySet);
            RepositoryContext repositoryContext = TemplateConfigHelper.getServerTypeContext(configService, session, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server type context ", repositoryContext);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server type context ", repositoryContext.getName());
            }
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servers");
            RepositoryContext repositoryContext2 = repositoryContext.getChild(repositoryContextType, TemplateConfigHelper.getPropValue(propertySet, "name"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "base context ", repositoryContext2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "base context ", repositoryContext2.getName());
            }
            ConfigArchiveUtils.copyContext(repositoryContext, repositoryContext2, string2);
            RepositoryContext repositoryContext3 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext, "servers", string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new template context ", repositoryContext3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new template context ", repositoryContext3.getName());
            }
            RepositoryContext repositoryContext4 = repositoryContext.getChild(repositoryContextType, TemplateConfigHelper.getPropValue(propertySet2, "name"));
            Set set = repositoryContext4.getFiles();
            Object object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).equals("template-metadata.xml")) continue;
                TemplateConfigHelper.copyFile(repositoryContext3, repositoryContext4, string2, (String)object);
            }
            TemplateConfigHelper.createMetadata(configService, session, propertySet, propertySet2, repositoryContext, string2);
            TemplateConfigHelper.removeServerMetadata(configService, session, repositoryContext3);
            TemplateConfigHelper.createMetadata(configService, session, propertySet, propertySet2, repositoryContext3, string2);
            object2 = new ConfigDataId(repositoryContext3.getURI(), "server.xml");
            object = ConfigServiceHelper.createObjectName((ConfigDataId)object2, null, string2);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", string2);
            configService.setAttributes(session, (ObjectName)object, attributeList);
            EndpointConfigHelper.setAdjustFlag(new Boolean(false));
            EndpointConfigHelper.createServerEntry(repositoryContext, string2, MOFUtil.createObjectName(repositoryContext2));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTemplate", object);
            }
            Object object3 = object;
            return object3;
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        finally {
            EndpointConfigHelper.setAdjustFlag(new Boolean(true));
        }
    }

    public static void createMetadata(ConfigService configService, Session session, PropertySet propertySet, PropertySet propertySet2, RepositoryContext repositoryContext, String string) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMetadata", new Object[]{propertySet, propertySet2, repositoryContext, string});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        EList eList = propertySet.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object2 = (Property)iterator.next();
            if (object2.getName().equals("name") || object2.getName().equals("matchingProperties")) continue;
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", object2.getName());
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", object2.getValue());
            arrayList.add(object);
        }
        eList = propertySet2.getProperties();
        iterator = eList.iterator();
        while (iterator.hasNext()) {
            object2 = (Property)iterator.next();
            if (object2.getName().equals("name") || object2.getName().equals("featureTemplate") || object2.getName().equals("matchingProperties")) continue;
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", object2.getName());
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", object2.getValue());
            arrayList.add(object);
        }
        object2 = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)object2, "name", "name");
        ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", string);
        arrayList.add(object2);
        object = TemplateConfigHelper.getMatchingPropertiesAsString(propertySet);
        String string2 = TemplateConfigHelper.getMatchingPropertiesAsString(propertySet2);
        String string3 = null;
        if (object != null && string2 != null) {
            string3 = (String)object + "," + string2;
            object2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, "name", "matchingProperties");
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", string3);
            arrayList.add(object2);
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "properties", arrayList);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "template-metadata.xml");
        ObjectName objectName = docAccessor.createRootConfigObject(session, "PropertySet", attributeList);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMetadata");
        }
    }

    public static void removeTemplate(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        BaseServerDelegator baseServerDelegator = new BaseServerDelegator(ConfigServiceImpl.getInstance());
        baseServerDelegator.deleteConfigData(session, objectName);
    }

    public static void removeTemplateMetadata(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        configService.deleteConfigData(session, objectName);
    }

    public static boolean checkFpVersionsForCompatibility(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        PropertySet propertySet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFpVersionsForCompatibility", new Object[]{string, string2, string3});
        }
        if ((propertySet = TemplateConfigHelper.getCompatibilityInfo(configService, session, string3, string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(false));
            }
            return false;
        }
        String string4 = TemplateConfigHelper.getPropValue(propertySet, "start");
        String string5 = TemplateConfigHelper.getPropValue(propertySet, "end");
        PropertySet propertySet2 = TemplateConfigHelper.getCompatibilityInfo(configService, session, string3, string2);
        if (propertySet2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(false));
            }
            return false;
        }
        String string6 = TemplateConfigHelper.getPropValue(propertySet2, "start");
        String string7 = TemplateConfigHelper.getPropValue(propertySet2, "end");
        if (string4.equals(string6) && string5.equals(string7)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFpVersionsForCompatibility", new Boolean(false));
        }
        return false;
    }

    public static boolean isFeaturePackUsed(ConfigService configService, Session session, PropertySet propertySet) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeaturePackUsed", new Object[]{configService, session, propertySet});
        }
        List list = TemplateConfigHelper.getMatchingProperties(propertySet);
        String string = null;
        String string2 = null;
        if (list != null && list.size() > 0) {
            string = TemplateConfigHelper.getFpMatchingProperty(propertySet);
            string2 = TemplateConfigHelper.getPropValue(propertySet, string);
        }
        boolean bl = TemplateConfigHelper.isFeaturePackUsed(configService, session, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeaturePackUsed(", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isFeaturePackUsed(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeaturePackUsed", new Object[]{configService, session, string, string2});
        }
        if (string == null || string2 == null) {
            return false;
        }
        PropertySet propertySet = TemplateConfigHelper.getCompatibilityInfo(configService, session, string, string2);
        if (propertySet == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFeaturePackUsed", new Boolean(false));
            }
            return false;
        }
        String string3 = TemplateConfigHelper.getPropValue(propertySet, "start");
        String string4 = TemplateConfigHelper.getPropValue(propertySet, "end");
        ManagedObjectMetadataHelper managedObjectMetadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = managedObjectMetadataHelper.getAccessor();
        ObjectName[] objectNameArray = configService.resolve(session, "Node=");
        for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
            String string5 = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
            String string6 = managedObjectMetadataAccessor.getMetadataProperty(string5, string);
            if (string6 == null || !TemplateConfigHelper.withInRange(string3, string4, string6)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFeaturePackUsed", new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeaturePackUsed", new Boolean(false));
        }
        return false;
    }

    public static void addToServerMetadata(ConfigService configService, Session session, PropertySet propertySet, PropertySet propertySet2, RepositoryContext repositoryContext, RepositoryContext repositoryContext2) throws Exception {
        AttributeList attributeList;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToServerMetadata", new Object[]{configService, session, propertySet, propertySet2, repositoryContext, repositoryContext2});
        }
        ObjectName objectName = MOFUtil.createObjectName((EObject)propertySet);
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>();
        EList eList = propertySet.getProperties();
        String string = null;
        String string2 = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object = (Property)iterator.next();
            if (object.getName().equals("matchingProperties")) {
                string = object.getValue();
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding " + object.getName() + "=" + object.getValue());
            }
            attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", object.getName());
            ConfigServiceHelper.setAttributeValue(attributeList, "value", object.getValue());
            arrayList.add(attributeList);
        }
        eList = propertySet2.getProperties();
        iterator = eList.iterator();
        while (iterator.hasNext()) {
            object = (Property)iterator.next();
            if (object.getName().equals("name") || object.getName().equals("featureProperty")) continue;
            if (object.getName().equals("matchingProperties")) {
                string2 = object.getValue();
                continue;
            }
            if (TemplateConfigHelper.propExists(object.getName(), propertySet)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding " + object.getName() + "=" + object.getValue());
            }
            attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", object.getName());
            ConfigServiceHelper.setAttributeValue(attributeList, "value", object.getValue());
            arrayList.add(attributeList);
        }
        if (string != null) {
            string2 = string2 != null ? string + "," + string2 : string;
        }
        if (string2 != null) {
            object = new AttributeList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding matchingProperties=" + string2);
            }
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", "matchingProperties");
            ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", string2);
            arrayList.add((AttributeList)object);
        }
        TemplateConfigHelper.setNewTemplateMetadata(configService, session, repositoryContext, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToServerMetadata");
        }
    }

    public static void removeFromServerMetadata(ConfigService configService, Session session, PropertySet propertySet, PropertySet propertySet2, RepositoryContext repositoryContext, RepositoryContext repositoryContext2) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeFromServerMetadata", new Object[]{configService, session, propertySet, propertySet2, repositoryContext, repositoryContext2});
        }
        ObjectName objectName = MOFUtil.createObjectName((EObject)propertySet);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        List list = TemplateConfigHelper.getMatchingPropertiesReal(propertySet);
        List list2 = TemplateConfigHelper.getMatchingPropertiesReal(propertySet2);
        String string = null;
        String string2 = null;
        EList eList = list2.iterator();
        while (eList.hasNext()) {
            object2 = (String)eList.next();
            if (!list.contains(object2)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing " + (String)object2);
            }
            arrayList2.add(object2);
            list.remove(object2);
        }
        eList = propertySet.getProperties();
        object2 = eList.iterator();
        while (object2.hasNext()) {
            object = (Property)object2.next();
            if (object.getName().equals("matchingProperties")) {
                string2 = object.getValue();
                continue;
            }
            if (arrayList2.contains(object.getName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding " + object.getName() + "=" + object.getValue());
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", object.getName());
            ConfigServiceHelper.setAttributeValue(attributeList, "value", object.getValue());
            arrayList.add(attributeList);
        }
        object = list.iterator();
        while (object.hasNext()) {
            if (string == null) {
                string = (String)object.next();
                continue;
            }
            string = string + "," + (String)object.next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adding matchineProperties=" + string);
        }
        object = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)object, "name", "matchingProperties");
        ConfigServiceHelper.setAttributeValue((AttributeList)object, "value", string);
        arrayList.add(object);
        TemplateConfigHelper.setNewTemplateMetadata(configService, session, repositoryContext, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeFromServerMetadata");
        }
    }

    public static boolean propExists(String string, PropertySet propertySet) {
        EList eList = propertySet.getProperties();
        if (eList == null) {
            return false;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string2 = property.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void copyFile(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new Object[]{repositoryContext, repositoryContext2, string, string2});
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        Template template = templateManager.getTemplate(repositoryContext2);
        templateManager.createFile(repositoryContext, string2, template, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static boolean isFeatureUsedByServer(ConfigService configService, Session session, String string, String string2, String string3, String string4, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeatureUsedByServer", new Object[]{string, string2, string4, string3});
        }
        boolean bl2 = true;
        PropertySet propertySet = TemplateConfigHelper.getFeatureTemplateMetadata(configService, session, string2, string);
        if (propertySet == null) {
            String string5 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0630E", new Object[]{string});
            throw new Exception(string5);
        }
        RepositoryContext repositoryContext = TemplateConfigHelper.getServerContext(configService, session, string4, string3);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
        }
        catch (Exception exception) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFeatureUsedByServer", new Boolean(bl));
            }
            return bl;
        }
        ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
        if (objectNameArray == null || objectNameArray.length != 1) {
            String string6 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{string4, string3});
            throw new Exception(string6);
        }
        PropertySet propertySet2 = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[0]);
        List list = TemplateConfigHelper.getMatchingProperties(propertySet);
        List list2 = TemplateConfigHelper.getMatchingProperties(propertySet2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string7 = (String)iterator.next();
            if (list2.contains(string7)) continue;
            bl2 = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeatureUsedByServer", new Boolean(bl2));
        }
        return bl2;
    }

    public static void setNewTemplateMetadata(ConfigService configService, Session session, RepositoryContext repositoryContext, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNewTemplateMetadata", new Object[]{repositoryContext, list});
        }
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
        }
        catch (Exception exception) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{repositoryContext.getName(), null});
            throw new Exception(string);
        }
        ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
        for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing ", objectNameArray[i]);
            }
            configService.deleteConfigData(session, objectNameArray[i]);
        }
        docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "template-metadata.xml");
        if (docAccessor == null) {
            String string = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{repositoryContext.getName(), null});
            throw new Exception(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "docAccessor ", docAccessor);
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "properties", list);
        ObjectName objectName = docAccessor.createRootConfigObject(session, "PropertySet", attributeList);
        docAccessor.localSave();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNewTemplateMetadata");
        }
    }

    public static boolean isFeatureTemplate(PropertySet propertySet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFeatureTemplate", propertySet);
        }
        boolean bl = false;
        String string = TemplateConfigHelper.getPropValue(propertySet, "featureTemplate");
        if (string != null && string.equals("true")) {
            bl = true;
        }
        if (TemplateConfigHelper.getPropValue(propertySet, "com.ibm.websphere.baseProductVersion") == null) {
            EList eList = propertySet.getProperties();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                String string2 = property.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template property " + string2);
                }
                if (!string2.startsWith(PROD_VER_PREFIX) || !string2.endsWith(PROD_VER_SUFFIX)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFeatureTemplate", new Boolean(bl));
        }
        return bl;
    }

    public static ObjectName findBestMatchingDefaultTemplate(ConfigService configService, Session session, List list) {
        return TemplateConfigHelper.findBestMatchingTemplate(configService, session, list, new Boolean(true));
    }

    public static ObjectName findBestMatchingTemplate(ConfigService configService, Session session, List list) {
        return TemplateConfigHelper.findBestMatchingTemplate(configService, session, list, new Boolean(false));
    }

    public static ObjectName findBestMatchingTemplate(ConfigService configService, Session session, List list, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findBestMatchingTemplate", new Object[]{configService, session, list, bl});
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        int n = 0;
        ObjectName objectName = null;
        try {
            for (int i = 0; list != null && i < list.size(); ++i) {
                PropertySet propertySet = TemplateConfigHelper.getPropertySetOfTemplate(configService, session, (ObjectName)list.get(i));
                if (propertySet == null || bl2 && !TemplateConfigHelper.isSystemAndDefault(propertySet)) continue;
                List list2 = TemplateConfigHelper.getMatchingProperties(propertySet);
                if (list2 != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, " matching properties size ", new Integer(list2.size()));
                }
                if (list2 == null || list2.size() <= n) continue;
                n = list2.size();
                objectName = (ObjectName)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " new match selected ", new Integer(n));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, " new match selected ", objectName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findBestMatchingTemplate", objectName);
        }
        return objectName;
    }

    public static void updateTemplateMetadata(ConfigService configService, Session session, ObjectName objectName, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateTemplateMetadata", new Object[]{configService, session, objectName, string});
        }
        try {
            ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            String string2 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
            RepositoryContext repositoryContext = workSpace.findContext(string2);
            DocAccessor docAccessor = null;
            try {
                docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
            }
            catch (Exception exception) {
                docAccessor = null;
            }
            if (docAccessor == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, " no metadata for ", repositoryContext.getName());
                }
                return;
            }
            ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
            if (objectNameArray != null && objectNameArray.length > 0) {
                Object object;
                Object object2;
                Object object3;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string3 = null;
                PropertySet propertySet = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[0]);
                EList eList = propertySet.getProperties();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    object3 = (Property)iterator.next();
                    if (object3.getName().equals("matchingProperties")) {
                        string3 = object3.getValue();
                        continue;
                    }
                    object2 = new AttributeList();
                    arrayList2.add(object3.getName());
                    ConfigServiceHelper.setAttributeValue((AttributeList)object2, "name", object3.getName());
                    if (object3.getName().equals("name")) {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", string);
                    } else if (object3.getName().equals("isDefaultTemplate")) {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", "false");
                    } else if (object3.getName().equals("isSystemTemplate")) {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", "false");
                    } else {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", object3.getValue());
                    }
                    arrayList.add((Cloneable)object2);
                }
                object3 = TemplateConfigHelper.getNodeName(configService, session, objectName);
                if (object3 != null) {
                    object2 = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties((String)object3);
                    object = ((Properties)object2).propertyNames();
                    while (object.hasMoreElements()) {
                        String string4 = (String)object.nextElement();
                        if (!string4.startsWith(PROD_VER_PREFIX) || !string4.endsWith(PROD_VER_SUFFIX) || arrayList2.contains(string4)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding ", string4 + " = " + ((Properties)object2).get(string4));
                        }
                        AttributeList attributeList = new AttributeList();
                        ConfigServiceHelper.setAttributeValue(attributeList, "name", string4);
                        ConfigServiceHelper.setAttributeValue(attributeList, "value", ((Properties)object2).get(string4));
                        arrayList.add(attributeList);
                        if (string3 == null) continue;
                        string3 = string3 + "," + string4;
                    }
                }
                if (string3 != null) {
                    object2 = new AttributeList();
                    ConfigServiceHelper.setAttributeValue((AttributeList)object2, "name", "matchingProperties");
                    ConfigServiceHelper.setAttributeValue((AttributeList)object2, "value", string3);
                    arrayList.add((Cloneable)object2);
                }
                configService.deleteConfigData(session, objectNameArray[0]);
                docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "template-metadata.xml");
                if (docAccessor == null) {
                    object2 = TemplateConfigHelper.getFormattedMessage(resBundle, "ADMG0629E", new Object[]{repositoryContext.getName(), null});
                    throw new Exception((String)object2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "docAccessor ", docAccessor);
                }
                object2 = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)object2, "properties", arrayList);
                object = docAccessor.createRootConfigObject(session, "PropertySet", (AttributeList)object2);
                docAccessor.localSave();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateTemplateMetadata");
        }
    }

    public static void removeServerMetadata(ConfigService configService, Session session, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServerMetadata", new Object[]{configService, session, repositoryContext});
        }
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
        }
        catch (Exception exception) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, " no metadata for ", repositoryContext.getName());
            }
            return;
        }
        ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
        for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
            configService.deleteConfigData(session, objectNameArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServerMetadata");
        }
    }

    public static Integer getMatchCountInteger(ConfigService configService, Session session, ObjectName objectName, String string) throws Exception {
        return new Integer(TemplateConfigHelper.getMatchCount(configService, session, objectName, string));
    }

    public static int getMatchCount(ConfigService configService, Session session, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchCount", new Object[]{configService, session, objectName, string});
        }
        int n = 0;
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        String string2 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        RepositoryContext repositoryContext = workSpace.findContext(string2);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
        }
        catch (Exception exception) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            PropertySet propertySet;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " no metadata for ", repositoryContext.getName());
            }
            if ((propertySet = TemplateConfigHelper.getPropertySetFromServerType(configService, session, repositoryContext)) != null) {
                n = TemplateConfigHelper.getMatchCount(configService, session, propertySet, string);
            } else {
                String string3 = TemplateConfigHelper.getNodeName(configService, session, objectName);
                if (string3 != null && !string3.equals("")) {
                    n = TemplateConfigHelper.getMatchCount(configService, session, string3, string);
                }
            }
        } else {
            ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
            if (objectNameArray != null && objectNameArray.length > 0) {
                PropertySet propertySet = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[0]);
                List list = TemplateConfigHelper.getMatchingProperties(propertySet);
                if (list != null) {
                    n = list.size();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " matching properties size ", new Integer(n));
                    }
                }
                if (!TemplateConfigHelper.checkNodeProperties(configService, session, propertySet, string)) {
                    n = -1;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchCount", new Integer(n));
        }
        return n;
    }

    public static boolean checkNodeProperties(ConfigService configService, Session session, PropertySet propertySet, String string) {
        boolean bl;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkNodeProperties", new Object[]{configService, session, propertySet, string});
            }
            bl = true;
            try {
                List list = TemplateConfigHelper.getMatchingProperties(propertySet);
                if (list == null) break block9;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2.equals("com.ibm.websphere.nodeOperatingSystem")) {
                        String string3 = TemplateConfigHelper.getPropValue(propertySet, string2);
                        if (string3 != null && string3.equals("os390")) {
                            if (TemplateConfigHelper.isNodeZOS(session, string)) continue;
                            bl = false;
                        } else {
                            if (string3 == null || string3.equals("os390") || !TemplateConfigHelper.isNodeZOS(session, string)) continue;
                            bl = false;
                        }
                    } else {
                        if (TemplateConfigHelper.isMatchWithNode(configService, session, string2, TemplateConfigHelper.getPropValue(propertySet, string2), string)) continue;
                        bl = false;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNodeProperties", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isMatchWithNode(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        Properties properties;
        String string4;
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchWithNode", new Boolean(bl));
        }
        if ((string4 = (String)(properties = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(string3)).get(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find node property for ", string + "in node " + string3);
            }
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isMatchWithNode", new Boolean(bl));
            }
            return bl;
        }
        PropertySet propertySet = TemplateConfigHelper.getCompatibilityInfo(configService, session, string, string2);
        String string5 = null;
        String string6 = null;
        if (propertySet == null) {
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find compatibility information in the product-info.xml ", string);
            }
            if ((n = string2.indexOf(46)) != -1) {
                string5 = string2.substring(0, n);
                int n2 = Integer.parseInt(string5);
                string6 = Integer.toString(++n2);
                if (string.equals("com.ibm.websphere.baseProductVersion") && string2.startsWith("6.0")) {
                    string6 = "6.1";
                }
                if (string.equals("com.ibm.websphere.baseProductVersion") && string2.startsWith("6.1")) {
                    string5 = "6.1";
                }
            } else {
                string5 = string2;
                string6 = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start ", string5);
            }
        } else {
            string5 = TemplateConfigHelper.getPropValue(propertySet, "start");
            string6 = TemplateConfigHelper.getPropValue(propertySet, "end");
        }
        if (!TemplateConfigHelper.withInRange(string5, string6, string4)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeValue ", string4 + " is node with in range " + string5 + " " + string6);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isMatchWithNode", new Boolean(bl));
        }
        return bl;
    }

    public static Object findDefaultTemplate(ConfigService configService, Session session, String string, ObjectName objectName, String string2) throws Exception {
        Object object;
        ObjectName objectName2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findDefaultTemplate", new Object[]{configService, session, string, objectName, string2});
        }
        ArrayList arrayList = new ArrayList();
        try {
            object = Class.forName("com.ibm.websphere.management.application.AppDeploymentUtil");
            Method method2 = ((Class)object).getMethod("isNodeValidForCluster", String.class, String.class, String.class, String.class, Locale.class, List.class);
            method2.invoke(null, TemplateConfigHelper.getCellName(configService, session, objectName), string, ConfigServiceHelper.getDisplayName(objectName), session.toString(), Locale.getDefault(), arrayList);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.commands.templates.TemplateConfigHelper.getTemplateMetadata", "291");
        }
        if (arrayList.size() <= 0) {
            object = TemplateConfigHelper.getTemplatesServertypes(configService, session, "listServerTemplates", string2, string);
            objectName2 = TemplateConfigHelper.findBestMatchingDefaultTemplate(configService, session, (List)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "errors", new Integer(arrayList.size()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findDefaultTemplate", objectName2);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return objectName2;
    }

    public static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigServiceException {
        return WorkspaceHelper.getWorkspace(session).getMetadataHelper();
    }

    public static boolean isNodeZOS(Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeZOS", string);
        }
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        boolean bl = managedObjectMetadataHelper.isNodeZOS(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeZOS", new Boolean(bl));
        }
        return bl;
    }

    public static String getCellName(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName", new Object[]{configService, session, objectName});
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "obj props = " + properties);
        }
        String string = properties.getProperty("cell");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", string);
        }
        return string;
    }

    public static String getNodeName(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeName", new Object[]{configService, session, objectName});
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "obj props = " + properties);
        }
        String string = properties.getProperty("node");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeName", string);
        }
        return string;
    }

    public static int getMatchCount(ConfigService configService, Session session, String string, String string2) throws Exception {
        Object object;
        Object object2;
        int n = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchCount", new Object[]{configService, session, string, string2});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Properties properties = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(string);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", object2);
            }
            if ((!((String)object2).startsWith(PROD_VER_PREFIX) || !((String)object2).endsWith(PROD_VER_SUFFIX)) && !((String)object2).equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            arrayList.add(object2);
        }
        object2 = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(string2);
        enumeration = ((Properties)object2).propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if ((!((String)object).startsWith(PROD_VER_PREFIX) || !((String)object).endsWith(PROD_VER_SUFFIX)) && !((String)object).equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", object);
            }
            if (!arrayList.contains(object)) continue;
            arrayList2.add(object);
        }
        if (arrayList.size() != arrayList2.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodes are not compatible", arrayList.size() + " " + arrayList2.size());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkNode", new Integer(-1));
            }
            return -1;
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prop ", string3);
            }
            String string4 = (String)properties.get(string3);
            if (string3.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            if (!TemplateConfigHelper.isMatchWithNode(configService, session, string3, string4, string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No match ", string3 + "=" + string4 + " " + string + " " + string2);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkNode", new Integer(-1));
                }
                return -1;
            }
            ++n;
        }
        if (TemplateConfigHelper.isNodeZOS(session, string)) {
            if (!TemplateConfigHelper.isNodeZOS(session, string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node " + string + " is ZOS " + string + " is not");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkNode", new Integer(-1));
                }
                return -1;
            }
        } else if (!TemplateConfigHelper.isNodeZOS(session, string) && TemplateConfigHelper.isNodeZOS(session, string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node " + string + " is ZOS " + string + " is not");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkNode", new Integer(-1));
            }
            return -1;
        }
        ++n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchCount", new Integer(n));
        }
        return n;
    }

    public static PropertySet getPropertySetFromServerType(ConfigService configService, Session session, RepositoryContext repositoryContext) throws Exception {
        PropertySet propertySet = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertySetFromServerType", new Object[]{configService, session, repositoryContext});
        }
        String string = repositoryContext.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "template name ", string);
        }
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parent contex ", repositoryContext2);
        }
        if (repositoryContext2 != null) {
            DocAccessor docAccessor = null;
            try {
                docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext2, "template-metadata.xml");
            }
            catch (Exception exception) {
                docAccessor = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPropertySetFromServerType", propertySet);
                }
                return propertySet;
            }
            if (docAccessor != null) {
                ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
                for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
                    PropertySet propertySet2 = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[i]);
                    String string2 = TemplateConfigHelper.getPropValue(propertySet2, "name");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking ", string2);
                    }
                    if (!string.equals(string2)) continue;
                    propertySet = propertySet2;
                    break;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertySetFromServerType", propertySet);
        }
        return propertySet;
    }

    public static int getMatchCount(ConfigService configService, Session session, PropertySet propertySet, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchCount", new Object[]{configService, session, propertySet, string});
        }
        int n = 0;
        List list = TemplateConfigHelper.getMatchingProperties(propertySet);
        if (list != null && list.size() > 0) {
            n = list.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " matching properties size ", new Integer(n));
            }
            if (!TemplateConfigHelper.checkNodeProperties(configService, session, propertySet, string)) {
                n = -1;
            }
        } else {
            String string2 = TemplateConfigHelper.getPropValue(propertySet, "com.ibm.websphere.baseProductVersion");
            if (string2 == null || !TemplateConfigHelper.isMatchWithNode(configService, session, "com.ibm.websphere.baseProductVersion", string2, string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No match ", "com.ibm.websphere.baseProductVersion=" + string2 + " " + string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMatchCount", new Integer(-1));
                }
                return -1;
            }
            string2 = TemplateConfigHelper.getPropValue(propertySet, "com.ibm.websphere.nodeOperatingSystem");
            if (string2 != null && string2.equals("os390")) {
                if (!TemplateConfigHelper.isNodeZOS(session, string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No match ", "com.ibm.websphere.nodeOperatingSystem=" + string2 + " " + string);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMatchCount", new Integer(-1));
                    }
                    return -1;
                }
            } else if (string2 != null && !string2.equals("os390") && TemplateConfigHelper.isNodeZOS(session, string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No match ", "com.ibm.websphere.nodeOperatingSystem=" + string2 + " " + string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMatchCount", new Integer(-1));
                }
                return -1;
            }
            n = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchCount", new Integer(n));
        }
        return n;
    }

    public static PropertySet getPropertySetOfTemplate(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertySetOfTemplate", new Object[]{configService, session, objectName});
        }
        PropertySet propertySet = null;
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        String string = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        RepositoryContext repositoryContext = workSpace.findContext(string);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, "template-metadata.xml");
        }
        catch (Exception exception) {
            docAccessor = null;
        }
        if (docAccessor == null) {
            propertySet = TemplateConfigHelper.getPropertySetFromServerType(configService, session, repositoryContext);
        } else {
            ObjectName[] objectNameArray = docAccessor.getRootObjects(session);
            if (objectNameArray != null && objectNameArray.length > 0) {
                propertySet = (PropertySet)MOFUtil.convertToEObject(session, objectNameArray[0]);
            }
        }
        if (propertySet == null) {
            propertySet = TemplateConfigHelper.derivePropertySetFromTemplateNode(configService, session, objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertySetOfTemplate", propertySet);
        }
        return propertySet;
    }

    public static PropertySet derivePropertySetFromTemplateNode(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "derivePropertySetFromTemplateNode", new Object[]{configService, session, objectName});
        }
        PropertySet propertySet = null;
        String string = ConfigServiceHelper.getDisplayName(objectName);
        String string2 = TemplateConfigHelper.getNodeName(configService, session, objectName);
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "derivePropertySetFromTemplateNode", propertySet);
            }
            return propertySet;
        }
        propertySet = TemplateConfigHelper.derivePropertySetFromNode(configService, session, string2, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "derivePropertySetFromTemplateNode", propertySet);
        }
        return propertySet;
    }

    public static PropertySet derivePropertySetFromNode(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "derivePropertySetFromNode", new Object[]{configService, session, string, string2});
        }
        PropertySet propertySet = null;
        PropertiesPackage propertiesPackage = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        PropertiesFactory propertiesFactory = propertiesPackage.getPropertiesFactory();
        propertySet = propertiesFactory.createPropertySet();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created new ps", propertySet);
        }
        Properties properties = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got props of node ", properties);
        }
        Property property = propertiesFactory.createProperty();
        property.setName("name");
        property.setValue(string2);
        propertySet.getProperties().add((Object)property);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if ((!string3.startsWith(PROD_VER_PREFIX) || !string3.endsWith(PROD_VER_SUFFIX)) && !string3.equals("com.ibm.websphere.nodeOperatingSystem")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding ", string3 + " = " + properties.get(string3));
            }
            property = propertiesFactory.createProperty();
            property.setName(string3);
            property.setValue((String)properties.get(string3));
            propertySet.getProperties().add((Object)property);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "derivePropertySetFromNode", propertySet);
        }
        return propertySet;
    }

    public static Integer getLeastDefaultTemplateMatchCount(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLeastDefaultTemplateMatchCount", new Object[]{configService, session, string, string2});
        }
        List list = TemplateConfigHelper.getTemplatesServertypes(configService, session, "listServerTemplates", string, string2);
        Integer n = TemplateConfigHelper.findLeastMatchingCnt(configService, session, list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLeastDefaultTemplateMatchCount", n);
        }
        return n;
    }

    public static Integer findLeastMatchingCnt(ConfigService configService, Session session, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findLeastMatchingCnt", new Object[]{configService, session, list});
        }
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        ObjectName objectName = null;
        try {
            for (int i = 0; list != null && i < list.size(); ++i) {
                PropertySet propertySet = TemplateConfigHelper.getPropertySetOfTemplate(configService, session, (ObjectName)list.get(i));
                if (propertySet == null || bl && !TemplateConfigHelper.isSystemAndDefault(propertySet)) continue;
                List list2 = TemplateConfigHelper.getMatchingProperties(propertySet);
                if (list2 != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, " matching properties size ", new Integer(list2.size()));
                }
                if (list2 == null || list2.size() > n) continue;
                n = list2.size();
                objectName = (ObjectName)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " new match selected ", new Integer(n));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, " new match selected ", objectName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findLeastMatchingCnt", new Integer(n));
        }
        return new Integer(n);
    }

    public static Integer getDefaultTemplateMatchCount(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTemplateMatchCount", new Object[]{configService, session, string, string2});
        }
        List list = TemplateConfigHelper.getTemplatesServertypes(configService, session, "listServerTemplates", string, string2);
        Integer n = TemplateConfigHelper.findBestMatchingCnt(configService, session, list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTemplateMatchCount", n);
        }
        return n;
    }

    public static Integer findBestMatchingCnt(ConfigService configService, Session session, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findBestMatchingCnt", new Object[]{configService, session, list});
        }
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        ObjectName objectName = null;
        try {
            for (int i = 0; list != null && i < list.size(); ++i) {
                PropertySet propertySet = TemplateConfigHelper.getPropertySetOfTemplate(configService, session, (ObjectName)list.get(i));
                if (propertySet == null || bl && !TemplateConfigHelper.isSystemAndDefault(propertySet)) continue;
                List list2 = TemplateConfigHelper.getMatchingProperties(propertySet);
                if (list2 != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, " matching properties size ", new Integer(list2.size()));
                }
                if (list2 == null || list2.size() <= n) continue;
                n = list2.size();
                objectName = (ObjectName)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " new match selected ", new Integer(n));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, " new match selected ", objectName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findBestMatchingCnt", new Integer(n));
        }
        return new Integer(n);
    }

    public static List listMatchingServerTemplatesForNode(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (configService == null) {
            configService = ConfigServiceFactory.getConfigService();
        }
        if (string == null) {
            string = "APPLICATION_SERVER";
        }
        return TemplateConfigHelper.getTemplatesServertypes(configService, session, "listServerTemplates", string, string2);
    }

    public static List listMatchingServersForNode(ConfigService configService, Session session, String string) throws Exception {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listMatchingServersForNode", new Object[]{configService, session, string});
        }
        if (configService == null) {
            configService = ConfigServiceFactory.getConfigService();
        }
        String string2 = "Server=";
        int n = 0;
        ObjectName[] objectNameArray = configService.resolve(session, string2);
        for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
            int n2;
            ObjectName objectName = objectNameArray[i];
            String string3 = ConfigServiceHelper.getDisplayName(objectName);
            String string4 = TemplateConfigHelper.getNodeName(configService, session, objectName);
            if (string4 == null || string4.equals("") || TemplateConfigHelper.isNodeAgentOrDmgr(configService, session, string4, string3, "APPLICATION_SERVER")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " checking server ", string4 + " " + string3);
            }
            if ((n2 = TemplateConfigHelper.getMatchCount(configService, session, string4, string)) > n) {
                n = n2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " found better server ", string4 + " " + string3);
                }
                arrayList.clear();
                arrayList.add(objectName);
                continue;
            }
            if (n2 != n) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " adding server ", string4 + " " + string3);
            }
            arrayList.add(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listMatchingServersForNode", arrayList);
        }
        return arrayList;
    }

    public static List listAvailableClusterMemberNodes(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", new Object[]{configService, session, string, string2});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (configService == null) {
            configService = ConfigServiceFactory.getConfigService();
        }
        String[] stringArray = null;
        stringArray = string2 != null ? NodeGroupHelper.getNodeGroupMembers(session, configService, string2) : TemplateConfigHelper.getAllNodes(configService, session, string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (TemplateConfigHelper.isDmgrNode(configService, session, stringArray[i]) || !TemplateConfigHelper.isManagedNode(configService, session, stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", arrayList);
        }
        return arrayList;
    }

    public static List listAvailableClusterMemberNodes(ConfigService configService, Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", new Object[]{configService, session, string});
        }
        if (configService == null) {
            configService = ConfigServiceFactory.getConfigService();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "ServerCluster=" + string;
        ObjectName[] objectNameArray = configService.resolve(session, string2);
        if (objectNameArray != null && objectNameArray.length == 1) {
            ObjectName objectName = objectNameArray[0];
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, objectName2, null);
            String string3 = null;
            if (objectNameArray2 != null && objectNameArray2.length > 0) {
                string3 = (String)configService.getAttribute(session, objectNameArray2[0], "nodeName");
            }
            String string4 = (String)configService.getAttribute(session, objectName, "nodeGroupName");
            String[] stringArray = null;
            stringArray = string4 != null ? NodeGroupHelper.getNodeGroupMembers(session, configService, string4) : TemplateConfigHelper.getAllNodes(configService, session, string3);
            for (int i = 0; i < stringArray.length; ++i) {
                if (TemplateConfigHelper.isDmgrNode(configService, session, stringArray[i]) || !TemplateConfigHelper.isManagedNode(configService, session, stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAvailableClusterMemberNodes", arrayList);
        }
        return arrayList;
    }

    public static String[] getAllNodes(ConfigService configService, Session session, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllNodes", new Object[]{configService, session, string});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "Node=";
        boolean bl = false;
        if (string != null) {
            bl = TemplateConfigHelper.isNodeZOS(session, string);
        }
        ObjectName[] objectNameArray = configService.resolve(session, string2);
        for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
            ObjectName objectName = objectNameArray[i];
            String string3 = ConfigServiceHelper.getDisplayName(objectName);
            if (bl) {
                if (!TemplateConfigHelper.isNodeZOS(session, string3)) continue;
                arrayList.add(string3);
                continue;
            }
            if (string != null) {
                if (TemplateConfigHelper.isNodeZOS(session, string3)) continue;
                arrayList.add(string3);
                continue;
            }
            arrayList.add(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllNodes", arrayList);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static boolean isDmgrNode(ConfigService configService, Session session, String string) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManaged", new Object[]{configService, session, string});
        }
        try {
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext repositoryContext = workSpace.getRootContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
            RepositoryContext repositoryContext2 = (RepositoryContext)repositoryContext.findContext(repositoryContextType).iterator().next();
            RepositoryContext repositoryContext3 = workSpace.findContext(repositoryContext2.getURI() + "/nodes/" + string);
            repositoryContext3.extract("serverindex.xml", false);
            Resource resource = repositoryContext3.getResourceSet().createResource(URI.createURI((String)"serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManaged", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isManagedNode(ConfigService configService, Session session, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManaged", new Object[]{configService, session, string});
        }
        boolean bl = false;
        try {
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext repositoryContext = workSpace.getRootContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
            RepositoryContext repositoryContext2 = (RepositoryContext)repositoryContext.findContext(repositoryContextType).iterator().next();
            RepositoryContext repositoryContext3 = workSpace.findContext(repositoryContext2.getURI() + "/nodes/" + string);
            repositoryContext3.extract("serverindex.xml", false);
            Resource resource = repositoryContext3.getResourceSet().createResource(URI.createURI((String)"serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") && !serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManaged", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isNodeAgentOrDmgr(ConfigService configService, Session session, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeAgentOrDmgr", new Object[]{configService, session, string, string2});
        }
        boolean bl = false;
        try {
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContext repositoryContext = workSpace.getRootContext();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
            RepositoryContext repositoryContext2 = (RepositoryContext)repositoryContext.findContext(repositoryContextType).iterator().next();
            RepositoryContext repositoryContext3 = workSpace.findContext(repositoryContext2.getURI() + "/nodes/" + string);
            repositoryContext3.extract("serverindex.xml", false);
            Resource resource = repositoryContext3.getResourceSet().createResource(URI.createURI((String)"serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") || serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) {
                    if (!serverEntry.getServerName().equals(string2)) continue;
                    bl = true;
                } else {
                    if (string3 == null || !serverEntry.getServerName().equals(string2) || serverEntry.getServerType().equalsIgnoreCase(string3)) continue;
                    bl = true;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeAgentOrDmgr", new Boolean(bl));
        }
        return bl;
    }

    private static String[] getBaseProductInfo(ConfigService configService, Session session, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBaseProductInfo", new Object[]{configService, session, string, string2});
        }
        String[] stringArray = new String[2];
        PropertySet propertySet = TemplateConfigHelper.getCompatibilityInfo(configService, session, string, string2);
        String string3 = null;
        String string4 = null;
        if (propertySet == null) {
            int n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find compatibility information in the product-info.xml ", string);
            }
            if ((n = string2.indexOf(46)) != -1) {
                string3 = string2.substring(0, n);
                int n2 = Integer.parseInt(string3);
                string4 = Integer.toString(++n2);
                if (string.equals("com.ibm.websphere.baseProductVersion") && string2.startsWith("6.0")) {
                    string4 = "6.1";
                }
                if (string.equals("com.ibm.websphere.baseProductVersion") && string2.startsWith("6.1")) {
                    string3 = "6.1";
                }
            } else {
                string3 = string2;
                string4 = null;
            }
        } else {
            string3 = TemplateConfigHelper.getPropValue(propertySet, "start");
            string4 = TemplateConfigHelper.getPropValue(propertySet, "end");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "start ", string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "end ", string4);
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBaseProductInfo ", stringArray);
        }
        return stringArray;
    }

    public static boolean isTemplateMatchWithNode(ConfigService configService, Session session, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTemplateMatchWithNode ", new Object[]{objectName, string});
        }
        boolean bl = true;
        int n = TemplateConfigHelper.getMatchCount(configService, session, objectName, string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "template match cnt ", new Integer(n));
        }
        PropertySet propertySet = TemplateConfigHelper.derivePropertySetFromNode(configService, session, string, "temp");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node ps ", propertySet);
        }
        List list = TemplateConfigHelper.getMatchingProperties(propertySet);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node mp ", list);
        }
        int n2 = list.size();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node match cnt ", new Integer(n2));
        }
        bl = n == n2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTemplateMatchWithNode ", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isSameFeatureOnNodes(ConfigService configService, Session session, String string, String string2) {
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSameFeatureOnNodes ", new Object[]{session, string, string2});
        }
        if (string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        try {
            String string3;
            String string4;
            Properties properties = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(string);
            Properties properties2 = TemplateConfigHelper.getMetadataHelper(session).getAccessor().getMetadataProperties(string2);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                if (!string4.startsWith(PROD_VER_PREFIX) || !string4.endsWith(FEATURE_PROD_VER_SUFFIX)) continue;
                string3 = properties.getProperty(string4);
                String string5 = properties2.getProperty(string4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prop name and values ", string4 + " " + string3 + " " + string5);
                }
                if (string5 == null) {
                    bl = false;
                    break;
                }
                PropertySet propertySet = TemplateConfigHelper.getCompatibilityInfo(configService, session, string4, string3);
                if (propertySet == null || TemplateConfigHelper.checkFpVersionsForCompatibility(configService, session, string3, string5, string4)) continue;
                bl = false;
                break;
            }
            enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                if (!string4.startsWith(PROD_VER_PREFIX) || !string4.endsWith(FEATURE_PROD_VER_SUFFIX)) continue;
                string3 = properties.getProperty(string4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prop name and values ", string4 + " " + string3);
                }
                if (string3 != null) continue;
                bl = false;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSameFeatureOnNodes ", new Boolean(bl));
        }
        return bl;
    }
}

