/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.asc.bridge.ws.server.WsAntAgent;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigEpoch;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.RepositoryService;
import com.ibm.websphere.models.config.cellmanager.CellManager;
import com.ibm.websphere.models.config.ipc.TCPIPProtocolType;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminHelperImpl;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.ControlAdminService;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.DataSourceConfigHelperMBean;
import com.ibm.ws.management.MBeanExtensions;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.PlatformMBeanServer;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgrImpl;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.component.AdminOperationsMBean;
import com.ibm.ws.management.component.AdminOperationsMBeanProxy;
import com.ibm.ws.management.component.ConfigChangeHandler;
import com.ibm.ws.management.component.JMXConnectors;
import com.ibm.ws.management.component.JVMMBean;
import com.ibm.ws.management.component.JVMMBeanProxy;
import com.ibm.ws.management.component.PluginConfigServiceImpl;
import com.ibm.ws.management.dm.AdminDiagnosticModule;
import com.ibm.ws.management.event.NotificationServiceMBean;
import com.ibm.ws.management.event.ZServantListener;
import com.ibm.ws.management.fileservice.FileServiceFactory;
import com.ibm.ws.management.j2ee.J2EEDomain;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.status.StatusCache;
import com.ibm.ws.management.status.StatusCacheClient;
import com.ibm.ws.management.status.StatusCacheFactory;
import com.ibm.ws.management.sync.EpochFileHelper;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.runtime.component.Component;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerMBean;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws390.management.proxy.RasLoggingServiceMBeanProxy;
import com.ibm.ws390.management.proxy.TraceServiceMBeanProxy;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextServices;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class AdminImpl
extends ContainerImpl
implements Admin,
PropertyChangeListener {
    private static final TraceComponent tc = Tr.register(AdminImpl.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private ConfigChangeHandler configChangeHandler = new ConfigChangeHandler();
    private boolean serverStarted = false;
    private ControlAdminService control = null;
    private ConfigRepositoryListener crListener = null;
    private ObjectName nameServerMBeanName = null;
    private String _serverLogRoot = null;
    private StatusCacheClient cacheClient = null;
    private VariableMap variableMap = null;
    private EndPointMgr endpointMgr = null;
    private Repository repository = null;
    private final String CELL_EPOCH_FILE_NAME = "fileRepositoryCellLevel.epoch";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        Properties properties;
        com.ibm.websphere.models.config.process.Server server2;
        Cell cell;
        Node node;
        block119: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", object);
            }
            boolean bl = false;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                bl = true;
            }
            boolean bl2 = AdminHelper.getPlatformHelper().isServantJvm();
            Server server3 = null;
            node = null;
            cell = null;
            server2 = null;
            ServerEntry serverEntry = null;
            NodeAgent nodeAgent = null;
            String string = null;
            String string2 = null;
            properties = null;
            ContainerConfig containerConfig = (ContainerConfig)object;
            AdminService adminService = (AdminService)containerConfig.getConfig();
            EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
            AdminService adminService2 = (AdminService)etoolsCopyUtility.copy((EObject)adminService);
            ((BeanContextServices)this.getBeanContext()).addService(Admin.class, this);
            properties = AdminImpl.getProperties((Service)adminService2);
            try {
                try {
                    Object object2;
                    boolean bl3;
                    Object object3;
                    AdminServiceImpl adminServiceImpl;
                    block118: {
                        Object object4;
                        Object object5;
                        Object object6;
                        boolean bl5;
                        boolean bl4;
                        block122: {
                            block121: {
                                block117: {
                                    Object object7;
                                    TCPIPProtocolType tCPIPProtocolType;
                                    adminServiceImpl = new AdminServiceImpl();
                                    AdminServiceFactoryInitializer.setAdminService(adminServiceImpl);
                                    MBeanFactoryImpl mBeanFactoryImpl = (MBeanFactoryImpl)adminServiceImpl.getMBeanFactory();
                                    MBeanServer mBeanServer = mBeanFactoryImpl.getMBeanServer();
                                    if (mBeanServer instanceof PlatformMBeanServer) {
                                        ((PlatformMBeanServer)mBeanServer).setAdminProps(properties);
                                    }
                                    server3 = (Server)this.getService(Server.class);
                                    this.repository = (Repository)this.getService(Repository.class);
                                    this.endpointMgr = (EndPointMgr)this.getService(EndPointMgr.class);
                                    this.variableMap = (VariableMap)this.getService(VariableMap.class);
                                    this._serverLogRoot = this.variableMap.expand("${LOG_ROOT}/" + server3.getName());
                                    server3.addPropertyChangeListener("state", this);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Server service = " + server3);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Repository service = " + this.repository);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "EndpoitMgr service = " + this.endpointMgr);
                                    }
                                    AdminHelperImpl.setEndPointManager(this.endpointMgr);
                                    string2 = this.repository.getRootURI();
                                    properties.put("repositoryRootURIProperty", string2);
                                    try {
                                        cell = this.getCell(this.repository);
                                        properties.put("cellNameConfigProperty", cell.getName());
                                        tCPIPProtocolType = cell.getCellDiscoveryProtocol();
                                        if (tCPIPProtocolType == null) {
                                            properties.put("cellDiscoveryProtocolConfigProperty", "TCP");
                                        } else {
                                            properties.put("cellDiscoveryProtocolConfigProperty", tCPIPProtocolType.toString());
                                        }
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "174", this);
                                        throw new ConfigurationWarning("Problem loading Cell document.", exception);
                                    }
                                    try {
                                        node = this.getNode(this.repository);
                                        properties.put("nodeNameConfigProperty", node.getName());
                                        if (node.isSetDiscoveryProtocol()) {
                                            properties.put("nodeDiscoveryProtocolConfigProperty", node.getDiscoveryProtocol().toString());
                                        } else {
                                            properties.put("nodeDiscoveryProtocolConfigProperty", "TCP");
                                        }
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "183", this);
                                        throw new ConfigurationWarning("Problem loading Node document.", exception);
                                    }
                                    try {
                                        server2 = this.getServer(this.repository);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "WCCM Server = " + server2);
                                        }
                                        properties.put("processNameConfigProperty", server2.getName());
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "171", this);
                                        throw new ConfigurationWarning("Problem loading Server.", exception);
                                    }
                                    try {
                                        serverEntry = this.getServerEntry(this.repository, server2.getName());
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "WCCM ServerEntry = " + serverEntry);
                                        }
                                        properties.put("serverTypeConfigProperty", serverEntry.getServerType());
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "291", this);
                                        throw new ConfigurationWarning("Problem loading ServerEntry.", exception);
                                    }
                                    string = adminService2.isStandalone() ? "UnManagedProcess" : "ManagedProcess";
                                    tCPIPProtocolType = server2.getComponents();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "number of serverComponents: " + tCPIPProtocolType.size());
                                    }
                                    for (int i = 0; i < tCPIPProtocolType.size(); ++i) {
                                        object7 = (ServerComponent)tCPIPProtocolType.get(i);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "ServerComponent: " + object7);
                                        }
                                        if (object7 instanceof NodeAgent) {
                                            string = "NodeAgent";
                                            nodeAgent = (NodeAgent)object7;
                                            break;
                                        }
                                        if (!(object7 instanceof CellManager)) continue;
                                        string = "DeploymentManager";
                                        break;
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "process type = " + string);
                                    }
                                    properties.put("adminTypeProperty", string);
                                    mBeanFactoryImpl.setCellName(cell.getName());
                                    mBeanFactoryImpl.setNodeName(node.getName());
                                    mBeanFactoryImpl.setProcessName(server2.getName());
                                    mBeanFactoryImpl.setRepositoryDir(string2);
                                    AdminInitializer.getInstance().initialize(properties);
                                    AdminInitializer.getInstance().setMBeanExtensions(new MBeanExtensions(adminService2, this.variableMap, (ExtClassLoader)server3.getRuntimeClassLoader()));
                                    this.initializeConfigRepository(adminService2, this.variableMap, string2);
                                    try {
                                        if (bl) {
                                            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Activate JVMMBean in Servant JVM");
                                                }
                                                AdminServiceFactory.getMBeanFactory().activateMBean("JVM", new JVMMBean(), "JVM", null);
                                                break block117;
                                            }
                                            JVMMBeanProxy jVMMBeanProxy = new JVMMBeanProxy();
                                            object7 = AdminServiceFactory.getMBeanFactory().activateMBean("JVM", jVMMBeanProxy, "JVM", null);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Activate JVMMBean Proxy in Control JVM", object7);
                                            }
                                            break block117;
                                        }
                                        AdminServiceFactory.getMBeanFactory().activateMBean("JVM", new JVMMBean(), "JVM", null);
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "237", this);
                                        throw new ConfigurationWarning("Problem registering JVM MBean.", exception);
                                    }
                                }
                                if (bl && !bl2 && AdminServiceFactory.getAdminService().getServerType().equalsIgnoreCase("PROXY_SERVER")) {
                                    ObjectName objectName;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Activating TraceService MBean Proxy in Control Region");
                                        }
                                        objectName = AdminServiceFactory.getMBeanFactory().activateMBean("TraceService", new TraceServiceMBeanProxy(), "TraceService", null);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Activated TraceService MBean Proxy in Control Region", objectName);
                                        }
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "537", this);
                                        throw new ConfigurationWarning("Problem registering TraceService MBean.", exception);
                                    }
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Activating RasLoggingService MBean Proxy in Control Region");
                                        }
                                        objectName = AdminServiceFactory.getMBeanFactory().activateMBean("RasLoggingService", new RasLoggingServiceMBeanProxy(), "RasLoggingService", null);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Activated RasLoggingService MBean Proxy in Control Region", objectName);
                                        }
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "557", this);
                                        throw new ConfigurationWarning("Problem registering RasLoggingService MBean.", exception);
                                    }
                                }
                                bl4 = false;
                                bl5 = false;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Begining Status Cache load");
                                }
                                if (!AdminHelper.getPlatformHelper().isZOS()) break block121;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Loading Status Cache on z/OS");
                                }
                                if (AdminHelper.getPlatformHelper().isControlJvm()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Running in z/OS Control Region");
                                    }
                                    bl4 = true;
                                    WsAntAgent wsAntAgent = new WsAntAgent(properties);
                                    if (wsAntAgent != null) {
                                        this.activateMBean("AntAgent", wsAntAgent, "AntAgent", null);
                                    }
                                    break block122;
                                } else if (AdminHelper.getPlatformHelper().isServantJvm()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Running in z/OS Servant Region");
                                    }
                                    bl5 = true;
                                }
                                break block122;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Running on Distributed");
                            }
                            bl4 = true;
                            bl5 = true;
                        }
                        boolean bl6 = Boolean.getBoolean("com.ibm.websphere.management.status.disable");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Disable Switch: " + bl6);
                        }
                        if (!bl6) {
                            if (bl4) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Status Cache load");
                                }
                                StatusCacheFactory.init(this.repository);
                                object6 = StatusCacheFactory.getStatusCache();
                                object5 = AdminServiceFactory.getMBeanFactory().activateMBean("StatusCache", (RuntimeCollaborator)object6, "StatusCache", null);
                                ((RuntimeCollaborator)object6).setObjectName((ObjectName)object5);
                            }
                            if (bl5) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Status Client load");
                                }
                                if (((String)(object6 = AdminServiceFactory.getAdminService().getProcessType())).equals("DeploymentManager") || ((String)object6).equals("UnManagedProcess")) {
                                    this.cacheClient = StatusCacheFactory.getStatusCacheClient(false);
                                }
                            }
                        }
                        try {
                            object6 = null;
                            if (bl) {
                                try {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "AdminOperationsMBeanProxy init");
                                    }
                                    if (AdminHelper.getPlatformHelper().isControlJvm()) {
                                        AdminOperationsMBeanProxy.init(this);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Starting just proxy for ALL Control Regions");
                                        }
                                        object6 = new AdminOperationsMBeanProxy();
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Starting AdminOperationsMBean in servant");
                                    }
                                    object6 = new AdminOperationsMBean(this);
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "255", this);
                                    throw new ConfigurationWarning("Problem registering AdminOperations MBean.", exception);
                                }
                            } else {
                                object6 = new AdminOperationsMBean(this);
                            }
                            if (object6 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Activating AdminOperationsMBean");
                                }
                                object5 = new DefaultRuntimeCollaborator(object6, "AdminOperations");
                                AdminServiceFactory.getMBeanFactory().activateMBean("AdminOperations", (RuntimeCollaborator)object5, "AdminOperations", null);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "255", this);
                            throw new ConfigurationWarning("Problem registering AdminOperations MBean.", exception);
                        }
                        if (string == "UnManagedProcess" || string == "DeploymentManager") {
                            try {
                                object6 = adminServiceImpl.getDomainName();
                                object5 = new Properties();
                                ((Properties)object5).setProperty("name", (String)object6);
                                AdminServiceFactory.getMBeanFactory().activateMBean("J2EEDomain", new J2EEDomain((String)object6), "J2EEDomain", null, (Properties)object5);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "309", this);
                                throw new ConfigurationWarning("Problem registering J2EEDomain MBean.", exception);
                            }
                        }
                        boolean bl7 = false;
                        boolean bl8 = bl7 = bl && AdminHelper.getPlatformHelper().isServantJvm();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Activate WorkSpace manager", new Boolean(bl7));
                        }
                        if (bl7) {
                            try {
                                object5 = WorkSpaceManagerMBean.getInstance();
                                object4 = AdminServiceFactory.getMBeanFactory().activateMBean("WorkSpaceManager", (RuntimeCollaborator)object5, "WorkSpaceManager", null);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WorkSpaceManager MBean", object5);
                                }
                                ((RuntimeCollaborator)object5).setObjectName((ObjectName)object4);
                                WorkSpaceManagerMBean.setActive(true);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "500", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception activating WorkSpace MBean", exception);
                                }
                                throw new ConfigurationWarning("Problem registering WorkSpaceManager MBean.", exception);
                            }
                        }
                        object5 = adminService2.getProperties();
                        object4 = null;
                        Iterator iterator = object5.iterator();
                        while (iterator.hasNext()) {
                            object3 = (Property)iterator.next();
                            if (!"com.ibm.websphere.management.enableConfigMBean".equals(object3.getName())) continue;
                            object4 = object3.getValue();
                            break;
                        }
                        boolean bl9 = bl3 = string.equals("DeploymentManager") || string.equals("UnManagedProcess");
                        if (object4 != null) {
                            if ("true".equalsIgnoreCase((String)object4)) {
                                bl3 = true;
                            } else if ("false".equalsIgnoreCase((String)object4)) {
                                bl3 = false;
                            }
                        }
                        try {
                            WsAntAgent wsAntAgent;
                            object3 = ConfigServiceFactory.createConfigService(bl3, properties);
                            if (bl) {
                                if (!AdminHelper.getPlatformHelper().isServantJvm()) break block118;
                                if (object3 != null) {
                                    this.activateMBean("ConfigService", object3, "ConfigService", null);
                                }
                                if ((object2 = new RemoteCommandMgrImpl()) != null) {
                                    this.activateMBean("RemoteCommandMgr", object2, "RemoteCommandMgr", null);
                                }
                                break block118;
                            }
                            if (object3 != null) {
                                this.activateMBean("ConfigService", object3, "ConfigService", null);
                            }
                            if ((object2 = new RemoteCommandMgrImpl()) != null) {
                                this.activateMBean("RemoteCommandMgr", object2, "RemoteCommandMgr", null);
                            }
                            if ((wsAntAgent = new WsAntAgent(properties)) != null) {
                                this.activateMBean("AntAgent", wsAntAgent, "AntAgent", null);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "288", this);
                            throw new ConfigurationWarning("Problem initializing config service.", exception);
                        }
                    }
                    if (bl3) {
                        if (bl) {
                            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                                this.registerAppManagementMBean(properties);
                            }
                        } else {
                            this.registerAppManagementMBean(properties);
                        }
                    }
                    try {
                        object3 = new DataSourceConfigHelperMBean(this.variableMap, this.repository);
                        object2 = this.activateMBean("DataSourceCfgHelper", object3, "DataSourceCfgHelper", null);
                        ((RuntimeCollaborator)object3).setObjectName((ObjectName)object2);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "344", this);
                        throw new ConfigurationWarning("Problem registering DataSource config helper.", exception);
                    }
                    try {
                        object3 = new NotificationServiceMBean(adminServiceImpl.getNotificationService());
                        object2 = this.activateMBean("NotificationService", object3, "NotificationService", null);
                        ((RuntimeCollaborator)object3).setObjectName((ObjectName)object2);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initialize", "357", this);
                        throw new ConfigurationWarning("Problem registering NotificationService MBean", exception);
                    }
                    AdminDiagnosticModule.registerAll();
                    this.components = this.loadComponents("META-INF/ws-admin-startup.xml");
                    this.initializeComponents((EObject)adminService2, null);
                    this.getJMXConnectors().initializeConnectors(adminService2);
                    this.getPluginConfigServiceImpl().initializePluginConfigService(adminService2.getPluginConfigService());
                    if (string != "ManagedProcess") {
                        this.createFileBrowserMBean(adminService2);
                        if (string == "UnManagedProcess" || string == "DeploymentManager") {
                            try {
                                if (!bl || AdminHelper.getPlatformHelper().isControlJvm()) {
                                    object3 = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null);
                                    object3.updateMetadata("Collect Metadata", null);
                                }
                            }
                            catch (AdminException adminException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Metadata collection failed.", adminException);
                                }
                                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.component.AdminImpl", "760", this);
                            }
                        }
                    }
                    Object var32_54 = null;
                    if (server3 == null) break block119;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminImpl.initialize", "353", this);
                    throw new ConfigurationError("Problem initializing AdminImpl: ", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var32_55 = null;
                if (server3 != null) {
                    this.releaseService(server3);
                }
                if (this.repository != null) {
                    this.releaseService(this.repository);
                }
                if (this.endpointMgr != null) {
                    this.releaseService(this.endpointMgr);
                }
                if (this.variableMap != null) {
                    this.releaseService(this.variableMap);
                }
                cell = null;
                node = null;
                server2 = null;
                throw throwable;
            }
            this.releaseService(server3);
        }
        if (this.repository != null) {
            this.releaseService(this.repository);
        }
        if (this.endpointMgr != null) {
            this.releaseService(this.endpointMgr);
        }
        if (this.variableMap != null) {
            this.releaseService(this.variableMap);
        }
        cell = null;
        node = null;
        server2 = null;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "initialize", properties);
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            this.registerRepositoryListener();
            NodeSync.addLocalSyncEventListener(this.configChangeHandler);
            this.startComponents();
        }
        catch (RuntimeError runtimeError) {
            throw runtimeError;
        }
        catch (Exception exception) {
            throw new RuntimeError(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        this.persistCellRepositoryEpoch(ConfigRepositoryFactory.getConfigRepository().getRepositoryEpoch());
        this.deregisterRepositoryListener();
        this.stopComponents();
    }

    public void persistCellRepositoryEpoch(ConfigEpoch configEpoch) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "persistCellRepositoryEpoch");
        }
        String string = AdminServiceFactory.getAdminService().getProcessName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AdminServiceFactory.getAdminService().getProcessName() = " + string);
        }
        if (!"dmgr".equalsIgnoreCase(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "persistCellRepositoryEpoch", "Not the dmgr - so not persisting epoch");
            }
            return;
        }
        String string2 = this.getEpochFileName();
        Vector<String> vector = new Vector<String>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "epochData=" + vector.toString() + "configEpoch=" + configEpoch);
        }
        if (configEpoch != null) {
            vector.add(configEpoch.toString());
        }
        EpochFileHelper.persistEpochData(string2, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "persistCellRepositoryEpoch");
        }
    }

    public String getEpochFileName() {
        String string = null;
        String string2 = System.getProperty("user.install.root");
        if (string2 != null && !string2.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "System property user.intsall.root = " + string2);
            }
            String string3 = AdminServiceFactory.getAdminService().getProcessName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminServiceFactory.getAdminService().getProcessName() = " + string3);
            }
            string = string2 + File.separator + "logs" + File.separator + string3 + File.separator + "fileRepositoryCellLevel.epoch";
        }
        return string;
    }

    public void destroy() {
    }

    public ObjectName activateMBean(String string, Object object, String string2, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateMBean");
        }
        RuntimeCollaborator runtimeCollaborator = null;
        ObjectName objectName = null;
        try {
            if (!(object instanceof RuntimeCollaborator)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using DefaultRuntimeCollaborator.");
                }
                runtimeCollaborator = new DefaultRuntimeCollaborator(object, string2);
            } else {
                runtimeCollaborator = (RuntimeCollaborator)object;
            }
            objectName = AdminServiceFactory.getMBeanFactory().activateMBean(string, runtimeCollaborator, string2, string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "activateMBean");
            }
            return objectName;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.activateMBean", "402", this);
            throw new AdminException(exception, "MBean could not be registered.");
        }
    }

    public void deactivateMBean(String string) throws AdminException {
        super.deregisterMBean(string);
    }

    public Cell getCell(Repository repository2) throws Exception {
        Resource resource = repository2.getConfigRoot().getResource(0, "cell.xml");
        return (Cell)resource.getContents().get(0);
    }

    public Node getNode(Repository repository2) throws Exception {
        Resource resource = repository2.getConfigRoot().getResource(3, "node.xml");
        return (Node)resource.getContents().get(0);
    }

    public ServerEntry getServerEntry(Repository repository2, String string) throws Exception {
        Resource resource = null;
        try {
            resource = repository2.getConfigRoot().getResource(3, "serverindex.xml");
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMN0066E", exception);
            throw exception;
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        ServerEntry serverEntry = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry2 = (ServerEntry)iterator.next();
            if (!serverEntry2.getServerName().equals(string)) continue;
            serverEntry = serverEntry2;
            break;
        }
        return serverEntry;
    }

    public com.ibm.websphere.models.config.process.Server getServer(Repository repository2) throws Exception {
        Resource resource = repository2.getConfigRoot().getResource(4, "server.xml");
        return (com.ibm.websphere.models.config.process.Server)resource.getContents().get(0);
    }

    String expandGivenVariable(String string) {
        return super.expandVariable(string);
    }

    private void initializeConfigRepository(AdminService adminService, VariableMap variableMap, String string) throws ConfigurationWarning {
        try {
            RepositoryService repositoryService = null;
            repositoryService = adminService.getConfigRepository();
            ConfigRepository configRepository = ConfigRepositoryFactory.createConfigRepository(repositoryService != null);
            if (configRepository == null) {
                return;
            }
            Properties properties = new Properties();
            if (repositoryService.getProperties() != null) {
                EList eList = repositoryService.getProperties();
                for (int i = 0; i < eList.size(); ++i) {
                    Property property = (Property)eList.get(i);
                    String string2 = property.getName();
                    String string3 = property.getValue();
                    if (string2 == null || string3 == null) continue;
                    try {
                        properties.setProperty(string2, variableMap.expand(string3));
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.management.component.AdminImpl.initializeConfigRepository", "618", this);
                        Tr.warning(tc, "ADMN0024W", new Object[]{string3, illegalArgumentException.getMessage()});
                    }
                }
            }
            properties.setProperty("auditingEnabled", new Boolean(repositoryService.isAuditEnabled()).toString());
            if (string != null) {
                properties.setProperty("was.repository.root", string);
            }
            configRepository.initialize(properties);
            configRepository.addListener(this.configChangeHandler);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initializeConfigRepository", "666", this);
            throw new ConfigurationWarning("Problem initializing config repository.", exception);
        }
    }

    private void registerAppManagementMBean(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAppManagementMBean");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.websphere.management.application.AppManagementFactory");
            Method method2 = clazz.getMethod("initMBean", String.class, String.class, String.class, String.class);
            method2.invoke(clazz, properties.getProperty("repositoryRootURIProperty"), properties.getProperty("cellNameConfigProperty"), properties.getProperty("nodeNameConfigProperty"), properties.getProperty("processNameConfigProperty"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminImpl.registerAppManagementMBean", "738", this);
            Tr.warning(tc, "ADMN0018W", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAppManagementMBean");
        }
    }

    private JMXConnectors getJMXConnectors() {
        JMXConnectors jMXConnectors = null;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component2 = (Component)this.components.get(i);
            if (!(component2 instanceof JMXConnectors)) continue;
            jMXConnectors = (JMXConnectors)component2;
            break;
        }
        return jMXConnectors;
    }

    private PluginConfigServiceImpl getPluginConfigServiceImpl() {
        PluginConfigServiceImpl pluginConfigServiceImpl = null;
        for (int i = 0; i < this.components.size(); ++i) {
            Component component2 = (Component)this.components.get(i);
            if (!(component2 instanceof PluginConfigServiceImpl)) continue;
            pluginConfigServiceImpl = (PluginConfigServiceImpl)component2;
            break;
        }
        return pluginConfigServiceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        File file;
        String string = (String)propertyChangeEvent.getNewValue();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Request from Server Region. Do not update the PID file. Current State = " + string);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Request from Control Region. Update the PID file. Current State = " + string);
            }
        }
        if (string.equals("STARTED")) {
            Object object;
            this.serverStarted = true;
            String string2 = null;
            try {
                object = ProcessFactory.createSelf();
                if (object != null) {
                    string2 = object.id();
                }
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.management.component.AdminImpl.propertyChange", "773", this);
            }
            if (string2 != null) {
                object = new File(this.getServerPidFile());
                ((File)object).getParentFile().mkdirs();
                OutputStream outputStream = null;
                try {
                    if (!((File)object).exists()) {
                        ((File)object).createNewFile();
                    }
                    outputStream = new FileOutputStream((File)object);
                    ((FileOutputStream)outputStream).write(string2.getBytes());
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.component.AdminImpl.propertyChange", "732", this);
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            ((FileOutputStream)outputStream).close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.component.AdminImpl.propertyChange", "744", this);
                        }
                    }
                }
            }
        } else if (string.equals("DESTROYED") && this.serverStarted && (file = new File(this.getServerPidFile())).exists()) {
            file.delete();
        }
    }

    private String getServerPidFile() {
        String string = AdminServiceFactory.getAdminService().getProcessName();
        String string2 = AdminServiceFactory.getAdminService().getProcessType();
        String string3 = string2.equals("NodeAgent") ? "nodeagent" : string;
        String string4 = this.expandVariable("${LOG_ROOT}");
        string3 = string4 + "/" + string3 + "/" + string3 + ".pid";
        return string3;
    }

    public void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configChangeHandler.addConfigChangeListener(configChangeListener);
    }

    public void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        this.configChangeHandler.removeConfigChangeListener(configChangeListener);
    }

    void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        this.configChangeHandler.configChanged(configRepositoryEvent);
    }

    public String getTotalMemory() {
        Runtime runtime2 = Runtime.getRuntime();
        String string = new Long(runtime2.totalMemory()).toString();
        return string;
    }

    public String getFreeMemory() {
        Runtime runtime2 = Runtime.getRuntime();
        String string = new Long(runtime2.freeMemory()).toString();
        return string;
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getProperty(String string) {
        return System.getProperty(string);
    }

    public String getIPAddress(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.management.component.AdminImpl.getIPAddress", "474", this);
            return null;
        }
    }

    public long getCurrentTimeInMillis() {
        return System.currentTimeMillis();
    }

    public String getJVMNode() {
        String string = null;
        try {
            string = AdminHelper.getInstance().getNodeHostName(AdminServiceFactory.getAdminService().getNodeName());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.getJVMNode", "452", this);
            Tr.service(tc, "ADMN0020W", exception);
        }
        return string;
    }

    public void dumpThreads() {
        Process process = null;
        try {
            process = ProcessFactory.createSelf();
            process.generateJVMDump();
        }
        catch (ProcessOpException processOpException) {
            FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.management.component.AdminImpl.dumpThreads", "469", this);
            Tr.error(tc, "ADMN0021W", processOpException);
        }
    }

    private void registerRepositoryListener() {
        ConfigRepository configRepository;
        Object object;
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isControlJvm()) {
            object = AdminServiceFactory.getAdminService().getProcessType();
            if (((String)object).equals("DeploymentManager") || ((String)object).equals("NodeAgent") || ((String)object).equals("UnManagedProcess")) {
                this.crListener = (ConfigRepositoryListener)ImplFactory.loadImplFromKey("com.ibm.ws.management.util.zos.ZOSConfigRepositoryListener");
                if (this.crListener != null) {
                    configRepository = ConfigRepositoryFactory.getConfigRepository();
                    configRepository.addListener(this.crListener);
                } else {
                    Tr.warning(tc, "Unable to load ZOSConfigRepositoryListener");
                }
            }
            if (((String)object).equals("NodeAgent")) {
                NodeSync.addLocalSyncEventListener((NotificationListener)((Object)this.crListener));
            }
        }
        if (!AdminHelper.getPlatformHelper().isServantJvm() && !Boolean.getBoolean("com.ibm.websphere.management.status.disable")) {
            object = StatusCacheFactory.getStatusCache();
            configRepository = ConfigRepositoryFactory.getConfigRepository();
            configRepository.addListener((ConfigRepositoryListener)object);
        }
    }

    private void deregisterRepositoryListener() {
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (AdminHelper.getPlatformHelper().isControlJvm() && this.crListener != null) {
                ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
                configRepository.removeListener(this.crListener);
            }
            if (string.equals("NodeAgent")) {
                NodeSync.removeLocalSyncEeventListener((NotificationListener)((Object)this.crListener));
            }
        }
    }

    public void createControlAdminService() {
        if (AdminServiceFactoryInitializer.getPlatformHelper().isControlJvm()) {
            try {
                this.control = new ControlAdminServiceImpl(AdminServiceFactory.getMBeanFactory());
                Class<?> clazz = Class.forName("com.ibm.ws390.management.ServantJVMListener");
                clazz.newInstance();
                ZServantListener zServantListener = ZServantListener.getInstance();
                if (zServantListener != null) {
                    zServantListener.initialize();
                }
                try {
                    StatusCache statusCache = StatusCacheFactory.getStatusCache();
                    if (statusCache != null) {
                        statusCache.registerServantStartup();
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not initialze Servant Listener in StatusCache", exception);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void createFileBrowserMBean(AdminService adminService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFileServiceMBean");
        }
        boolean bl = true;
        EList eList = adminService.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            if (!"com.ibm.websphere.management.enableFileServiceMBean".equals(string) || !"false".equalsIgnoreCase(property.getValue())) continue;
            bl = false;
            break;
        }
        if (bl) {
            FileServiceFactory.createFileBrowserMBean(this.variableMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFileServiceMBean");
        }
    }
}

