/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.j2c.J2CProps;
import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.J2EEResourcePropertySet;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.j2c.J2cFactory;
import com.ibm.ejs.models.base.resources.j2c.J2cPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.DocumentChangedException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.component.AdminImpl;
import com.ibm.ws.management.component.InstallRAHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.discovery.Utils;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.tools.DMgrConfigUtils;
import com.ibm.ws.management.util.PlatformUtils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.wsspi.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import com.ibm.wsspi.management.tools.DmgrSideExtensionChecker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.RarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.ConfigProperty;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.ResourceAdapter;

public class AdminOperationsMBean {
    private static int iii = 1;
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.adminservice");
    private static final TraceComponent tc = Tr.register(AdminOperationsMBean.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    private static final long TOKEN_EXPIRATION_TIME = 1800000L;
    public static final String IGNORE_BEAN_PROPERTY_EXCEPTIONS = "com.ibm.ws.management.component.AdminOperationsMBean_ignoreBeanPropertyExceptions";
    private static final boolean ignoreBeanPropertyExceptions = Boolean.getBoolean("com.ibm.ws.management.component.AdminOperationsMBean_ignoreBeanPropertyExceptions");
    private AdminImpl adminImpl;
    private boolean nodeFederationOrRemovalInProgress = false;
    private Integer currentToken = new Integer(0);
    private long previousTokenHandout = 0L;
    private int chmodPermissions = 0;
    private int permsetPermissions = 0;
    private boolean zos = false;
    private PlatformUtils platformUtils = AdminServiceImpl.getPlatformUtils();
    static final int DELETE_FLAG = 1000;

    public AdminOperationsMBean(AdminImpl adminImpl) throws AdminException {
        this.adminImpl = adminImpl;
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
    }

    public static void mergeConfigDataOnDmgr(Properties properties, Properties properties2) throws Exception {
        Tr.debug(tc, "Enter mergeConfigDataOnDmgr()\n nodePoperties = " + properties);
        Tr.debug(tc, "Enter mergeConfigDataOnDmgr()\n adminPoperties = " + properties2);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeConfigDataOnDmgr:  " + properties);
        }
        DMgrConfigUtils.doMergeConfig(properties, properties2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeConfigDataOnDmgr");
        }
    }

    public static void doUnMergeConfigDataOnDmgr(Properties properties) throws Exception {
        Tr.debug(tc, "Enter doUnMergeConfigDataOnDmgr()\n nodePoperties = " + properties);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doUnMergeConfigDataOnDmgr:  " + properties);
        }
        DMgrConfigUtils.doUnMergeConfig(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doUnMergeConfigDataOnDmgr");
        }
    }

    public void checkNodeAndDmgrCompatibility(Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNodeAndDmgrCompatibility", properties);
        }
        String string = "com.ibm.wsspi.extension.dmgr-side-extension-checker";
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        Properties properties2 = null;
        if (iExtensionPoint == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkNodeAndDmgrCompatibility - ext point not defined");
            }
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            DmgrSideExtensionChecker dmgrSideExtensionChecker;
            try {
                dmgrSideExtensionChecker = (DmgrSideExtensionChecker)iConfigurationElementArray[i].createExecutableExtension("class");
            }
            catch (Exception exception) {
                throw new AdminException("At extension point " + string + ", the extension class " + iConfigurationElementArray[i].getAttribute("class") + " failed to load");
            }
            if (properties2 == null) {
                ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    throw new AdminException("Unable to get AdminService");
                }
                String string2 = adminService.getNodeName();
                managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                properties2 = managedObjectMetadataAccessor.getMetadataProperties(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Dmgr node metadata:", properties2);
                }
            }
            dmgrSideExtensionChecker.checkCompatibility(properties, properties2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNodeAndDmgrCompatibility");
        }
    }

    public static void renameNodeOnDmgr(String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renameNodeOnDmgr", new Object[]{string, string2, string3});
        }
        DMgrConfigUtils.doRenameNode(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renameNodeOnDmgr");
        }
    }

    public void addNode(String string, String string2) throws Exception {
        if (this.zos) {
            this.add390Node(string, string2, null);
        } else {
            this.addNodeWithOptions(string, string2, null);
        }
    }

    public void addNodeWithOptions(String string, String string2, String string3) throws Exception {
        block14: {
            if (this.zos) {
                this.add390Node(string, string2, string3);
            } else {
                CreationParams creationParams = new CreationParams();
                String string4 = System.getProperty("was.install.root") + File.separator + "bin";
                creationParams.setWorkingDirectory(string4);
                String string5 = "addNode.sh";
                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                    string5 = "addNode.bat";
                } else if (System.getProperty("os.name").equals("OS/400")) {
                    string5 = "addNode";
                }
                String string6 = string4 + File.separator + string5;
                creationParams.setExecutable(string6);
                creationParams.setProcessName("addNode");
                creationParams.setDetachProcess(true);
                List<String> list = new ArrayList<String>();
                if (System.getProperty("os.name").equals("OS/400")) {
                    list.add("-instance");
                    list.add(this.getInstanceName());
                }
                list.add(string);
                list.add(string2);
                list = this.addCommandLineOptions(list, string3);
                list.add("-fromMBean");
                creationParams.setCommandLineArgs(this.createCommandArgsFromGivenOptions(list));
                String string7 = this.getLogFileName("addNode");
                creationParams.setStdFileName(1, string7);
                creationParams.setStdFileName(2, string7);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Launching process with params: " + creationParams.toString());
                }
                AdminClient adminClient = null;
                Properties properties = this.createUserData();
                ObjectName objectName = null;
                try {
                    adminClient = this.createAdminClient(string, string2, list);
                    objectName = this.getNotificationService(adminClient);
                    if (objectName != null) {
                        this.emitStartingNotification(adminClient, objectName, "websphere.addnode.starting", creationParams, properties);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminOperationsMBean.addNode", "149", this);
                }
                try {
                    Process process = ProcessFactory.create(creationParams);
                    process.release();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminOperationsMBean.addNode", "157", this);
                    if (objectName == null) break block14;
                    try {
                        this.emitFailedNotification(adminClient, objectName, "websphere.addnode.failed", creationParams, properties, exception);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private String getInstanceName() {
        String string = System.getProperty("user.install.root");
        return string.substring(string.lastIndexOf(File.separator) + 1);
    }

    private String getLogFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.expandVariable("${LOG_ROOT}"));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append("MBean.log");
        return stringBuffer.toString();
    }

    private ObjectName getNotificationService(AdminClient adminClient) throws Exception {
        String string = "WebSphere:*,type=NotificationService,process=" + com.ibm.ws.management.util.Utils.getNetmgrName(adminClient);
        Set set = adminClient.queryNames(new ObjectName(string), null);
        if (!set.isEmpty()) {
            return (ObjectName)set.iterator().next();
        }
        return null;
    }

    private Properties createUserData() {
        Properties properties = new Properties();
        properties.setProperty("nodeName", AdminServiceFactory.getAdminService().getNodeName());
        return properties;
    }

    private void emitStartingNotification(AdminClient adminClient, ObjectName objectName, String string, CreationParams creationParams, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitStartingNotification", new Object[]{adminClient, objectName, string, creationParams, properties});
        }
        String string2 = AdminOperationsMBean.getFormattedMessage("ADMN0032I", new Object[]{creationParams.getExecutable() + " " + this.toString(creationParams.getCommandLineArgs())}, null);
        adminClient.invoke(objectName, "emitNotification", new Object[]{string, string2, properties}, NTFY_PARAMS);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitStartingNotification");
        }
    }

    private void emitFailedNotification(AdminClient adminClient, ObjectName objectName, String string, CreationParams creationParams, Properties properties, Exception exception) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitFailedNotification", new Object[]{adminClient, objectName, string, creationParams, properties, exception});
        }
        String string2 = AdminOperationsMBean.getFormattedMessage("ADMN0033E", new Object[]{creationParams.getProcessName(), exception}, null);
        adminClient.invoke(objectName, "emitNotification", new Object[]{string, string2, properties}, NTFY_PARAMS);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "emitFailedNotification");
        }
    }

    public void removeNode() throws Exception {
        if (this.zos) {
            this.remove390Node(null);
        } else {
            this.removeNodeWithOptions(null);
        }
    }

    public void add390Node(String string, String string2, String string3) throws Exception {
        CreationParams creationParams = new CreationParams();
        String string4 = System.getProperty("server.root") + System.getProperty("file.separator") + "bin";
        String string5 = "addNode";
        String string6 = string4 + System.getProperty("file.separator") + string5;
        String string7 = "/tmp";
        File file = new File(string7);
        File file2 = File.createTempFile(string5, ".sh", file);
        String string8 = string7 + System.getProperty("file.separator") + file2.getName();
        List<String> list = new ArrayList<String>();
        list.add(string);
        list.add(string2);
        list = this.addCommandLineOptions(list, string3);
        list.add("-fromMBean");
        String[] stringArray = this.createCommandArgsFromGivenOptions(list);
        String string9 = this.getLine(string6, stringArray);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1047"));
        printWriter.println("#!/bin/sh");
        printWriter.println(string9);
        printWriter.close();
        creationParams.setExecutable(string8);
        creationParams.setCommandLineArgs(new String[]{" "});
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Launching process with params: " + creationParams.toString());
        }
        this.chmod(string8);
        AdminClient adminClient = null;
        Properties properties = this.createUserData();
        ObjectName objectName = null;
        try {
            adminClient = this.createAdminClient(string, string2, list);
            objectName = this.getNotificationService(adminClient);
            if (objectName != null) {
                this.emitStartingNotification(adminClient, objectName, "websphere.addnode.starting", creationParams, properties);
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "AdminOperationsMBean.addNode Notification Failed", exception);
        }
        try {
            Process process = ProcessFactory.create(creationParams);
            process.release();
        }
        catch (Exception exception) {
            Tr.debug(tc, "AdminOperationsMBean.addNode Failed", exception);
        }
    }

    public void remove390Node(String string) throws Exception {
        CreationParams creationParams = new CreationParams();
        String string2 = System.getProperty("server.root") + System.getProperty("file.separator") + "bin";
        String string3 = "removeNode";
        String string4 = string2 + System.getProperty("file.separator") + string3;
        String string5 = "/tmp";
        File file = new File(string5);
        File file2 = File.createTempFile(string3, ".sh", file);
        String string6 = string5 + System.getProperty("file.separator") + file2.getName();
        List<String> list = new ArrayList();
        list = this.addCommandLineOptions(list, string);
        list.add("-fromMBean");
        String[] stringArray = this.createCommandArgsFromGivenOptions(list);
        String string7 = this.getLine(string4, stringArray);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1047"));
        printWriter.println("#!/bin/sh");
        printWriter.println(string7);
        printWriter.close();
        creationParams.setExecutable(string6);
        creationParams.setCommandLineArgs(new String[]{" "});
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Launching process with params: " + creationParams.toString());
        }
        this.chmod(string6);
        AdminClient adminClient = null;
        Properties properties = this.createUserData();
        ObjectName objectName = null;
        try {
            adminClient = Utils.getDmgrAdminClient();
            objectName = this.getNotificationService(adminClient);
            if (objectName != null) {
                this.emitStartingNotification(adminClient, objectName, "websphere.removenode.starting", creationParams, properties);
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "AdminOperationsMBean.removeNode Notification Failed", exception);
        }
        try {
            Process process = ProcessFactory.create(creationParams);
            process.release();
        }
        catch (Exception exception) {
            Tr.debug(tc, "AdminOperationsMBean.removeNode Failed", exception);
        }
    }

    public void removeNodeWithOptions(String string) throws Exception {
        block14: {
            if (this.zos) {
                this.remove390Node(string);
            } else {
                CreationParams creationParams = new CreationParams();
                String string2 = System.getProperty("was.install.root") + File.separator + "bin";
                creationParams.setWorkingDirectory(string2);
                String string3 = "removeNode.sh";
                if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                    string3 = "removeNode.bat";
                } else if (System.getProperty("os.name").equals("OS/400")) {
                    string3 = "removeNode";
                }
                String string4 = string2 + File.separator + string3;
                creationParams.setExecutable(string4);
                creationParams.setProcessName("removeNode");
                creationParams.setDetachProcess(true);
                List<String> list = new ArrayList<String>();
                if (System.getProperty("os.name").equals("OS/400")) {
                    list.add("-instance");
                    list.add(this.getInstanceName());
                }
                list = this.addCommandLineOptions(list, string);
                list.add("-fromMBean");
                creationParams.setCommandLineArgs(this.createCommandArgsFromGivenOptions(list));
                String string5 = this.getLogFileName("removeNode");
                creationParams.setStdFileName(1, string5);
                creationParams.setStdFileName(2, string5);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Launching process with params: " + creationParams.toString());
                }
                AdminClient adminClient = null;
                Properties properties = this.createUserData();
                ObjectName objectName = null;
                try {
                    adminClient = Utils.getDmgrAdminClient();
                    objectName = this.getNotificationService(adminClient);
                    if (objectName != null) {
                        this.emitStartingNotification(adminClient, objectName, "websphere.removenode.starting", creationParams, properties);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminOperationsMBean.removeNode", "282", this);
                }
                try {
                    Process process = ProcessFactory.create(creationParams);
                    process.release();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminOperationsMBean.removeNode", "291", this);
                    if (objectName == null) break block14;
                    try {
                        this.emitFailedNotification(adminClient, objectName, "websphere.removenode.failed", creationParams, properties, exception);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private List addCommandLineOptions(List list, String string) throws Exception {
        int n;
        if (string == null) {
            return list;
        }
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(47);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        block8: while ((n = streamTokenizer.nextToken()) != -1) {
            try {
                switch (n) {
                    case -3: {
                        list.add(streamTokenizer.sval);
                        continue block8;
                    }
                    case -1: {
                        continue block8;
                    }
                    case 10: {
                        continue block8;
                    }
                    case -2: {
                        continue block8;
                    }
                }
                list.add(streamTokenizer.sval);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        stringReader.close();
        return list;
    }

    private String[] createCommandArgsFromGivenOptions(List list) {
        Object object;
        int n = list.indexOf("-configURL");
        if (n != -1) {
            String string;
            list.remove(n);
            object = (String)list.remove(n);
            int n2 = ((String)object).indexOf(34);
            boolean bl = false;
            if (n2 != -1) {
                bl = true;
                if ((n2 = ((String)object).indexOf(34, n2 + 1)) >= 0) {
                    bl = false;
                }
                while (bl) {
                    string = (String)list.remove(n);
                    object = (String)object + string;
                    n2 = string.indexOf(34);
                    if (n2 < 0) continue;
                    bl = !bl;
                }
            }
            object = this.expandVariable((String)object);
            n = list.indexOf("-conntype");
            if (n != -1) {
                string = (String)list.get(n + 1);
                if (string.equalsIgnoreCase("SOAP")) {
                    System.setProperty("com.ibm.SOAP.ConfigURL", (String)object);
                } else {
                    System.setProperty("com.ibm.CORBA.ConfigURL", (String)object);
                }
            } else {
                System.setProperty("com.ibm.SOAP.ConfigURL", (String)object);
            }
        }
        object = new String[list.size()];
        object = list.toArray((T[])object);
        return object;
    }

    private AdminClient createAdminClient(String string, String string2, List list) throws ConnectorException {
        Properties properties = new Properties();
        properties.setProperty("host", string);
        properties.setProperty("port", string2);
        if (list != null) {
            int n = list.indexOf("-conntype");
            if (n != -1) {
                properties.setProperty("type", (String)list.get(n + 1));
            } else {
                properties.setProperty("type", "SOAP");
            }
            n = list.indexOf("-username");
            if (n != -1) {
                properties.setProperty("username", (String)list.get(n + 1));
            }
            if ((n = list.indexOf("-user")) != -1) {
                properties.setProperty("username", (String)list.get(n + 1));
            }
            if ((n = list.indexOf("-password")) != -1) {
                properties.setProperty("password", (String)list.get(n + 1));
            }
        }
        return AdminClientFactory.createAdminClient(properties);
    }

    private String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        return stringBuffer.toString();
    }

    public synchronized Object getTokenForNodeFederationOrRemoval() throws AdminException {
        String string = com.ibm.ws.management.util.Utils.getProductVersion();
        Tr.audit(tc, "ADMN1100E", new Object[]{string});
        String string2 = AdminOperationsMBean.getFormattedMessage("ADMN1100E", new Object[]{string}, null);
        throw new AdminException(string2);
    }

    public synchronized Object getTokenForNodeFederationOrRemoval(String string) {
        String string2 = com.ibm.ws.management.util.Utils.getProductVersion();
        Tr.audit(tc, "ADMN1101I", new Object[]{string, string2});
        if (this.nodeFederationOrRemovalInProgress) {
            if (this.isTokenExpired()) {
                this.currentToken = new Integer(this.currentToken + 1);
            } else {
                return null;
            }
        }
        this.nodeFederationOrRemovalInProgress = true;
        this.previousTokenHandout = System.currentTimeMillis();
        return this.currentToken;
    }

    private boolean isTokenExpired() {
        return System.currentTimeMillis() - this.previousTokenHandout > 1800000L;
    }

    public synchronized boolean completeNodeFederationOrRemoval(Object object) {
        if (object != null && object.equals(this.currentToken)) {
            this.nodeFederationOrRemovalInProgress = false;
            this.currentToken = new Integer(this.currentToken + 1);
            return true;
        }
        return false;
    }

    public synchronized void forceNodeFederationOrRemovalTokenReset() {
        this.nodeFederationOrRemovalInProgress = false;
    }

    public String expandVariable(String string) {
        String string2 = string;
        try {
            string2 = this.adminImpl.expandGivenVariable(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminOperationsMBean.expandVariable", "313", this);
        }
        return string2;
    }

    public AttributeList getResourceAdapterFromRAR(String string, Hashtable hashtable) throws AdminException {
        String string2 = this.expandVariable(string);
        string2 = string2.replace('\\', '/');
        return AdminOperationsMBean._getResourceAdapterFromRAR(string2, hashtable);
    }

    public static AttributeList local_getResourceAdapterFromRAR(String string, Hashtable hashtable, String string2, String string3, String string4) throws AdminException {
        String string5 = InstallRAHelper.expandVar(string, string2, string3, string4);
        string5 = string5.replace('\\', '/');
        return AdminOperationsMBean._getResourceAdapterFromRAR(string5, hashtable);
    }

    public static AttributeList _getResourceAdapterFromRAR(String string, Hashtable hashtable) throws AdminException {
        CommonarchiveFactory commonarchiveFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceAdapterFromRAR: " + string + ", " + hashtable);
        }
        if (string == null) {
            throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0027E", null, null));
        }
        RARFile rARFile = null;
        try {
            ArchiveInit.init();
            commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Path: " + string);
            }
            rARFile = commonarchiveFactory.openRARFile(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.component.AdminOperationsMBean._getResourceAdapterFromRAR", "545");
            throw new AdminException(exception, AdminOperationsMBean.getFormattedMessage("ADMN0028E", new String[]{string, exception.toString()}, "Could not open RAR file " + string));
        }
        commonarchiveFactory = rARFile.getDeploymentDescriptor();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Connector is: " + commonarchiveFactory);
        }
        J2cPackage j2cPackage = (J2cPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi");
        J2cFactory j2cFactory = j2cPackage.getJ2cFactory();
        hashtable = InstallRAHelper.populateProps(hashtable, string, (Connector)commonarchiveFactory);
        RefObjectHelper refObjectHelper = RefObjectHelperFactory.getRefObjectHelper();
        Connector connector2 = (Connector)refObjectHelper.clone((EObject)commonarchiveFactory);
        AttributeList attributeList = null;
        try {
            J2CResourceAdapter j2CResourceAdapter = null;
            int n = ((XMLResource)commonarchiveFactory.eResource()).getVersionID();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "version id: " + n);
            }
            if (n < 14) {
                ResourcesPackage resourcesPackage = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
                ResourcesFactory resourcesFactory = resourcesPackage.getResourcesFactory();
                j2CResourceAdapter = AdminOperationsMBean.createJ2CResourceAdapter(j2cFactory, resourcesFactory, connector2, hashtable);
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    int n2;
                    String string2 = adminService.getNodeName();
                    String string3 = adminService.getCellName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "node name is " + string2 + " cell name is  " + string3);
                    }
                    String string4 = AdminOperationsMBean.getNodeMajorVersion(string3, string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "node version is " + string4);
                    }
                    if ((n2 = Integer.parseInt(string4)) < 6) {
                        throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0065E", new Object[]{new Integer(n), string2, new Integer(n2)}, null));
                    }
                }
                j2CResourceAdapter = AdminOperationsMBean.createJ2C15ResourceAdapter(j2cFactory, connector2, hashtable, rARFile);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created new J2CResourceAdapter : " + j2CResourceAdapter);
            }
            AdminOperationsMBean.saveThis((EObject)j2CResourceAdapter, refObjectHelper);
            attributeList = MOFUtil.getAttributes((EObject)j2CResourceAdapter, null, true);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminOperationsMBean._getResourceAdapterFromRAR", "606");
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "");
        }
        finally {
            if (rARFile != null) {
                rARFile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceAdapterFromRAR:" + attributeList);
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static J2CResourceAdapter createJ2C15ResourceAdapter(J2cFactory j2cFactory, Connector connector2, Hashtable hashtable, RARFile rARFile) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2C15ResourceAdapter");
        }
        J2CResourceAdapter j2CResourceAdapter = null;
        SecurityManager securityManager = System.getSecurityManager();
        boolean bl2 = securityManager != null;
        boolean bl3 = bl = rARFile.getDeploymentDescriptor().getResourceAdapter().getSecurityPermissions() != null && bl2;
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createJ2C15ResourceAdapter Without Protection Domain");
            }
            j2CResourceAdapter = AdminOperationsMBean.createJ2C15ResourceAdapter(j2cFactory, connector2, hashtable, rARFile, null);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createJ2C15ResourceAdapter With Protection Domain");
            }
            ProtectionDomain protectionDomain = null;
            HashMap<String, String> hashMap = new HashMap<String, String>(2);
            DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
            try {
                if (dynamicPolicy != null) {
                    hashMap.put("type", "ra");
                    hashMap.put("RARFile", (String)rARFile);
                    dynamicPolicy.setupPolicy(hashMap);
                }
                protectionDomain = InstallRAHelper.getProtectionDomainForRAR(rARFile);
                j2CResourceAdapter = AdminOperationsMBean.createJ2C15ResourceAdapter(j2cFactory, connector2, hashtable, rARFile, protectionDomain);
            }
            finally {
                InstallRAHelper.removePDFromCache(rARFile.toString());
                dynamicPolicy.removePolicy(hashMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2C15ResourceAdapter");
        }
        return j2CResourceAdapter;
    }

    public static J2CResourceAdapter createJ2C15ResourceAdapter(J2cFactory j2cFactory, Connector connector2, Hashtable hashtable, RARFile rARFile, ProtectionDomain protectionDomain) throws Exception {
        EList eList;
        List list;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2C15ResourceAdapter");
        }
        int n = 15;
        J2CResourceAdapter j2CResourceAdapter = j2cFactory.createJ2CResourceAdapter();
        j2CResourceAdapter.setDeploymentDescriptor(connector2);
        ResourceAdapter resourceAdapter = connector2.getResourceAdapter();
        InstallRAHelper.setupRAGeneralProperty(hashtable, j2CResourceAdapter);
        List list2 = (List)hashtable.get("rar.propertiesSet");
        List list3 = InstallRAHelper.setupRAProperties(list2);
        String string = resourceAdapter.getResourceAdapterClass();
        if (string == null || string.equals("")) {
            Tr.warning(tc, "ADMN0063W", "<resourceadapter-class>");
        }
        if ((object = ExtClassLoader.getInstance()) == null) {
            object = AdminOperationsMBean.class.getClassLoader();
        }
        RarFileDynamicClassLoader rarFileDynamicClassLoader = new RarFileDynamicClassLoader((Archive)rARFile, (ClassLoader)object, null, protectionDomain);
        List list4 = null;
        if (ignoreBeanPropertyExceptions) {
            try {
                list4 = InstallRAHelper.loadBeanProperty(string, (ClassLoader)rarFileDynamicClassLoader);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminOperationsMBean.createJ2C15ResourceAdapter", "1191");
                Tr.warning(tc, "ADMN1219W", new Object[]{string, throwable});
            }
        } else {
            list4 = InstallRAHelper.loadBeanProperty(string, (ClassLoader)rarFileDynamicClassLoader);
        }
        if ((list = J2CProps.mergeRAProperties(list4, (List)(eList = resourceAdapter.getConfigProperties()), list3, n)) != null) {
            J2EEResourcePropertySet j2EEResourcePropertySet = InstallRAHelper.getResourcePropertySet(list);
            j2CResourceAdapter.setPropertySet(j2EEResourcePropertySet);
        }
        InstallRAHelper.setOutboundRA(j2cFactory, resourceAdapter, j2CResourceAdapter, rARFile, list, n);
        InstallRAHelper.setInboundRA(j2cFactory, resourceAdapter, j2CResourceAdapter, rARFile, list);
        InstallRAHelper.setAdminObject(j2cFactory, resourceAdapter, j2CResourceAdapter, rARFile, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2C15ResourceAdapter");
        }
        return j2CResourceAdapter;
    }

    private static void saveThis(EObject eObject, RefObjectHelper refObjectHelper) throws Exception {
        try {
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

                public URI normalize(URI uRI) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "normalize -----" + uRI);
                    }
                    return super.normalize(uRI);
                }
            };
            wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
            URI uRI = URI.createFileURI((String)("test1_" + iii));
            Resource resource = wASResourceSetImpl.createResource(uRI);
            resource.getContents().add((Object)eObject);
            refObjectHelper.refreshRefId(eObject);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminOperationsMBean.saveThis", "693");
            throw new AdminException(throwable, AdminOperationsMBean.getFormattedMessage("ADMN038E", new Object[]{throwable.toString()}, "Internal error"));
        }
    }

    public static J2CResourceAdapter createJ2CResourceAdapter(J2cFactory j2cFactory, ResourcesFactory resourcesFactory, Connector connector2, Hashtable hashtable) throws Exception {
        ResourceAdapter resourceAdapter;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJ2CResourceAdapter");
        }
        boolean bl = false;
        J2CResourceAdapter j2CResourceAdapter = j2cFactory.createJ2CResourceAdapter();
        j2CResourceAdapter.setDeploymentDescriptor(connector2);
        String string2 = (String)hashtable.get("rar.name");
        j2CResourceAdapter.setName(string2);
        String string3 = (String)hashtable.get("rar.archivePath");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive path: " + string3);
        }
        j2CResourceAdapter.setArchivePath(string3);
        String string4 = (String)hashtable.get("rar.desc");
        if (string4 == null || string4.equals("")) {
            string4 = connector2.getDescription();
        }
        if (string4 != null) {
            j2CResourceAdapter.setDescription(string4);
        }
        String string5 = (String)hashtable.get("rar.classpath");
        j2CResourceAdapter.getClasspath().add((Object)string3);
        if (string5 != null) {
            AdminOperationsMBean.addFromString(string5, (List)j2CResourceAdapter.getClasspath());
        }
        if ((string = (String)hashtable.get("rar.nativePath")) != null) {
            AdminOperationsMBean.addFromString(string, (List)j2CResourceAdapter.getNativepath());
        }
        if ((resourceAdapter = connector2.getResourceAdapter()).getConfigProperties() != null) {
            J2EEResourcePropertySet j2EEResourcePropertySet = resourcesFactory.createJ2EEResourcePropertySet();
            EList eList = resourceAdapter.getConfigProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "========================");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configs " + eList);
            }
            for (int i = 0; i < eList.size(); ++i) {
                String string6;
                ConfigProperty configProperty = (ConfigProperty)eList.get(i);
                J2EEResourceProperty j2EEResourceProperty = resourcesFactory.createJ2EEResourceProperty();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "..... setting up resource property: " + configProperty.getName());
                }
                if ((string6 = configProperty.getName()).indexOf("Password") != -1) {
                    bl = true;
                } else if (string6.indexOf("password") != -1) {
                    bl = true;
                }
                j2EEResourceProperty.setName(configProperty.getName());
                j2EEResourceProperty.setType(configProperty.getType());
                if (bl) {
                    String string7 = configProperty.getValue();
                    if (string7 != null && !string7.trim().equals("")) {
                        string7 = PasswordUtil.encode(string7);
                    }
                    j2EEResourceProperty.setValue(string7);
                } else {
                    j2EEResourceProperty.setValue(configProperty.getValue());
                }
                bl = false;
                j2EEResourceProperty.setDescription(configProperty.getDescription());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "..... setting up resource desc: " + configProperty.getDescription());
                }
                j2EEResourcePropertySet.getResourceProperties().add((Object)j2EEResourceProperty);
            }
            j2CResourceAdapter.setPropertySet(j2EEResourcePropertySet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJ2CResourceAdapter");
        }
        return j2CResourceAdapter;
    }

    private static void addFromString(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFromString: " + string + " and " + list);
        }
        if (string == null || list == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2 == null || string2.trim().length() == 0) continue;
            list.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFromString: " + list);
        }
    }

    private static String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = nls.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (Exception exception) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
    }

    public void extractArchive(String string, String string2, int n) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + string + ", flags=: " + n);
        }
        String string3 = this.expandVariable(string);
        string3 = string3.replace('\\', '/');
        String string4 = this.expandVariable(string2);
        string4 = string4.replace('/', File.separatorChar);
        AdminOperationsMBean._extractArchive(string3, string4, n);
        if (this.zos) {
            File file = new File(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "destFile", file.getAbsolutePath());
            }
            this.permset(file);
        }
    }

    public static void local_extractArchive(String string, String string2, int n, String string3, String string4, String string5) throws AdminException {
        String string6 = InstallRAHelper.expandVar(string, string3, string4, string5);
        string6 = string6.replace('\\', '/');
        String string7 = InstallRAHelper.expandVar(string2, string3, string4, string5);
        string7 = string7.replace('/', File.separatorChar);
        AdminOperationsMBean._extractArchive(string6, string7, n);
    }

    public static void _extractArchive(String string, String string2, int n) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + string + ", flags=: " + n);
        }
        try {
            ArchiveInit.init();
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ArchivePath: " + string);
            }
            Archive archive = commonarchiveFactory.openArchive(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Archive: " + archive);
            }
            if (archive != null) {
                String string3 = string2;
                File file = new File(string3);
                if (!(file.mkdirs() || file.exists() && file.isDirectory())) {
                    throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0031E", new String[]{string3}, "Error extracting archive: could not create directory path " + string3));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Dest: " + string3);
                }
                int n2 = 0;
                if (n >= 1000) {
                    n2 = n - 1000;
                }
                archive.extractTo(string3, n2);
                archive.close();
                if (n >= 1000) {
                    File file2 = new File(string);
                    boolean bl = file2.delete();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Delete original archive: " + string3 + " -- success: " + bl);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0029E", new String[]{string, throwable.toString()}, "Error extracting archive " + string + ": " + throwable));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractArchive");
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        this.adminImpl.configChanged(configRepositoryEvent);
    }

    private String getLine(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(string + ".sh ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + " ");
        }
        return stringBuffer.toString();
    }

    private void chmod(String string) throws Exception {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chmod()");
        }
        if (this.chmodPermissions == 0) {
            this.chmodPermissions = this.platformUtils.getUserReadMask() | this.platformUtils.getUserWriteMask() | this.platformUtils.getUserExecuteMask() | this.platformUtils.getGroupReadMask() | this.platformUtils.getGroupExecuteMask() | this.platformUtils.getOtherReadMask() | this.platformUtils.getOtherExecuteMask();
        }
        if ((n = this.platformUtils.chmod(string, this.chmodPermissions)) != 0 && tc.isEntryEnabled()) {
            Tr.exit(tc, "Return Code: ", new Integer(n).toString());
        }
    }

    private void permset(File file) {
        File[] fileArray = file.listFiles();
        String string = file.getAbsolutePath();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "files.length", new Integer(fileArray.length).toString());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            int n;
            if (fileArray[i].isDirectory()) {
                this.permset(fileArray[i]);
                continue;
            }
            if (!fileArray[i].getName().endsWith(".so")) continue;
            String string2 = string + File.separator + fileArray[i].getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cmd =", string2);
            }
            if (this.permsetPermissions == 0) {
                this.permsetPermissions = this.platformUtils.getUserReadMask() | this.platformUtils.getUserWriteMask() | this.platformUtils.getUserExecuteMask() | this.platformUtils.getGroupReadMask() | this.platformUtils.getGroupExecuteMask() | this.platformUtils.getOtherReadMask() | this.platformUtils.getOtherExecuteMask();
            }
            if ((n = this.platformUtils.chmod(string2, this.permsetPermissions)) == 0 || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Return Code: ", new Integer(n).toString());
        }
    }

    public void updateMetadataForNode(String string, Properties properties) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMetadataForNode");
        }
        try {
            Object object;
            Object object2;
            AdminService adminService;
            block36: {
                if (string == null) {
                    AdminException adminException = new AdminException("updateMetadataForNode: Invalid parameter. Null node name.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Null node name.");
                    }
                    throw adminException;
                }
                if (properties == null) {
                    AdminException adminException = new AdminException("updateMetadataForNode: Invalid parameter. Null metadata properties object.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Null metadata properties object.");
                    }
                    throw adminException;
                }
                adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    AdminException adminException = new AdminException("updateMetadataForNode: Null AdminService reference.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Null AdminService reference.");
                    }
                    throw adminException;
                }
                String string2 = adminService.getProcessType();
                if (!string2.equals("DeploymentManager") && !string2.equals("UnManagedProcess")) {
                    AdminException adminException = new AdminException("The updateMetadataForNode method on the AdminOperations MBean was invoked in a process in a managed environment other than the dmgr process.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateMetadataForNode: Not DMgr process.");
                    }
                    throw adminException;
                }
                try {
                    object2 = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                    object = object2.getMetadataProperties(string);
                    if (((Properties)object).equals(properties)) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "updateMetadataForNode: No metadata properties have changed.");
                        }
                        return;
                    }
                }
                catch (AdminException adminException) {
                    if (!tc.isDebugEnabled()) break block36;
                    Tr.debug(tc, "updateMetadataForNode: exception occurred while comparing node metadata: ", adminException);
                }
            }
            object2 = new Properties();
            ((Properties)object2).setProperty("location", "local");
            object = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)object2);
            if (object == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "updateMetadataForNode: Null ConfigRepository returned.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "updateMetadataForNode: Null ConfigRepository.");
                }
                return;
            }
            String string3 = adminService.getCellName();
            String string4 = ConfigStructureHelper.getURI(adminService.getCellName(), string, "", "node-metadata.properties");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, null);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            DocumentContentSource documentContentSource = null;
            int n = 2;
            DocumentChangedException documentChangedException = null;
            try {
                Object object3;
                do {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateMetadataForNode: Extracting " + string4);
                    }
                    object3 = object.getDigest(string4);
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "updateMetadataForNode: Modifying " + string4);
                        }
                        documentContentSource = new DocumentContentSource(new Document(string4, (DocumentDigest)object3), new ByteArrayInputStream(byArray));
                        DocumentDigest documentDigest = object.modify(documentContentSource);
                        n = -99;
                    }
                    catch (DocumentChangedException documentChangedException2) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "updateMetadataForNode: DocumentChangedException.", new Object[]{"retryCount=" + n, documentChangedException2});
                        }
                        --n;
                        documentChangedException = documentChangedException2;
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "updateMetadataForNode: Failed to write metadata.", throwable);
                        }
                        AdminException adminException = new AdminException(throwable, "Could not update node metadata.  See root exception for more info.");
                        throw adminException;
                    }
                } while (n >= 0);
                if (n == -1) {
                    object3 = new AdminException(documentChangedException, "Could not store metadata to the config repository after 2 retries.");
                    Tr.exit(tc, "updateMetadataForNode: Exhausted retry count.", object3);
                    throw object3;
                }
            }
            catch (DocumentNotFoundException documentNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateMetadataForNode: Creating " + string4);
                }
                documentContentSource = new DocumentContentSource(new Document(string4), new ByteArrayInputStream(byArray));
                DocumentDigest documentDigest = object.create(documentContentSource);
                n = -99;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateMetadataForNode: Failed to read existing metadata.", throwable);
                }
                AdminException adminException = new AdminException(throwable, "Could not read node metadata.  See root exception for more info.");
                throw adminException;
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException(adminException, "com.ibm.ws.management.component.AdminOperationsMBean.updateMetadataForNode", "1032");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateMetadataForNode: AdminException: " + adminException);
            }
            throw adminException;
        }
        catch (Throwable throwable) {
            AdminException adminException = new AdminException(throwable, "Could not update node metadata.  See root exception for more info.");
            FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminOperationsMBean.updateMetadataForNode", "953");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateMetadataForNode: Exception: ", throwable);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMetadataForNode");
        }
    }

    public Properties collectMetadataForThisNode() throws AdminException {
        Properties properties;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectMetadataForThisNode");
        }
        try {
            ManagedObjectMetadataCollectorManager managedObjectMetadataCollectorManager;
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService == null) {
                AdminException adminException = new AdminException("collectMetadataForThisNode: Null AdminService reference.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "collectMetadataForThisNode: Null AdminService reference.");
                }
                throw adminException;
            }
            String string = adminService.getProcessType();
            if (string.equals("DeploymentManager") || string.equals("UnManagedProcess")) {
                managedObjectMetadataCollectorManager = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null);
            } else {
                AdminClient adminClient = adminService.getDeploymentManagerAdminClient();
                managedObjectMetadataCollectorManager = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(null, adminClient);
            }
            properties = managedObjectMetadataCollectorManager.updateMetadata("Collect Metadata", null);
        }
        catch (AdminException adminException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "collectMetadataForThisNode: AdminException: " + adminException);
            }
            throw adminException;
        }
        catch (Throwable throwable) {
            AdminException adminException = new AdminException(throwable, "Could not collect metadata.  See root exception for more info.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "collectMetadataForThisNode: Exception: ", throwable);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectMetadataForThisNode", properties);
        }
        return properties;
    }

    public Hashtable _getAppDistributionStatus(String string, Hashtable hashtable) throws AdminException {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getAppDistributionStatus: " + string);
        }
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        String string2 = new String();
        String string3 = System.getProperty("user.install.root");
        String string4 = CommonAppUtils.getAppSyncMarkerLocation(string3, string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "marker name: " + string4);
        }
        string2 = !(file = new File(string4)).exists() ? "-1" : (file.length() < 4L ? "0" : "ADMA7008E");
        hashtable2.put(string, string2);
        if (!file.exists()) {
            Tr.debug(tc, " marker file doesnt exist calling J2CApp");
            Hashtable hashtable3 = J2CAppUtils.getAppDocuments(string);
            if (hashtable3 != null) {
                hashtable2.put("uri", hashtable3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getAppDistributionStatus: " + hashtable2);
        }
        return hashtable2;
    }

    public Hashtable getRARInfo(String string, Hashtable hashtable) throws AdminException {
        String string2 = this.expandVariable(string);
        string2 = string2.replace('\\', '/');
        Hashtable hashtable2 = AdminOperationsMBean._getRARInfo(string2, hashtable);
        return hashtable2;
    }

    public static Hashtable _getRARInfo(String string, Hashtable hashtable) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRARInfo: " + string + ", " + hashtable);
        }
        if (string == null) {
            throw new AdminException(AdminOperationsMBean.getFormattedMessage("ADMN0027E", null, null));
        }
        RARFile rARFile = null;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        try {
            ArchiveInit.init();
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Path: " + string);
            }
            rARFile = commonarchiveFactory.openRARFile(string);
            Connector connector2 = rARFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connector is: " + connector2);
            }
            String string2 = null;
            String string3 = (String)hashtable.get("rar.desc");
            String string4 = (String)hashtable.get("rar.archivePath");
            String string5 = (String)hashtable.get("rar.classpath");
            String string6 = (String)hashtable.get("rar.nativePath");
            string2 = connector2.getDisplayName();
            if (string2 == null || string2.equals("")) {
                string2 = (String)hashtable.get("rar.name");
            }
            if (string3 == null || string3.equals("")) {
                string3 = connector2.getDescription();
            }
            if (string4 == null || string4.equals("")) {
                string4 = string;
            }
            if (string5 == null || string5.equals("")) {
                string5 = string;
            }
            if (string6 == null || string6.equals("")) {
                string6 = string;
            }
            if (string2 != null) {
                hashtable2.put("rar.name", string2);
            }
            if (string3 != null) {
                hashtable2.put("rar.desc", string3);
            }
            if (string4 != null) {
                hashtable2.put("rar.archivePath", string4);
            }
            if (string5 != null) {
                hashtable2.put("rar.classpath", string5);
            }
            if (string6 != null) {
                hashtable2.put("rar.nativePath", string6);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.component.AdminOperationsMBean._getResourceAdapterFromRAR", "545");
            throw new AdminException(exception, AdminOperationsMBean.getFormattedMessage("ADMN0028E", new String[]{string, exception.toString()}, "Could not open RAR file " + string));
        }
        finally {
            if (rARFile != null) {
                rARFile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceAdapterFromRAR:" + hashtable2);
        }
        return hashtable2;
    }

    public static Hashtable local_getRARInfo(String string, Hashtable hashtable, String string2, String string3, String string4) {
        Hashtable hashtable2 = new Hashtable();
        String string5 = InstallRAHelper.expandVar(string, string2, string3, string4);
        string5 = string5.replace('\\', '/');
        try {
            hashtable2 = AdminOperationsMBean._getRARInfo(string, hashtable);
        }
        catch (Exception exception) {
            System.out.println("Unexpected Exception" + exception);
        }
        return hashtable2;
    }

    public static String getNodeMajorVersion(String string, String string2) throws AdminException {
        try {
            Properties properties = new Properties();
            properties.setProperty("local.cell", string);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
            String string3 = managedObjectMetadataHelper.getNodeMajorVersion(string2);
            return string3;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, "");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<clinit>", "com.ibm.ws.management.component.AdminOperationsMBean_ignoreBeanPropertyExceptions=" + ignoreBeanPropertyExceptions);
        }
    }
}

