/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.deploymentmanager.DeploymentManager;
import com.ibm.ws.management.service.CellManager;
import com.ibm.ws.management.sync.CellSync;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class CellManagerImpl
extends ComponentImpl
implements CellManager {
    private static TraceComponent tc = Tr.register(CellManagerImpl.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private VariableMap variableMap = null;
    private Repository repository = null;
    private EndPointMgr endPtMgr = null;
    private com.ibm.websphere.models.config.cellmanager.CellManager dmgrCfg = null;
    private CellSync cellSync = null;

    public void initialize(Object object) throws ComponentDisabledException {
        com.ibm.websphere.models.config.cellmanager.CellManager cellManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        if ((cellManager = (com.ibm.websphere.models.config.cellmanager.CellManager)object).getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this.dmgrCfg = (com.ibm.websphere.models.config.cellmanager.CellManager)etoolsCopyUtility.copy((EObject)cellManager);
        this.addService(CellManager.class);
        this.variableMap = (VariableMap)this.getService(VariableMap.class);
        this.repository = (Repository)this.getService(Repository.class);
        this.endPtMgr = (EndPointMgr)this.getService(EndPointMgr.class);
        this.releaseService(this.variableMap);
        this.releaseService(this.repository);
        this.releaseService(this.endPtMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        boolean bl = false;
        if (AdminHelper.getPlatformHelper().isZOS() && !AdminHelper.getPlatformHelper().isControlJvm()) {
            bl = true;
        }
        if (!bl) {
            try {
                this.registerAgentMBean();
                this.initializeCellSync();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.CellManagerImpl.start", "67", this);
                throw new RuntimeError(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CellManagerImpl.stop: calling CellSync.stop()");
        }
        if (this.cellSync != null) {
            this.cellSync.stop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
    }

    private void initializeCellSync() throws ConfigurationWarning {
        this.cellSync = CellSync.getCellSync();
        try {
            this.cellSync.initialize(this.variableMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.CellManagerImpl.initializeCellSync", "302", this);
            throw new ConfigurationWarning("Problem initializing cell sync.", exception);
        }
    }

    private void registerAgentMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAgentMBeans");
        }
        String string = AdminServiceFactory.getAdminService().getCellName();
        String string2 = this.repository.getRootURI();
        DeploymentManager deploymentManager = new DeploymentManager(string2, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAgentMBeans");
        }
    }
}

