/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

class ConfigChangeHandler
implements ConfigRepositoryListener,
AlarmListener,
NotificationListener {
    private static final TraceComponent tc = Tr.register(ConfigChangeHandler.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private List listeners = new ArrayList();
    private boolean holdEvents = false;
    private List heldEvents = new ArrayList();

    ConfigChangeHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addConfigChangeListener", configChangeListener);
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(configChangeListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addConfigChangeListener", configChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeConfigChangeListener", configChangeListener);
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(configChangeListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeConfigChangeListener", configChangeListener);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node sync initiated");
            }
            this.holdEvents = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            ConfigRepositoryEvent configRepositoryEvent;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node sync complete");
            }
            ConfigRepository configRepository = null;
            ArrayList<ConfigChangeNotifier> arrayList = new ArrayList<ConfigChangeNotifier>();
            ConfigChangeNotifier[] configChangeNotifierArray = this.heldEvents.iterator();
            while (configChangeNotifierArray.hasNext()) {
                configRepositoryEvent = (ConfigRepositoryEvent)configChangeNotifierArray.next();
                if (configRepository == null) {
                    configRepository = (ConfigRepository)configRepositoryEvent.getSource();
                }
                arrayList.addAll(Arrays.asList(configRepositoryEvent.getChanges()));
            }
            if (arrayList.size() > 0) {
                configChangeNotifierArray = new ConfigChangeNotifier[arrayList.size()];
                arrayList.toArray(configChangeNotifierArray);
                configRepositoryEvent = new ConfigRepositoryEvent(configRepository, ConfigRepositoryEvent.generateId(), configChangeNotifierArray);
                this.sendEvent(configRepositoryEvent);
                this.heldEvents.clear();
            }
            this.holdEvents = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onChangeCompletion");
        }
        if (this.holdEvents) {
            this.heldEvents.add(configRepositoryEvent);
        } else {
            this.sendEvent(configRepositoryEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onChangeCompletion");
        }
    }

    public void onRepositoryEpochRefresh() {
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged");
        }
        this.sendEvent(configRepositoryEvent);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        ConfigChangeEventDispatcher configChangeEventDispatcher = (ConfigChangeEventDispatcher)object;
        configChangeEventDispatcher.run();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm", object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendEvent," + configRepositoryEvent.getId());
        }
        List list = this.listeners;
        synchronized (list) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                AlarmManager.createNonDeferrable(0L, this, new ConfigChangeEventDispatcher(configRepositoryEvent, (ConfigChangeListener)iterator.next()));
            }
        }
        new Thread(new ConfigChangeEventWorker(configRepositoryEvent)).start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendEvent");
        }
    }

    private class ConfigChangeEventDispatcher
    implements Runnable {
        private ConfigRepositoryEvent e;
        private ConfigChangeListener l = null;
        private ObjectName adminOperation = null;

        ConfigChangeEventDispatcher(ConfigRepositoryEvent configRepositoryEvent, ConfigChangeListener configChangeListener) {
            this.e = configRepositoryEvent;
            this.l = configChangeListener;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Dispatcher created for listener " + configChangeListener);
            }
        }

        ConfigChangeEventDispatcher(ConfigRepositoryEvent configRepositoryEvent, ObjectName objectName) {
            this.e = configRepositoryEvent;
            this.adminOperation = objectName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Dispatcher created for " + objectName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            Subject subject = null;
            Subject subject2 = null;
            subject2 = SecurityHelper.getOwnedSubject();
            try {
                if (subject2 != null) {
                    subject = SecurityHelper.pushInvocationSubject(subject2);
                }
                if (this.l != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Notifying local listener", this.l);
                    }
                    this.l.configChanged(this.e);
                } else if (this.adminOperation != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Notifying remote listener", this.adminOperation);
                    }
                    try {
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        adminService.invoke(this.adminOperation, "configChanged", new Object[]{this.e}, new String[]{"com.ibm.websphere.management.repository.ConfigRepositoryEvent"});
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.component.ConfigChangeHandler.run", "186", this);
                        Tr.warning(tc, "ADMN0014W", new Object[]{this.adminOperation, this.e});
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "ibm.ws.management.component.ConfigChangeHandler", "8888", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in ConfigChangeHandler run method:" + exception);
                }
            }
            finally {
                if (subject2 != null) {
                    SecurityHelper.popInvocationSubject(subject);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }
    }

    private class ConfigChangeEventWorker
    implements Runnable {
        private ConfigRepositoryEvent e;

        ConfigChangeEventWorker(ConfigRepositoryEvent configRepositoryEvent) {
            this.e = configRepositoryEvent;
        }

        public void run() {
            Subject subject;
            Subject subject2;
            block11: {
                AdminService adminService;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "ConfigChangeEventWorker started," + this.e.getId());
                }
                subject2 = null;
                subject = null;
                subject = SecurityHelper.getOwnedSubject();
                if (subject != null) {
                    subject2 = SecurityHelper.pushInvocationSubject(subject);
                }
                if ((adminService = AdminServiceFactory.getAdminService()).getProcessType().equals("NodeAgent")) {
                    ObjectName objectName;
                    block10: {
                        objectName = null;
                        try {
                            objectName = new ObjectName("*:type=AdminOperations,*");
                        }
                        catch (MalformedObjectNameException malformedObjectNameException) {
                            malformedObjectNameException.printStackTrace();
                            if (!tc.isDebugEnabled()) break block10;
                            Tr.debug(tc, "There was an error forming object name for AdminOpeartions mbean");
                        }
                    }
                    try {
                        Set set = adminService.queryNames(objectName, null);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            ObjectName objectName2 = (ObjectName)iterator.next();
                            String string = ObjectNameHelper.getProcessName(objectName2);
                            if (string.equals(adminService.getProcessName())) continue;
                            new Thread(new ConfigChangeEventDispatcher(this.e, objectName2)).start();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "There was an error querying AdminOpeartions mbeans, config changes event may not be sent to downstream servers.");
                    }
                }
            }
            if (subject != null) {
                SecurityHelper.popInvocationSubject(subject2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConfigChangeEventWorker done");
            }
        }
    }
}

