/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.authorizer.service.AdminAuthzService;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.HTTPConnector;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.TCPIPProtocolType;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.connector.rmi.RMIConnectorController;
import com.ibm.ws.management.connector.soap.JMXSoapAdapter;
import com.ibm.ws.management.discovery.CMDiscoveryAdapter;
import com.ibm.ws.management.discovery.DiscoveryAdapter;
import com.ibm.ws.management.discovery.MPDiscoveryAdapter;
import com.ibm.ws.management.discovery.NADiscoveryAdapter;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.transport.MulticastServer;
import com.ibm.ws.management.dmgrmode.DmgrModeFactory;
import com.ibm.ws.management.dmgrmode.DmgrModeListener;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.nodeagent.Forwarder;
import com.ibm.ws.management.remote.RMIServer;
import com.ibm.ws.management.repository.FileRepository;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.workloadcontroller.IWorkloadRegulator;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.util.ThreadPool;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class JMXConnectors
extends ComponentImpl
implements IWorkloadRegulator,
PropertyChangeListener,
SecurityServiceListener,
DmgrModeListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(JMXConnectors.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS connectorNLS = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    public static String FILETRANSFER_BUNDLE_NAME = "com.ibm.ws.management.resources.fileservice";
    private static final ResourceBundle FILETRANSFER_RESOURCE_BUNDLE = ResourceBundle.getBundle(FILETRANSFER_BUNDLE_NAME, Locale.getDefault());
    private static final String TMX4J_HTTP_PORT_PROPERTY = "tmx4j.httpadaptor.port";
    public static final String DEFAULT_HTTP_CONNECTOR_PORT = "8082";
    private SecurityService securityService;
    private EndPointMgr endPtMgr;
    private Repository repository;
    private MBeanFactory _mbeanFactory;
    private String adminType;
    private String cellName;
    private String nodeName;
    private String serverName;
    private int cellDiscoveryProtocol;
    private int nodeDiscoveryProtocol;
    private String pConnectorType;
    private EndPtCollector epCollector;
    private ThreadPoolMgr threadPoolMgr;
    private JMXConnector soapConnector;
    private JMXConnector rmiConnector;
    private boolean soapConnectorEnabled = false;
    private boolean rmiConnectorEnabled = false;
    private boolean httpConnectorEnabled = false;
    private boolean soapConnectorThreadPoolGrowable = true;
    private String httpAdapterPort;
    private Properties soapConnectorProperties;
    private String sslConfigProp;
    private boolean jsr160Enabled = true;
    private boolean connectorStopped = false;
    private RMIServer rmiService = null;
    private String RMI_CONNECTOR_PROP = "disableJDKRMIConnector";
    private boolean security_started = false;
    private boolean WLC_started = false;
    public static boolean loginQuickFail;
    static /* synthetic */ Class class$com$ibm$ws$management$discovery$ServerInfo;

    public void initialize(Object object) {
        Object object2;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", object);
            }
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servant process - exiting initialize");
                }
                return;
            }
            this.endPtMgr = (EndPointMgr)this.getService(EndPointMgr.class);
            this.threadPoolMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
            this.repository = (Repository)this.getService(Repository.class);
            this.cellName = this.repository.getCellName();
            this.nodeName = this.repository.getNodeName();
            this.serverName = this.repository.getServerName();
            try {
                object2 = this.repository.getConfigRoot();
                Resource resource = object2.getResource(0, "cell.xml");
                Cell cell = (Cell)resource.getContents().get(0);
                EList eList = cell.getProperties();
                for (int i = 0; i < eList.size(); ++i) {
                    Property property = (Property)eList.get(i);
                    String string = property.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found property: " + string);
                    }
                    if (string == null || !string.equals("com.ibm.ws.management.connector.loginQuickFail")) continue;
                    loginQuickFail = new Boolean(property.getValue());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loginQuickFail=" + loginQuickFail);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Throwable while trying to extract loginQuickFail value:");
            }
        }
        object2 = (Server)this.getService(Server.class);
        object2.addPropertyChangeListener("state", this);
        WorkloadController.registerRegulator(this);
        this.releaseService(this.endPtMgr);
        this.releaseService(this.repository);
        this.releaseService(this.threadPoolMgr);
        this.releaseService(object2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        boolean bl = AdminHelper.getPlatformHelper().isServantJvm();
        this.securityService = (SecurityService)this.getService(SecurityService.class);
        AdminAuthzService adminAuthzService = (AdminAuthzService)this.getService(AdminAuthzService.class);
        SecurityHelper.getHelper().setSecurityService(this.securityService);
        this.securityService.addListener(SecurityHelper.getHelper());
        adminAuthzService.addListener(SecurityHelper.getHelper());
        this.securityService.addListener(this);
        this.releaseService(this.securityService);
        DmgrModeFactory.getDmgrModeManager().addListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    private void initDiscovery() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initDiscovery");
            }
            try {
                Properties properties = AdminInitializer.getInstance().getProperties();
                this.adminType = (String)properties.get("adminTypeProperty");
                if (!this.adminType.equals("UnManagedProcess")) {
                    String string;
                    if (!this.adminType.equals("ManagedProcess")) {
                        this.epCollector = new EndPtCollector(this.endPtMgr);
                    }
                    this.cellDiscoveryProtocol = (string = (String)properties.get("cellDiscoveryProtocolConfigProperty")) != null ? TCPIPProtocolType.get((String)string).getValue() : 1;
                    String string2 = (String)properties.get("nodeDiscoveryProtocolConfigProperty");
                    this.nodeDiscoveryProtocol = string2 != null ? TCPIPProtocolType.get((String)string2).getValue() : 1;
                    this.interprocessRegistration();
                    if (this.epCollector != null && !this.adminType.equals("NodeAgent")) {
                        this.epCollector.discard();
                        this.epCollector = null;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.initDiscovery", "202", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Got Exception initializing discovery:", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDiscovery");
        }
    }

    public void stop() {
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant process - exiting stop");
            }
            return;
        }
        if (this.soapConnectorEnabled && this.soapConnector != null) {
            this.soapConnector.stop();
        }
        RoutingTable.getInstance().shutdown();
    }

    public void destroy() {
    }

    public void initializeConnectors(AdminService adminService) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeConnectors");
        }
        EList eList = adminService.getConnectors();
        com.ibm.websphere.models.config.adminservice.JMXConnector jMXConnector = null;
        EList eList2 = null;
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            block0: for (int i = 0; i < eList.size(); ++i) {
                jMXConnector = (com.ibm.websphere.models.config.adminservice.JMXConnector)eList.get(i);
                if (!(jMXConnector instanceof SOAPConnector)) continue;
                eList2 = jMXConnector.getProperties();
                for (int j = 0; j < eList2.size(); ++j) {
                    Property property = (Property)eList2.get(j);
                    if (!property.getName().equals("sslConfig")) continue;
                    this.sslConfigProp = property.getValue();
                    if (!tc.isDebugEnabled()) break block0;
                    Tr.debug(tc, "Servant Process - initializeConnectors " + this.sslConfigProp);
                    break block0;
                }
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant process - exiting initializeConnectors");
            }
            return;
        }
        com.ibm.websphere.models.config.adminservice.JMXConnector jMXConnector2 = adminService.getPreferredConnector();
        EndPointMgr.NodeEndPoints nodeEndPoints = this.endPtMgr.getNodeEndPoints("@");
        EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints("@");
        for (int i = 0; i < eList.size(); ++i) {
            jMXConnector = (com.ibm.websphere.models.config.adminservice.JMXConnector)eList.get(i);
            eList2 = jMXConnector.getProperties();
            Properties properties = new Properties();
            for (int j = 0; j < eList2.size(); ++j) {
                Property property = (Property)eList2.get(j);
                String string = property.getName();
                String string2 = property.getValue();
                if (string == null || string2 == null) continue;
                properties.put(string, string2);
                if (!string.equals("sslConfig")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client SSL config initialized to: " + string2);
                }
                SecurityHelper.getHelper().setClientSSLAlias(string2);
            }
            if (jMXConnector instanceof SOAPConnector) {
                this.initSOAPConnector(properties, serverEndPoints, this.threadPoolMgr);
                this.soapConnectorEnabled = true;
                if (!jMXConnector.getClass().isAssignableFrom(jMXConnector2.getClass())) continue;
                this.pConnectorType = "SOAP";
                String string = properties.getProperty("requestTimeout");
                if (string == null) continue;
                System.getProperties().setProperty("com.ibm.SOAP.requestTimeout", string);
                continue;
            }
            if (jMXConnector instanceof HTTPConnector) {
                this.initHTTPConnector(properties);
                this.httpConnectorEnabled = true;
                continue;
            }
            if (!(jMXConnector instanceof RMIConnector)) continue;
            this.jsr160Enabled(jMXConnector);
            this.initRMIConnector(properties, serverEndPoints);
            this.rmiConnectorEnabled = true;
            if (!jMXConnector.getClass().isAssignableFrom(jMXConnector2.getClass())) continue;
            this.pConnectorType = "RMI";
        }
        if (tc.isDebugEnabled() && this.pConnectorType != null) {
            Tr.debug(tc, "the preferred connector type:", this.pConnectorType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeConnectors");
        }
    }

    private void jsr160Enabled(com.ibm.websphere.models.config.adminservice.JMXConnector jMXConnector) {
        EList eList = null;
        if (jMXConnector instanceof RMIConnector) {
            eList = jMXConnector.getProperties();
            for (int i = 0; i < eList.size(); ++i) {
                Property property = (Property)eList.get(i);
                if (!property.getName().equals(this.RMI_CONNECTOR_PROP)) continue;
                String string = property.getValue();
                if (string != null && string.equals("true")) {
                    this.jsr160Enabled = false;
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Remote JMX - initialize RMI Connector " + this.jsr160Enabled);
                break;
            }
        }
    }

    private void initSOAPConnector(Properties properties, EndPointMgr.EndPoints endPoints, ThreadPoolMgr threadPoolMgr) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSOAPConnector");
        }
        String string = null;
        String string2 = null;
        EndPoint endPoint = null;
        String string3 = AdminServiceFactory.getAdminService().getProcessType();
        if (string3.equals("DeploymentManager")) {
            endPoint = endPoints.getEndPoint("SOAP_PROXY_CONNECTOR_ADDRESS");
        }
        if (endPoint == null) {
            endPoint = endPoints.getEndPoint("SOAP_CONNECTOR_ADDRESS");
        }
        if (endPoint != null) {
            string = new Integer(endPoint.getPort()).toString();
            string2 = endPoint.getHost();
            if (string2 == null) {
                try {
                    string2 = AdminHelper.getInstance().getHostName();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.initSOAPConnector", "296", this);
                }
            }
        } else {
            throw new RuntimeError(connectorNLS.getString("ADMC0016E"));
        }
        properties.setProperty("type", "SOAP");
        properties.setProperty("host", string2);
        properties.setProperty("port", string);
        this.soapConnectorProperties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initSOAPConnector", this.soapConnectorProperties);
        }
    }

    private void startSOAPConnector() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startSOAPConnector");
        }
        if (!this.soapConnectorEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "soapConnector is not enabled");
            }
            return;
        }
        int n = 5;
        String string = System.getProperty("com.ibm.websphere.management.soapThreads");
        String string2 = System.getProperty("com.ibm.websphere.management.soapConnectorThreadPoolGrowable");
        if (string2 != null) {
            this.soapConnectorThreadPoolGrowable = new Boolean(string2);
        }
        if (string != null) {
            n = new Integer(string);
        }
        ThreadPool threadPool = this.getThreadPool("SoapConnectorThreadPool", n);
        JMXSoapAdapter jMXSoapAdapter = new JMXSoapAdapter(threadPool);
        this.soapConnector = jMXSoapAdapter;
        jMXSoapAdapter.initialize(this.soapConnectorProperties);
        this.soapConnectorProperties = null;
        DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(jMXSoapAdapter, "SOAPConnector");
        AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", defaultRuntimeCollaborator, "SOAPConnector", null);
        this.soapConnector.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startSOAPConnector");
        }
    }

    private void initRMIConnector(Properties properties, EndPointMgr.EndPoints endPoints) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initRMIConnector");
        }
        try {
            this.rmiConnector = new RMIConnectorController();
            Properties properties2 = new Properties();
            String string = null;
            String string2 = null;
            EndPoint endPoint = endPoints.getEndPoint("BOOTSTRAP_ADDRESS");
            if (endPoint == null) {
                throw new RuntimeError(connectorNLS.getString("ADMC0018E"));
            }
            string = new Integer(endPoint.getPort()).toString();
            string2 = endPoint.getHost();
            properties2.setProperty("type", "RMI");
            properties2.setProperty("port", string);
            properties2.setProperty("host", string2);
            this.rmiConnector.initialize(properties2);
            AdminServiceFactory.getMBeanFactory().activateMBean("JMXConnector", new DefaultRuntimeCollaborator(this.rmiConnector, "RMIConnector"), "RMIConnector", null);
            try {
                if (this.jsr160Enabled) {
                    this.rmiService = new RMIServer();
                    this.rmiService.initialize(properties2);
                }
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException("Connector Error:" + iOException.getMessage());
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
            catch (ConnectorException connectorException) {
                RuntimeException runtimeException = new RuntimeException("Connector Error:" + connectorException.getMessage());
                runtimeException.initCause(connectorException);
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.component.JMXConnectors.initRMIConnector", "396", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to initialize the RMI connector", throwable);
            }
            Tr.error(tc, "ADMC0020E", throwable.getMessage());
            throw new RuntimeError(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initRMIConnector");
        }
    }

    public void startRMIConnector() {
        boolean bl;
        boolean bl2 = AdminHelper.getPlatformHelper().isZOS() ? true : (bl = this.security_started && this.WLC_started);
        if (bl) {
            try {
                if (this.rmiConnectorEnabled) {
                    this.rmiConnector.start();
                }
                if (this.jsr160Enabled && this.rmiService != null) {
                    this.rmiService.start();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    private void initHTTPConnector(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initHTTPConnector");
        }
        this.httpAdapterPort = properties.getProperty("port");
        if (this.httpAdapterPort == null || this.httpAdapterPort.equals("")) {
            this.httpAdapterPort = DEFAULT_HTTP_CONNECTOR_PORT;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initHTTPConnector", this.httpAdapterPort);
        }
    }

    private void startHTTPConnector() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startHTTPConnector");
        }
        if (!this.httpConnectorEnabled) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "httpConnector is not enabled");
            }
            return;
        }
        try {
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                Tr.audit(tc, "ADMC0040I");
            } else {
                System.setProperty(TMX4J_HTTP_PORT_PROPERTY, this.httpAdapterPort);
                ObjectName objectName = new ObjectName("WebSphere", "name", "HTTPAdapter");
                ObjectInstance objectInstance = AdminServiceFactory.getMBeanFactory().getMBeanServer().createMBean("com.tivoli.jmx.http_pa.Listener", objectName);
                AdminServiceFactory.getMBeanFactory().getMBeanServer().invoke(objectName, "startListener", null, null);
                Tr.audit(tc, "ADMC0027I", this.httpAdapterPort);
                this.httpAdapterPort = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.startHTTPConnector", "381", this);
            Tr.warning(tc, "ADMC0028W", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startHTTPConnector");
        }
    }

    private void interprocessRegistration() throws Exception {
        Object object;
        JMXConnector[] jMXConnectorArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interprocessRegistration");
        }
        if (this.adminType.equals("UnManagedProcess")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "interprocessRegistration - standalone");
            }
            return;
        }
        Process process = ProcessFactory.createSelf();
        String string = process.id();
        Vector<String> vector = new Vector<String>();
        EndPoint endPoint = this.endPtMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("BOOTSTRAP_ADDRESS");
        if (endPoint != null) {
            jMXConnectorArray = new Integer(endPoint.getPort()).toString();
            String string2 = endPoint.getHost();
            object = new StringBuffer("endpoint:");
            ((StringBuffer)object).append("name=").append("BOOTSTRAP_ADDRESS");
            ((StringBuffer)object).append(";host=").append(string2);
            ((StringBuffer)object).append(";port=").append((String)jMXConnectorArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bootstrap endpoint:", object);
            }
            vector.addElement(((StringBuffer)object).toString());
        }
        jMXConnectorArray = new JMXConnector[]{this.soapConnector, this.rmiConnector};
        for (int i = 0; i < jMXConnectorArray.length; ++i) {
            object = jMXConnectorArray[i];
            if (jMXConnectorArray[i] == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "skipping connector at position " + i);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer("connector:");
            stringBuffer.append(object.getName());
            if (this.pConnectorType != null && object.getType().equals(this.pConnectorType)) {
                stringBuffer.append(";preferred=true");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the preferred connector name: ", stringBuffer);
                }
            }
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security enabled connector");
                }
                stringBuffer.append(";").append("securityEnabled").append("=true");
            }
            stringBuffer.append(";").append("isInternal").append("=true");
            vector.addElement(stringBuffer.toString());
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "connector URI: " + stringBuffer);
        }
        ServerInfo serverInfo = new ServerInfo(string, this.cellName, this.nodeName, this.serverName, this.adminType, Utils.getProductVersion(), vector);
        RoutingTable.getInstance().setOwnInfo(serverInfo);
        if (this.adminType.equals("DeploymentManager")) {
            this.doCellMgrDiscovery(serverInfo);
        } else if (this.adminType.equals("NodeAgent")) {
            this.doNodeAgentDiscovery(serverInfo);
        } else if (this.adminType.equals("ManagedProcess")) {
            this.doManagedProcessDiscovery(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interprocessRegistration");
        }
    }

    private void doCellMgrDiscovery(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCellMgrDiscovery");
        }
        Map map = this.epCollector.getNodeAgents();
        String string = new Integer(this.epCollector.getCellDiscoveryEndPoint().getPort()).toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initialize the CellManager discovery service");
        }
        CMDiscoveryAdapter cMDiscoveryAdapter = new CMDiscoveryAdapter(serverInfo, string, this.cellDiscoveryProtocol);
        try {
            cMDiscoveryAdapter.initialize(this.threadPoolMgr);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.doCellMgrDiscovery", "455", this);
            Tr.error(tc, "ADMC0029E", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doCellMgrDiscovery - failed");
            }
            return;
        }
        HashMap hashMap = this.loadNodeProtocols();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            EndPoint endPoint = (EndPoint)map.get(string2);
            String string3 = endPoint.getHost();
            String string4 = new Integer(endPoint.getPort()).toString();
            ServerInfo serverInfo2 = new ServerInfo(this.cellName, string2, "NodeAgent");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The deployment manager is looking for the node agent: ", new Object[]{string2, string3, string4, serverInfo2});
            }
            Integer n = (Integer)hashMap.get(string2);
            int n2 = 1;
            if (n != null) {
                n2 = n;
            }
            cMDiscoveryAdapter.discovery(string3, string4, n2, serverInfo2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCellMgrDiscovery");
        }
    }

    private void doNodeAgentDiscovery(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doNodeAgentDiscovery");
        }
        String string = new Integer(this.epCollector.getNodeDiscoveryEndPoint().getPort()).toString();
        NADiscoveryAdapter nADiscoveryAdapter = new NADiscoveryAdapter(serverInfo, string, this.nodeDiscoveryProtocol);
        try {
            nADiscoveryAdapter.initialize(this.threadPoolMgr);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.doNodeAgentDiscovery", "501", this);
            Tr.error(tc, "ADMC0030E", exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doNodeAgentDiscovery - failed");
            }
            return;
        }
        Map map = this.epCollector.getDmgrs();
        EndPoint endPoint = map.keySet().iterator();
        while (endPoint.hasNext()) {
            String string2 = (String)endPoint.next();
            EndPoint endPoint2 = (EndPoint)map.get(string2);
            String string3 = endPoint2.getHost();
            String string4 = new Integer(endPoint2.getPort()).toString();
            ServerInfo serverInfo2 = new ServerInfo(this.cellName, string2, "DeploymentManager");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The node agent is looking for the cell manager: ", new Object[]{string2, string3, string4, serverInfo2});
            }
            nADiscoveryAdapter.discovery(string3, string4, this.cellDiscoveryProtocol, serverInfo2);
        }
        endPoint = this.getServerMulticastDiscoveryEndPoint();
        EndPoint endPoint3 = this.getServerIPv6MulticastDiscoveryEndPoint();
        ServerInfo serverInfo3 = new ServerInfo(this.cellName, this.nodeName, "ManagedProcess");
        String string5 = null;
        String string6 = null;
        MulticastVerifier multicastVerifier = null;
        if (endPoint != null) {
            string5 = endPoint.getHost();
            string6 = new Integer(endPoint.getPort()).toString();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "looking for the managed process (multicast based):", new Object[]{string5, string6, serverInfo3});
            }
            multicastVerifier = new MulticastVerifier(string5, string6, 30000);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                multicastVerifier.setDaemon(true);
            }
            multicastVerifier.start();
            multicastVerifier.waitForListening();
            nADiscoveryAdapter.discovery(string5, string6, 2, serverInfo3);
            try {
                multicastVerifier.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((endPoint == null || multicastVerifier.failed) && endPoint3 != null) {
            string5 = endPoint3.getHost();
            string6 = new Integer(endPoint3.getPort()).toString();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "looking for the managed process (ipv6_multicast based):", new Object[]{string5, string6, serverInfo3});
            }
            multicastVerifier = new MulticastVerifier(string5, string6, 30000);
            if (AdminHelper.getPlatformHelper().isZOS()) {
                multicastVerifier.setDaemon(true);
            }
            multicastVerifier.start();
            multicastVerifier.waitForListening();
            nADiscoveryAdapter.discovery(string5, string6, 2, serverInfo3);
            try {
                multicastVerifier.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (endPoint == null && endPoint3 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for app servers, non-multicast based");
            }
            HashMap hashMap = this.epCollector.getServerDiscoveryEndPoints();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                EndPoint endPoint4 = (EndPoint)hashMap.get(string7);
                string5 = endPoint4.getHost();
                string6 = new Integer(endPoint4.getPort()).toString();
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "looking for server: ", new Object[]{string7, string5, string6});
                }
                nADiscoveryAdapter.discovery(string5, string6, this.nodeDiscoveryProtocol, serverInfo3);
            }
        } else if (multicastVerifier.failed) {
            Tr.warning(tc, "ADMC0051W");
            multicastVerifier.rediscover();
        }
        if (this.epCollector != null) {
            this.epCollector.discard();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doNodeAgentDiscovery");
        }
    }

    private void doManagedProcessDiscovery(ServerInfo serverInfo) throws Exception {
        EndPoint endPoint;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doManagedProcessDiscovery");
        }
        MulticastServer.setupNodeAgentConnector(this.endPtMgr);
        EndPoint endPoint2 = this.getServerMulticastDiscoveryEndPoint();
        EndPoint endPoint3 = this.getServerIPv6MulticastDiscoveryEndPoint();
        ServerInfo serverInfo2 = new ServerInfo(this.cellName, this.nodeName, "NodeAgent");
        MPDiscoveryAdapter mPDiscoveryAdapter = null;
        DiscoveryAdapter discoveryAdapter = null;
        String string = null;
        String string2 = null;
        if (endPoint2 != null) {
            string = endPoint2.getHost();
            string2 = new Integer(endPoint2.getPort()).toString();
            mPDiscoveryAdapter = new MPDiscoveryAdapter(serverInfo, string2, 2, string);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialize the managed process discovery service: multicast");
                }
                if (bl = mPDiscoveryAdapter.initialize(this.threadPoolMgr)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IPv4 multicast initialization appeared OK");
                    }
                    discoveryAdapter = mPDiscoveryAdapter;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", "565", this);
                Tr.error(tc, "ADMC0031E", exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - failed");
                }
                return;
            }
        }
        if (endPoint3 != null) {
            string = endPoint3.getHost();
            string2 = new Integer(endPoint3.getPort()).toString();
            mPDiscoveryAdapter = new MPDiscoveryAdapter(serverInfo, string2, 2, string);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialize the managed process discovery service: IPv6 multicast");
                }
                if (bl = mPDiscoveryAdapter.initialize(this.threadPoolMgr)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IPv6 multicast initialization appeared OK");
                    }
                    discoveryAdapter = mPDiscoveryAdapter;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", "565", this);
                Tr.error(tc, "ADMC0031E", exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - IPv6 multicast failed");
                }
                return;
            }
        }
        if (endPoint2 == null && endPoint3 == null) {
            endPoint = this.getServerDiscoveryEndPoint();
            if (endPoint == null) {
                NullPointerException nullPointerException = new NullPointerException("getServerDiscoveryEndPoint returned null value");
                FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", "714", this);
                Tr.error(tc, "ADMC0031E", nullPointerException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - failed");
                }
                throw nullPointerException;
            }
            mPDiscoveryAdapter = new MPDiscoveryAdapter(serverInfo, new Integer(endPoint.getPort()).toString(), this.nodeDiscoveryProtocol);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initialize the managed process discovery service: non-multicast");
                }
                if (bl = mPDiscoveryAdapter.initialize(this.threadPoolMgr)) {
                    discoveryAdapter = mPDiscoveryAdapter;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.doManagedProcessDiscovery", "714", this);
                Tr.error(tc, "ADMC0031E", exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doManagedProcessDiscovery - failed");
                }
                return;
            }
        }
        endPoint = this.getNodeDiscoveryEndPoint();
        String string3 = endPoint.getHost();
        String string4 = new Integer(endPoint.getPort()).toString();
        if (discoveryAdapter != null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The managed process is looking for its node agent:", new Object[]{this.nodeName, string3, string4, serverInfo2});
            }
            discoveryAdapter.discovery(string3, string4, this.nodeDiscoveryProtocol, serverInfo2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doManagedProcessDiscovery");
        }
    }

    private HashMap loadNodeProtocols() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadNodeProtocols");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ConfigRoot configRoot = this.repository.getConfigRoot();
        String[] stringArray = configRoot.list(3, null);
        String string = configRoot.getValue(3);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Integer n;
                configRoot.setValue(3, stringArray[i]);
                Resource resource = configRoot.getResource(3, "node.xml");
                Node node = (Node)resource.getContents().get(0);
                if (node.isSetDiscoveryProtocol()) {
                    TCPIPProtocolType tCPIPProtocolType = node.getDiscoveryProtocol();
                    n = new Integer(tCPIPProtocolType.getValue());
                } else {
                    n = new Integer(1);
                }
                if (n == null) continue;
                hashMap.put(node.getName(), n);
                continue;
            }
            catch (Exception exception) {
                Tr.service(tc, "ADMC0050E");
            }
        }
        configRoot.setValue(3, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadNodeProtocols");
        }
        return hashMap;
    }

    private EndPoint getServerDiscoveryEndPoint() throws Exception {
        return this.endPtMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint("SERVER_DISCOVERY_ADDRESS");
    }

    private EndPoint getServerMulticastDiscoveryEndPoint() {
        EndPoint endPoint = null;
        EndPointMgr.NodeEndPoints nodeEndPoints = this.endPtMgr.getNodeEndPoints("@");
        endPoint = nodeEndPoints.getEndPoint("NODE_MULTICAST_DISCOVERY_ADDRESS");
        return endPoint;
    }

    private EndPoint getServerIPv6MulticastDiscoveryEndPoint() {
        EndPoint endPoint = null;
        EndPointMgr.NodeEndPoints nodeEndPoints = this.endPtMgr.getNodeEndPoints("@");
        endPoint = nodeEndPoints.getEndPoint("NODE_IPV6_MULTICAST_DISCOVERY_ADDRESS");
        return endPoint;
    }

    private EndPoint getNodeDiscoveryEndPoint() throws Exception {
        EndPoint endPoint = null;
        EndPointMgr.NodeEndPoints nodeEndPoints = this.endPtMgr.getNodeEndPoints("@");
        endPoint = nodeEndPoints.getEndPoint("NODE_DISCOVERY_ADDRESS");
        return endPoint;
    }

    private ThreadPool getThreadPool(String string, int n) throws Exception {
        ThreadPool threadPool = null;
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        com.ibm.websphere.models.config.process.ProcessFactory processFactory = processPackage.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool threadPool2 = processFactory.createThreadPool();
        threadPool2.setMinimumSize(3);
        threadPool2.setMaximumSize(n);
        if (this.soapConnectorThreadPoolGrowable) {
            threadPool2.setIsGrowable(true);
        }
        threadPool = this.threadPoolMgr.getThreadPool(string, threadPool2);
        return threadPool;
    }

    public void modeChanged(String string, String string2) {
        if (string.equals("discovery") && string2.equals("active")) {
            this.initDiscovery();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertyChange");
        }
        if ((string = (String)propertyChangeEvent.getNewValue()).equals("STARTED") && DmgrModeFactory.getDmgrModeManager().isActive("discovery")) {
            this.initDiscovery();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertyChange");
        }
    }

    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stateChanged");
        }
        if ((n = securityServiceEvent.getState()) == 1) {
            this.security_started = true;
            Properties properties = AdminInitializer.getInstance().getProperties();
            this.adminType = (String)properties.get("adminTypeProperty");
            String string = AdminServiceFactory.getAdminService().getServerType();
            if (!(this.adminType.equals("NodeAgent") || this.adminType.equals("ManagedProcess") || string.equals("PROXY_SERVER") || string.equals("ONDEMAND_ROUTER"))) {
                this.startFileTransferService();
            }
            try {
                if (AdminHelper.getPlatformHelper().isZOS()) {
                    if (AdminHelper.getPlatformHelper().isServantJvm()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Servant process - exiting initialize");
                        }
                        return;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "SecurityService Event was STARTED");
                    }
                    boolean bl = true;
                    if (!AdminServiceImpl.getPlatformUtils().runningWhereConfigured()) {
                        bl = false;
                    }
                    if (bl) {
                        this.startSOAPConnector();
                        this.startHTTPConnector();
                        this.startRMIConnector();
                    }
                } else {
                    this.startSOAPConnector();
                    this.startHTTPConnector();
                    this.startRMIConnector();
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connector start error", exception);
                }
                throw new WsRuntimeException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    public boolean started() {
        this.WLC_started = true;
        this.startRMIConnector();
        return true;
    }

    public boolean quiesce() {
        try {
            if (this.rmiConnectorEnabled && this.rmiConnector != null) {
                this.rmiConnector.stop();
                if (this.jsr160Enabled && this.rmiService != null && !this.connectorStopped) {
                    this.rmiService.stop();
                    this.connectorStopped = true;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return true;
    }

    public boolean starting() {
        return true;
    }

    public boolean quiesceComplete() {
        return true;
    }

    public String getTypeName() {
        return "RMIConnector";
    }

    public int getType() {
        return 16;
    }

    public String getName() {
        return "";
    }

    private void startFileTransferService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startFileTransferService");
        }
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isServantJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant process exit - startFileTransferService ");
            }
            return;
        }
        FileTransferConfig fileTransferConfig = this.getFileTransferConfig();
        try {
            FileTransferFactory.initialize(fileTransferConfig);
        }
        catch (Throwable throwable) {
            String string = FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0102");
            Tr.error(tc, string, throwable);
        }
        FileRepository.getRepository().setFileTransferConfig(fileTransferConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startFileTransferService");
        }
    }

    private FileTransferConfig getFileTransferConfig() {
        Object object;
        Object object2;
        VariableMap variableMap;
        String string;
        FileTransferConfig fileTransferConfig;
        String string2;
        String string3;
        String string4;
        String string5;
        block35: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFileTransferConfig");
            }
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            fileTransferConfig = null;
            String string6 = null;
            string = null;
            variableMap = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.filetransfer.FileTransferConfigImpl");
                fileTransferConfig = (FileTransferConfig)clazz.newInstance();
                boolean bl = SecurityHelper.getHelper().isSecurityEnabled();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security enabled = " + bl);
                }
                fileTransferConfig.setSecurityEnabled(bl);
                variableMap = (VariableMap)this.getService(VariableMap.class);
                fileTransferConfig.setVariableMap(variableMap);
                string2 = AdminServiceFactory.getAdminService().getProcessName();
                object2 = this.getServerEndPointName("WCInboundFileTransfer");
                if (object2 != null) {
                    object = this.getServerPortFromEndpoint(string2, (String)object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCInboundFileTransfer! Port = " + (String)object);
                    }
                } else {
                    string6 = this.getServerEndPointName("WCInboundAdmin");
                    if (string6 != null) {
                        string4 = this.getServerPortFromEndpoint(string2, string6);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WCinBoundAdmin! Port = " + string4);
                        }
                    }
                }
                object2 = this.getServerEndPointName("WCInboundFileTransferSecure");
                if (object2 != null) {
                    string3 = this.getServerPortFromEndpoint(string2, (String)object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WCInboundFileTransferSecure! Port = " + string4);
                    }
                } else {
                    string6 = this.getServerEndPointName("WCInboundAdminSecure");
                    if (string6 != null) {
                        string3 = this.getServerPortFromEndpoint(string2, string6);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WCinBoundAdminSecure! Port = " + string4);
                        }
                    }
                }
                if (string4 == null || string3 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Get the ports the old way!");
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Resource resource = this.repository.getConfigRoot().getResource(4, "server.xml");
                    com.ibm.websphere.models.config.process.Server server2 = (com.ibm.websphere.models.config.process.Server)resource.getContents().get(0);
                    EList eList = server2.getComponents();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Number of components = " + eList.size());
                    }
                    block4: for (int i = 0; i < eList.size(); ++i) {
                        Component component2 = (Component)eList.get(i);
                        if (!(component2 instanceof ApplicationServer)) continue;
                        ApplicationServer applicationServer = (ApplicationServer)component2;
                        EList eList2 = applicationServer.getComponents();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Number of Subcomponents = " + eList2.size());
                        }
                        for (int j = 0; j < eList2.size(); ++j) {
                            Component component3 = (Component)eList2.get(j);
                            if (!(component3 instanceof WebContainer)) continue;
                            EList eList3 = ((WebContainer)component3).getTransports();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Number of transports = " + eList3.size());
                            }
                            for (int k = 0; k < eList3.size(); ++k) {
                                Transport transport2 = (Transport)eList3.get(k);
                                EndPoint endPoint = transport2.getAddress();
                                if (transport2.isSslEnabled()) {
                                    if (string3 != null) continue;
                                    string3 = new Integer(endPoint.getPort()).toString();
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "securePort = " + string3);
                                    continue;
                                }
                                if (string4 != null) continue;
                                string4 = new Integer(endPoint.getPort()).toString();
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "port = " + string4);
                            }
                            if (string3 != null && string4 != null) continue block4;
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.getFileTransferConfig", "258", this);
                if (!tc.isDebugEnabled()) break block35;
                Tr.debug(tc, "Error occurred initializing config: " + exception.getMessage());
            }
        }
        boolean bl = false;
        if (string4 == null) {
            string4 = FileTransferConfigImpl.DEFAULT_PORT_STRING_VALUE;
            String string7 = FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0114");
            object2 = MessageFormat.format(string7, string4);
            Tr.warning(tc, (String)object2);
            if (string3 != null) {
                bl = true;
            }
        }
        if (string5 == null || string5.equals("127.0.0.1")) {
            try {
                string5 = AdminHelper.getInstance().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string5 == null) {
            string5 = "localhost";
            String string8 = FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0132");
            Tr.warning(tc, string8);
        } else if (string5.equals("127.0.0.1")) {
            String string9 = FILETRANSFER_RESOURCE_BUNDLE.getString("ADFS0131");
            Tr.warning(tc, string9);
        }
        string = variableMap.expand(string5);
        fileTransferConfig.getProperties().put("host", string);
        fileTransferConfig.getProperties().put("port", string4);
        fileTransferConfig.getProperties().put("server_name", string2);
        if (string3 != null) {
            fileTransferConfig.getProperties().put("secure_port", string3);
            if (bl) {
                fileTransferConfig.setSecurityEnabled(true);
            }
        }
        String string10 = null;
        object2 = ConfigRepositoryFactory.getConfigRepository();
        object = object2.getConfig();
        string10 = ((Properties)object).getProperty("was.repository.temp");
        fileTransferConfig.setStagingLocation(string10);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Configuration: " + fileTransferConfig.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFileTransferConfig");
        }
        return fileTransferConfig;
    }

    private String getServerEndPointName(String string) {
        String string2;
        block9: {
            string2 = null;
            try {
                Resource resource = this.repository.getConfigRoot().getResource(4, "server.xml");
                com.ibm.websphere.models.config.process.Server server2 = null;
                EList eList = resource.getContents();
                for (int i = 0; i < eList.size(); ++i) {
                    Object object = eList.get(i);
                    if (!(object instanceof com.ibm.websphere.models.config.process.Server)) continue;
                    server2 = (com.ibm.websphere.models.config.process.Server)object;
                    break;
                }
                if (server2 == null) break block9;
                EList eList2 = server2.getServices();
                for (int i = 0; i < eList2.size(); ++i) {
                    Service service = (Service)eList2.get(i);
                    if (service instanceof TransportChannelService) {
                        Chain chain;
                        TransportChannelService transportChannelService = (TransportChannelService)service;
                        EList eList3 = transportChannelService.getChains();
                        for (int j = 0; j < eList3.size() && (chain = (Chain)eList3.get(j)) != null && !chain.getTransportChannels().isEmpty(); ++j) {
                            if (chain.getName().equalsIgnoreCase(string)) {
                                for (int k = 0; k < chain.getTransportChannels().size(); ++k) {
                                    TransportChannel transportChannel = (TransportChannel)chain.getTransportChannels().get(k);
                                    if (!(transportChannel instanceof TCPInboundChannel)) continue;
                                    TCPInboundChannel tCPInboundChannel = (TCPInboundChannel)transportChannel;
                                    string2 = tCPInboundChannel.getEndPointName();
                                    break;
                                }
                            }
                            if (string2 != null) break;
                        }
                    }
                    if (string2 == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.getServerEndPointName", "377", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Error occurred initializing config: " + exception.getMessage());
            }
        }
        return string2;
    }

    private String getServerPortFromEndpoint(String string, String string2) {
        String string3;
        block7: {
            string3 = null;
            try {
                if (string2 == null) break block7;
                Resource resource = this.repository.getConfigRoot().getResource(3, "serverindex.xml");
                ServerIndex serverIndex = null;
                EList eList = resource.getContents();
                for (int i = 0; i < eList.size(); ++i) {
                    Object object = eList.get(i);
                    if (!(object instanceof ServerIndex)) continue;
                    serverIndex = (ServerIndex)object;
                    break;
                }
                if (serverIndex == null) break block7;
                EList eList2 = serverIndex.getServerEntries();
                for (int i = 0; i < eList2.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList2.get(i);
                    if (serverEntry.getServerName().equalsIgnoreCase(string)) {
                        EList eList3 = serverEntry.getSpecialEndpoints();
                        for (int j = 0; j < eList3.size(); ++j) {
                            NamedEndPoint namedEndPoint = (NamedEndPoint)eList3.get(j);
                            if (!namedEndPoint.getEndPointName().equals(string2)) continue;
                            EndPoint endPoint = namedEndPoint.getEndPoint();
                            int n = endPoint.getPort();
                            string3 = new String("" + n);
                            break;
                        }
                    }
                    if (string3 == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.getServerPortFromEndpoint", "433", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Error occurred initializing config: " + exception.getMessage());
            }
        }
        return string3;
    }

    private class MulticastVerifier
    extends Thread {
        MulticastSocket serverSocket;
        boolean failed;
        boolean listening;
        boolean ignore;
        int timeout;

        MulticastVerifier(String string, String string2, int n) {
            super("MulticastVerifier");
            this.failed = false;
            this.listening = false;
            this.ignore = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MulticastVerifier", new Object[]{string, string2, new Integer(this.timeout)});
            }
            int n2 = Integer.parseInt(string2);
            this.timeout = n;
            try {
                this.serverSocket = new MulticastSocket(n2);
                this.serverSocket.joinGroup(InetAddress.getByName(string));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.MulticastVerifier", "959", this);
                this.failed = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MulticastVerifier");
            }
        }

        synchronized boolean isLisetening() {
            return this.listening;
        }

        void waitForListening() {
            int n = 0;
            while (true) {
                ++n;
                if (this.isLisetening()) {
                    return;
                }
                if (n > 10) {
                    this.ignore = true;
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MulticastVerifier.run");
            }
            if (this.serverSocket != null) {
                try {
                    byte[] byArray = new byte[16384];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    this.serverSocket.setSoTimeout(this.timeout);
                    this.listening = true;
                    this.serverSocket.receive(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                    FFDCFilter.processException((Throwable)interruptedIOException, "com.ibm.ws.management.component.JMXConnectors.MulticastVerifier.run", "979", this);
                    this.failed = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JMXConnectors.MulticastVerifier.run", "987", this);
                }
                finally {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.failed = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MulticastVerifier.run");
            }
        }

        void rediscover() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "rediscover");
            }
            HashMap hashMap = JMXConnectors.this.epCollector.getServerConnectorEndPoints();
            AdminClient adminClient = null;
            ObjectName objectName = null;
            boolean bl = SecurityHelper.getHelper().isSecurityEnabled();
            String string = bl ? "true" : "false";
            try {
                objectName = new ObjectName("*:*,type=Discovery");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            Subject subject = SecurityHelper.getServerSubject();
            if (subject != null) {
                SecurityHelper.pushInvocationSubject(subject);
            }
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                boolean bl2;
                String string2;
                block16: {
                    string2 = (String)iterator.next();
                    EndPoint endPoint = (EndPoint)hashMap.get(string2);
                    String string3 = endPoint.getHost();
                    String string4 = new Integer(endPoint.getPort()).toString();
                    bl2 = false;
                    Properties properties = new Properties();
                    String string5 = Forwarder.getServerConnectorType(string2);
                    if (string3 != null && string3.length() > 0) {
                        properties.setProperty("host", string3);
                    } else {
                        properties.setProperty("host", "localhost");
                    }
                    properties.setProperty("port", string4);
                    properties.setProperty("type", string5);
                    properties.setProperty("securityEnabled", string);
                    properties.setProperty("isInternal", "true");
                    try {
                        adminClient = AdminClientFactory.createAdminClient(properties);
                    }
                    catch (ConnectorException connectorException) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "unable to create client to remote process", new Object[]{properties, connectorException});
                    }
                }
                if (adminClient != null) {
                    try {
                        Set set = adminClient.queryNames(objectName, null);
                        if (set.iterator().hasNext()) {
                            ObjectName objectName2 = (ObjectName)set.iterator().next();
                            adminClient.invoke(objectName2, "query", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{(class$com$ibm$ws$management$discovery$ServerInfo == null ? JMXConnectors.class$("com.ibm.ws.management.discovery.ServerInfo") : class$com$ibm$ws$management$discovery$ServerInfo).getName()});
                        } else {
                            bl2 = true;
                        }
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "failed to send out discover message", exception);
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                Tr.warning(tc, "ADMC0052W", string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rediscover");
            }
        }
    }

    private class EndPtCollector {
        Map dmgrs;
        Map nodeAgents;
        EndPoint cellDiscoveryEndPoint;
        EndPoint nodeDiscoveryEndPoint;
        EndPoint serverDiscoveryEndPoint;
        HashMap serverDiscoveryEndPoints;
        HashMap serverConnectorEndPoints;

        EndPtCollector(EndPointMgr endPointMgr) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "EndPtCollector");
            }
            this.dmgrs = new HashMap();
            this.nodeAgents = new HashMap();
            this.serverDiscoveryEndPoints = new HashMap();
            this.serverConnectorEndPoints = new HashMap();
            Map map = endPointMgr.getNodeEndPoints();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.equals("@")) continue;
                EndPointMgr.NodeEndPoints nodeEndPoints = (EndPointMgr.NodeEndPoints)map.get(string);
                Map map2 = nodeEndPoints.getServerEndPoints();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing node: ", string);
                }
                Iterator iterator2 = map2.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (string2.equals("@")) continue;
                    EndPointMgr.EndPoints endPoints = (EndPointMgr.EndPoints)map2.get(string2);
                    Map map3 = endPoints.getEndPoints();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing server: ", string2);
                    }
                    Iterator iterator3 = map3.keySet().iterator();
                    while (iterator3.hasNext()) {
                        String string3;
                        String string4 = (String)iterator3.next();
                        EndPoint endPoint = (EndPoint)map3.get(string4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing endPoint: ", string4);
                        }
                        if (string4.equals("NODE_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "node agent discovery endpoint found for node: " + string);
                            }
                            this.nodeAgents.put(string, endPoint);
                            if (!string.equals(JMXConnectors.this.nodeName)) continue;
                            this.nodeDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("NODE_MULTICAST_DISCOVERY_ADDRESS")) {
                            if (!string.equals(JMXConnectors.this.nodeName)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "server discovery endpoint found for server: " + string2);
                            }
                            this.serverDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("CELL_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cellmgr node name: " + string);
                            }
                            if (JMXConnectors.this.cellDiscoveryProtocol == 2) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "tcp ip protocol type is not multicast");
                            }
                            this.dmgrs.put(string, endPoint);
                            if (!string.equals(JMXConnectors.this.nodeName)) continue;
                            this.cellDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("CELL_MULTICAST_DISCOVERY_ADDRESS")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cellmgr node name: " + string);
                            }
                            if (JMXConnectors.this.cellDiscoveryProtocol != 2) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "tcp ip protocol type is multicast");
                            }
                            this.dmgrs.put(string, endPoint);
                            if (!string.equals(JMXConnectors.this.nodeName)) continue;
                            this.cellDiscoveryEndPoint = endPoint;
                            continue;
                        }
                        if (string4.equals("SERVER_DISCOVERY_ADDRESS")) {
                            this.serverDiscoveryEndPoints.put(string2, endPoint);
                            continue;
                        }
                        if (string4.equals("SOAP_CONNECTOR_ADDRESS")) {
                            if (!string.equals(JMXConnectors.this.nodeName) || string2.equals(JMXConnectors.this.serverName) || !(string3 = Forwarder.getServerConnectorType(string2)).equals("SOAP")) continue;
                            this.serverConnectorEndPoints.put(string2, endPoint);
                            continue;
                        }
                        if (!string4.equals("BOOTSTRAP_ADDRESS") || !string.equals(JMXConnectors.this.nodeName) || string2.equals(JMXConnectors.this.serverName) || !(string3 = Forwarder.getServerConnectorType(string2)).equals("RMI")) continue;
                        this.serverConnectorEndPoints.put(string2, endPoint);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "EndPtCollector");
            }
        }

        EndPoint getCellDiscoveryEndPoint() {
            return this.cellDiscoveryEndPoint;
        }

        Map getDmgrs() {
            return this.dmgrs;
        }

        EndPoint getNodeDiscoveryEndPoint() {
            return this.nodeDiscoveryEndPoint;
        }

        Map getNodeAgents() {
            return this.nodeAgents;
        }

        EndPoint getServerMulticastDiscoveryEndPoint() {
            return this.serverDiscoveryEndPoint;
        }

        HashMap getServerDiscoveryEndPoints() {
            return this.serverDiscoveryEndPoints;
        }

        HashMap getServerConnectorEndPoints() {
            return this.serverConnectorEndPoints;
        }

        void discard() {
            this.nodeAgents.clear();
            this.serverDiscoveryEndPoints.clear();
            this.serverConnectorEndPoints.clear();
            this.cellDiscoveryEndPoint = null;
            this.nodeDiscoveryEndPoint = null;
            this.serverDiscoveryEndPoint = null;
        }
    }
}

