/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jvm.Dump;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.HeapDumpNotSupportedException;
import com.ibm.websphere.management.exception.HeapDumpOnDiskLimitReachedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.process.exception.ProcessOpException;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.Notification;

public class JVMMBean
extends J2EEManagedObjectCollaborator {
    private static final TraceComponent tc = Tr.register(JVMMBean.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private int seqNum = 0;
    private int maxDumpsOnDisk = 10;
    private MBeanServer platformMBeanServer = null;
    private MemoryMXBean mxbean = null;

    public String getTotalMemory() {
        Runtime runtime2 = Runtime.getRuntime();
        String string = new Long(runtime2.totalMemory()).toString();
        return string;
    }

    public void setVerbose(boolean bl, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose " + bl + " " + string);
        }
        try {
            if (this.platformMBeanServer == null) {
                this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (AdminHelper.getPlatformHelper().isZOS()) {
                if (string.equals("Servant") && AdminHelper.getPlatformHelper().isServantJvm() && !AdminHelper.getPlatformHelper().isCRAJvm() || string.equals("Adjunct") && AdminHelper.getPlatformHelper().isCRAJvm()) {
                    this.setVerbose(bl);
                }
            } else {
                this.setVerbose(bl);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JVMMBean.setVerbose", "70", this);
            Tr.debug(tc, "Could not set verbose on JVM", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose " + bl + " " + string);
        }
    }

    public void setVerbose(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose " + bl);
        }
        if (this.mxbean == null) {
            this.mxbean = ManagementFactory.getMemoryMXBean();
        }
        if (this.mxbean != null) {
            this.mxbean.setVerbose(bl);
        } else {
            Tr.debug(tc, "MemoryMXBean not registered");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose");
        }
    }

    public boolean isVerbose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isVerbose");
        }
        boolean bl = false;
        if (this.mxbean == null) {
            this.mxbean = ManagementFactory.getMemoryMXBean();
        }
        if (this.mxbean != null) {
            bl = this.mxbean.isVerbose();
        } else {
            Tr.debug(tc, "MemoryMXBean not registered");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isVerbose " + bl);
        }
        return bl;
    }

    public String getFreeMemory() {
        Runtime runtime2 = Runtime.getRuntime();
        String string = new Long(runtime2.freeMemory()).toString();
        return string;
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getProperty(String string) {
        return System.getProperty(string);
    }

    public String getIPAddress(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.management.component.JVMMBean.getIPAddress", "60", this);
            return null;
        }
    }

    public long getCurrentTimeInMillis() {
        return System.currentTimeMillis();
    }

    public String getJVMNode() {
        String string = null;
        try {
            string = AdminHelper.getInstance().getNodeHostName(AdminServiceFactory.getAdminService().getNodeName());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.JVMMBean.getJVMNode", "90", this);
            Tr.service(tc, "ADMN0020W", exception);
        }
        return string;
    }

    public void dumpThreads() {
        Process process = null;
        try {
            process = ProcessFactory.createSelf();
            process.generateJVMDump();
        }
        catch (ProcessOpException processOpException) {
            FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.management.component.JVMMBean.dumpThreads", "97", this);
            Tr.error(tc, "ADMN0021W", processOpException);
        }
    }

    public void setMaxDumpsOnDisk(Integer n) {
        Tr.entry(tc, "setMaxDumpsOnDisk");
        this.maxDumpsOnDisk = n;
        Tr.exit(tc, "setMaxDumpsOnDisk" + this.maxDumpsOnDisk);
    }

    public Integer getMaxDumpsOnDisk() {
        return new Integer(this.maxDumpsOnDisk);
    }

    public String getMaxMemory() {
        return String.valueOf(Runtime.getRuntime().maxMemory());
    }

    private boolean isApplicable() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isApplicable");
            }
            try {
                String string = System.getProperty("java.vendor");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JVM Vendor is " + string);
                }
                if (string != null && string.indexOf("IBM") != -1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Is IBM JDK and we can take heap dumps");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isApplicable");
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "could not create system calc and test for applicability: " + exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isApplicable");
        }
        return false;
    }

    private File takeDump() throws HeapDumpOnDiskLimitReachedException {
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "takeDump");
            }
            File file = null;
            try {
                Object object;
                String string = System.getenv("IBM_HEAPDUMPDIR");
                String string2 = System.getenv("IBM_HEAPDUMP");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM_HEAPDUMPDIR", string);
                    Tr.debug(tc, "IBM_HEAPDUMP", string2);
                }
                if (string != null && string.length() > 0) {
                    file = new File(string);
                } else if (AdminHelper.getPlatformHelper().isZOS()) {
                    object = System.getProperty("user.home");
                    file = new File((String)object);
                } else {
                    file = new File(".");
                }
                object = new HeapDumpFileNameFilter();
                File[] fileArray = file.listFiles((FilenameFilter)object);
                ArrayList arrayList = new ArrayList();
                if (fileArray == null) {
                    fileArray = new File[]{};
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There are " + fileArray.length + " dumps on disk");
                }
                if (fileArray.length >= this.maxDumpsOnDisk) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not take heap dump because we have exceded max heap dumps on disk");
                    }
                    throw new HeapDumpOnDiskLimitReachedException("There are already " + this.maxDumpsOnDisk + " heap dumps on disk");
                }
                System.gc();
                Dump.HeapDump();
                File[] fileArray2 = file.listFiles((FilenameFilter)object);
                if (fileArray2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find heap dump file");
                    }
                } else {
                    boolean bl = false;
                    for (int i = 0; i < fileArray2.length; ++i) {
                        bl = false;
                        String string3 = fileArray2[i].getAbsoluteFile().toString();
                        for (int j = 0; j < fileArray.length; ++j) {
                            String string4 = fileArray[j].getAbsoluteFile().toString();
                            if (!string3.equals(string4)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found: " + fileArray2[i]);
                            }
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not find : " + fileArray2[i]);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "takeDump", fileArray2[i]);
                        }
                        return fileArray2[i];
                    }
                }
            }
            catch (HeapDumpOnDiskLimitReachedException heapDumpOnDiskLimitReachedException) {
                throw heapDumpOnDiskLimitReachedException;
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block22;
                Tr.debug(tc, "Exception caught when taking heap dump : " + exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "takeDump");
        }
        return null;
    }

    public String generateHeapDump() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "received manual request to take heap dumps");
        }
        if (!this.isApplicable()) {
            throw new HeapDumpNotSupportedException("Could not take single dump as " + System.getProperty("java.vendor") + " is not supported", true);
        }
        try {
            if (!AdminHelper.getPlatformHelper().isControlJvm()) {
                this.sendNotification(new Notification("websphere.jvm.heapdump.attempting", this.getObjectName(), this.seqNum++));
            }
            String string = "";
            File file = this.takeDump();
            if (file != null) {
                string = file.getAbsolutePath();
            }
            if (!AdminHelper.getPlatformHelper().isControlJvm()) {
                this.sendNotification(new Notification("websphere.jvm.heapdump.generated", (Object)this.getObjectName(), (long)this.seqNum++, string));
            }
            String string2 = "";
            if (file != null) {
                string2 = file.getAbsolutePath();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file absolute path", string2);
            }
            return string2;
        }
        catch (HeapDumpOnDiskLimitReachedException heapDumpOnDiskLimitReachedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "coud not take heap dump:  " + heapDumpOnDiskLimitReachedException.toString());
            }
            throw heapDumpOnDiskLimitReachedException;
        }
    }

    public String[] generateHeapDumps() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDumps");
        }
        String[] stringArray = new String[]{this.generateHeapDump()};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDumps", stringArray);
        }
        return stringArray;
    }

    public String[] generateHeapDump(String string) throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDump", string);
        }
        String[] stringArray = new String[]{this.generateHeapDump()};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDump", stringArray);
        }
        return stringArray;
    }

    private class HeapDumpFileNameFilter
    implements FilenameFilter {
        public static final String HEAP_DUMP_EXT = "phd";
        public boolean debug = false;

        private HeapDumpFileNameFilter() {
        }

        public boolean accept(File file, String string) {
            StringTokenizer stringTokenizer;
            if (this.debug) {
                System.out.println(">>>accept");
            }
            if ((stringTokenizer = new StringTokenizer(string, ".", false)).countTokens() < 2) {
                if (this.debug) {
                    System.out.println(string + " does not have enough tokens");
                }
                if (this.debug) {
                    System.out.println("<<<accept");
                }
                return false;
            }
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (this.debug) {
                System.out.println(string + " has extension " + string2);
            }
            if (string2.equals(HEAP_DUMP_EXT)) {
                if (this.debug) {
                    System.out.println("<<<accept");
                }
                return true;
            }
            if (this.debug) {
                System.out.println("<<<accept");
            }
            return false;
        }
    }
}

