/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.exception.HeapDumpNotSupportedException;
import com.ibm.websphere.management.exception.HeapDumpOnDiskLimitReachedException;
import com.ibm.ws.management.component.JVMMBean;
import com.ibm.ws.pmi.dynamicproxy.MBeanStatsAggregationHandler;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.j2ee.statistics.Stats;

public class JVMMBeanProxy
extends ProxyMBeanSupport {
    private int seqNum = 0;
    private ServantMBeanInvoker mbeanInvoker = new ServantMBeanInvoker();
    private MBeanStatsAggregationHandler aggregator = new MBeanStatsAggregationHandler();
    protected static TraceComponent tc = Tr.register(JVMMBeanProxy.class, null, null);
    private JVMMBean jvmBean = new JVMMBean();

    public JVMMBeanProxy() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JVMMBeanProxy constructor");
        }
    }

    public String getTotalMemory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTotalMemory");
        }
        String string = null;
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getTotalMemory", objectArray, stringArray);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Controller: " + Long.toString(Runtime.getRuntime().totalMemory()) + ";");
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)iterator.next();
                stringBuffer.append("\nServant " + servantMBeanInvokerData.getStoken() + ": " + servantMBeanInvokerData.getResult() + ";");
            }
            string = stringBuffer.toString();
        } else {
            string = this.jvmBean.getTotalMemory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTotalMemory");
        }
        return string;
    }

    public void setVerbose(boolean bl, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose", new Object[]{new Boolean(bl), string});
        }
        this.jvmBean.setVerbose(bl, string);
        Object[] objectArray = new Object[]{new Boolean(bl), string};
        String[] stringArray = new String[]{"Z", "java.lang.String"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "setVerbose", objectArray, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose");
        }
    }

    public void setVerbose(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerbose", new Object[]{new Boolean(bl)});
        }
        this.jvmBean.setVerbose(bl);
        Object[] objectArray = new Object[]{new Boolean(bl)};
        String[] stringArray = new String[]{"Z"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "setVerbose", objectArray, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerbose");
        }
    }

    public boolean isVerbose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isVerbose");
        }
        boolean bl = this.jvmBean.isVerbose();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isVerbose", new Boolean(bl));
        }
        return bl;
    }

    public String getFreeMemory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFreeMemory");
        }
        String string = null;
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getFreeMemory", objectArray, stringArray);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Controller: " + Long.toString(Runtime.getRuntime().freeMemory()) + ";");
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)iterator.next();
                stringBuffer.append("\nServant " + servantMBeanInvokerData.getStoken() + ": " + servantMBeanInvokerData.getResult() + ";");
            }
            string = stringBuffer.toString();
        } else {
            string = this.jvmBean.getFreeMemory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFreeMemory");
        }
        return string;
    }

    public String getJavaVendor() {
        return this.jvmBean.getJavaVendor();
    }

    public String getJavaVersion() {
        return this.jvmBean.getJavaVersion();
    }

    public String getProperty(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty");
        }
        String string2 = null;
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getProperty", objectArray, stringArray);
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            String string3 = null;
            if (vector.size() > 0) {
                string3 = this.jvmBean.getProperty(string);
            }
            String string4 = null;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)iterator.next();
                string4 = (String)servantMBeanInvokerData.getResult();
                if (string3 != null && string4 == null) {
                    bl = false;
                } else if (string3 == null && string4 != null) {
                    bl = false;
                } else if (string3 != null) {
                    bl = string3.equals(string4);
                }
                stringBuffer.append("Servant " + servantMBeanInvokerData.getStoken() + ": " + string4 + ";\n");
            }
            string2 = bl ? string3 : stringBuffer.toString();
        } else {
            string2 = this.jvmBean.getProperty(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperty", string2);
        }
        return string2;
    }

    public String getIPAddress(String string) {
        return this.jvmBean.getIPAddress(string);
    }

    public long getCurrentTimeInMillis() {
        return this.jvmBean.getCurrentTimeInMillis();
    }

    public String getJVMNode() {
        return this.jvmBean.getJVMNode();
    }

    public void dumpThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpThreads");
        }
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, set.size() + " servants found.");
            }
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "dumpThreads", objectArray, stringArray);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No servants found, calling dumpThreads on jvmBean");
            }
            this.jvmBean.dumpThreads();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dumpThreads");
        }
    }

    public void setMaxDumpsOnDisk(Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMaxDumpsOnDisk");
        }
        Object[] objectArray = new Object[]{n};
        String[] stringArray = new String[]{"java.lang.Integer"};
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "setMaxDumpsOnDisk", objectArray, stringArray);
        } else {
            this.jvmBean.setMaxDumpsOnDisk(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMaxDumpsOnDisk");
        }
    }

    public Integer getMaxDumpsOnDisk() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxDumpsOnDisk");
        }
        Integer n = null;
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getMaxDumpsOnDisk", objectArray, stringArray);
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.get(0);
            n = (Integer)servantMBeanInvokerData.getResult();
        } else {
            n = this.jvmBean.getMaxDumpsOnDisk();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxDumpsOnDisk", n);
        }
        return n;
    }

    public String getMaxMemory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxMemory");
        }
        String string = null;
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getMaxMemory", objectArray, stringArray);
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.get(0);
            string = (String)servantMBeanInvokerData.getResult();
        } else {
            string = this.jvmBean.getMaxMemory();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxMemory", string);
        }
        return string;
    }

    public String generateHeapDump() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDump");
        }
        String string = null;
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "generateHeapDump", objectArray, stringArray);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)iterator.next();
                if (servantMBeanInvokerData.resultThrowable()) {
                    Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result was throwable", throwable);
                    }
                    if (throwable instanceof HeapDumpNotSupportedException) {
                        throw (HeapDumpNotSupportedException)throwable;
                    }
                    if (throwable instanceof HeapDumpOnDiskLimitReachedException) {
                        throw (HeapDumpOnDiskLimitReachedException)throwable;
                    }
                    if (throwable instanceof MBeanException) {
                        throw (MBeanException)throwable;
                    }
                    throw new UndeclaredThrowableException(throwable);
                }
                string = (String)servantMBeanInvokerData.getResult();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Expected Result", string);
            }
        } else {
            this.sendNotification(new Notification("websphere.jvm.heapdump.attempting", this.getObjectName(), this.seqNum++));
            string = this.jvmBean.generateHeapDump();
            this.sendNotification(new Notification("websphere.jvm.heapdump.generated", (Object)this.getObjectName(), (long)this.seqNum++, string));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expected Result", string);
            }
            return string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDump", null);
        }
        return null;
    }

    public String[] generateHeapDumps() throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDumps");
        }
        int n = this.currentServants().size();
        String[] stringArray = new String[n];
        Object[] objectArray = null;
        String[] stringArray2 = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "generateHeapDumps", objectArray, stringArray2);
            Iterator iterator = vector.iterator();
            String string = null;
            int n2 = 0;
            while (iterator.hasNext()) {
                ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)iterator.next();
                if (servantMBeanInvokerData.resultThrowable()) {
                    Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result was throwable", throwable);
                    }
                    if (throwable instanceof HeapDumpNotSupportedException) {
                        throw (HeapDumpNotSupportedException)throwable;
                    }
                    if (throwable instanceof HeapDumpOnDiskLimitReachedException) {
                        throw (HeapDumpOnDiskLimitReachedException)throwable;
                    }
                    if (throwable instanceof MBeanException) {
                        throw (MBeanException)throwable;
                    }
                    throw new UndeclaredThrowableException(throwable);
                }
                string = (String)servantMBeanInvokerData.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expected Result", string);
                }
                stringArray[n2++] = string;
                string = (String)servantMBeanInvokerData.getResult();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "generateHeapDumps stoken " + servantMBeanInvokerData.getStoken() + "  --  " + string);
            }
        } else {
            stringArray = this.jvmBean.generateHeapDumps();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDumps", stringArray);
        }
        return stringArray;
    }

    public String[] generateHeapDump(String string) throws MBeanException, HeapDumpNotSupportedException, HeapDumpOnDiskLimitReachedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeapDump", string);
        }
        String[] stringArray = null;
        if (string == null || string.trim().equalsIgnoreCase("")) {
            stringArray = this.generateHeapDumps();
        } else {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(string);
            Object[] objectArray = new Object[]{string};
            String[] stringArray2 = new String[]{"java.lang.String"};
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(hashSet, this.getObjectName(), "generateHeapDump", objectArray, stringArray2);
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.get(0);
            if (servantMBeanInvokerData.resultThrowable()) {
                Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result was throwable", throwable);
                }
                if (throwable instanceof HeapDumpNotSupportedException) {
                    throw (HeapDumpNotSupportedException)throwable;
                }
                if (throwable instanceof HeapDumpOnDiskLimitReachedException) {
                    throw (HeapDumpOnDiskLimitReachedException)throwable;
                }
                if (throwable instanceof MBeanException) {
                    throw (MBeanException)throwable;
                }
                throw new UndeclaredThrowableException(throwable);
            }
            stringArray = (String[])servantMBeanInvokerData.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeapDump", stringArray);
        }
        return stringArray;
    }

    public String getObjectNameStr() {
        return this.getObjectName().toString();
    }

    public boolean isStateManageable() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStateManageable");
        }
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "isStateManageable", objectArray, stringArray);
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.get(0);
            Boolean bl2 = (Boolean)servantMBeanInvokerData.getResult();
            bl = bl2;
        } else {
            bl = this.jvmBean.isStateManageable();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStateManageable", new Boolean(bl));
        }
        return bl;
    }

    public boolean isStatisticsProvider() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStatisticsProvider");
        }
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "isStatisticsProvider", objectArray, stringArray);
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.get(0);
            Boolean bl2 = (Boolean)servantMBeanInvokerData.getResult();
            bl = bl2;
        } else {
            bl = this.jvmBean.isStatisticsProvider();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStatisticsProvider", new Boolean(bl));
        }
        return bl;
    }

    public boolean isEventProvider() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEventProvider");
        }
        Object[] objectArray = null;
        String[] stringArray = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "isEventProvider", objectArray, stringArray);
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.get(0);
            Boolean bl2 = (Boolean)servantMBeanInvokerData.getResult();
            bl = bl2;
        } else {
            bl = this.jvmBean.isEventProvider();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEventProvider", new Boolean(bl));
        }
        return bl;
    }

    public Stats getStats() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStats");
        }
        Object[] objectArray = null;
        String[] stringArray = null;
        Stats stats = null;
        Set set = this.currentServants();
        if (set != null && !set.isEmpty()) {
            Vector vector = this.mbeanInvoker.invokeSpecifiedServants(set, this.getObjectName(), "getStats", objectArray, stringArray);
            ServantMBeanResult[] servantMBeanResultArray = vector.toArray(new ServantMBeanResult[0]);
            stats = (Stats)this.aggregator.aggregateResults("getStats", objectArray, stringArray, servantMBeanResultArray, null);
        } else {
            stats = this.jvmBean.getStats();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStats", stats);
        }
        return stats;
    }
}

