/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.FileTransferService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import com.ibm.ws.management.metadata.NodeAgentCollector;
import com.ibm.ws.management.nodeagent.Forwarder;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.service.SecurityService;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class NodeAgentImpl
extends ComponentImpl
implements com.ibm.ws.management.service.NodeAgent {
    private static TraceComponent tc = Tr.register(NodeAgentImpl.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private NodeAgent agentcfg;
    private static final int UUID_LENGTH = 16;
    private VariableMap variableMap = null;
    private Repository repository = null;
    private SecurityService securityService = null;
    private NodeSync nodeSync = null;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        NodeAgent nodeAgent;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        if ((nodeAgent = (NodeAgent)object).getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this.agentcfg = (NodeAgent)etoolsCopyUtility.copy((EObject)nodeAgent);
        this.addService(com.ibm.ws.management.service.NodeAgent.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            this.variableMap = (VariableMap)this.getService(VariableMap.class);
            this.repository = (Repository)this.getService(Repository.class);
            this.registerAgentMBean();
            this.startFileTransferService();
            NodeAgentCollector nodeAgentCollector = new NodeAgentCollector();
            this.initializeNodeSync();
            String string = System.getProperty("os.name");
            if (string != null && string.equalsIgnoreCase("os/400")) {
                try {
                    ConfigRepositoryListener configRepositoryListener = (ConfigRepositoryListener)Class.forName("com.ibm.ws.os400.RepositoryChangedListener").newInstance();
                    ConfigRepositoryFactory.getConfigRepository().addListener(configRepositoryListener);
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "ADMN0064E", throwable);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.NodeAgentImpl.start", "89", this);
            throw new RuntimeError(exception);
        }
        finally {
            this.releaseService(this.variableMap);
            this.releaseService(this.repository);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start");
            }
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NodeAgentImpl.stop: calling NodeSync.stop()");
        }
        if (this.nodeSync != null) {
            this.nodeSync.stop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
    }

    protected String getUuid(long l) {
        String string = Long.toHexString(l);
        if (string.length() < 16) {
            for (int i = 16 - string.length(); i > 0; --i) {
                string = string + "0";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFileTransferService() {
        Serializable serializable;
        FileTransferService fileTransferService = this.agentcfg.getFileTransferService();
        if (fileTransferService == null || !fileTransferService.isEnable()) {
            return;
        }
        FileTransferConfig fileTransferConfig = null;
        try {
            serializable = Class.forName("com.ibm.ws.management.filetransfer.FileTransferConfigImpl");
            fileTransferConfig = (FileTransferConfig)((Class)serializable).newInstance();
        }
        catch (Throwable throwable) {
            Tr.error(tc, "ADMN0016E", throwable);
        }
        fileTransferConfig.setTransferRequestTimeout(new Integer(fileTransferService.getRetryWaitTime()));
        fileTransferConfig.setTransferRetryCount(new Integer(fileTransferService.getRetriesCount()));
        fileTransferConfig.setVariableMap(this.variableMap);
        serializable = ComponentImpl.getProperties((Service)fileTransferService);
        if (serializable == null) {
            serializable = new Properties();
        } else {
            Enumeration<Object> enumeration = ((Properties)serializable).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = ((Properties)serializable).getProperty(string);
                string2 = this.variableMap.expand(string2);
                ((Properties)serializable).put(string, string2);
            }
        }
        fileTransferConfig.setProperties((Properties)serializable);
        try {
            FileTransferFactory.initialize(fileTransferConfig);
        }
        catch (Throwable throwable) {
            Tr.error(tc, "ADFS0102", throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    private void initializeNodeSync() throws ConfigurationWarning {
        Property property;
        Properties properties = new Properties();
        ConfigSynchronizationService configSynchronizationService = this.agentcfg.getFileSynchronizationService();
        EList eList = configSynchronizationService.getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            property = (Property)iterator.next();
            properties.setProperty(property.getName(), property.getValue());
        }
        property = null;
        if (configSynchronizationService != null) {
            properties.setProperty("was.sync.processType", "NodeAgent");
            properties.setProperty("was.sync.autoSyncEnabled", new Boolean(configSynchronizationService.isAutoSynchEnabled()).toString());
            properties.setProperty("was.sync.syncInterval", new Integer(configSynchronizationService.getSynchInterval()).toString());
            properties.setProperty("was.sync.serverStartupSyncEnabled", new Boolean(configSynchronizationService.isSynchOnServerStartup()).toString());
            property = configSynchronizationService.getExclusions();
            try {
                this.nodeSync = NodeSync.createNodeSync();
                if (this.nodeSync != null) {
                    this.nodeSync.initialize(properties, (List)property, this.variableMap);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.component.AdminImpl.initializeNodeSync", "604", this);
                throw new ConfigurationWarning("Problem initializing node sync.", exception);
            }
        }
    }

    private void registerAgentMBean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAgentMBeans");
        }
        Server server2 = (Server)this.getService(Server.class);
        ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
        Forwarder.initReceiver(this.repository, this.variableMap, threadPoolMgr);
        Forwarder.serverListenerRegistration(server2);
        this.releaseService(server2);
        this.releaseService(threadPoolMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAgentMBeans");
        }
    }

    public SecurityService registerSecurityService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSecurityService");
        }
        this.securityService = (SecurityService)this.getService(SecurityService.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSecurityService");
        }
        return this.securityService;
    }
}

