/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.models.config.adminservice.PluginConfigService;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.cellmanager.CellManager;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class PluginConfigServiceImpl
extends ComponentImpl {
    private static TraceComponent tc = Tr.register(PluginConfigServiceImpl.class, "PLUGINCFG", "com.ibm.websphere.plugincfg.generator.PluginConfigGeneratorNLS");
    private VariableMap variableMap = null;
    private Repository repository = null;
    private static boolean started = false;
    protected static TraceNLS nls;
    static String className;

    protected void setState(String string) {
        try {
            super.setState(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, className + "setState", "1", this);
        }
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        String string = "initialize: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.setState("INITIALIZING");
        super.initialize(object);
        this.setState("INITIALIZED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        String string = "start: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.setState("STARTING");
        super.start();
        this.setState("STARTED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void stop() {
        String string = "stop: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.setState("STOPPING");
        super.stop();
        this.setState("STOPPED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void destroy() {
        String string = "destroy: ";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        this.setState("DESTROYING");
        super.destroy();
        this.setState("DESTROYED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    public void initializePluginConfigService(PluginConfigService pluginConfigService) {
        String string;
        block25: {
            block24: {
                string = "initializePluginConfigService: ";
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, string);
                }
                try {
                    nls = TraceNLS.getTraceNLS("com.ibm.websphere.plugincfg.generator.PluginConfigGeneratorNLS");
                }
                catch (MissingResourceException missingResourceException) {
                    FFDCFilter.processException(missingResourceException, "com.ibm.websphere.plugincfg.initializers.PluginConfigService.initialize", "26");
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, string + "Unable to Find NLS Resources: " + missingResourceException.getMessage());
                }
            }
            this.setState("INITIALIZING");
            try {
                if (AdminHelper.getPlatformHelper().isZOS() && !AdminHelper.getPlatformHelper().isControlJvm()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + "Plugin config service is started only in the control region.");
                    }
                } else {
                    Object object;
                    this.variableMap = (VariableMap)this.getService(VariableMap.class);
                    this.repository = (Repository)this.getService(Repository.class);
                    Server server2 = PluginConfigServiceImpl.getServer(this.repository);
                    EList eList = server2.getComponents();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    for (int i = 0; i < eList.size(); ++i) {
                        object = (ServerComponent)eList.get(i);
                        if (object instanceof NodeAgent) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "Found an instance of NodeAgent");
                            }
                            bl = true;
                            continue;
                        }
                        if (object instanceof CellManager) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string + "Found an instance of CellManager");
                            }
                            bl2 = true;
                            continue;
                        }
                        if (!(object instanceof ApplicationServer)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "Found an instance of ApplicationServer");
                        }
                        bl3 = true;
                    }
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    if (adminService != null && (object = adminService.getProcessType()) != null) {
                        if (bl2 || ((String)object).equals("UnManagedProcess")) {
                            this.registerWebServerMBean(this.repository.getRootURI());
                            this.registerPluginCfgMBean();
                        } else {
                            bl4 = true;
                        }
                    }
                    if (pluginConfigService != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, string + "PluginConfigService enabled=" + pluginConfigService.isEnable());
                        }
                        if (!pluginConfigService.isEnable()) {
                            Tr.info(tc, "pluginconfigservice.notstarted");
                        } else {
                            object = "com.ibm.websphere.plugincfg.initializers.PluginRepositoryListener";
                            Class<?> clazz = Class.forName((String)object);
                            if (clazz != null) {
                                Class[] classArray = new Class[]{Repository.class, VariableMap.class, TraceNLS.class, Boolean.class, Boolean.class};
                                Method method2 = clazz.getMethod("createInstance", classArray);
                                method2.invoke(null, this.repository, this.variableMap, nls, new Boolean(bl2), new Boolean(bl4));
                            }
                            Tr.info(tc, "pluginconfigservice.started");
                            started = true;
                        }
                    } else {
                        Tr.info(tc, "pluginconfigservice.notstarted");
                    }
                }
            }
            catch (Throwable throwable) {
                Tr.error(tc, "pluginconfigservice.starterror");
                if (!tc.isDebugEnabled()) break block25;
                Tr.debug(tc, string + throwable.getMessage());
            }
        }
        this.setState("INITIALIZED");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private void registerPluginCfgMBean() {
        block3: {
            String string = "registerPluginCfgMBean: ";
            try {
                String string2 = "com.ibm.websphere.plugincfg.generator.PluginConfigGenerator";
                Class<?> clazz = Class.forName(string2);
                Object obj = clazz.newInstance();
                AdminServiceFactory.getMBeanFactory().activateMBean("PluginCfgGenerator", (RuntimeCollaborator)obj, "PluginCfgGenerator", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + "Plugin config generator MBean is registered.");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.component.PluginConfigServiceImpl", "329", this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, string + "Unable to register plugin config generator MBean.");
            }
        }
    }

    private void registerWebServerMBean(String string) {
        block3: {
            String string2 = "registerWebServerMBean: ";
            try {
                String string3 = "com.ibm.ws.management.webserver.WebServer";
                Class<?> clazz = Class.forName(string3);
                Class[] classArray = new Class[]{String.class};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object obj = constructor.newInstance(string);
                AdminServiceFactory.getMBeanFactory().activateMBean("WebServer", (RuntimeCollaborator)obj, "WebServer", null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + "WebServer MBean is registered.");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.component.PluginConfigServiceImpl", "330", this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, string2 + "Unable to register WebServer operations MBean.");
            }
        }
    }

    private static Server getServer(Repository repository2) throws Exception {
        Resource resource = repository2.getConfigRoot().getResource(4, "server.xml");
        return (Server)resource.getContents().get(0);
    }

    static {
        className = "com.ibm.ws.management.component.PluginConfigServiceImpl.";
    }
}

