/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.security.common.util.MergeSecurityConfig;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportStep;
import java.util.Collections;
import javax.management.ObjectName;

public class AddNodeSecurityExt
extends ImportStep {
    private static TraceComponent tc = Tr.register(AddNodeSecurityExt.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public AddNodeSecurityExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public AddNodeSecurityExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    protected void executeStep() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            return;
        }
        try {
            super.executeStep();
            Session session = this.getConfigSession();
            Session session2 = this.getConfigArchiveSession();
            Security security2 = this.getSecurity(session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellSecurity: ", security2);
            }
            Security security3 = this.getSecurity(session2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeSecurity: ", security3);
            }
            ServerIndex serverIndex = this.getServerIndex(session2);
            String string = serverIndex.getHostName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeHostName: ", string);
            }
            String string2 = (String)this.taskCmd.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName: ", string2);
            }
            String string3 = WorkspaceHelper.getWorkspace(session).getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "workspace path: ", string3);
            }
            String string4 = WorkspaceHelper.getWorkspace(session2).getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "workspace (archive) path: ", string4);
            }
            ManagedObjectMetadataHelper managedObjectMetadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            String string5 = managedObjectMetadataHelper.getNodePlatformOS(string2);
            String string6 = System.getProperty("os.name");
            if (string6 != null) {
                string6 = ManagedObjectMetadataUtilities.normalizeOSName(string6);
            }
            if (string6 == null) {
                string6 = "windows";
            }
            if (string5 == null) {
                string5 = string6;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeOS", string5);
            }
            boolean bl = false;
            if (managedObjectMetadataHelper.compareNodeVersion(string2, "6.1") == -1) {
                bl = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isOldVersionNode ", Boolean.toString(bl));
            }
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string7 = adminService.getNodeName();
            MergeSecurityConfig.merge(string4, string3, security2, security3, string2, string, string6, string5, bl, string7);
            security2.eResource().save(Collections.EMPTY_MAP);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.AddNodeSecurityExt.executeStep", "48");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "mergeSecurity step failed"));
        }
    }

    private Security getSecurity(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurity");
        }
        Security security2 = null;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName = configService.resolve(session, null, "Cell=:Security=")[0];
        security2 = (Security)MOFUtil.convertToEObject(session, objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurity", security2);
        }
        return security2;
    }

    private ServerIndex getServerIndex(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndex");
        }
        ServerIndex serverIndex = null;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName objectName3 = configService.getRelationship(session, objectName2, "ServerIndex")[0];
        serverIndex = (ServerIndex)MOFUtil.convertToEObject(session, objectName3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndex", serverIndex);
        }
        return serverIndex;
    }
}

