/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityFactory;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariablesFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveComposer;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.configarchive.ApplicationConfigurator;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class ApplicationConfiguratorImpl
extends ApplicationConfigurator {
    private static TraceComponent tc = Tr.register(ApplicationConfiguratorImpl.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private FileAccessor fileAccessor = null;
    private WorkSpace archiveWorkspace = null;
    private RepositoryContext cellContext = null;
    private RepositoryContext applicationContext = null;
    private RepositoryContext appDeploymentContext = null;
    private RepositoryContext serverContext = null;
    private RepositoryContext nodeContext = null;
    public static final String CELL_NAME = "defaultCell";
    private static final String NODE_NAME = "defaultNode";
    private static final String SERVER_NAME = "defaultServer";
    public static final String APPLICATION_NAME = "defaultApp";
    public static final String APPLICATION_BIN_NAME = "defaultApp.ear_";

    public ApplicationConfiguratorImpl(FileAccessor fileAccessor) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ApplicationConfiguratorImpl", fileAccessor);
        }
        this.fileAccessor = fileAccessor;
        this.archiveWorkspace = ConfigArchiveComposer.loadConfigArchive(null, this.fileAccessor);
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)this.archiveWorkspace;
        workSpaceImpl.setDisableCleanup();
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ApplicationConfiguratorImpl");
        }
    }

    public ApplicationConfiguratorImpl(WorkSpace workSpace) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ApplicationConfiguratorImpl", workSpace);
        }
        this.archiveWorkspace = workSpace;
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)workSpace;
        workSpaceImpl.setDisableCleanup();
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ApplicationConfiguratorImpl");
        }
    }

    private void init() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        try {
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
            RepositoryContext repositoryContext = this.archiveWorkspace.getRootContext();
            Collection collection = repositoryContext.findContext("cells", CELL_NAME);
            this.cellContext = collection == null || collection.size() == 0 ? repositoryContext.create(repositoryContextType, CELL_NAME) : (RepositoryContext)collection.iterator().next();
            repositoryContextType = repositoryMetaData.getContextType("nodes");
            collection = this.cellContext.findContext("nodes", NODE_NAME);
            this.nodeContext = collection == null || collection.size() == 0 ? this.cellContext.create(repositoryContextType, NODE_NAME) : (RepositoryContext)collection.iterator().next();
            repositoryContextType = repositoryMetaData.getContextType("servers");
            collection = this.cellContext.findContext("servers", SERVER_NAME);
            this.serverContext = collection == null || collection.size() == 0 ? this.nodeContext.create(repositoryContextType, SERVER_NAME) : (RepositoryContext)collection.iterator().next();
            repositoryContextType = repositoryMetaData.getContextType("applications");
            collection = this.cellContext.findContext("applications", APPLICATION_NAME);
            this.applicationContext = collection == null || collection.size() == 0 ? this.cellContext.create(repositoryContextType, APPLICATION_NAME) : (RepositoryContext)collection.iterator().next();
            repositoryContextType = repositoryMetaData.getContextType("deployments");
            collection = this.applicationContext.findContext("deployments", APPLICATION_NAME);
            this.appDeploymentContext = collection == null || collection.size() == 0 ? this.applicationContext.create(repositoryContextType, APPLICATION_NAME) : (RepositoryContext)collection.iterator().next();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ApplicationConfiguratorImpl.init", "147");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "init failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public List listResourceProvider() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResourceProvider");
        }
        EList eList = null;
        try {
            Resource resource = ConfigArchiveUtils.getResource(this.appDeploymentContext, "resources.xml");
            eList = resource.getContents();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listResourceProvider", "111");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "listResourceProvider failed");
        }
        if (eList.size() == 0) {
            this.addDefaultResources((List)eList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listResourceProvider", eList);
        }
        return eList;
    }

    public List listVirtualHost() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listVirtualHost");
        }
        EList eList = null;
        try {
            Resource resource = ConfigArchiveUtils.getResource(this.cellContext, "virtualhosts.xml");
            eList = resource.getContents();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listVirtualHost", "142");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "listVirtualHost failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listVirtualHost", eList);
        }
        return eList;
    }

    public List listVariables() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listVariables");
        }
        EList eList = null;
        try {
            Resource resource = ConfigArchiveUtils.getResource(this.appDeploymentContext, "variables.xml");
            EList eList2 = resource.getContents();
            VariableMap variableMap = null;
            if (eList2.size() == 0) {
                variableMap = VariablesFactory.eINSTANCE.createVariableMap();
                eList2.add(variableMap);
            } else {
                variableMap = (VariableMap)eList2.get(0);
            }
            eList = variableMap.getEntries();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listVariables", "179");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "listVariables failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listVariables", eList);
        }
        return eList;
    }

    public List listLibraries() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listLibraries");
        }
        EList eList = null;
        try {
            Resource resource = ConfigArchiveUtils.getResource(this.serverContext, "libraries.xml");
            eList = resource.getContents();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listLibraries", "197");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "listLibraries failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listLibraries", eList);
        }
        return eList;
    }

    public List listJAASAuthData() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listJAASAuthData");
        }
        EList eList = null;
        try {
            Resource resource = ConfigArchiveUtils.getResource(this.cellContext, "security.xml");
            EList eList2 = resource.getContents();
            Security security2 = null;
            if (eList2.size() == 0) {
                security2 = SecurityFactory.eINSTANCE.createSecurity();
                eList2.add(security2);
            } else {
                security2 = (Security)eList2.get(0);
            }
            eList = security2.getAuthDataEntries();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listJAASAuthData", "235");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "listJAASAuthData failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listJAASAuthData", eList);
        }
        return eList;
    }

    public void save() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save");
        }
        this.saveContext(this.archiveWorkspace.getRootContext());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
    }

    private void saveContext(RepositoryContext repositoryContext) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveContext");
        }
        try {
            Object object;
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            Object object2 = resourceSet.getResources().iterator();
            while (object2.hasNext()) {
                object = (Resource)object2.next();
                if (!object.isModified()) continue;
                object.save(Collections.EMPTY_MAP);
            }
            object2 = repositoryContext.getChildren();
            object = object2.iterator();
            while (object.hasNext()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)object.next();
                this.saveContext(repositoryContext2);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.saveContext", "271");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "saveContext failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveContext");
        }
    }

    public void cleanup() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        ConfigArchiveComposer.unloadConfigArchive(this.archiveWorkspace.getUserName());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    public List listDeployments() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listDeployments");
        }
        EList eList = null;
        try {
            Resource resource = ConfigArchiveUtils.getResource(this.appDeploymentContext, "deployment.xml");
            eList = resource.getContents();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchivearchive.ApplicationConfiguratorImpl.listDeployment", "311");
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)throwable;
            }
            throw new ConfigArchiveException(throwable, "listDeployments failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listDeployments", eList);
        }
        return eList;
    }

    private void addDefaultResources(List list) {
        try {
            String string;
            RepositoryContext repositoryContext;
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            String string2 = "WebSphere Relational Resource Adapter";
            Session session = new Session();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addDefaultResources");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a builin_rra");
            }
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("servertypes");
            RepositoryContextType repositoryContextType2 = repositoryMetaData.getContextType("servers");
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
            RepositoryContext repositoryContext2 = templateManager.getRootTemplateContext();
            if (repositoryContext2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template context");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context ", repositoryContext2);
            }
            if ((repositoryContext = repositoryContext2.getChild(repositoryContextType, string = "APPLICATION_SERVER")) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find server type context");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for servertypes", repositoryContext);
            }
            List list2 = repositoryContext.getChildren();
            RepositoryContext repositoryContext3 = null;
            Resource resource = list2.iterator();
            while (resource.hasNext() && !(repositoryContext3 = (RepositoryContext)resource.next()).getName().equals("default")) {
            }
            if (repositoryContext3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find template for default server");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found template context for server", repositoryContext3.getName());
            }
            if ((resource = ConfigArchiveUtils.getResource(repositoryContext3, "resources.xml")) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addDefaultResources", "Cannot find resources.xml for default server");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found resource", resource);
            }
            EList eList = resource.getContents();
            Object object = eList.iterator();
            while (object.hasNext()) {
                EObject eObject = (EObject)object.next();
                Resource resource2 = eObject.eResource();
                String string3 = null;
                if (resource2 instanceof XMIResource) {
                    string3 = ((XMIResource)resource2).getID(eObject);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding ", string3);
                }
                object.remove();
                list.add(eObject);
                resource2 = eObject.eResource();
                if (!(resource2 instanceof XMIResource)) continue;
                ((XMIResource)resource2).setID(eObject, string3);
            }
            object = WorkSpaceManagerFactory.getManager();
            object.removeWorkSpace(session.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addDefaultResources", list);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

