/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import javax.management.ObjectName;

public class CleanupNode
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CleanupNode.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private ObjectName nodeId = null;
    private String nodeName = null;

    public CleanupNode(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public CleanupNode(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node", this.nodeName);
            ObjectName[] objectNameArray = configService.queryConfigObjects(this.getConfigSession(), null, objectName, null);
            if (objectNameArray.length != 1) {
                String string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0009E", new Object[]{this.nodeName}, null);
                throw new CommandValidationException(string);
            }
            this.nodeId = objectNameArray[0];
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.CleanupNode.validate", "63");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to validate the command", throwable);
            }
            CommandValidationException commandValidationException = new CommandValidationException(throwable, "unexpected exception during validation");
            throw commandValidationException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.removeApplicationsFromNode(this.nodeName);
            try {
                this.removeNodeFromAllNodeGroups();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.CleanupNode.beforeStepsExecuted", "99");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.CleanupNode.beforeStepsExecuted", "175");
            taskCommandResultImpl.setException(new CommandException(throwable, "cleanupNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            Session session = this.getConfigSession();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] objectNameArray = configService.queryConfigObjects(this.getConfigSession(), this.nodeId, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "match[" + i + "]", objectNameArray[i]);
                }
                configService.deleteConfigData(session, objectNameArray[i]);
            }
            configService.deleteConfigData(session, this.nodeId);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.CleanupNode.afterStepsExecuted", "126");
            taskCommandResultImpl.setException(new CommandException(throwable, "cleanupNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    private void removeApplicationsFromNode(String string) throws Exception {
        AppManagement appManagement = CommandMgr.getCommandMgr().getCommandProviderHelper().getAppManagement();
        Session session = this.getConfigSession();
        String string2 = session.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wsId", string2);
        }
        String string3 = ConfigArchiveUtils.getCellName();
        appManagement.removeAllAppsFromNode(string, string3, null, string2);
    }

    private void removeNodeFromAllNodeGroups() throws Throwable {
        Session session = this.getConfigSession();
        Object var2_2 = null;
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("removeNodeFromNodeGroups");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject(this.nodeName);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (!commandResult.isSuccessful()) {
            throw commandResult.getException();
        }
    }
}

