/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerImpl;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ConfigArchiveComposer {
    private static TraceComponent tc = Tr.register(ConfigArchiveComposer.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static final int MAXBYTES = 2048;
    static final String BUNDLE_WORKSPACE_PATH_NAME = WorkSpaceConstant.WORKSPACE_PATH_NAME + File.separator;

    public static WorkSpace createConfigArchive(String string, FileAccessor fileAccessor) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigArchive " + string + " " + fileAccessor);
        }
        String string2 = string;
        WorkSpace workSpace = null;
        String string3 = BUNDLE_WORKSPACE_PATH_NAME;
        workSpace = ConfigArchiveComposer.getWorkSpace(string2, string3, fileAccessor);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigArchive");
        }
        return workSpace;
    }

    public static Session createConfigArchiveSession(String string, FileAccessor fileAccessor) throws ConfigArchiveException {
        WorkSpace workSpace = ConfigArchiveComposer.createConfigArchive(string, fileAccessor);
        return new Session(workSpace.getUserName(), true);
    }

    public static WorkSpace loadConfigArchive(File file, FileAccessor fileAccessor) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfigArchive " + file + " " + fileAccessor);
        }
        String string = null;
        WorkSpace workSpace = null;
        String string2 = BUNDLE_WORKSPACE_PATH_NAME;
        string = ConfigArchiveComposer.getWsId(file);
        workSpace = ConfigArchiveComposer.getWorkSpace(string, string2, fileAccessor);
        ConfigArchiveComposer.loadArchiveToWorkSpace(workSpace, file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfigArchive");
        }
        return workSpace;
    }

    public static Session loadConfigArchiveSession(File file, FileAccessor fileAccessor) throws ConfigArchiveException {
        WorkSpace workSpace = ConfigArchiveComposer.loadConfigArchive(file, fileAccessor);
        return new Session(workSpace.getUserName(), true);
    }

    public static void saveConfigArchive(String string, File file) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveConfigArchive " + string + " " + file);
        }
        String string2 = string;
        WorkSpace workSpace = null;
        if (string2 == null) {
            throw new ConfigArchiveException("No archive name specified for saveConfigArchive");
        }
        Properties properties = new Properties();
        properties.setProperty("workspace.user.id", string2);
        try {
            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(properties);
        }
        catch (Exception exception) {
            throw new ConfigArchiveException(exception, "Failed to create workspace for archive");
        }
        ConfigArchiveComposer.saveConfigArchiveFromWorkspace(workSpace, string, file);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveConfigArchive");
        }
    }

    public static void unloadConfigArchive(String string) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unloadConfigArchive ", string);
        }
        String string2 = string;
        WorkSpace workSpace = null;
        Properties properties = new Properties();
        if (string2 != null) {
            properties.setProperty("workspace.user.id", string2);
        }
        try {
            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(properties);
        }
        catch (Exception exception) {
            throw new ConfigArchiveException(exception, "Failed to create workspace for archive");
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            configService.discard(new Session(string, true));
        }
        catch (Exception exception) {
            throw new ConfigArchiveException(exception, "Failed to unload archive related files from workspace");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unloadConfigArchive");
        }
    }

    private static String getWsId(File file) {
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    private static void loadArchiveToWorkSpace(WorkSpace workSpace, File file) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadArchiveToWorkSpace " + workSpace + " " + file);
        }
        if (file == null) {
            return;
        }
        FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
        ZipFile zipFile = null;
        try {
            String string = workSpace.getUserPath();
            zipFile = new ZipFile(file, 1);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                String string2 = zipEntry.getName();
                String string3 = string2.replace('\\', '/');
                OutputStream outputStream = fileAccessor.getOutputStream(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loading  " + string3 + " into workspace");
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 2048);
                byte[] byArray = new byte[2048];
                while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "loaded  " + string3 + " into workspace.");
            }
        }
        catch (Exception exception) {
            throw new ConfigArchiveException(exception, "Failed to unload archive archive to workspace");
        }
        finally {
            block17: {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ConfigArchiveComposer.loadConfigArchive", "321");
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "unexpected exception", throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadArchiveToWorkSpace");
        }
    }

    private static void saveConfigArchiveFromWorkspace(WorkSpace workSpace, String string, File file) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveConfigArchiveFromWorkspace " + workSpace + " " + string + " " + file);
        }
        FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
        try {
            String string2 = workSpace.getUserPath();
            byte[] byArray = new byte[2048];
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            List list = new ArrayList();
            list = workSpace.getRootContext().getAllList(true);
            for (int i = 0; i < list.size(); ++i) {
                int n;
                WorkSpaceFile workSpaceFile = (WorkSpaceFile)list.get(i);
                String string3 = workSpaceFile.getURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "saving  " + string3);
                }
                if (!fileAccessor.exists(string3)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "file does not exist  " + string3);
                    continue;
                }
                InputStream inputStream = fileAccessor.load(string3);
                String string4 = string3;
                zipOutputStream.putNextEntry(new ZipEntry(string4));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "saving  " + inputStream);
                }
                while ((n = inputStream.read(byArray, 0, 2048)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                zipOutputStream.closeEntry();
                inputStream.close();
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            throw new ConfigArchiveException(exception, "Failed to load archive archive from workspace");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveConfigArchiveFromWorkspace");
        }
    }

    public static ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataHelper", session);
        }
        ManagedObjectMetadataHelper managedObjectMetadataHelper = null;
        try {
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            managedObjectMetadataHelper = workSpace.getMetadataHelper();
        }
        catch (Exception exception) {
            throw new ConfigArchiveException(exception, "fail to get ManagedObjectMetadataHelper for session " + session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataHelper", managedObjectMetadataHelper);
        }
        return managedObjectMetadataHelper;
    }

    private static WorkSpace getWorkSpace(String string, String string2, FileAccessor fileAccessor) throws ConfigArchiveException {
        int n = 20;
        WorkSpace workSpace = null;
        int n2 = 0;
        while (workSpace == null) {
            Properties properties = new Properties();
            if (string == null) {
                string = "archive" + System.currentTimeMillis();
            }
            properties.setProperty("workspace.user.id", string);
            properties.setProperty("workspace.repository.adapter", "com.ibm.ws.management.configarchive.ConfigArchiveRepositoryAdapter");
            string2 = string2 + string;
            if (fileAccessor != null) {
                properties.put("workspace.file.accessor", fileAccessor);
            } else {
                properties.setProperty("workspace.root", string2);
            }
            try {
                WorkSpaceManagerImpl workSpaceManagerImpl = (WorkSpaceManagerImpl)WorkSpaceManagerFactory.getManager();
                workSpace = workSpaceManagerImpl.createUniqueWorkSpace(properties);
            }
            catch (Exception exception) {
                workSpace = null;
            }
            if (workSpace == null) {
                ++n2;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n2 <= n) continue;
            throw new ConfigArchiveException("Failed to create workspace for archive");
        }
        return workSpace;
    }
}

