/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileAccessorUtil;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class ConfigArchiveRepositoryAdapter
implements WorkSpaceRepositoryAdapter,
WorkSpaceMessage,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ConfigArchiveRepositoryAdapter.class);
    private static boolean init = false;
    private static RepositoryMetaData defaultMetaData = null;

    public String[] getCatalog(WorkSpace workSpace, String string, int n, int n2) throws WorkSpaceException {
        FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
        String string2 = this.getURI(workSpace, string);
        List list = FileAccessorUtil.listFiles(fileAccessor, string2, n, n2);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            int n3 = string2.length() == 0 ? 0 : string2.length() + 1;
            string3 = string3.substring(n3);
            stringArray[i] = string3 = string3.replace(FILE_SEPERATOR_CHAR, '/');
        }
        return stringArray;
    }

    private String getURI(WorkSpace workSpace, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public boolean exist(WorkSpace workSpace, String string) throws WorkSpaceException {
        FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
        return FileAccessorUtil.exist(fileAccessor, this.getURI(workSpace, string));
    }

    public Integer checkSynchState(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        return ConflictState.UN_MODIFIED;
    }

    public void update(Map[] mapArray) throws WorkSpaceException {
    }

    public void extract(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
    }

    public void release(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        if (workSpaceImpl.cleanupNeeded()) {
            FileAccessorUtil.deleteTree(fileAccessor, workSpaceFile.getURI());
        }
    }

    public void release(RepositoryContext repositoryContext) throws WorkSpaceException {
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        if (workSpaceImpl.cleanupNeeded()) {
            FileAccessorUtil.deleteTree(fileAccessor, repositoryContext.getURI());
        }
    }

    public void delete(RepositoryContext repositoryContext) throws WorkSpaceException {
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        FileAccessorUtil.deleteTree(fileAccessor, repositoryContext.getURI());
    }

    public void delete(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        RepositoryContext repositoryContext = workSpaceFile.getContext();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        FileAccessorUtil.delete(fileAccessor, workSpaceFile.getURI());
    }

    public void setSessionId(WorkSpace workSpace) throws WorkSpaceException {
    }

    public void unsetSessionId(WorkSpace workSpace) throws WorkSpaceException {
    }

    public boolean isValid(WorkSpace workSpace) throws WorkSpaceException {
        return true;
    }

    public void initialize(Properties properties) throws WorkSpaceException {
    }

    public void remove(WorkSpace workSpace) throws WorkSpaceException {
        FileAccessor fileAccessor = ((WorkSpaceImpl)workSpace).getFileAccessor();
        if (((WorkSpaceImpl)workSpace).cleanupNeeded()) {
            FileAccessorUtil.deleteTree(fileAccessor, "");
        }
    }

    public void save(RepositoryContext repositoryContext) throws WorkSpaceException {
        Object var2_2 = null;
        String string = repositoryContext.getURI();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)repositoryContext.getWorkSpace();
        FileAccessor fileAccessor = workSpaceImpl.getFileAccessor();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Saving Context: (" + repositoryContext.getState() + ") " + string);
        }
        try {
            FileAccessorUtil.makeDir(fileAccessor, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saved  Context: (" + repositoryContext.getState() + ") " + string);
            }
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0006E Error while saving context {0}-{1}", new Object[]{repositoryContext.getName(), exception}, exception);
        }
    }

    public String restore(RepositoryContext repositoryContext) throws WorkSpaceException {
        return null;
    }

    public RepositoryMetaData getMetaData() {
        return this.getDefaultMetaData();
    }

    private RepositoryMetaData getDefaultMetaData() {
        if (defaultMetaData == null) {
            defaultMetaData = RepositoryMetaDataFactory.getFactory().getMetaData();
        }
        return defaultMetaData;
    }
}

