/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigArchiveUtils {
    private static TraceComponent tc = Tr.register(ConfigArchiveUtils.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static String waitTarget = null;

    private static RepositoryContext copyContext(RepositoryContext repositoryContext, Template template, HashMap hashMap, String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyContext", new Object[]{repositoryContext, template, hashMap, string});
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        RepositoryContext repositoryContext2 = templateManager.createContext(repositoryContext, string == null ? template.getName() : string, template, hashMap);
        List list = template.getContext().getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext3 = (RepositoryContext)iterator.next();
            ConfigArchiveUtils.copyContext(repositoryContext2, templateManager.getTemplate(repositoryContext3), hashMap, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyContext", repositoryContext2);
        }
        return repositoryContext2;
    }

    public static RepositoryContext copyContext(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyContext", new Object[]{repositoryContext, repositoryContext2});
        }
        RepositoryContext repositoryContext3 = null;
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        Template template = templateManager.getTemplate(repositoryContext2);
        repositoryContext3 = ConfigArchiveUtils.copyContext(repositoryContext, template, null, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyContext", repositoryContext3);
        }
        return repositoryContext3;
    }

    private static RepositoryContext copyOrCreateContext(RepositoryContext repositoryContext, Template template, HashMap hashMap, String string) throws WorkSpaceException {
        Collection collection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyOrCreateContext", new Object[]{repositoryContext, template, hashMap, string});
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        RepositoryContext repositoryContext2 = null;
        if (string != null) {
            collection = repositoryContext.findContext(template.getType().getName(), string);
            if (collection.iterator().hasNext()) {
                repositoryContext2 = (RepositoryContext)collection.iterator().next();
                Tr.debug(tc, "Found the context with a context name = " + string);
            } else {
                Tr.debug(tc, "no context with a context name " + string + " found");
            }
        }
        if (repositoryContext2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "context " + string + " does not exist so create it");
            }
            repositoryContext2 = templateManager.createContext(repositoryContext, string == null ? template.getName() : string, template, hashMap);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "context " + string + " exists already so use it");
            }
            templateManager.copyContext(repositoryContext2, template, hashMap);
        }
        collection = template.getContext().getChildren();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext3 = (RepositoryContext)iterator.next();
            repositoryContext2 = ConfigArchiveUtils.copyOrCreateContext(repositoryContext2, templateManager.getTemplate(repositoryContext3), hashMap, repositoryContext3.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyOrCreateContext", repositoryContext2);
        }
        return repositoryContext2;
    }

    public static RepositoryContext copyOrCreateContext(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, String string) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyOrCreateContext", new Object[]{repositoryContext, repositoryContext2});
        }
        RepositoryContext repositoryContext3 = null;
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        Template template = templateManager.getTemplate(repositoryContext2);
        repositoryContext3 = ConfigArchiveUtils.copyOrCreateContext(repositoryContext, template, null, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyOrCreateContext", repositoryContext3);
        }
        return repositoryContext3;
    }

    public static RepositoryContext createContext(RepositoryContext repositoryContext, String string, RepositoryContext repositoryContext2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContext", new Object[]{repositoryContext, string, repositoryContext2});
        }
        RepositoryContext repositoryContext3 = null;
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        repositoryContext3 = templateManager.createContext(repositoryContext, string, templateManager.getTemplate(repositoryContext2), null);
        RepositoryDocumentType repositoryDocumentType = repositoryContext3.getType().getRootDocumentType();
        ConfigDataId configDataId = new ConfigDataId(repositoryContext3.getURI(), repositoryDocumentType.getFilePattern());
        Session session = new Session(repositoryContext3.getWorkSpace().getUserName(), true);
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "name", string);
            configService.setAttributes(session, ConfigServiceHelper.createObjectName(configDataId), attributeList);
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createContext", repositoryContext3);
        }
        return repositoryContext3;
    }

    public static void mergeList(List list, List list2, String string, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeList", new Object[]{list, list2, string, new Boolean(bl)});
        }
        for (int i = 0; i < list2.size(); ++i) {
            EObject eObject = (EObject)list2.get(i);
            EObject eObject2 = ConfigArchiveUtils.match(list, eObject, string);
            if (eObject2 != null && bl) {
                list.remove(eObject2);
            }
            if (eObject2 != null && !bl) continue;
            list.add(eObject);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeList");
        }
    }

    static void mergeVariableList(List list, List list2, String string, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeVariableList", new Object[]{list, list2, string, new Boolean(bl)});
        }
        for (int i = 0; i < list2.size(); ++i) {
            EObject eObject = (EObject)list2.get(i);
            String string2 = ((VariableSubstitutionEntry)eObject).getValue();
            if (string2 == null || string2.length() == 0) continue;
            EObject eObject2 = ConfigArchiveUtils.match(list, eObject, string);
            if (eObject2 != null && bl) {
                list.remove(eObject2);
            }
            if (eObject2 != null && !bl) continue;
            list.add(eObject);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeVariableList");
        }
    }

    private static EObject match(List list, EObject eObject, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "match", new Object[]{list, eObject, string});
        }
        EObject eObject2 = null;
        Object object = eObject.eGet(eObject.eClass().getEStructuralFeature(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EObject eObject3 = (EObject)iterator.next();
            Object object2 = eObject3.eGet(eObject3.eClass().getEStructuralFeature(string));
            if (object2 == null || !object2.equals(object)) continue;
            eObject2 = eObject3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "match", eObject2);
        }
        return eObject2;
    }

    static void mergeVirtualHostList(List list, List list2, String string, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeVirtualHostList", new Object[]{list, list2, string, new Boolean(bl)});
        }
        for (int i = 0; i < list2.size(); ++i) {
            EObject eObject = (EObject)list2.get(i);
            String string2 = ((VirtualHost)eObject).getName();
            if (string2 == null || string2.length() == 0) continue;
            EObject eObject2 = ConfigArchiveUtils.match(list, eObject, string);
            if (eObject2 != null && bl) {
                list.remove(eObject2);
                ConfigArchiveUtils.mergeList((List)((VirtualHost)eObject).getAliases(), (List)((VirtualHost)eObject2).getAliases(), "port", false);
            }
            if (eObject2 != null && !bl) continue;
            list.add(eObject);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeVirtualHostList");
        }
    }

    public static Resource getResource(RepositoryContext repositoryContext, String string) throws Exception {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResource", new Object[]{repositoryContext, string});
            }
            try {
                WorkspaceHelper.getDocAccessor(repositoryContext, string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getDocAccessor failed");
            }
        }
        Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    public static AdminCommand getCreateTemplateCommand(ConfigService configService, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateTemplateCommand", new Object[]{configService, session, objectName});
        }
        String string = (String)configService.getAttribute(session, objectName, "serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", string);
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("showServerTypeInfo");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject(string);
        adminCommand.execute();
        AttributeList attributeList = (AttributeList)adminCommand.getCommandResult().getResult();
        String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "createTemplateCommand");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createTemplateCmd", string2);
        }
        AdminCommand adminCommand2 = commandMgr.createCommand(string2);
        adminCommand2.setConfigSession(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateTemplateCommand", adminCommand2);
        }
        return adminCommand2;
    }

    public static AdminCommand getCreateCommand(ConfigService configService, Session session, Session session2, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateCommand", new Object[]{configService, session, session2, objectName});
        }
        String string = (String)configService.getAttribute(session2, objectName, "serverType");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverType", string);
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("showServerTypeInfo");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject(string);
        adminCommand.execute();
        AttributeList attributeList = (AttributeList)adminCommand.getCommandResult().getResult();
        String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "createCommand");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createCmd", string2);
        }
        AdminCommand adminCommand2 = commandMgr.createCommand(string2);
        adminCommand2.setConfigSession(session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateCommand", adminCommand2);
        }
        return adminCommand2;
    }

    public static RepositoryContext createContextIfNeeded(RepositoryContext repositoryContext, String string, String string2) throws Throwable {
        RepositoryMetaData repositoryMetaData;
        RepositoryContextType repositoryContextType;
        RepositoryContext repositoryContext2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContextIfNeeded", new Object[]{repositoryContext, string, string2});
        }
        if ((repositoryContext2 = repositoryContext.getChild(repositoryContextType = (repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData()).getContextType(string), string2)) == null) {
            repositoryContext2 = repositoryContext.create(repositoryContextType, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createContextIfNeeded", repositoryContext2);
        }
        return repositoryContext2;
    }

    public static Object[] toNames(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toNames", collection);
        }
        Object[] objectArray = new Object[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = ((RepositoryContext)iterator.next()).getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "result[" + n + "]", objectArray[n]);
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toNames");
        }
        return objectArray;
    }

    public static String getCellName() {
        AdminService adminService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName");
        }
        String string = (adminService = AdminServiceFactory.getAdminService()) != null ? adminService.getCellName() : System.getProperty("local.cell");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployApplication(ApplicationDeployment applicationDeployment, Session session, String string, Session session2, String string2, String string3, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deployApplication", new Object[]{session, string, session2, string2});
        }
        AppManagement appManagement = CommandMgr.getCommandMgr().getCommandProviderHelper().getAppManagement();
        File file = null;
        try {
            AppInstallListener appInstallListener;
            Object object;
            file = File.createTempFile(string2, ".ear");
            String string5 = file.getAbsolutePath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "temp path", string5);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
            String string6 = null;
            EList eList = applicationDeployment.getProperties();
            for (int i = 0; i < eList.size(); ++i) {
                object = (Property)eList.get(i);
                if (!"was.loose.config".equals(object.getName())) continue;
                string6 = object.getValue();
            }
            if (!applicationDeployment.isEnableDistribution() && string6 != null) {
                hashtable.put("was.loose.config", string6);
            }
            ConfigService configService = ConfigServiceFactory.getConfigService();
            object = configService.queryConfigObjects(session2, null, ConfigServiceHelper.createObjectName(null, "Cell"), null)[0];
            String string7 = ConfigServiceHelper.getDisplayName((ObjectName)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellName", string7);
            }
            hashtable.put("cell.name", string7);
            appManagement.exportApplication(string2, string5, hashtable, session2.toString());
            string7 = ConfigArchiveUtils.getCellName();
            hashtable = new Hashtable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellName", string7);
            }
            hashtable.put("cell.name", string7);
            hashtable.put("node.name", string3);
            hashtable.put("server.name", string4);
            if (!applicationDeployment.isEnableDistribution() && string6 != null) {
                hashtable.put("was.loose.config", string6);
            }
            if (string == null) {
                string = string2;
            }
            AppInstallListener appInstallListener2 = appInstallListener = new AppInstallListener(string, file);
            synchronized (appInstallListener2) {
                waitTarget = "InstallApplication";
                if (AdminServiceFactory.getAdminService() == null) {
                    appManagement.installApplicationLocal(string5, string, hashtable, appInstallListener, session.toString());
                } else {
                    appManagement.installApplication(string5, string, hashtable, session.toString());
                }
                if (!appInstallListener.isComplete()) {
                    appInstallListener.wait();
                }
            }
            if (!appInstallListener.isSuccess()) {
                throw new ConfigArchiveException("fail to deploy application " + string);
            }
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deployApplication");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateApplication(ApplicationDeployment applicationDeployment, Session session, String string, Session session2, String string2, String string3, String string4, String string5) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateApplication", new Object[]{session, string, session2, string2});
        }
        AppManagement appManagement = CommandMgr.getCommandMgr().getCommandProviderHelper().getAppManagement();
        File file = null;
        try {
            Object object;
            file = File.createTempFile(string2, ".ear");
            Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName objectName = configService.queryConfigObjects(session2, null, ConfigServiceHelper.createObjectName(null, "Cell"), null)[0];
            String string6 = ConfigServiceHelper.getDisplayName(objectName);
            hashtable.put("node.name", string4);
            hashtable.put("server.name", string5);
            hashtable.put("was.profile.import", "was.profile.import");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellName", string6);
            }
            string6 = ConfigArchiveUtils.getCellName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellName", string6);
            }
            hashtable.put("cell.name", string6);
            hashtable.put("contenttype", "app");
            String string7 = null;
            EList eList = applicationDeployment.getProperties();
            for (int i = 0; i < eList.size(); ++i) {
                object = (Property)eList.get(i);
                if (!"was.loose.config".equals(object.getName())) continue;
                string7 = object.getValue();
            }
            if (!applicationDeployment.isEnableDistribution() && string7 != null) {
                hashtable.put("was.loose.config", string7);
            }
            if (string == null) {
                string = string2;
            }
            AppInstallListener appInstallListener = new AppInstallListener(string, file);
            object = appInstallListener;
            synchronized (object) {
                waitTarget = "InstallApplication";
                if (AdminServiceFactory.getAdminService() == null) {
                    appManagement.updateApplicationLocal(string, null, string3, "update", hashtable, appInstallListener, session.toString());
                } else {
                    appManagement.updateApplication(string, null, string3, "update", hashtable, session.toString());
                }
                if (!appInstallListener.isComplete()) {
                    appInstallListener.wait();
                }
                if (!appInstallListener.isSuccess()) {
                    throw new ConfigArchiveException("fail to deploy application " + string);
                }
            }
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateApplication");
        }
    }

    public static void copyFile(RepositoryContext repositoryContext, RepositoryContext repositoryContext2, String string, String string2) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile", new Object[]{repositoryContext, repositoryContext2, string, string2});
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(repositoryContext.getWorkSpace());
        Template template = templateManager.getTemplate(repositoryContext2);
        templateManager.createFile(repositoryContext, string2, template, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void copyFile(String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy file (" + string + " " + string2 + ")");
        }
        File file = new File(string);
        File file2 = new File(string2);
        ConfigArchiveUtils.copyFile(file, file2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copy file (" + file + " " + file2 + ")");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray, 0, 1024)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void copyDir(String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDir", string + " " + string2);
        }
        File file = new File(string);
        File file2 = new File(string2);
        ConfigArchiveUtils.copyDir(file, file2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDir");
        }
    }

    public static void copyDir(File file, File file2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDir", file + " " + file2);
        }
        if (file.isDirectory()) {
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("Cannot create directory " + file2);
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file, stringArray[i]);
                File file4 = new File(file2, stringArray[i]);
                ConfigArchiveUtils.copyDir(file3, file4);
            }
        } else {
            ConfigArchiveUtils.copyFile(file, file2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDir");
        }
    }

    public static void mkdirs(String string) throws IOException {
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create directory " + string);
        }
    }

    public static void deleteDir(File file) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteDir", file);
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                ConfigArchiveUtils.deleteDir(file2);
            }
        }
        file.delete();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteDir");
        }
    }

    public static void copyRar(String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyRar ", string + " " + string2);
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (file.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy dir");
            }
            ConfigArchiveUtils.copyDir(file, file2);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "copy file");
            }
            File file3 = new File(file2, file.getName());
            ConfigArchiveUtils.copyFile(file, file3);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyRar");
        }
    }

    public static void getRar(String string, String string2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRar ", string2 + " " + string);
        }
        File file = new File(string2);
        File file2 = new File(string);
        if (file.exists()) {
            if (!file2.exists()) {
                File[] fileArray = file.listFiles();
                boolean bl = false;
                int n = 0;
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        bl = true;
                    }
                    if (!fileArray[i].getName().endsWith("rar")) continue;
                    n = i;
                }
                if (!bl) {
                    File file3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy single rar file ", fileArray[0] + " " + file2);
                    }
                    if (!(file3 = file2.getParentFile()).exists()) {
                        file3.mkdirs();
                    }
                    ConfigArchiveUtils.copyFile(fileArray[n], file2);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "copy rar directory ", file + " " + file2);
                    }
                    file2.mkdirs();
                    ConfigArchiveUtils.copyDir(file, file2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "delete  " + file + " " + " as " + file2 + "exists");
                }
                file.delete();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRar");
        }
    }

    private static class AppInstallListener
    implements AppNotification.Listener,
    NotificationListener {
        private ObjectName appmgmtMBean = null;
        private String appName;
        private File earFile;
        private boolean success = false;
        private boolean complete = false;
        private String task = null;

        public AppInstallListener(String string, File file) {
            this.appName = string;
            this.earFile = file;
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    Set set;
                    String string2 = adminService.getProcessName();
                    String string3 = adminService.getNodeName();
                    String string4 = "WebSphere:type=AppManagement,node=" + string3 + ",process=" + string2 + ",*";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "query", string4);
                    }
                    if ((set = adminService.queryNames(new ObjectName(string4), null)).size() >= 1) {
                        this.appmgmtMBean = (ObjectName)set.iterator().next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appmgmtMBean", this.appmgmtMBean);
                        }
                        adminService.addNotificationListener(this.appmgmtMBean, this, null, null);
                    }
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", exception);
                }
                FFDCFilter.processException(exception, "com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", "313");
            }
        }

        public void handleNotification(Notification notification, Object object) {
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notification, object});
            }
            if ((object2 = notification.getUserData()) instanceof AppNotification) {
                this.appEventReceived((AppNotification)object2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", object2);
            }
            if (this.complete) {
                try {
                    AdminServiceFactory.getAdminService().removeNotificationListener(this.appmgmtMBean, this);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception", exception);
                    }
                    FFDCFilter.processException(exception, "com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", "331");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }

        public synchronized void appEventReceived(AppNotification appNotification) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "appEventReceived", appNotification);
            }
            String string = appNotification.props.getProperty("appname");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "thisAppName", string);
            }
            if (this.appName.equals(string)) {
                if (appNotification.taskStatus.equals("Completed")) {
                    this.success = true;
                    this.complete = true;
                    this.task = appNotification.taskName;
                } else if (appNotification.taskStatus.equals("Failed")) {
                    this.success = false;
                    this.complete = true;
                    this.task = appNotification.taskName;
                }
                if (this.complete) {
                    if (appNotification.taskName.equals(waitTarget)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "", string);
                        }
                        waitTarget = null;
                        this.notifyAll();
                    } else if (!this.success) {
                        waitTarget = null;
                        this.notifyAll();
                    } else {
                        this.complete = false;
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appEventReceived");
            }
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public String getTask() {
            return this.task;
        }
    }
}

