/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.management.configarchive.ConfigArchiveComposer;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configarchive.EARFileAccessor;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ApplicationConfigurator;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class EnhancedEarConfigurator {
    private static TraceComponent tc = Tr.register(EnhancedEarConfigurator.class, "EnhancedEarConfigurator", "com.ibm.ws.management.resources.configarchive");
    private static char URI_SEPARATOR = (char)47;
    private WorkSpace workspace;
    private WorkSpace earWorkspace = null;
    private EARFile earFile;
    private EARFileAccessor earFileAccessor = null;
    private String expandedEarFileLocation;
    private DefaultFileAccessor expandedEarFileAccessor = null;
    private WorkSpace expandedEarWorkspace = null;
    private RepositoryMetaData metadata = null;
    private boolean overWriteConfig;
    private String cellName = null;
    private String appName = null;
    private String binName = null;

    private void init(WorkSpace workSpace, EARFile eARFile, String string, boolean bl, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{workSpace, eARFile, string, new Boolean(bl), string2, string3, string4});
        }
        this.appName = string3;
        this.binName = string4;
        this.cellName = string2;
        this.overWriteConfig = bl;
        this.workspace = workSpace;
        if (string != null) {
            this.expandedEarFileLocation = string;
            String string5 = ApplicationConfigurator.getConfigBundleLocation();
            string5 = string + File.separator + string5.replace(URI_SEPARATOR, File.separatorChar);
            this.expandedEarFileAccessor = new DefaultFileAccessor(new File(string5));
            try {
                this.expandedEarWorkspace = ConfigArchiveComposer.createConfigArchive(null, this.expandedEarFileAccessor);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to create config archive composer");
                }
                exception.printStackTrace();
            }
        }
        if (eARFile != null) {
            this.earFile = eARFile;
            this.earFileAccessor = new EARFileAccessor(eARFile);
            try {
                this.earWorkspace = ConfigArchiveComposer.createConfigArchive(null, this.earFileAccessor);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to create config archive composer");
                }
                exception.printStackTrace();
            }
        }
        this.metadata = RepositoryMetaDataFactory.getRepositoryMetaData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public EnhancedEarConfigurator(WorkSpace workSpace, String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EnhancedEarConfigurator", new Object[]{workSpace, string, string2, string3, string4});
        }
        this.init(workSpace, null, string, false, string2, string3, string4);
        try {
            if (this.expandedEarFileAccessor != null) {
                this.expandedEarFileAccessor.makeDir("");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to create root context");
            }
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EnhancedEarConfigurator");
        }
    }

    public EnhancedEarConfigurator(WorkSpace workSpace, EARFile eARFile, boolean bl, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EnhancedEarConfigurator", new Object[]{workSpace, eARFile, new Boolean(bl), string, string2, string3});
        }
        this.init(workSpace, eARFile, null, bl, string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EnhancedEarConfigurator");
        }
    }

    public void importApplicationConfiguration() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importApplicationConfiguration");
        }
        try {
            if (this.earWorkspace == null) {
                throw new ConfigArchiveException("ear file is not specified for the Enhanced Ear Configurator");
            }
            RepositoryContext repositoryContext = this.earWorkspace.getRootContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found root context in workspace", repositoryContext);
            }
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No rootcontext found in the enhanced ear");
                }
                return;
            }
            RepositoryContext repositoryContext2 = null;
            RepositoryContextType repositoryContextType = this.metadata.getContextType("cells");
            Collection collection = repositoryContext.findContext(repositoryContextType);
            if (collection == null || collection.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No cell context found in ear file. Nothing to import");
                }
                return;
            }
            repositoryContext2 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found cell context in ear", repositoryContext2);
            }
            RepositoryContext repositoryContext3 = null;
            repositoryContextType = this.metadata.getContextType("applications");
            collection = repositoryContext2.findContext(repositoryContextType);
            if (collection == null || collection.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No application context found in ear file. Nothing to import");
                }
                return;
            }
            repositoryContext3 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found application context in ear", repositoryContext3);
            }
            RepositoryContext repositoryContext4 = null;
            repositoryContextType = this.metadata.getContextType("deployments");
            collection = repositoryContext3.findContext(repositoryContextType);
            if (collection == null || collection.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importApplicationConfiguration", "No deployment context fond. Nothing to import");
                }
                return;
            }
            repositoryContext4 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found deployment context in ear", repositoryContext4);
            }
            RepositoryContext repositoryContext5 = this.workspace.getRootContext();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found root context in workspace", repositoryContext5);
            }
            RepositoryContext repositoryContext6 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext5, "cells", this.cellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "created/found cells context in workspace", repositoryContext6);
            }
            RepositoryContext repositoryContext7 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext6, "applications", this.binName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "created/found applications context in workspace", repositoryContext7);
            }
            RepositoryContext repositoryContext8 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext7, "deployments", this.appName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "created/found deployments context in workspace", repositoryContext8);
            }
            Resource resource = null;
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext4, "deployment.xml");
            }
            catch (Exception exception) {
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext4, this.appName, "deployment.xml");
            }
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext4, "resources.xml");
            }
            catch (Exception exception) {
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext4, this.appName, "resources.xml");
            }
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext4, "variables.xml");
            }
            catch (Exception exception) {
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext4, this.appName, "variables.xml");
            }
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext4, "sca-module-properties.xml");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught an exception while getting sca-module-properties.xml", exception);
                }
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext4, this.appName, "sca-module-properties.xml");
            }
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importApplicationConfiguration failed", throwable.getMessage());
            }
            throw new ConfigArchiveException(throwable, "importApplicationConfiguration failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importApplicationConfiguration");
        }
    }

    public void updateApplicationConfiguration(List list) throws ConfigArchiveException {
        block73: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateApplicationConfiguration");
            }
            try {
                VirtualHost virtualHost;
                RepositoryContext repositoryContext = null;
                if (this.earWorkspace != null) {
                    repositoryContext = this.earWorkspace.getRootContext();
                } else if (this.expandedEarWorkspace != null) {
                    repositoryContext = this.expandedEarWorkspace.getRootContext();
                } else {
                    throw new ConfigArchiveException("ear file is not specified for the Enhanced Ear Configurator");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in workspace", repositoryContext);
                }
                if (repositoryContext == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateApplicationConfiguration ", "No rootcontext found in the enhanced ear");
                    }
                    return;
                }
                RepositoryContext repositoryContext2 = null;
                RepositoryContextType repositoryContextType = this.metadata.getContextType("cells");
                Collection collection = this.findContext(repositoryContext, repositoryContextType);
                if (collection == null || collection.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "updateApplicationConfiguration ", "No cell context found in ear file. Nothing to import");
                    }
                    return;
                }
                repositoryContext2 = (RepositoryContext)collection.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found cell context in ear", repositoryContext2);
                }
                RepositoryContext repositoryContext3 = this.workspace.getRootContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in workspace", repositoryContext3);
                }
                RepositoryContext repositoryContext4 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext3, "cells", this.cellName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "created/found cells context in workspace", repositoryContext4);
                }
                Resource resource = null;
                try {
                    resource = EnhancedEarConfigurator.getResource(repositoryContext2, "virtualhosts.xml");
                }
                catch (Exception exception) {
                    resource = null;
                }
                EList eList = null;
                VirtualHost virtualHost2 = null;
                if (resource != null && (eList = resource.getContents()) != null && eList.size() > 0) {
                    virtualHost2 = (VirtualHost)eList.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear virutal hosts", virtualHost2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear virutal hosts", virtualHost2);
                }
                Resource resource2 = null;
                try {
                    resource2 = EnhancedEarConfigurator.getResource(repositoryContext4, "virtualhosts.xml");
                }
                catch (Exception exception) {
                    resource2 = null;
                }
                EList eList2 = null;
                VirtualHost virtualHost3 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear virutal hosts", virtualHost2);
                }
                if (resource2 != null && virtualHost2 != null && (eList2 = resource2.getContents()) != null) {
                    for (int i = 0; i < eList2.size(); ++i) {
                        virtualHost = (VirtualHost)eList2.get(i);
                        if (!virtualHost.getName().equals(virtualHost2.getName())) continue;
                        virtualHost3 = virtualHost;
                        break;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "workspace virutal hosts", virtualHost3);
                }
                if (virtualHost2 != null) {
                    if (resource2 == null) {
                        ConfigArchiveUtils.copyFile(repositoryContext4, repositoryContext2, this.cellName, "virtualhosts.xml");
                    } else if (virtualHost3 != null) {
                        ConfigArchiveUtils.mergeList((List)virtualHost3.getAliases(), (List)virtualHost2.getAliases(), "port", this.overWriteConfig);
                    } else if (virtualHost2 != null) {
                        resource2.getContents().add((Object)virtualHost2);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "merged list = ", resource2.getContents());
                    }
                    if (resource2 != null) {
                        resource2.save(new HashMap());
                    }
                }
                Security security2 = null;
                try {
                    resource = EnhancedEarConfigurator.getResource(repositoryContext2, "security.xml");
                }
                catch (Exception exception) {
                    resource = null;
                }
                eList = null;
                if (resource != null) {
                    eList = resource.getContents();
                }
                if (eList != null && eList.size() > 0) {
                    security2 = (Security)eList.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "wear security ", security2);
                }
                virtualHost = null;
                try {
                    resource2 = EnhancedEarConfigurator.getResource(repositoryContext4, "security.xml");
                }
                catch (Exception exception) {
                    resource2 = null;
                }
                eList2 = null;
                if (resource2 != null) {
                    eList2 = resource2.getContents();
                }
                if (eList2 != null && eList2.size() > 0) {
                    virtualHost = (Security)eList2.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "workspace security ", virtualHost);
                }
                if (security2 != null) {
                    if (resource2 == null) {
                        ConfigArchiveUtils.copyFile(repositoryContext4, repositoryContext2, this.cellName, "security.xml");
                    } else {
                        ConfigArchiveUtils.mergeList((List)virtualHost.getAuthDataEntries(), (List)security2.getAuthDataEntries(), "alias", this.overWriteConfig);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "merged list = ", virtualHost.getAuthDataEntries());
                    }
                    if (resource2 != null) {
                        resource2.save(new HashMap());
                    }
                }
                RepositoryContext repositoryContext5 = null;
                repositoryContextType = this.metadata.getContextType("nodes");
                collection = this.findContext(repositoryContext2, repositoryContextType);
                if (collection == null || collection.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateApplicationConfiguration ", "No node context found in ear file. Nothing to import");
                    }
                } else {
                    repositoryContext5 = (RepositoryContext)collection.iterator().next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node context in ear ", repositoryContext5);
                }
                resource = null;
                RepositoryContext repositoryContext6 = null;
                repositoryContextType = this.metadata.getContextType("servers");
                collection = this.findContext(repositoryContext2, repositoryContextType);
                if (collection == null || collection.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "updateApplicationConfiguration ", "No server context found in ear file. Nothing to import");
                    }
                } else {
                    repositoryContext6 = (RepositoryContext)collection.iterator().next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server context in ear ", repositoryContext6);
                }
                if (repositoryContext6 != null) {
                    try {
                        resource = EnhancedEarConfigurator.getResource(repositoryContext6, "libraries.xml");
                    }
                    catch (Exception exception) {
                        resource = null;
                    }
                }
                Library library = null;
                eList = null;
                if (resource != null) {
                    eList = resource.getContents();
                }
                if (eList != null && eList.size() > 0) {
                    library = (Library)eList.get(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "libraries in ear ", library);
                }
                RepositoryContext repositoryContext7 = null;
                String string = null;
                if (library == null) break block73;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    DeploymentTarget deploymentTarget = (DeploymentTarget)iterator.next();
                    if (deploymentTarget instanceof ServerTarget) {
                        object = ((ServerTarget)deploymentTarget).getNodeName();
                        string = ((ServerTarget)deploymentTarget).getName();
                        Collection collection2 = repositoryContext4.findContext("nodes", (String)object);
                        RepositoryContext repositoryContext8 = (RepositoryContext)collection2.iterator().next();
                        collection2 = repositoryContext8.findContext("servers", string);
                        repositoryContext7 = (RepositoryContext)collection2.iterator().next();
                    } else if (deploymentTarget instanceof ClusteredTarget) {
                        string = ((ClusteredTarget)deploymentTarget).getName();
                        object = repositoryContext4.findContext("clusters", string);
                        repositoryContext7 = (RepositoryContext)object.iterator().next();
                    }
                    try {
                        resource2 = EnhancedEarConfigurator.getResource(repositoryContext7, "libraries.xml");
                    }
                    catch (Exception exception) {
                        resource2 = null;
                    }
                    object = null;
                    eList2 = null;
                    if (resource2 != null) {
                        eList2 = resource2.getContents();
                    }
                    if (eList2 != null && eList2.size() > 0) {
                        object = (Library)eList2.get(0);
                    }
                    if (eList2 != null && eList2.size() > 0) {
                        ConfigArchiveUtils.mergeList((List)eList2, (List)eList, "name", this.overWriteConfig);
                        resource2.save(new HashMap());
                        continue;
                    }
                    ConfigArchiveUtils.copyFile(repositoryContext7, repositoryContext6, string, "libraries.xml");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!tc.isDebugEnabled()) break block73;
                Tr.debug(tc, "updateApplicationConfiguration failed");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateApplicationConfiguration");
        }
    }

    public void exportApplicationConfiguration() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportApplicationConfiguration");
        }
        try {
            RepositoryContext repositoryContext;
            RepositoryContext repositoryContext2;
            RepositoryContext repositoryContext3;
            block41: {
                if (this.expandedEarWorkspace == null) {
                    throw new ConfigArchiveException("Expanded ear file location is not specified for the Enhanced Ear Configurator");
                }
                RepositoryContext repositoryContext4 = this.workspace.getRootContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in workspace", repositoryContext4);
                }
                RepositoryContext repositoryContext5 = null;
                Collection collection = repositoryContext4.findContext("cells", this.cellName);
                if (collection == null || collection.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "exportApplicationConfiguration");
                    }
                    throw new ConfigArchiveException("Cell Context not found");
                }
                repositoryContext5 = (RepositoryContext)collection.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found cell context in workspace", repositoryContext5);
                }
                RepositoryContext repositoryContext6 = null;
                collection = repositoryContext5.findContext("applications", this.binName);
                if (collection == null || collection.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "exportApplicationConfiguration");
                    }
                    throw new ConfigArchiveException("Application Context not found");
                }
                repositoryContext6 = (RepositoryContext)collection.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found application context in workspace", repositoryContext6);
                }
                repositoryContext3 = null;
                collection = repositoryContext6.findContext("deployments", this.appName);
                if (collection == null || collection.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "exportApplicationConfiguration");
                    }
                    throw new ConfigArchiveException("Application Context not found");
                }
                repositoryContext3 = (RepositoryContext)collection.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found deployment context in workspace", repositoryContext3);
                }
                repositoryContext2 = this.expandedEarWorkspace.getRootContext();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found root context in ear", repositoryContext2);
                }
                repositoryContext = ConfigArchiveUtils.createContextIfNeeded(repositoryContext2, "cells", "defaultCell");
                String string = System.getProperty("exportAllApplicationData", "false");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JVM property exportAllApplicationData = ", string);
                }
                if (string.equalsIgnoreCase("false")) {
                    try {
                        if (repositoryContext == null) break block41;
                        repositoryContext.delete(true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cleanup of enhanced ear config information present in META-INF/ibmconfig directory successfully");
                        }
                        if (repositoryContext2 != null) {
                            repositoryContext2.synch(new HashMap());
                        }
                        break block41;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cleanup of enhanced ear config information present in META-INF/ibmconfig directory failed");
                        }
                        break block41;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No cleanup of enhanced ear config information present in META-INF/ibmconfig directory is performed");
                }
            }
            repositoryContext = ConfigArchiveUtils.createContextIfNeeded(repositoryContext2, "cells", "defaultCell");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found cells context in ear", repositoryContext);
            }
            RepositoryContext repositoryContext7 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext, "applications", "defaultApp");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found applications context in ear", repositoryContext7);
            }
            RepositoryContext repositoryContext8 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext7, "deployments", "defaultApp");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found deployments context in ear", repositoryContext8);
            }
            Resource resource = null;
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext3, "deployment.xml");
            }
            catch (Exception exception) {
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext3, this.appName, "deployment.xml");
            }
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext3, "resources.xml");
            }
            catch (Exception exception) {
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext3, this.appName, "resources.xml");
            }
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext3, "variables.xml");
            }
            catch (Exception exception) {
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext3, this.appName, "variables.xml");
            }
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext3, "sca-module-properties.xml");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught an exception while getting sca-module-properties.xml", exception);
                }
                resource = null;
            }
            if (resource != null && resource.getContents().size() > 0) {
                ConfigArchiveUtils.copyFile(repositoryContext8, repositoryContext3, this.appName, "sca-module-properties.xml");
            }
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportApplicationConfiguration failed", throwable.getMessage());
            }
            throw new ConfigArchiveException(throwable, "exportAppplicationConfiguration failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportApplicationConfiguration");
        }
    }

    public Resource getDeploymentResource(String string) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentResource");
        }
        try {
            RepositoryContext repositoryContext = null;
            if (this.earWorkspace != null) {
                repositoryContext = this.earWorkspace.getRootContext();
            } else if (this.expandedEarWorkspace != null) {
                repositoryContext = this.expandedEarWorkspace.getRootContext();
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "EarFile not specified");
                }
                return null;
            }
            RepositoryContextType repositoryContextType = this.metadata.getContextType("cells");
            Collection collection = this.findContext(repositoryContext, repositoryContextType);
            if (collection == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "Cell context not found in ear file");
                }
                return null;
            }
            RepositoryContext repositoryContext2 = (RepositoryContext)collection.iterator().next();
            if ((collection = this.findContext(repositoryContext2, repositoryContextType = this.metadata.getContextType("applications"))) == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "application context not found in ear file");
                }
                return null;
            }
            RepositoryContext repositoryContext3 = (RepositoryContext)collection.iterator().next();
            if ((collection = this.findContext(repositoryContext3, repositoryContextType = this.metadata.getContextType("deployments"))) == null || collection.size() < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getDeploymentResource", "application delployment context not found in ear file");
                }
                return null;
            }
            RepositoryContext repositoryContext4 = (RepositoryContext)collection.iterator().next();
            Resource resource = null;
            try {
                resource = EnhancedEarConfigurator.getResource(repositoryContext4, string);
            }
            catch (Exception exception) {
                resource = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeploymentResource");
            }
            if (resource != null && resource.getContents().size() == 0) {
                return null;
            }
            return resource;
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDeploymentResource failed", throwable.getMessage());
            }
            return null;
        }
    }

    public Resource getDeployment() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeployment");
        }
        Resource resource = this.getDeploymentResource("deployment.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployment");
        }
        return resource;
    }

    public Resource getVariables() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariables");
        }
        Resource resource = this.getDeploymentResource("variables.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariables");
        }
        return resource;
    }

    public Resource getResources() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResources");
        }
        Resource resource = this.getDeploymentResource("resources.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResources");
        }
        return resource;
    }

    public List getDeploymentResources() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentResources");
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>(3);
        Resource resource = this.getResources();
        Resource resource2 = this.getVariables();
        Resource resource3 = this.getDeployment();
        if (resource != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding resources.xml");
            }
            arrayList.add(resource);
        }
        if (resource2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding variables.xml");
            }
            arrayList.add(resource2);
        }
        if (resource3 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding deployment.xml");
            }
            arrayList.add(resource3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentResources");
        }
        return arrayList;
    }

    public boolean isEnhancedEar() {
        try {
            Resource resource = this.getResources();
            if (resource != null && resource.getContents().size() > 0) {
                return true;
            }
            resource = this.getVariables();
            if (resource != null && resource.getContents().size() > 0) {
                return true;
            }
            resource = this.getDeployment();
            if (resource != null && resource.getContents().size() > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnhancedEar(WorkSpace workSpace, EARFile eARFile) {
        EnhancedEarConfigurator enhancedEarConfigurator = null;
        try {
            enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, eARFile, false, "defaultCell", "defaultApp", "defaultApp");
            boolean bl = enhancedEarConfigurator.isEnhancedEar();
            return bl;
        }
        finally {
            if (enhancedEarConfigurator != null) {
                enhancedEarConfigurator.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnhancedEar(WorkSpace workSpace, String string) {
        EnhancedEarConfigurator enhancedEarConfigurator = null;
        try {
            enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, string, "defaultCell", "defaultApp", "defaultApp");
            boolean bl = enhancedEarConfigurator.isEnhancedEar();
            return bl;
        }
        finally {
            if (enhancedEarConfigurator != null) {
                enhancedEarConfigurator.cleanup();
            }
        }
    }

    public static boolean isEnhancedEar(EARFile eARFile) {
        boolean bl = false;
        try {
            EARFileAccessor eARFileAccessor = new EARFileAccessor(eARFile);
            List list = eARFileAccessor.listFolders("cells");
            return list.size() > 0;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static boolean isEnhancedEar(String string) {
        boolean bl = false;
        try {
            DefaultFileAccessor defaultFileAccessor = new DefaultFileAccessor(new File(string));
            List list = defaultFileAccessor.listFolders("cells");
            return list.size() > 0;
        }
        catch (Exception exception) {
            return bl;
        }
    }

    private Collection findContext(RepositoryContext repositoryContext, RepositoryContextType repositoryContextType) {
        ArrayList<RepositoryContext> arrayList;
        block5: {
            arrayList = new ArrayList<RepositoryContext>();
            try {
                Collection collection = repositoryContext.findContext(repositoryContextType);
                if (collection == null || collection.size() == 0) {
                    return arrayList;
                }
                Iterator iterator = collection.iterator();
                block2: while (iterator.hasNext()) {
                    RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                    List list = repositoryContext2.getAllList(true);
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator2.next();
                        if (!workSpaceFile.getFileName().endsWith(".xml")) continue;
                        arrayList.add(repositoryContext2);
                        continue block2;
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Failed to find any context");
            }
        }
        return arrayList;
    }

    public void cleanup() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanup");
            }
            WorkSpace workSpace = null;
            if (this.earWorkspace != null) {
                workSpace = this.earWorkspace;
            } else if (this.expandedEarWorkspace != null) {
                workSpace = this.expandedEarWorkspace;
            }
            if (workSpace != null) {
                try {
                    WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
                    ValidationManagerRegistry validationManagerRegistry = ValidationHelper.getRegistry();
                    validationManagerRegistry.release(workSpace);
                    workSpaceManager.removeWorkSpace(workSpace.getUserName());
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "failed to cleanup config archive workspace");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }

    private static Resource getResource(RepositoryContext repositoryContext, String string) throws Exception {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getResource", new Object[]{repositoryContext, string});
            }
            try {
                WorkspaceHelper.getDocAccessorNoCreate(repositoryContext, string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getDocAccessor failed");
            }
        }
        Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }
}

