/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import com.ibm.wsspi.configarchive.ExportCommand;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ExportCommandBase
extends ExportCommand {
    private static TraceComponent tc = Tr.register(ExportCommandBase.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public ExportCommandBase(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportCommandBase(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    protected ObjectName exportServer(ObjectName objectName) throws Throwable {
        Object object;
        Object object2;
        Object object3;
        ObjectName objectName2;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportServer", objectName);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        WorkSpace workSpace2 = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = properties.getProperty("cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName", string);
        }
        String string2 = properties.getProperty("node");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", string2);
        }
        String string3 = properties.getProperty("server");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName", string3);
        }
        RepositoryContext repositoryContext = workSpace2.getRootContext();
        repositoryContext = ConfigArchiveUtils.createContextIfNeeded(repositoryContext, "cells", string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell context in archive", repositoryContext);
        }
        repositoryContext = ConfigArchiveUtils.createContextIfNeeded(repositoryContext, "nodes", string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node context in archive", repositoryContext);
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace2);
        RepositoryContext repositoryContext2 = (RepositoryContext)workSpace.getRootContext().findContext("nodes", string2).iterator().next();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node context", repositoryContext2);
        }
        templateManager.createFile(repositoryContext, "node-metadata.properties", templateManager.getTemplate(repositoryContext2), null);
        if (!repositoryContext.isAvailable("serverindex.xml")) {
            serializable = MOFUtil.createObjectName(repositoryContext2);
            objectName2 = configService.getRelationship(session, (ObjectName)serializable, "ServerIndex")[0];
            object3 = configService.getAttributes(session, objectName2, new String[]{"hostName"}, false);
            object2 = MOFUtil.createObjectName(repositoryContext);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeInArchiveId", object2);
            }
            object = this.getConfigArchiveSession();
            objectName2 = configService.createConfigData((Session)object, (ObjectName)object2, "ServerIndex", "ServerIndex", (AttributeList)object3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverindex in archive", objectName2);
            }
        }
        serializable = new ConfigDataId(repositoryContext.getURI(), null);
        objectName2 = WorkspaceHelper.createObjectName((ConfigDataId)serializable, "Node", string2, this.getConfigArchiveSession());
        object3 = ConfigArchiveUtils.getCreateTemplateCommand(configService, session, objectName);
        object3.setParameter("nodeName", string2);
        object3.setParameter("serverName", string3);
        object3.setParameter("templateName", string3);
        object3.setParameter("templateLocation", objectName2);
        if (object3 instanceof AbstractTaskCommand && object3.getCommandMetadata().getName().equals("createApplicationServerTemplate")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the command name is createApplicationServerTemplate");
            }
            object2 = (AbstractTaskCommand)object3;
            object = ((AbstractTaskCommand)object2).getCommandStep("DeleteSIBEngines");
            object.setParameter("archiveConfigSession", this.getConfigArchiveSession());
        }
        object3.execute();
        object = object3.getCommandResult();
        if (!object.isSuccessful()) {
            throw object.getException();
        }
        object2 = (ObjectName)object.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportServer", object2);
        }
        return object2;
    }

    protected ObjectName exportCluster(ObjectName objectName) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportCluster", objectName);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        WorkSpace workSpace2 = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = properties.getProperty("cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellName", string);
        }
        String string2 = properties.getProperty("cluster");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusterName", string2);
        }
        RepositoryContext repositoryContext = workSpace2.getRootContext();
        repositoryContext = ConfigArchiveUtils.createContextIfNeeded(repositoryContext, "cells", string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell context in archive", repositoryContext);
        }
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
        RepositoryContext repositoryContext2 = workSpace.getRootContext().getChild(repositoryContextType, string);
        repositoryContextType = repositoryMetaData.getContextType("clusters");
        repositoryContext2 = repositoryContext2.getChild(repositoryContextType, string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cluster context", repositoryContext2);
        }
        RepositoryContext repositoryContext3 = ConfigArchiveUtils.copyContext(repositoryContext, repositoryContext2, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cluster context in archive", repositoryContext);
        }
        this.exportDmgrNodeProperties();
        ConfigDataId configDataId = new ConfigDataId(repositoryContext3.getURI(), repositoryContext3.getType().getRootDocumentType().getFilePattern());
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(configDataId, "ServerCluster", string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusterin archive", objectName2);
        }
        List list = this.getClusterMembers(objectName);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName3 = (ObjectName)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "member", objectName3);
            }
            ObjectName objectName4 = this.exportServer(objectName3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberInArchive", objectName4);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attributeList, "clusterName", string2);
            configService.setAttributes(this.getConfigArchiveSession(), objectName4, attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportCluster");
        }
        return objectName2;
    }

    protected List getClusterMembers(ObjectName objectName) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterMembers", objectName);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        List list = (List)configService.getAttribute(session, objectName, "members");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeList attributeList = (AttributeList)iterator.next();
            String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "memberName", string);
            }
            String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", string2);
            }
            ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string2 + ":Server=" + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "match", objectNameArray);
            }
            arrayList.addAll(Arrays.asList(objectNameArray));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterMembers", arrayList);
        }
        return arrayList;
    }

    protected void exportDmgrNodeProperties() throws Throwable {
    }
}

