/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ExportCommandBase;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.util.HashSet;
import javax.management.ObjectName;

public class ExportServer
extends ExportCommandBase {
    private static TraceComponent tc = Tr.register(ExportServer.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private ObjectName server;

    public ExportServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportServer(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        String string = (String)this.getParameter("nodeName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName", string);
        }
        String string2 = (String)this.getParameter("serverName");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName", string2);
        }
        try {
            ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=" + string2);
            if (objectNameArray.length != 1) {
                String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0005E", new Object[]{string, string2}, null);
                throw new CommandValidationException(string3);
            }
            this.server = objectNameArray[0];
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ExportServer.validate", "62");
            throw new CommandValidationException(throwable, "validation for command ExportServer failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            this.exportServer(this.server);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ExportServer.beforeStepsExecuted", "159");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "exportServer command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", string);
        }
        Object[] objectArray = null;
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            if (string.equals("serverName")) {
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server");
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
                objectArray = new String[objectNameArray.length];
                for (int i = 0; i < objectNameArray.length; ++i) {
                    objectArray[i] = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                }
            } else if (string.equals("nodeName")) {
                HashSet<String> hashSet = new HashSet<String>();
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server", (String)this.getParameter("serverName"));
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    String string2 = ConfigServiceHelper.getObjectLocation(objectNameArray[i]).getProperty("node");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "nodeName", string2);
                    }
                    hashSet.add(string2);
                }
                objectArray = hashSet.toArray();
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ExportServer.getChoices", "111");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices");
        }
        return objectArray;
    }

    public void setConfigSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigSession", session);
        }
        super.setConfigSession(session);
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            if (objectNameArray.length == 1) {
                this.setParameter("nodeName", ConfigServiceHelper.getDisplayName(objectNameArray[0]));
                objectName = ConfigServiceHelper.createObjectName(null, "Server");
                objectNameArray = configService.queryConfigObjects(session, objectNameArray[0], objectName, null);
                if (objectNameArray.length == 1) {
                    this.setParameter("severName", ConfigServiceHelper.getDisplayName(objectNameArray[0]));
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ExportServer.setConfigSession", "135");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigSession");
        }
    }

    public void setParameter(String string, Object object) throws InvalidParameterValueException, InvalidParameterNameException {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setParameter", new Object[]{string, object});
            }
            super.setParameter(string, object);
            if (string.equals("serverName") && this.getParameter("nodeName") == null) {
                try {
                    ConfigService configService = ConfigServiceFactory.getConfigService();
                    ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server", (String)object);
                    ObjectName[] objectNameArray = configService.queryConfigObjects(this.getConfigSession(), null, objectName, null);
                    if (objectNameArray.length == 1) {
                        String string2 = ConfigServiceHelper.getObjectLocation(objectNameArray[0]).getProperty("node");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeName", string2);
                        }
                        this.setParameter("nodeName", string2);
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "unexpected exception", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }
}

