/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configarchive.ExportCommandBase;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ExportWsprofile
extends ExportCommandBase {
    private static TraceComponent tc = Tr.register(ExportWsprofile.class, "configarchive", "com.ibm.ws.management.resources.configarchive");

    public ExportWsprofile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportWsprofile(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            if (objectNameArray.length != 1) {
                String string = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0001E");
                throw new CommandValidationException(string);
            }
            objectName = ConfigServiceHelper.createObjectName(null, "Server");
            objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ExportCell.validate", "79");
            throw new CommandValidationException(throwable, "An unexpected exception is thrown.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("cells");
            Collection collection = workSpace.findContext(repositoryContextType);
            RepositoryContext repositoryContext = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell", repositoryContext);
            }
            WorkSpace workSpace2 = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            ConfigArchiveUtils.copyContext(workSpace2.getRootContext(), repositoryContext, null);
            this.removeSIBresources(workSpace2.getRootContext());
            try {
                this.addRars(workSpace2.getRootContext(), repositoryContext.getName());
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "export of rars failed");
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ExportCell.beforeStepsExecuted", "99");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "exportCell command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void removeSIBresources(RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSIBresources");
        }
        RepositoryContext repositoryContext2 = null;
        RepositoryContext repositoryContext3 = null;
        RepositoryContext repositoryContext4 = null;
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType("buses");
        if (repositoryContextType == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no busesCtx found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeSIBresources");
            }
            return;
        }
        Collection collection = repositoryContext.findContext(repositoryContextType);
        if (collection != null && collection.size() > 0) {
            repositoryContext2 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing busesCtx ", repositoryContext2);
            }
            repositoryContext2.delete(true);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no busesCtx found");
        }
        RepositoryContextType repositoryContextType2 = repositoryMetaData.getContextType("nodes");
        collection = repositoryContext.findContext(repositoryContextType2);
        if (collection != null && collection.size() > 0) {
            repositoryContext3 = (RepositoryContext)collection.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeCtx ", repositoryContext3);
        }
        if (repositoryContext3 == null) {
            return;
        }
        RepositoryContextType repositoryContextType3 = repositoryMetaData.getContextType("servers");
        collection = repositoryContext3.findContext(repositoryContextType3);
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                repositoryContext4 = (RepositoryContext)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing sib-engine.xml from serverCtx ", repositoryContext4);
                }
                if (repositoryContext4 != null) {
                    repositoryContext4.delete("sib-engines.xml");
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "removeSIBresources");
            }
        }
    }

    private void addRars(RepositoryContext repositoryContext, String string) throws Exception {
        RepositoryContextType repositoryContextType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRars", repositoryContext);
        }
        RepositoryContext repositoryContext2 = null;
        RepositoryContext repositoryContext3 = null;
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType repositoryContextType2 = repositoryMetaData.getContextType("cells");
        Collection collection = repositoryContext.findContext(repositoryContextType2);
        RepositoryContext repositoryContext4 = (RepositoryContext)collection.iterator().next();
        if ((collection = repositoryContext4.findContext(repositoryContextType = repositoryMetaData.getContextType("nodes"))) != null && collection.size() > 0) {
            repositoryContext2 = (RepositoryContext)collection.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeCtx ", repositoryContext2);
        }
        if (repositoryContext2 == null) {
            return;
        }
        RepositoryContextType repositoryContextType3 = repositoryMetaData.getContextType("servers");
        collection = repositoryContext2.findContext(repositoryContextType3);
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                repositoryContext3 = (RepositoryContext)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverCtx ", repositoryContext3);
                }
                VariableMap variableMap = this.createVariableMap(repositoryContext, string, repositoryContext2.getName(), repositoryContext3.getName());
                Resource resource = ConfigArchiveUtils.getResource(repositoryContext2, "resources.xml");
                if (resource != null) {
                    this.saveRarInArchive(resource, repositoryContext2, variableMap);
                }
                if ((resource = ConfigArchiveUtils.getResource(repositoryContext3, "resources.xml")) == null) continue;
                this.saveRarInArchive(resource, repositoryContext3, variableMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRars");
        }
    }

    private VariableMap createVariableMap(RepositoryContext repositoryContext, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVariableMap", new Object[]{repositoryContext, string, string2, string3});
        }
        BeanContextServicesSupport beanContextServicesSupport = new BeanContextServicesSupport();
        String string4 = repositoryContext.getPath();
        Repository repository2 = RepositoryFactory.createRepository("ws-server", string4, string, string2, string3);
        beanContextServicesSupport.addService(Repository.class, (BeanContextServiceProvider)((Object)repository2));
        VariableMap variableMap = VariableMapFactory.createVariableMap();
        beanContextServicesSupport.add(variableMap);
        try {
            variableMap.initialize(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + variableMap);
        }
        return variableMap;
    }

    private void saveRarInArchive(Resource resource, RepositoryContext repositoryContext, VariableMap variableMap) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveRarInArchive", repositoryContext);
        }
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            WorkSpaceFile workSpaceFile;
            Object e2 = eList.get(i);
            if (!(e2 instanceof J2CResourceAdapter)) continue;
            J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)e2;
            String string = j2CResourceAdapter.getArchivePath();
            String string2 = j2CResourceAdapter.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resName ", string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archiveLocation ", string);
            }
            if ((workSpaceFile = repositoryContext.getFile("resources.xml")) == null) continue;
            String string3 = workSpaceFile.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource uri ", string3);
            }
            string3 = string3.substring(0, string3.indexOf("/resources.xml"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node uri ", string3);
            }
            String string4 = repositoryContext.getWorkSpace().getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archive workspace path ", string4);
            }
            string4 = string4 + File.separator + string3 + File.separator + "rars" + File.separator + string2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rar path ", string4);
            }
            string = variableMap.expand(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded src rar path ", string);
            }
            ConfigArchiveUtils.mkdirs(string4);
            ConfigArchiveUtils.copyRar(string, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveRarInArchive");
        }
    }
}

