/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.metadata.ManagedObjectMetadataUtilities;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportCommand;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ImportNode
extends ImportCommand {
    private static TraceComponent tc = Tr.register(ImportNode.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.nodeutils", Locale.getDefault());
    private String nodeName = null;
    private String nodeShortName = null;
    private Map serversShortName = null;
    private String nodeGroupName = null;
    private String readLicenseAgreement = null;
    private ManagedObjectMetadataHelper archiveMetadataHelper = null;
    private ManagedObjectMetadataHelper metadataHelper = null;
    private RepositoryContext nodeInArchiveCxt = null;
    private RepositoryContext cellInArchiveCxt = null;

    public ImportNode(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportNode(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ObjectName objectName;
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            this.nodeName = (String)this.getParameter("nodeName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName", this.nodeName);
            }
            Collection collection = this.nodeName == null ? workSpace.getRootContext().findContext(repositoryMetaData.getContextType("nodes")) : workSpace.getRootContext().findContext("nodes", this.nodeName);
            this.nodeInArchiveCxt = (RepositoryContext)collection.iterator().next();
            if (this.nodeName == null) {
                this.nodeName = this.nodeInArchiveCxt.getName();
                this.setParameter("nodeName", this.nodeName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set new nodeName", this.nodeName);
                }
            }
            Collection collection2 = workSpace.getRootContext().findContext(repositoryMetaData.getContextType("cells"));
            this.cellInArchiveCxt = (RepositoryContext)collection2.iterator().next();
            Session session = this.getConfigSession();
            this.metadataHelper = WorkspaceHelper.getWorkspace(session).getMetadataHelper();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName = ConfigServiceHelper.createObjectName(null, "Cell"), null);
            if (objectNameArray.length != 1) {
                throw new CommandValidationException("There should only one Cell config object defined");
            }
            ObjectName objectName2 = objectNameArray[0];
            objectName = ConfigServiceHelper.createObjectName(null, "Node", this.nodeName);
            if ((objectNameArray = configService.queryConfigObjects(session, objectNameArray[0], objectName, null)).length != 0) {
                throw new CommandValidationException("The specified node " + this.nodeName + " exists in the cell already");
            }
            this.archiveMetadataHelper = this.getConfigArchiveMetadataHelper();
            if (this.archiveMetadataHelper != null && this.archiveMetadataHelper.isNodeZOS(this.nodeName)) {
                this.nodeShortName = this.getNodeShortName(this.nodeInArchiveCxt);
                this.serversShortName = this.getServersShortName(collection);
                this.validateNodeShortName(session, configService, objectName2);
                this.validateServersShortName(session, configService, objectName2);
                Collection collection3 = workSpace.getRootContext().findContext(repositoryMetaData.getContextType("servers"));
                this.deleteExclusionList(session, configService, objectName2, collection3);
                this.readLicenseAgreement(this.cellInArchiveCxt);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ImportNode.validate", "63");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to load archive", throwable);
            }
            InvalidParameterValueException invalidParameterValueException = new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            invalidParameterValueException.initCause(throwable);
            throw invalidParameterValueException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            WorkSpace workSpace;
            RepositoryContext repositoryContext;
            RepositoryMetaData repositoryMetaData;
            Session session;
            block10: {
                session = this.getConfigSession();
                WorkSpace workSpace2 = WorkspaceHelper.getWorkspace(session);
                repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
                Collection collection = workSpace2.getRootContext().findContext(repositoryMetaData.getContextType("cells"));
                repositoryContext = (RepositoryContext)collection.iterator().next();
                ConfigArchiveUtils.copyContext(repositoryContext, this.nodeInArchiveCxt, this.nodeName);
                workSpace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
                String string = "com.ibm.ws.management.application.AppUtils";
                try {
                    object3 = Class.forName(string);
                    object2 = ((Class)object3).getMethod("merge", WorkSpace.class, WorkSpace.class);
                    ((Method)object2).invoke(null, workSpace, workSpace2);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception " + exception + " thrown - should not happen");
                }
            }
            object3 = workSpace.getRootContext().findContext(repositoryMetaData.getContextType("applications"));
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContext)object2.next();
                ConfigArchiveUtils.copyOrCreateContext(repositoryContext, (RepositoryContext)object, object.getName());
            }
            this.addNodeGroupMember();
            if (this.archiveMetadataHelper != null && this.archiveMetadataHelper.isNodeZOS(this.nodeName)) {
                object2 = ConfigServiceFactory.getConfigService();
                object = ConfigServiceHelper.createObjectName(null, "Cell");
                ObjectName objectName = object2.queryConfigObjects(session, null, (ObjectName)object, null)[0];
                this.updateZOSConfigDocuments(session, (ConfigService)object2, objectName);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ImportNode.beforeStepsExecuted", "175");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "importNode command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private void addNodeGroupMember() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNodeGroupMember()");
        }
        Object var1_1 = null;
        Session session = this.getConfigSession();
        AdminCommand adminCommand = CommandMgr.getCommandMgr().createCommand("addNodeGroupMember");
        adminCommand.setConfigSession(session);
        this.nodeGroupName = (String)this.getParameter("nodeGroupName");
        if (this.nodeGroupName == null) {
            this.nodeGroupName = "DefaultNodeGroup";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeGroupName", this.nodeGroupName);
        }
        adminCommand.setTargetObject(this.nodeGroupName);
        adminCommand.setParameter("nodeName", this.nodeName);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        Collection collection = commandResult.getMessages();
        if (!commandResult.isSuccessful()) {
            throw commandResult.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNodeGroupMember()");
        }
    }

    private void updateZOSConfigDocuments(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateZOSConfigDocuments()");
        }
        String string = null;
        ObjectName objectName2 = configService.resolve(session, "Node=" + this.nodeName)[0];
        if (!this.isZOSCell()) {
            string = this.getCellShortName(session, configService, objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current cell short name", string);
            }
            if (string == null || string.trim().equals("")) {
                string = this.getCellContextShortName(this.cellInArchiveCxt);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell short name from archive", string);
                }
                this.updateCellShortName(session, configService, objectName, string);
            }
            this.updateReadLicenseAgreement(session, configService, objectName);
        } else {
            string = this.getCellShortName(session, configService, objectName);
        }
        this.updateNodeVariablesDoc(session, configService, objectName2);
        this.updateServersStartCommandArgs(session, configService, objectName2, string);
        this.updateNodeAgentConfig(session, configService, objectName, objectName2, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateZOSConfigDocuments()");
        }
    }

    private String getNodeAgentShortName(Session session, ConfigService configService, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeAgentShortName()", string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName2 = configService.getRelationship(session, objectNameArray[i], "ServerIndex")[0];
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName2, objectName3, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                String string2 = (String)configService.getAttribute(session, objectNameArray2[j], "serverType");
                if (string2 == null || string2.length() <= 0 || !string2.equals("NODE_AGENT")) continue;
                String string3 = (String)configService.getAttribute(session, objectNameArray[i], "name");
                String string4 = null;
                if (this.metadataHelper.compareNodeVersion(string3, "6") >= 0) {
                    string4 = (String)configService.getAttribute(session, objectNameArray2[j], "serverShortName");
                } else {
                    Tr.debug(tc, "getNodeAgentShortName()", "There is no serverShortName defined for a V5 node: " + string3);
                }
                if (string4 == null) continue;
                hashSet.add(string4);
            }
        }
        if (string != null) {
            if (hashSet.contains(string)) {
                throw new AdminException(this.getFormattedMessage("ADMU0183E", new Object[]{string}, null));
            }
            return string;
        }
        string = this.nextName(hashSet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAgentShortName()", string);
        }
        return string;
    }

    private void validateNodeShortName(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateNodeShortName()", this.nodeShortName);
        }
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string;
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
            boolean bl = this.isManagedNode(session, configService, objectNameArray[i]);
            if (!this.metadataHelper.isNodeZOS(string2) || !bl || (string = (String)configService.getAttribute(session, objectNameArray[i], "shortName")) == null || !string.equalsIgnoreCase(this.nodeShortName)) continue;
            throw new AdminException(this.getFormattedMessage("ADMU0182E", new Object[]{this.nodeShortName}, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateNodeShortName()");
        }
    }

    private void validateServersShortName(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateServersShortName()", this.serversShortName);
        }
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "name");
            if (!this.metadataHelper.isNodeZOS(string)) continue;
            ObjectName objectName2 = configService.getRelationship(session, objectNameArray[i], "ServerIndex")[0];
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName2, objectName3, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                String string2 = (String)configService.getAttribute(session, objectNameArray2[j], "serverType");
                if (string2 == null || !string2.equals("APPLICATION_SERVER")) continue;
                String string3 = ((String)configService.getAttribute(session, objectNameArray2[j], "serverShortName")).trim();
                String string4 = ((String)configService.getAttribute(session, objectNameArray2[j], "genericShortName")).trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_serverShortName,_genericShortName", new Object[]{string3, string4});
                }
                Iterator iterator = this.serversShortName.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string5 = ((String)entry.getKey()).trim();
                    String string6 = ((String)entry.getValue()).trim();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverShortName,genericShortName", new Object[]{string5, string6});
                    }
                    if (string3 != null && string5.equalsIgnoreCase(string3)) {
                        throw new AdminException(this.getFormattedMessage("ADMU0180E", new Object[]{string5, ConfigServiceHelper.getDisplayName(objectNameArray[i])}, null));
                    }
                    if (string4 == null || !string6.equalsIgnoreCase(string4)) continue;
                    throw new AdminException(this.getFormattedMessage("ADMU0181E", new Object[]{string6, ConfigServiceHelper.getDisplayName(objectNameArray[i])}, null));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateServersShortName()");
        }
    }

    private String nextName(Set set) {
        String string = "BBON";
        int n = 1;
        String string2 = "";
        if (set != null) {
            for (int i = 0; i < set.size() + 2; ++i) {
                String string3 = String.valueOf(n);
                while (string3.length() < 3) {
                    string3 = "0" + string3;
                }
                string2 = string + string3;
                if (set.contains(string2)) {
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            string2 = string + "001";
        }
        return string2;
    }

    private void updateNodeAgentConfig(Session session, ConfigService configService, ObjectName objectName, ObjectName objectName2, String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNodeAgentConfig", new Object[]{objectName, objectName2, string});
        }
        String string2 = "ClusterTransitionName";
        String string3 = null;
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName2, "Server");
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, "AdminService");
        String string4 = null;
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string5;
            Object object5;
            Object object6;
            Object object7;
            object4 = (String)configService.getAttribute(session, objectNameArray[i], "name");
            if (!((String)object4).equalsIgnoreCase("nodeagent")) continue;
            object3 = (String)configService.getAttribute(session, objectNameArray[i], "shortName");
            string3 = this.getNodeAgentShortName(session, configService, objectName, (String)object3);
            string4 = (String)configService.getAttribute(session, objectNameArray[i], "uniqueId");
            ConfigServiceHelper.setAttributeValue(attributeList, "shortName", string3);
            configService.setAttributes(session, objectNameArray[i], attributeList);
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                object2 = (String)configService.getAttribute(session, objectNameArray2[j], "processType");
                if (!((String)object2).equalsIgnoreCase("Control")) continue;
                object7 = this.getSymbolicName(session, configService, objectName2, "WAS_DEFAULT_CONTROL_PROC_NAME");
                object6 = "START " + (String)object7;
                object5 = "JOBNAME=" + string3 + ",ENV=" + string + "." + this.nodeShortName + "." + string3;
                string5 = "STOP " + string3 + ";CANCEL " + string3;
                String string6 = "FORCE " + string3;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object5);
                AttributeList attributeList2 = new AttributeList();
                attributeList2.add(new Attribute("startCommandArgs", arrayList));
                configService.setAttributes(session, objectNameArray2[j], attributeList2);
                attributeList2.clear();
                attributeList2.add(new Attribute("startCommand", object6));
                attributeList2.add(new Attribute("stopCommand", string5));
                attributeList2.add(new Attribute("terminateCommand", string6));
                configService.setAttributes(session, objectNameArray2[j], attributeList2);
                attributeList2.clear();
            }
            attributeList.clear();
            object = configService.queryConfigObjects(session, objectNameArray[i], objectName4, null)[0];
            object2 = configService.getAttributes(session, (ObjectName)object, new String[]{"properties"}, false);
            object7 = (List)((Attribute)((ArrayList)object2).get(0)).getValue();
            object6 = object7.iterator();
            while (object6.hasNext()) {
                object5 = (ObjectName)object6.next();
                string5 = (String)configService.getAttribute(session, (ObjectName)object5, "name");
                if (!string5.equalsIgnoreCase(string2)) continue;
                ConfigServiceHelper.setAttributeValue(attributeList, "value", string3);
                configService.setAttributes(session, (ObjectName)object5, attributeList);
            }
        }
        ObjectName objectName5 = configService.getRelationship(session, objectName2, "ServerIndex")[0];
        object4 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        object3 = configService.queryConfigObjects(session, objectName5, (ObjectName)object4, null);
        for (int i = 0; i < ((ObjectName[])object3).length; ++i) {
            object = (String)configService.getAttribute(session, object3[i], "serverType");
            if (!((String)object).equals("NODE_AGENT")) continue;
            object2 = new AttributeList();
            ((AttributeList)object2).add(new Attribute("serverShortName", string3));
            ((AttributeList)object2).add(new Attribute("genericShortName", string3));
            ((AttributeList)object2).add(new Attribute("serverUniqueId", string4));
            configService.setAttributes(session, object3[i], (AttributeList)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNodeAgentConfig");
        }
    }

    private void updateServersStartCommandArgs(Session session, ConfigService configService, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServersStartCommandArgs", new Object[]{objectName, string});
        }
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "Server");
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "JavaProcessDef");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "shortName");
            if (string2.equalsIgnoreCase("nodeagent")) continue;
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName2, null);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                AttributeList attributeList;
                ArrayList<String> arrayList;
                String string4;
                String string5;
                String string6;
                Map<String, String> map;
                String string7;
                List list;
                AttributeList attributeList2;
                String string8 = (String)configService.getAttribute(session, objectNameArray2[j], "processType");
                if (string8.equalsIgnoreCase("Control")) {
                    attributeList2 = configService.getAttributes(session, objectNameArray2[j], new String[]{"startCommandArgs"}, false);
                    list = null;
                    if (attributeList2 != null && attributeList2.size() > 0) {
                        list = (List)((Attribute)attributeList2.get(0)).getValue();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command arg list=" + list);
                    }
                    string7 = null;
                    map = new HashMap();
                    if (list != null && list.size() > 0) {
                        string7 = (String)list.get(0);
                        map = this.parseStartCommandArgs(string7);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command args=" + string7);
                    }
                    string6 = string3;
                    string5 = string + "." + this.nodeShortName + "." + string3;
                    map.put("JOBNAME", string6);
                    map.put("ENV", string5);
                    map.put("REUSASID", "YES");
                    string4 = this.generateStartCommandArgs(map);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new start command args=" + string4);
                    }
                    arrayList = new ArrayList<String>();
                    arrayList.add(string4);
                    attributeList = new AttributeList();
                    attributeList.add(new Attribute("startCommandArgs", arrayList));
                    configService.setAttributes(session, objectNameArray2[j], attributeList);
                    continue;
                }
                if (string8.equalsIgnoreCase("Servant")) {
                    attributeList2 = configService.getAttributes(session, objectNameArray2[j], new String[]{"startCommandArgs"}, false);
                    list = null;
                    if (attributeList2 != null && attributeList2.size() > 0) {
                        list = (List)((Attribute)attributeList2.get(0)).getValue();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command arg list=" + list);
                    }
                    string7 = null;
                    map = new HashMap();
                    if (list != null && list.size() > 0) {
                        string7 = (String)list.get(0);
                        map = this.parseStartCommandArgs(string7);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "original start command args=" + string7);
                    }
                    string6 = "&IWMSSNM.S";
                    string5 = "'" + string + "." + this.nodeShortName + "." + "&IWMSSNM." + "'";
                    map.put("JOBNAME", string6);
                    map.put("ENV", string5);
                    string4 = this.generateStartCommandArgs(map);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new start command args=" + string4);
                    }
                    arrayList = new ArrayList();
                    arrayList.add(string4);
                    attributeList = new AttributeList();
                    attributeList.add(new Attribute("startCommandArgs", arrayList));
                    configService.setAttributes(session, objectNameArray2[j], attributeList);
                    continue;
                }
                if (!string8.equalsIgnoreCase("Adjunct")) continue;
                attributeList2 = configService.getAttributes(session, objectNameArray2[j], new String[]{"startCommandArgs"}, false);
                list = null;
                if (attributeList2 != null && attributeList2.size() > 0) {
                    list = (List)((Attribute)attributeList2.get(0)).getValue();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "original start command arg list=" + list);
                }
                string7 = null;
                map = new HashMap();
                if (list != null && list.size() > 0) {
                    string7 = (String)list.get(0);
                    map = this.parseStartCommandArgs(string7);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "original start command args=" + string7);
                }
                string6 = "&IWMSSNM.A";
                string5 = "'" + string + "." + this.nodeShortName + "." + "&IWMSSNM." + "'";
                map.put("JOBNAME", string6);
                map.put("ENV", string5);
                string4 = this.generateStartCommandArgs(map);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new start command args=" + string4);
                }
                arrayList = new ArrayList();
                arrayList.add(string4);
                attributeList = new AttributeList();
                attributeList.add(new Attribute("startCommandArgs", arrayList));
                configService.setAttributes(session, objectNameArray2[j], attributeList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServersStartCommandArgs");
        }
    }

    private Map getServersShortName(Collection collection) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersShortName()", collection);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        WorkSpaceFile workSpaceFile = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            workSpaceFile = repositoryContext.getFile("serverindex.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)"serverindex.xml"));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                String string = serverEntry.getServerType();
                if (!string.equals("APPLICATION_SERVER")) continue;
                String string2 = serverEntry.getServerShortName();
                String string3 = serverEntry.getGenericShortName();
                hashMap.put(string2, string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersShortName()", hashMap);
        }
        return hashMap;
    }

    private String getNodeShortName(RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeShortName");
        }
        Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)"node.xml"));
        resource.load(new HashMap());
        Node node = (Node)resource.getContents().get(0);
        String string = node.getShortName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeShortName", string);
        }
        return string;
    }

    private void updateNodeVariablesDoc(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNodeVariablesDoc()");
        }
        String string = this.getSymbolicName(session, configService, objectName, "WAS_DAEMON_ONLY_server_configured_system_name");
        this.setSymbolicName(session, configService, objectName, "WAS_DAEMON_daemonInstanceName", string);
        this.setSymbolicName(session, configService, objectName, "WAS_DAEMON_ONLY_server_specific_short_name", string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNodeVariablesDoc()");
        }
    }

    private void setSymbolicName(Session session, ConfigService configService, ObjectName objectName, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSymbolicName()");
        }
        ObjectName objectName2 = configService.getRelationship(session, objectName, "VariableMap")[0];
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "symbolicName");
            if (string3 == null || string3.length() <= 0 || !string3.equals(string)) continue;
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute("value", string2));
            configService.setAttributes(session, objectNameArray[i], attributeList);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSymbolicName()");
        }
    }

    private String getSymbolicName(Session session, ConfigService configService, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSymbolicName()", string);
        }
        String string2 = null;
        ObjectName objectName2 = configService.getRelationship(session, objectName, "VariableMap")[0];
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "symbolicName");
            if (string3 == null || string3.length() <= 0 || !string3.equals(string)) continue;
            string2 = (String)configService.getAttribute(session, objectNameArray[i], "value");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSymbolicName()", string2);
        }
        return string2;
    }

    private String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = RESOURCE_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    private String getNodeGroupShortName(Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeGroupShortName");
        }
        String string = null;
        ObjectName objectName = configService.resolve(session, "NodeGroup=" + this.nodeGroupName)[0];
        string = (String)configService.getAttribute(session, objectName, "shortName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeGroupShortName", string);
        }
        return string;
    }

    private void updateReadLicenseAgreement(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateReadLicenseAgreement()");
        }
        if ((string = this.getSymbolicName(session, configService, objectName, "was.WAS_DAEMON_read_license_agreement")) != null && string.length() > 0) {
            this.setSymbolicName(session, configService, objectName, "was.WAS_DAEMON_read_license_agreement", this.readLicenseAgreement);
        } else {
            AttributeList attributeList = new AttributeList();
            ObjectName objectName2 = configService.getRelationship(session, objectName, "VariableMap")[0];
            attributeList.add(new Attribute("symbolicName", "was.WAS_DAEMON_read_license_agreement"));
            attributeList.add(new Attribute("value", this.readLicenseAgreement));
            configService.createConfigData(session, objectName2, "entries", null, attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateReadLicenseAgreement()");
        }
    }

    private void deleteExclusionList(Session session, ConfigService configService, ObjectName objectName, Collection collection) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteExclusionList()", collection);
        }
        if (!this.isZOSCell()) {
            String[] stringArray = new String[]{"was.env", "trace.dat", "control.jvm.options", "servant.jvm.options", "adjunct.jvm.options"};
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
                for (int i = 0; i < stringArray.length; ++i) {
                    repositoryContext.delete(stringArray[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteExclusionList()");
        }
    }

    private boolean isZOSCell(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isZOSCell()", objectName);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String[] stringArray = this.getAllNodes(session, configService, objectName);
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.metadataHelper.isNodeZOS(stringArray[i])) {
                bl2 = true;
                continue;
            }
            if (this.metadataHelper.isNodeZOS(stringArray[i])) continue;
            bl3 = true;
        }
        if (bl2 && !bl3) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isZOSCell()", new Boolean(bl));
        }
        return bl;
    }

    private String[] getAllNodes(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllNodes", objectName);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "Node");
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "name");
            arrayList.add(string);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllNodes", stringArray);
        }
        return stringArray;
    }

    private void readLicenseAgreement(RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readLicenseAgreement()");
        }
        Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)"variables.xml"));
        resource.load(new HashMap());
        EList eList = resource.getContents();
        VariableMap variableMap = (VariableMap)eList.get(0);
        EList eList2 = variableMap.getEntries();
        this.readLicenseAgreement = this.getEntryValue((List)eList2, "WAS_DAEMON_read_license_agreement");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReadLicenseAgreement()", this.readLicenseAgreement);
        }
    }

    private String getEntryValue(List list, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEntryValue()", string);
        }
        String string2 = null;
        for (int i = 0; i < list.size(); ++i) {
            VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)list.get(i);
            String string3 = variableSubstitutionEntry.getSymbolicName();
            if (!string.equalsIgnoreCase(string3)) continue;
            return variableSubstitutionEntry.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntryValue()", string2);
        }
        return string2;
    }

    private String getCellShortName(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellShortName()");
        }
        String string = (String)configService.getAttribute(session, objectName, "shortName");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellShortNames()", string);
        }
        return string;
    }

    private String getCellContextShortName(RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellContextShortName");
        }
        Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)"cell.xml"));
        resource.load(new HashMap());
        Cell cell = (Cell)resource.getContents().get(0);
        String string = cell.getShortName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellContextShortName", string);
        }
        return string;
    }

    private void updateCellShortName(Session session, ConfigService configService, ObjectName objectName, String string) throws Exception {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellShortName");
        }
        if ((string2 = this.getCellShortName(session, configService, objectName)) == null || string2.length() <= 0) {
            AttributeList attributeList = new AttributeList();
            attributeList.add(new Attribute("shortName", string));
            configService.setAttributes(session, objectName, attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCellShortName");
        }
    }

    private boolean isManagedNode(Session session, ConfigService configService, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedNode", objectName);
        }
        boolean bl = false;
        ObjectName objectName2 = configService.getRelationship(session, objectName, "ServerIndex")[0];
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "serverType");
            if (string == null || string.length() <= 0) continue;
            if (string.equals("NODE_AGENT")) {
                bl = true;
                break;
            }
            if (!string.equals("DEPLOYMENT_MANAGER")) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedNode", new Boolean(bl));
        }
        return bl;
    }

    private boolean isZOSCell() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isZOSCell");
        }
        String string = "os390";
        boolean bl = false;
        String string2 = System.getProperty("os.name");
        if (string2 != null) {
            string2 = ManagedObjectMetadataUtilities.normalizeOSName(string2);
        }
        if (string2.equals(string)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isZOSCell", new Boolean(bl));
        }
        return bl;
    }

    private Map parseStartCommandArgs(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseStartCommandArgs", string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token", string2);
            }
            int n = string2.indexOf(61);
            String string3 = null;
            String string4 = null;
            if (n > 0) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Value", string4);
                }
                hashMap.put(string3, string4);
                continue;
            }
            hashMap.put(string3, "");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Map", hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseStartCommandArgs", string);
        }
        return hashMap;
    }

    private String generateStartCommandArgs(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateStartCommandArgs", map);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.entrySet().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Key", entry.getKey());
                Tr.debug(tc, "Value", entry.getValue());
            }
            stringBuffer.append(entry.getKey());
            bl = false;
            if (entry.getValue() == null || ((String)entry.getValue()).trim().length() <= 0) continue;
            stringBuffer.append("=");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(",");
            bl = true;
        }
        if (bl) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateStartCommandArgs", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

