/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportCommand;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ImportServer
extends ImportCommand {
    private static TraceComponent tc = Tr.register(ImportServer.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private RepositoryContext nodeInArchiveCxt = null;
    private RepositoryContext serverInArchiveCxt = null;
    private RepositoryContext nodeCxt = null;

    public ImportServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportServer(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            String string;
            String string2;
            Collection collection;
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            String string3 = (String)this.getParameter("nodeInArchive");
            Collection collection2 = workSpace.getRootContext().findContext("nodes", string3);
            if (collection2.size() != 1) {
                throw new InvalidParameterValueException(this.getName(), "nodeInArchive", string3);
            }
            this.nodeInArchiveCxt = (RepositoryContext)collection2.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeInArchiveCxt", this.nodeInArchiveCxt);
            }
            if ((collection = this.nodeInArchiveCxt.findContext("servers", string2 = (String)this.getParameter("serverInArchive"))).size() != 1) {
                throw new InvalidParameterValueException(this.getName(), "serverInArchive", string2);
            }
            this.serverInArchiveCxt = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverInArchiveCxt", this.serverInArchiveCxt);
            }
            String string4 = (String)this.getParameter("nodeName");
            WorkSpace workSpace2 = WorkspaceHelper.getWorkspace(this.getConfigSession());
            collection2 = workSpace2.getRootContext().findContext("nodes", string4);
            if (collection2.size() != 1) {
                throw new InvalidParameterValueException(this.getName(), "nodeName", string4);
            }
            this.nodeCxt = (RepositoryContext)collection2.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeCxt", this.nodeCxt);
            }
            if ((collection = this.nodeCxt.findContext("servers", string = (String)this.getParameter("serverName"))).size() != 0) {
                String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0007E", new Object[]{string, string4}, null);
                throw new CommandValidationException(string5);
            }
            String string6 = (String)this.getParameter("coreGroup");
            if (string6 != null && string6.length() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "coreGrp", string6);
                }
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "CoreGroup", string6);
                ObjectName[] objectNameArray = ConfigServiceFactory.getConfigService().queryConfigObjects(this.getConfigSession(), null, objectName, null);
                if (objectNameArray.length == 1) {
                    throw new InvalidParameterValueException(this.getName(), "coreGroup", string6);
                }
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ImportServer.validate", "89");
            throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setParameter(String var1_1, Object var2_2) throws InvalidParameterValueException, InvalidParameterNameException {
        if (ImportServer.tc.isEntryEnabled()) {
            Tr.entry(ImportServer.tc, "setParameter", new Object[]{var1_1, var2_2});
        }
        super.setParameter(var1_1, var2_2);
        if (var1_1.equals("archive")) {
            try {
                var3_3 = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
                var4_5 = RepositoryMetaDataFactory.getRepositoryMetaData();
                var5_6 = var3_3.findContext(var4_5.getContextType("nodes"));
                if (var5_6.size() == 1) {
                    this.setParameter("nodeInArchive", ((RepositoryContext)var5_6.iterator().next()).getName());
                }
                if ((var6_7 = var3_3.findContext(var4_5.getContextType("servers"))).size() != 1) ** GOTO lbl22
                this.setParameter("serverInArchive", ((RepositoryContext)var6_7.iterator().next()).getName());
            }
            catch (Throwable var3_4) {
                FFDCFilter.processException(var3_4, "com.ibm.ws.management.configarchive.ImportServer.setParameter", "71");
                throw new InvalidParameterValueException(this.getName(), "archive", this.getParameter("archive"));
            }
        } else if (var1_1.equals("serverInArchive") && this.getParameter("serverName") == null) {
            super.setParameter(var1_1, var2_2);
            this.setParameter("serverName", var2_2);
        } else {
            super.setParameter(var1_1, var2_2);
        }
lbl22:
        // 4 sources

        if (ImportServer.tc.isEntryEnabled()) {
            Tr.exit(ImportServer.tc, "setParameter");
        }
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChoices", string);
        }
        Object[] objectArray = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
            WorkSpace workSpace2 = WorkspaceHelper.getWorkspace(this.getConfigSession());
            if (workSpace != null) {
                if (string.equals("nodeInArchive")) {
                    object4 = workSpace.findContext(repositoryMetaData.getContextType("nodes"));
                    objectArray = ConfigArchiveUtils.toNames((Collection)object4);
                }
                if (string.equals("serverInArchive")) {
                    object4 = (String)this.getParameter("nodeInArchive");
                    object3 = workSpace.getRootContext().findContext("nodes", (String)object4);
                    if (object3.size() == 1) {
                        object2 = (RepositoryContext)object3.iterator().next();
                        object = object2.getChildren(repositoryMetaData.getContextType("servers"));
                        objectArray = ConfigArchiveUtils.toNames((Collection)object);
                    }
                }
            }
            if (string.equals("nodeName")) {
                object4 = workSpace2.findContext(repositoryMetaData.getContextType("nodes"));
                objectArray = ConfigArchiveUtils.toNames((Collection)object4);
            }
            if (string.equals("coreGroup")) {
                object4 = ConfigServiceFactory.getConfigService();
                object3 = this.getConfigSession();
                object2 = ConfigServiceHelper.createObjectName(null, "CoreGroup", null);
                object = object4.queryConfigObjects((Session)object3, null, (ObjectName)object2, null);
                objectArray = new Object[((ObjectName[])object).length];
                for (int i = 0; i < ((ObjectName[])object).length; ++i) {
                    objectArray[i] = ConfigServiceHelper.getDisplayName(object[i]);
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.configarchive.ImportServer.getChoices", "105");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices", objectArray);
        }
        return objectArray;
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            taskCommandResultImpl.setResult(this.importServer());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ImportServer.beforeStepsExecuted", "175");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "importServer command failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private ObjectName importServer() throws Throwable {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importServer");
        }
        ObjectName objectName = MOFUtil.createObjectName(this.serverInArchiveCxt);
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        Session session2 = this.getConfigArchiveSession();
        AdminCommand adminCommand = ConfigArchiveUtils.getCreateCommand(configService, session, session2, objectName);
        adminCommand.setTargetObject(this.getParameter("nodeName"));
        adminCommand.setParameter("name", this.getParameter("serverName"));
        adminCommand.setParameter("templateName", this.serverInArchiveCxt.getName());
        objectName = WorkspaceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(objectName), ConfigServiceHelper.getConfigDataType(objectName), ConfigServiceHelper.getDisplayName(objectName), session2);
        adminCommand.setParameter("templateLocation", objectName);
        CommandStep commandStep = null;
        try {
            commandStep = ((TaskCommand)adminCommand).getCommandStep("configCoreGroup");
        }
        catch (CommandNotFoundException commandNotFoundException) {
            // empty catch block
        }
        if (commandStep != null) {
            object = this.getParameter("coreGroup");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "coreGroup", object);
            }
            commandStep.setParameter("coregroupName", object);
        }
        adminCommand.execute();
        object = adminCommand.getCommandResult();
        ObjectName objectName2 = null;
        if (!object.isSuccessful()) {
            throw object.getException();
        }
        objectName2 = (ObjectName)object.getResult();
        this.fixSSLConfigAlias(objectName2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importServer", objectName2);
        }
        return objectName2;
    }

    public void setConfigSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigSession", session);
        }
        super.setConfigSession(session);
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            if (objectNameArray.length == 1) {
                this.setParameter("nodeName", ConfigServiceHelper.getDisplayName(objectNameArray[0]));
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ImportServer.setConfigSession", "135");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigSession");
        }
    }

    private void fixSSLConfigAlias(ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixSSLConfigAlias", objectName);
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName2, null);
        objectNameArray = configService.getRelationship(session, objectNameArray[0], "Security");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cell level security", objectNameArray[0]);
        }
        if ((objectNameArray = configService.queryConfigObjects(session, objectNameArray[0], objectName2 = ConfigServiceHelper.createObjectName(null, "SSLConfig"), null)).length > 0) {
            int n;
            Object object;
            String string = (String)configService.getAttribute(session, objectNameArray[0], "alias");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newSSLConfig", string);
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            ObjectName objectName3 = objectNameArray[0];
            AttributeList attributeList = new AttributeList();
            List list = (List)configService.getAttribute(session, objectName3, "properties", false);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                object = (ObjectName)iterator.next();
                if (!"sslConfig".equals(configService.getAttribute(session, (ObjectName)object, "name")) || !(string2 = (String)configService.getAttribute(session, (ObjectName)object, "value")).endsWith("/DefaultSSLSettings")) continue;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, "value", string);
                configService.setAttributes(session, (ObjectName)object, attributeList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ssl config alias is update from " + string2 + " to " + string);
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "SSLInboundChannel");
            objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            for (n = 0; n < objectNameArray.length; ++n) {
                object = (String)configService.getAttribute(session, objectNameArray[n], "sslConfigAlias");
                if (object == null || !((String)object).endsWith("/DefaultSSLSettings")) continue;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, "sslConfigAlias", string);
                configService.setAttributes(session, objectNameArray[n], attributeList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ssl config alias is update from " + (String)object + " to " + string);
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "SSLOutboundChannel");
            objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            for (n = 0; n < objectNameArray.length; ++n) {
                object = (String)configService.getAttribute(session, objectNameArray[n], "sslConfigAlias");
                if (object == null || !((String)object).endsWith("/DefaultSSLSettings")) continue;
                attributeList.clear();
                ConfigServiceHelper.setAttributeValue(attributeList, "sslConfigAlias", string);
                configService.setAttributes(session, objectNameArray[n], attributeList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ssl config alias is update from " + (String)object + " to " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixSSLConfigAlias");
        }
    }
}

