/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroupMember;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configarchive.ConfigArchiveUtils;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.common.util.MergeSecurityConfig;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportCommand;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ImportWsprofile
extends ImportCommand {
    private static TraceComponent tc = Tr.register(ImportWsprofile.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private final String CELL_NAME = "CELL_NAME";
    private final String NODE_NAME = "NODE_NAME";
    private final String SERVER_NAME = "SERVER_NAME";
    private final String SERVER_INDEX = "SERVER_INDEX";
    private final String NODE_VARIABLE_MAP = "NODE_VARIABLE_MAP";
    private final String SYSTEM_APPS = "SYSTEM_APPS";
    private final String VIRTUAL_HOSTS = "VIRTUAL_HOSTS";
    private final String NUMBER_SERVERS = "NUMBER_SERVERS";
    private int oldServerCnt;

    public ImportWsprofile(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ImportWsprofile(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            if (objectNameArray.length != 1) {
                String string = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0001E");
                throw new CommandValidationException(string);
            }
            objectName = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] objectNameArray2 = objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            Session session2 = this.getConfigArchiveSession();
            objectNameArray = configService.queryConfigObjects(session2, null, objectName = ConfigServiceHelper.createObjectName(null, "Node"), null);
            if (objectNameArray.length != 1) {
                String string = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0003E");
                throw new CommandValidationException(string);
            }
            objectName = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] objectNameArray3 = objectNameArray = configService.queryConfigObjects(session2, null, objectName, null);
            this.oldServerCnt = objectNameArray2.length;
            if (objectNameArray2.length > 0 && objectNameArray2.length != objectNameArray3.length) {
                String string = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0016E");
                throw new CommandValidationException(string);
            }
            for (int i = 0; objectNameArray2.length > 0 && i < objectNameArray2.length; ++i) {
                String string = (String)ConfigServiceHelper.getObjectLocation(objectNameArray2[i]).get("server");
                boolean bl = false;
                for (int j = 0; j < objectNameArray3.length; ++j) {
                    String string2 = (String)ConfigServiceHelper.getObjectLocation(objectNameArray3[j]).get("server");
                    if (!string.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                String string3 = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0017E");
                throw new CommandValidationException(string3);
            }
        }
        catch (CommandValidationException commandValidationException) {
            throw commandValidationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ImportWsprofile.validate", "113");
            throw new CommandValidationException(throwable, "An unexpected exception is thrown.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName[] objectNameArray;
            List list;
            RepositoryContext repositoryContext;
            RepositoryContext repositoryContext2;
            RepositoryMetaData repositoryMetaData;
            RepositoryContext repositoryContext3;
            ObjectName objectName;
            ConfigService configService;
            block27: {
                Object object;
                RepositoryContext repositoryContext4;
                RepositoryContext repositoryContext5;
                configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                WorkSpace workSpace2 = WorkspaceHelper.getWorkspace(this.getConfigArchiveSession());
                objectName = ConfigServiceHelper.createObjectName(null, "Cell");
                ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
                configService.deleteConfigData(session, objectName2);
                repositoryContext3 = workSpace.getRootContext();
                repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
                RepositoryContext repositoryContext6 = (RepositoryContext)workSpace2.findContext(repositoryMetaData.getContextType("cells")).iterator().next();
                RepositoryContext repositoryContext7 = ConfigArchiveUtils.createContext(repositoryContext3, (String)this.preImportData.get("CELL_NAME"), repositoryContext6);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell context", repositoryContext7);
                }
                String string = repositoryContext7.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell name ", string);
                }
                repositoryContext2 = repositoryContext6;
                repositoryContext = repositoryContext7;
                List list2 = repositoryContext6.getChildren();
                Resource resource = list2.iterator();
                while (resource.hasNext()) {
                    repositoryContext5 = (RepositoryContext)resource.next();
                    if (repositoryContext5.getType().getName().equals("nodes") || repositoryContext5.getType().getName().equals("applications")) continue;
                    ConfigArchiveUtils.copyContext(repositoryContext7, repositoryContext5, null);
                }
                this.updateSecurity((String)this.preImportData.get("NODE_NAME"));
                resource = ConfigArchiveUtils.getResource(repositoryContext7, "security.xml");
                repositoryContext5 = (Security)resource.getContents().get(0);
                MergeSecurityConfig.updateCellNameAndNodeName((Security)repositoryContext5, (String)this.preImportData.get("CELL_NAME"), (String)this.preImportData.get("NODE_NAME"));
                resource.save(Collections.EMPTY_MAP);
                Resource resource2 = ConfigArchiveUtils.getResource(repositoryContext7, "virtualhosts.xml");
                EList eList = resource2.getContents();
                List list3 = (List)this.preImportData.get("VIRTUAL_HOSTS");
                ConfigArchiveUtils.mergeVirtualHostList((List)eList, list3, "name", true);
                resource2.save(Collections.EMPTY_MAP);
                this.updateCellVariableMap(repositoryContext7, (String)this.preImportData.get("CELL_NAME"));
                RepositoryContext repositoryContext8 = (RepositoryContext)repositoryContext7.findContext(repositoryMetaData.getContextType("nodegroups")).iterator().next();
                this.updateNodeGroup(repositoryContext8, (String)this.preImportData.get("NODE_NAME"));
                RepositoryContext repositoryContext9 = (RepositoryContext)repositoryContext7.findContext(repositoryMetaData.getContextType("coregroups")).iterator().next();
                this.updateCoreGroup(repositoryContext9, (String)this.preImportData.get("NODE_NAME"));
                repositoryContext6 = (RepositoryContext)repositoryContext6.findContext(repositoryMetaData.getContextType("nodes")).iterator().next();
                repositoryContext7 = ConfigArchiveUtils.createContext(repositoryContext7, (String)this.preImportData.get("NODE_NAME"), repositoryContext6);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node context", repositoryContext7);
                }
                list2 = repositoryContext6.getChildren();
                Resource resource3 = list2.iterator();
                while (resource3.hasNext()) {
                    repositoryContext4 = (RepositoryContext)resource3.next();
                    if (repositoryContext4.getType().getName().equals("servers")) continue;
                    ConfigArchiveUtils.copyContext(repositoryContext7, repositoryContext4, null);
                }
                resource3 = ConfigArchiveUtils.getResource(repositoryContext7, "variables.xml");
                repositoryContext4 = resource3.getContents();
                VariableMap variableMap = (VariableMap)this.preImportData.get("NODE_VARIABLE_MAP");
                if (repositoryContext4.size() == 0) {
                    repositoryContext4.add(variableMap);
                } else {
                    ConfigArchiveUtils.mergeVariableList((List)((VariableMap)repositoryContext4.get(0)).getEntries(), (List)variableMap.getEntries(), "symbolicName", true);
                }
                resource3.save(Collections.EMPTY_MAP);
                resource3 = ConfigArchiveUtils.getResource(repositoryContext7, "serverindex.xml");
                ServerIndex serverIndex = (ServerIndex)resource3.getContents().get(0);
                ServerIndex serverIndex2 = (ServerIndex)this.preImportData.get("SERVER_INDEX");
                String string2 = serverIndex2.getHostName();
                this.setHostName(serverIndex, string2);
                list = (List)this.preImportData.get("SERVER_NAME");
                for (int i = 0; i < this.oldServerCnt; ++i) {
                    object = (ServerEntry)serverIndex.getServerEntries().get(i);
                    object.setServerName((String)list.get(i));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverEntry", object);
                    }
                    objectNameArray = object.getSpecialEndpoints();
                    object = (ServerEntry)serverIndex2.getServerEntries().get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverEntry", object);
                    }
                    EList eList2 = object.getSpecialEndpoints();
                    ConfigArchiveUtils.mergeList((List)objectNameArray, (List)eList2, "endPointName", true);
                }
                if (!((List)this.preImportData.get("SYSTEM_APPS")).isEmpty()) {
                    repositoryContext7.delete("systemapps.xml");
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext7, "systemapps.xml");
                    repositoryContext4 = repositoryContext7.getResourceSet().getResource(URI.createURI((String)"systemapps.xml"), false).getContents();
                    object = (List)this.preImportData.get("SYSTEM_APPS");
                    repositoryContext4.addAll(object);
                    docAccessor.localSave();
                } else {
                    this.checkSystemAppsPath(repositoryContext6);
                }
                this.resolvePortConflict(repositoryContext7, serverIndex);
                resource3.save(Collections.EMPTY_MAP);
                Collection collection = repositoryContext6.findContext(repositoryMetaData.getContextType("servers"));
                object = collection.iterator();
                while (object.hasNext()) {
                    repositoryContext6 = (RepositoryContext)object.next();
                    objectNameArray = ConfigArchiveUtils.createContext(repositoryContext7, repositoryContext6.getName(), repositoryContext6);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "server context", objectNameArray);
                }
                this.updateServer((String)this.preImportData.get("NODE_NAME"));
                for (int i = 0; i < this.oldServerCnt; ++i) {
                    this.updateServerVariableMap(repositoryContext7, (String)list.get(i));
                }
                try {
                    this.getRars(repositoryContext3, string);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block27;
                    Tr.debug(tc, "import of rars failed");
                }
            }
            Session session = this.getConfigArchiveSession();
            objectName = ConfigServiceHelper.createObjectName(null, "Deployment");
            objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                Object object;
                Object object2;
                Object object3;
                String string = null;
                Deployment deployment = (Deployment)MOFUtil.convertToEObject(session, objectNameArray[i]);
                int n = (Integer)this.preImportData.get("NUMBER_SERVERS");
                if (n > 1 || n <= 0 || list.size() == 0) {
                    object3 = deployment.eAllContents();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        if (!(object2 instanceof ServerTarget)) continue;
                        object = (ServerTarget)object2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "svrTarget", object);
                        }
                        string = object.getName();
                    }
                } else {
                    string = (String)list.get(0);
                }
                object3 = this.createVariableMap(repositoryContext3, (String)this.preImportData.get("CELL_NAME"), (String)this.preImportData.get("NODE_NAME"), string);
                object2 = ConfigServiceHelper.getDisplayName(objectNameArray[i]);
                this.updateDeploymentTarget(deployment);
                object = repositoryContext2.findContext(repositoryMetaData.getContextType("applications")).iterator();
                this.deployApplications((String)object2, repositoryContext2, repositoryContext, (Iterator)object, deployment, (com.ibm.ws.runtime.service.VariableMap)object3);
            }
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configarchive", "ADMB0008I");
            taskCommandResultImpl.addWarnings(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.configarchive.ImportWsProfile.beforeStepsExecuted", "99");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "importWsprofile command failed"));
            throwable.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    private com.ibm.ws.runtime.service.VariableMap createVariableMap(RepositoryContext repositoryContext, String string, String string2, String string3) {
        String string4 = repositoryContext.getPath();
        Repository repository2 = RepositoryFactory.createRepository("ws-server", string4, string, string2, string3);
        com.ibm.ws.runtime.service.VariableMap variableMap = VariableMapFactory.createVariableMap(repository2);
        variableMap.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + variableMap);
        }
        return variableMap;
    }

    private void checkSystemAppsPath(RepositoryContext repositoryContext) throws CommandValidationException {
        Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)"systemapps.xml"), true);
        if (resource == null) {
            return;
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().iterator().next();
        if (serverIndex == null) {
            return;
        }
        String string = "${WAS_INSTALL_ROOT}";
        String string2 = "adminconsole.ear";
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            EList eList2 = serverEntry.getDeployedApplications();
            String string3 = null;
            for (int j = 0; j < eList2.size(); ++j) {
                string3 = (String)eList2.get(j);
                if (!string3.endsWith(string2) || string3.startsWith(string)) continue;
                String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configarchive", "ADMB0010E", new Object[]{string, string2}, null);
                throw new CommandValidationException(string4);
            }
        }
    }

    protected void collectConfigBeforeImport() throws Exception {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectConfigBeforeImport");
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigArchiveSession();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        Integer n = new Integer(objectNameArray.length);
        this.preImportData.put("NUMBER_SERVERS", n);
        Session session2 = this.getConfigSession();
        objectName = ConfigServiceHelper.createObjectName(null, "Server");
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session2, null, objectName, null);
        ObjectName objectName2 = null;
        Properties properties = null;
        if (objectNameArray2.length > 0) {
            objectName2 = objectNameArray2[0];
            properties = ConfigServiceHelper.getObjectLocation(objectName2);
        } else {
            object = configService.queryConfigObjects(session2, null, ConfigServiceHelper.createObjectName(null, "Node"), null);
            serializable2 = object[0];
            properties = ConfigServiceHelper.getObjectLocation((ObjectName)serializable2);
        }
        this.preImportData.put("CELL_NAME", properties.get("cell"));
        object = (String)properties.get("node");
        this.preImportData.put("NODE_NAME", object);
        serializable2 = new ArrayList();
        for (int i = 0; i < objectNameArray2.length; ++i) {
            serializable = ConfigServiceHelper.getObjectLocation(objectNameArray2[i]);
            serializable2.add(serializable.get("server"));
        }
        this.preImportData.put("SERVER_NAME", serializable2);
        ObjectName objectName3 = configService.resolve(session2, "Node=" + (String)object)[0];
        serializable = configService.getRelationship(session2, objectName3, "ServerIndex")[0];
        ServerIndex serverIndex = (ServerIndex)MOFUtil.convertToEObject(session2, (ObjectName)serializable);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverindex", serverIndex);
        }
        this.preImportData.put("SERVER_INDEX", serverIndex);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session2, ConfigServiceHelper.getConfigDataId(objectName3));
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "systemapps.xml");
        EList eList = repositoryContext.getResourceSet().getResource(URI.createURI((String)"systemapps.xml"), false).getContents();
        this.preImportData.put("SYSTEM_APPS", eList);
        ObjectName objectName4 = configService.getRelationship(session2, objectName3, "VariableMap")[0];
        VariableMap variableMap = (VariableMap)MOFUtil.convertToEObject(session2, objectName4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeVar", variableMap);
        }
        this.preImportData.put("NODE_VARIABLE_MAP", variableMap);
        objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName5 = configService.queryConfigObjects(session2, null, objectName, null)[0];
        RepositoryContext repositoryContext2 = WorkspaceHelper.getContext(session2, ConfigServiceHelper.getConfigDataId(objectName5));
        docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "virtualhosts.xml");
        EList eList2 = repositoryContext2.getResourceSet().getResource(URI.createURI((String)"virtualhosts.xml"), false).getContents();
        this.preImportData.put("VIRTUAL_HOSTS", eList2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectConfigBeforeImport");
        }
    }

    private void setHostName(ServerIndex serverIndex, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHostName", new Object[]{serverIndex, string});
        }
        serverIndex.setHostName(string);
        TreeIterator treeIterator = serverIndex.eAllContents();
        while (treeIterator.hasNext()) {
            EndPoint endPoint;
            String string2;
            Object e2 = treeIterator.next();
            if (!(e2 instanceof EndPoint) || (string2 = (endPoint = (EndPoint)e2).getHost()) == null || !string2.equals("*")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Preserving  HostName as *  for port " + endPoint.getPort());
                continue;
            }
            ((EndPoint)e2).setHost(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHostName");
        }
    }

    private void resolvePortConflict(RepositoryContext repositoryContext, ServerIndex serverIndex) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolvePortConflict", new Object[]{repositoryContext, serverIndex});
        }
        TreeIterator treeIterator = serverIndex.eAllContents();
        while (treeIterator.hasNext()) {
            int n;
            Object e2 = treeIterator.next();
            if (!(e2 instanceof EndPoint)) continue;
            EndPoint endPoint = (EndPoint)e2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "endPnt", endPoint);
            }
            if ((n = endPoint.getPort()) != 0) {
                endPoint.setPort(0);
                EndpointConfigHelper.adjustPort(repositoryContext, n, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "port," + n);
                }
            }
            endPoint.setPort(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolvePortConflict");
        }
    }

    private void updateDeploymentTarget(Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateDeploymentTarget", deployment);
        }
        TreeIterator treeIterator = deployment.eAllContents();
        while (treeIterator.hasNext()) {
            Object e2 = treeIterator.next();
            if (!(e2 instanceof ServerTarget)) continue;
            ServerTarget serverTarget = (ServerTarget)e2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "svrTarget", serverTarget);
            }
            int n = (Integer)this.preImportData.get("NUMBER_SERVERS");
            List list = (List)this.preImportData.get("SERVER_NAME");
            String string = n > 1 || n <= 0 || list.size() == 0 ? serverTarget.getName() : (String)list.get(0);
            serverTarget.setName(string);
            serverTarget.setNodeName((String)this.preImportData.get("NODE_NAME"));
        }
        deployment.eResource().save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateDeploymentTarget");
        }
    }

    private void deployApplications(String string, RepositoryContext repositoryContext, RepositoryContext repositoryContext2, Iterator iterator, Deployment deployment, com.ibm.ws.runtime.service.VariableMap variableMap) throws Exception {
        Object object;
        Object e2;
        TreeIterator treeIterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deployApplications", new Object[]{string, repositoryContext, repositoryContext2, iterator, deployment, variableMap});
        }
        RepositoryContext repositoryContext3 = repositoryContext;
        RepositoryContext repositoryContext4 = repositoryContext2;
        String string2 = string + ".ear";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appBinName = ", string2);
        }
        List list = (List)this.preImportData.get("SERVER_NAME");
        String string3 = null;
        int n = (Integer)this.preImportData.get("NUMBER_SERVERS");
        if (n > 1 || n <= 0 || list.size() == 0) {
            treeIterator = deployment.eAllContents();
            while (treeIterator.hasNext()) {
                e2 = treeIterator.next();
                if (!(e2 instanceof ServerTarget)) continue;
                object = (ServerTarget)e2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "svrTarget", object);
                }
                string3 = object.getName();
            }
        } else {
            string3 = (String)list.get(0);
        }
        treeIterator = deployment.eAllContents();
        while (treeIterator.hasNext()) {
            Object object2;
            e2 = treeIterator.next();
            object = this.getConfigArchiveSession();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName[] objectNameArray = ConfigServiceFactory.getConfigService().queryConfigObjects((Session)object, null, objectName, null);
            String string4 = ConfigServiceHelper.getDisplayName(objectNameArray[0]);
            if (!(e2 instanceof ApplicationDeployment)) continue;
            ApplicationDeployment applicationDeployment = (ApplicationDeployment)e2;
            String string5 = applicationDeployment.getBinariesURL();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old binURL", string5);
            }
            String string6 = variableMap.expand(string5);
            String string7 = "$(APP_INSTALL_ROOT)/" + string4 + "/";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expandedURL= ", string6);
            }
            boolean bl = false;
            boolean bl2 = false;
            try {
                object2 = new File(string6);
                if (!((File)object2).exists()) {
                    ((File)object2).mkdirs();
                    ((File)object2).delete();
                    bl = true;
                } else {
                    bl2 = true;
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                bl = false;
                bl2 = false;
            }
            if (applicationDeployment.isEnableDistribution()) {
                if (!bl) {
                    string5 = "${APP_INSTALL_ROOT}/" + this.preImportData.get("CELL_NAME") + "/" + string2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new binURL", string5);
                    }
                    applicationDeployment.setBinariesURL(string5);
                    deployment.eResource().save(Collections.EMPTY_MAP);
                }
                ConfigArchiveUtils.deployApplication(applicationDeployment, this.getConfigSession(), string, this.getConfigArchiveSession(), string, (String)this.preImportData.get("NODE_NAME"), string3);
                continue;
            }
            if (!bl2) continue;
            try {
                Object object3;
                object2 = iterator;
                while (object2.hasNext()) {
                    object3 = (RepositoryContext)object2.next();
                    if (!object3.getName().equals(string) && !object3.getName().equals(string2)) continue;
                    repositoryContext3 = object3;
                    break;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "app context = " + repositoryContext3);
                }
                repositoryContext4 = ConfigArchiveUtils.createContextIfNeeded(repositoryContext4, "applications", string2);
                object2 = repositoryContext3.getChildren();
                object3 = object2.iterator();
                while (object3.hasNext()) {
                    RepositoryContext repositoryContext5 = (RepositoryContext)object3.next();
                    ConfigArchiveUtils.copyContext(repositoryContext4, repositoryContext5, null);
                }
            }
            catch (WorkSpaceException workSpaceException) {
                workSpaceException.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ConfigArchiveUtils.updateApplication(applicationDeployment, this.getConfigSession(), string, this.getConfigArchiveSession(), string, string6, (String)this.preImportData.get("NODE_NAME"), string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deployApplications");
        }
    }

    private void updateSecurity(String string) throws Exception {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSecurity", string);
        }
        Session session = this.getConfigSession();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName = ConfigServiceHelper.createObjectName(null, "Cell"), null);
        if (objectNameArray == null || objectNameArray.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateSecurity", "cell context not found");
            }
            return;
        }
        ObjectName objectName2 = objectNameArray[0];
        objectName = ConfigServiceHelper.createObjectName(null, "Security");
        if ((objectNameArray = configService.queryConfigObjects(session, objectName2, objectName, null)) == null || objectNameArray.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateSecurity", "security context not found");
            }
            return;
        }
        ObjectName objectName3 = objectNameArray[0];
        this.updateAllSSL(string, objectName3, "IIOPTransport", "sslConfig", configService, session, null);
        this.updateAllSSL(string, objectName3, "SSLConfig", "alias", configService, session, null);
        this.updateAllSSL(string, objectName3, "LDAPUserRegistry", "sslConfig", configService, session, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSecurity");
        }
    }

    private void updateServer(String string) throws Exception {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServer", string);
        }
        Session session = this.getConfigSession();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName = ConfigServiceHelper.createObjectName(null, "Node"), null);
        if (objectNameArray == null || objectNameArray.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServer", "cell context not found");
            }
            return;
        }
        ObjectName objectName2 = objectNameArray[0];
        objectName = ConfigServiceHelper.createObjectName(null, "Server");
        if ((objectNameArray = configService.queryConfigObjects(session, objectName2, objectName, null)) == null || objectNameArray.length <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServer", "security context not found");
            }
            return;
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName3 = objectNameArray[i];
            this.updateAllSSL(string, objectName3, "SSLInboundChannel", "sslConfigAlias", configService, session, null);
            this.updateAllSSL(string, objectName3, "SSLOutboundChannel", "sslConfigAlias", configService, session, null);
            objectName = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName3, objectName, null);
            if (objectNameArray2 == null || objectNameArray2.length <= 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "updateServer", "soap connector context not found");
                continue;
            }
            ObjectName objectName4 = objectNameArray2[0];
            List list = (List)configService.getAttribute(session, objectName4, "properties", false);
            AttributeList attributeList = new AttributeList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                ObjectName objectName5 = (ObjectName)iterator.next();
                if (!"sslConfig".equals(configService.getAttribute(session, objectName5, "name")) || (string2 = (String)configService.getAttribute(session, objectName5, "value")).indexOf("/") <= 0) continue;
                attributeList.clear();
                int n = string2.indexOf("/");
                String string3 = string + string2.substring(n);
                ConfigServiceHelper.setAttributeValue(attributeList, "value", string3);
                configService.setAttributes(session, objectName5, attributeList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Soap connector ssl config alias is changed  from " + string2 + " to " + string3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServer", string);
        }
    }

    private void updateAllSSL(String string, ObjectName objectName, String string2, String string3, ConfigService configService, Session session, String string4) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSslAlias", new Object[]{objectName, string2, string3});
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, string2);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        AttributeList attributeList = new AttributeList();
        int n = objectNameArray == null ? 0 : objectNameArray.length;
        for (int i = 0; i < n; ++i) {
            ObjectName objectName3 = objectNameArray[i];
            String string5 = (String)configService.getAttribute(session, objectName3, string3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updating ", objectName3);
            }
            if (string5 == null || string5.indexOf("/") < 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sslAlias=", string5);
            }
            int n2 = string5.indexOf("/");
            String string6 = string + string5.substring(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newSslAlias=", string6);
            }
            attributeList.clear();
            ConfigServiceHelper.setAttributeValue(attributeList, string3, string6);
            configService.setAttributes(session, objectName3, attributeList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSslAlias");
        }
    }

    private void updateServerVariableMap(RepositoryContext repositoryContext, String string) throws Exception {
        Resource resource;
        VariableMap variableMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerVariableMap", new Object[]{repositoryContext, string});
        }
        if ((variableMap = (VariableMap)(resource = ConfigArchiveUtils.getResource(repositoryContext, "variables.xml")).getContents().get(0)) != null) {
            EList eList = variableMap.getEntries();
            for (int i = 0; i < eList.size(); ++i) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)eList.get(i);
                if (variableSubstitutionEntry.getSymbolicName().equals("WAS_SERVER_NAME")) {
                    variableSubstitutionEntry.setValue(string);
                }
                if (!variableSubstitutionEntry.getSymbolicName().equals("SERVER_LOG_ROOT")) continue;
                variableSubstitutionEntry.setValue("${LOG_ROOT}/" + string);
            }
        }
        resource.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateServerVariableMap");
        }
    }

    private void updateCellVariableMap(RepositoryContext repositoryContext, String string) throws Exception {
        Resource resource;
        VariableMap variableMap;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellVariableMap", new Object[]{repositoryContext, string});
        }
        if ((variableMap = (VariableMap)(resource = ConfigArchiveUtils.getResource(repositoryContext, "variables.xml")).getContents().get(0)) != null) {
            EList eList = variableMap.getEntries();
            for (int i = 0; i < eList.size(); ++i) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)eList.get(i);
                if (!variableSubstitutionEntry.getSymbolicName().equals("WAS_CELL_NAME")) continue;
                variableSubstitutionEntry.setValue(string);
            }
        }
        resource.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCellVariableMap");
        }
    }

    private void updateNodeGroup(RepositoryContext repositoryContext, String string) throws Exception {
        Resource resource;
        NodeGroup nodeGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateNodeGroup", new Object[]{repositoryContext, string});
        }
        if ((nodeGroup = (NodeGroup)(resource = ConfigArchiveUtils.getResource(repositoryContext, "nodegroup.xml")).getContents().get(0)) != null) {
            EList eList = nodeGroup.getMembers();
            for (int i = 0; i < eList.size(); ++i) {
                NodeGroupMember nodeGroupMember = (NodeGroupMember)eList.get(i);
                nodeGroupMember.setNodeName(string);
            }
        }
        resource.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateNodeGroup");
        }
    }

    private void updateCoreGroup(RepositoryContext repositoryContext, String string) throws Exception {
        Resource resource;
        CoreGroup coreGroup;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCoreGroup", new Object[]{repositoryContext, string});
        }
        if ((coreGroup = (CoreGroup)(resource = ConfigArchiveUtils.getResource(repositoryContext, "coregroup.xml")).getContents().get(0)) != null) {
            EList eList = coreGroup.getCoreGroupServers();
            for (int i = 0; i < eList.size(); ++i) {
                CoreGroupServer coreGroupServer = (CoreGroupServer)eList.get(i);
                coreGroupServer.setNodeName(string);
            }
        }
        resource.save(Collections.EMPTY_MAP);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCoreGroup");
        }
    }

    private void getRars(RepositoryContext repositoryContext, String string) throws Exception {
        RepositoryContextType repositoryContextType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRars", repositoryContext);
        }
        RepositoryContext repositoryContext2 = null;
        RepositoryContext repositoryContext3 = null;
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType repositoryContextType2 = repositoryMetaData.getContextType("cells");
        Collection collection = repositoryContext.findContext(repositoryContextType2);
        RepositoryContext repositoryContext4 = (RepositoryContext)collection.iterator().next();
        if ((collection = repositoryContext4.findContext(repositoryContextType = repositoryMetaData.getContextType("nodes"))) != null && collection.size() > 0) {
            repositoryContext2 = (RepositoryContext)collection.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeCtx ", repositoryContext2);
        }
        if (repositoryContext2 == null) {
            return;
        }
        RepositoryContextType repositoryContextType3 = repositoryMetaData.getContextType("servers");
        collection = repositoryContext2.findContext(repositoryContextType3);
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                repositoryContext3 = (RepositoryContext)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverCtx ", repositoryContext3);
                }
                com.ibm.ws.runtime.service.VariableMap variableMap = this.createVariableMap(repositoryContext, string, repositoryContext2.getName(), repositoryContext3.getName());
                Resource resource = ConfigArchiveUtils.getResource(repositoryContext2, "resources.xml");
                if (resource != null) {
                    this.getRarFromArchive(resource, repositoryContext2, variableMap);
                }
                if ((resource = ConfigArchiveUtils.getResource(repositoryContext3, "resources.xml")) == null) continue;
                this.getRarFromArchive(resource, repositoryContext3, variableMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRars");
        }
    }

    private void getRarFromArchive(Resource resource, RepositoryContext repositoryContext, com.ibm.ws.runtime.service.VariableMap variableMap) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRarFromArchive", repositoryContext);
        }
        String string = null;
        String string2 = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            WorkSpaceFile workSpaceFile;
            object4 = eList.get(i);
            if (!(object4 instanceof J2CResourceAdapter)) continue;
            object3 = (J2CResourceAdapter)object4;
            object2 = object3.getArchivePath();
            object = object3.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resName ", object);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archiveLocation ", object2);
            }
            if ((workSpaceFile = repositoryContext.getFile("resources.xml")) == null) continue;
            String string3 = workSpaceFile.getURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resource uri ", string3);
            }
            string3 = string3.substring(0, string3.indexOf("/resources.xml"));
            string2 = string3 + "/rars";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node uri ", string3);
            }
            String string4 = repositoryContext.getWorkSpace().getPath();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "archive workspace path ", string4);
            }
            string = string4 + File.separator + string3 + File.separator + "rars";
            string4 = string4 + File.separator + string3 + File.separator + "rars" + File.separator + (String)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rar path ", string4);
            }
            object2 = variableMap.expand((String)object2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded src rar path ", object2);
            }
            try {
                ConfigArchiveUtils.getRar((String)object2, string4);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string != null) {
            RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            object4 = repositoryMetaData.getContextType("rars");
            object3 = repositoryContext.findContext((RepositoryContextType)object4);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContext)object2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "expanded src rar path ", object.getName());
                }
                object.delete(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRarFromArchive");
        }
    }
}

