/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.naming.util.ImportProfileUtility;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportStep;
import javax.management.ObjectName;

public class UpdateNameBindingsExt
extends ImportStep {
    private static TraceComponent tc = Tr.register(UpdateNameBindingsExt.class, "configarchive", "com.ibm.ws.management.resources.configarchive");
    private static final String CLASS_NAME;

    public UpdateNameBindingsExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public UpdateNameBindingsExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    protected void executeStep() {
        TaskCommandResultImpl taskCommandResultImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeStep");
        }
        if (!(taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getTaskCommandResult()).isSuccessful()) {
            return;
        }
        try {
            super.executeStep();
            Session session = this.getConfigSession();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "session", session);
            }
            String string = WorkspaceHelper.getWorkspace(session).getUserName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "workSpaceID", string);
            }
            String string2 = this.getNodeName(session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodename", string2);
            }
            ImportProfileUtility importProfileUtility = ImportProfileUtility.createUtilityInstance(string, string2);
            importProfileUtility.updateNameBindings();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, CLASS_NAME + ".executeStep", "93");
            taskCommandResultImpl.setException(new ConfigArchiveException(throwable, "update node name step failed"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeStep");
        }
    }

    private String getNodeName(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeName");
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
        ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
        ObjectName objectName3 = configService.getRelationship(session, objectName2, "Node")[0];
        String string = ConfigServiceHelper.getDisplayName(objectName3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeName", string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.jmx/src/com/ibm/ws/management/configarchive/UpdateNameBindingsExt.java, WAS.admin.jmx, WAS61.SERV1, cf311012.09, ver. 1.1");
        }
        CLASS_NAME = UpdateNameBindingsExt.class.getName();
    }
}

