/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AuthorizationGroupDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(AuthorizationGroupDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public AuthorizationGroupDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("authorizationgroups"));
    }

    public ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, objectName, childTypeInfo, attributeList});
        }
        this.checkAccess(objectName);
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final ConfigObjectDelegator.ChildTypeInfo childTypeInfo2 = childTypeInfo;
        final AttributeList attributeList2 = attributeList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ObjectName objectName3 = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.createConfigObjectAsSystem(session2, objectName2, childTypeInfo2, attributeList2);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", objectName3);
            }
            return objectName3;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }

    private ObjectName createConfigObjectAsSystem(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        return super.createConfigObject(session, objectName, childTypeInfo, attributeList);
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, objectName, string, attributeList});
        }
        this.checkAccess(objectName);
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final String string2 = string;
        final AttributeList attributeList2 = attributeList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ObjectName objectName3 = (ObjectName)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.createConfigDataAsSystem(session2, objectName2, string2, attributeList2);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigData", objectName3);
            }
            return objectName3;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }

    private ObjectName createConfigDataAsSystem(Session session, ObjectName objectName, String string, AttributeList attributeList) throws ConfigServiceException {
        return super.createConfigData(session, objectName, string, attributeList);
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, objectName, attributeList});
        }
        this.checkAccess(objectName);
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final AttributeList attributeList2 = attributeList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.setAttributesAsSystem(session2, objectName2, attributeList2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void setAttributesAsSystem(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        super.setAttributes(session, objectName, attributeList);
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, objectName, attributeList});
        }
        this.checkAccess(objectName);
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final AttributeList attributeList2 = attributeList;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.resetAttributesAsSystem(session2, objectName2, attributeList2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public void resetAttributesAsSystem(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        super.setAttributes(session, objectName, attributeList);
    }

    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{session, objectName});
        }
        this.checkAccess(objectName);
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final String string2 = string;
        final Object object2 = object;
        final int n2 = n;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.addElementAsSystem(session2, objectName2, string2, object2, n2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    private void addElementAsSystem(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        super.addElement(session, objectName, string, object, n);
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        this.checkAccess(objectName);
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.deleteConfigDataAsSystem(session2, objectName2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    private void deleteConfigDataAsSystem(Session session, ObjectName objectName) throws ConfigServiceException {
        super.deleteConfigData(session, objectName);
    }

    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, objectName, stringArray});
        }
        this.checkAccess(objectName);
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final String[] stringArray2 = stringArray;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthorizationGroupDelegator.this.unsetAttributesAsSystem(session2, objectName2, stringArray2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    private void unsetAttributesAsSystem(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        super.unsetAttributes(session, objectName, stringArray);
    }

    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, objectName});
        }
        if (stringArray != null && stringArray.length == 1 && !stringArray[0].equals("name")) {
            this.checkAccess(objectName);
        } else if (stringArray != null && stringArray.length > 1) {
            this.checkAccess(objectName);
        }
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final String[] stringArray2 = stringArray;
        final boolean bl2 = bl;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            AttributeList attributeList = (AttributeList)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.getAttributesAsSystem(session2, objectName2, stringArray2, bl2);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttributes", attributeList);
            }
            return attributeList;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }

    private AttributeList getAttributesAsSystem(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        return super.getAttributes(session, objectName, stringArray, bl);
    }

    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, objectName, string});
        }
        if (string != null && !string.equals("name")) {
            this.checkAccess(objectName);
        }
        final Session session2 = session;
        final ObjectName objectName2 = objectName;
        final String string2 = string;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            Object object = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AuthorizationGroupDelegator.this.getAttributeAsSystem(session2, objectName2, string2);
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttribute", object);
            }
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }

    private Object getAttributeAsSystem(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        return super.getAttribute(session, objectName, string);
    }

    private void checkAccess(ObjectName objectName) throws ConfigServiceException {
        this.checkAccess(objectName, "adminsecuritymanager");
    }

    private void checkAccess(ObjectName objectName, String string) throws ConfigServiceException {
        if (objectName == null) {
            return;
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string2 = properties.getProperty("cell");
        String string3 = "cells/" + string2;
        AdminAuthorizer adminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer();
        if (adminAuthorizer != null && !adminAuthorizer.checkAccess(string3, string)) {
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0505E", new Object[]{objectName}, null);
            throw new ConfigServiceException(string4);
        }
    }
}

