/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpacePersistentObject;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class BaseServerDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(BaseServerDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    protected static final String SERVER_TYPE = "serverType";

    public BaseServerDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers"));
    }

    public AttributeList getAttributesMetaInfo(String string) throws InvalidConfigDataTypeException {
        AttributeList attributeList = super.getAttributesMetaInfo(string);
        AttributeList attributeList2 = MOFUtil.getAttributeMetaInfo("ServerEntry", TypeRegistry.getMetaObject("ServerEntry").getEStructuralFeature(SERVER_TYPE), null);
        attributeList.add(new Attribute(SERVER_TYPE, attributeList2));
        AttributeList attributeList3 = new AttributeList();
        attributeList3.add(new Attribute("_Attribute_MetaInfo_Name", "adjustPort"));
        attributeList3.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        attributeList3.add(new Attribute("_Attribute_MetaInfo_Type", "Boolean"));
        attributeList3.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        attributeList3.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        attributeList.add(new Attribute("adjustPort", attributeList3));
        return attributeList;
    }

    public ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, objectName, childTypeInfo, attributeList});
        }
        this.checkServerTypeAttr(attributeList);
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, "adjustPort");
            if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                EndpointConfigHelper.setAdjustFlag(new Boolean(false));
            }
            ConfigServiceHelper.removeAttribute(attributeList, "adjustPort");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        object = WorkspaceHelper.getContext(session, configDataId);
        ObjectName objectName2 = this.getTemplate(session, attributeList);
        ServerEntry serverEntry = EndpointConfigHelper.createServerEntry((RepositoryContext)object, this.getName(attributeList), objectName2);
        serverEntry.getDeployedApplications().clear();
        ObjectName objectName3 = super.createConfigObject(session, objectName, childTypeInfo, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", objectName3);
        }
        EndpointConfigHelper.setAdjustFlag(new Boolean(true));
        return objectName3;
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        repositoryContext = repositoryContext.getParent();
        String string = ConfigServiceHelper.getDisplayName(objectName);
        super.deleteConfigData(session, objectName);
        EndpointConfigHelper.deleteServerEntry(repositoryContext, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        this.checkServerTypeAttr(attributeList);
        super.setAttributes(session, objectName, attributeList);
    }

    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        this.checkServerTypeAttr(stringArray);
        super.unsetAttributes(session, objectName, stringArray);
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        this.checkServerTypeAttr(attributeList);
        super.resetAttributes(session, objectName, attributeList);
    }

    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        AttributeList attributeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        boolean bl2 = false;
        if (stringArray == null) {
            bl2 = true;
        } else {
            attributeList = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(SERVER_TYPE)) {
                    bl2 = true;
                    continue;
                }
                attributeList.add(stringArray[i]);
            }
            stringArray = new String[attributeList.size()];
            attributeList.toArray(stringArray);
        }
        attributeList = super.getAttributes(session, objectName, stringArray, bl);
        if (bl2) {
            String string = this.getServerType(session, objectName);
            attributeList.add(new Attribute(SERVER_TYPE, string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributeList);
        }
        return attributeList;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, objectName, string});
        }
        Object object = SERVER_TYPE.equals(string) ? this.getServerType(session, objectName) : super.getAttribute(session, objectName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return object;
    }

    public static void adjustPort(Session session, ConfigService configService, ObjectName objectName) throws ConfigServiceException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "adjustPort", new Object[]{session, configService, objectName});
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("_Websphere_Config_Data_Type", "EndPoint");
            ObjectName objectName2 = new ObjectName("WebSphere", hashtable);
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                WorkSpacePersistentObject workSpacePersistentObject = null;
                try {
                    EndPoint endPoint = (EndPoint)MOFUtil.convertToEObject(session, objectNameArray[i]);
                    int n = endPoint.getPort();
                    if (n == 0) continue;
                    endPoint.setPort(0);
                    Server server2 = (Server)MOFUtil.convertToEObject(session, objectName);
                    workSpacePersistentObject = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext();
                    endPoint.setPort(EndpointConfigHelper.adjustPort((RepositoryContext)workSpacePersistentObject, n, null));
                    continue;
                }
                catch (ConfigServiceException configServiceException) {
                    Tr.warning(tc, "ADMG0022W", new Object[]{configServiceException, workSpacePersistentObject.getName()});
                }
            }
        }
        catch (ConnectorException connectorException) {
            throw new ConfigServiceException(connectorException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new ConfigServiceException(malformedObjectNameException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustPort");
        }
    }

    private void checkServerTypeAttr(AttributeList attributeList) throws ReadOnlyAttributeException {
        try {
            Object object = ConfigServiceHelper.getAttributeValue(attributeList, SERVER_TYPE);
            throw new ReadOnlyAttributeException(SERVER_TYPE);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return;
        }
    }

    private void checkServerTypeAttr(String[] stringArray) throws ReadOnlyAttributeException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(SERVER_TYPE)) continue;
            throw new ReadOnlyAttributeException(SERVER_TYPE);
        }
    }

    private String getServerType(Session session, ObjectName objectName) throws ConfigServiceException {
        return EndpointConfigHelper.getServerType(WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(objectName)));
    }
}

