/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ClusterMemberDelegator
extends ConfigServiceDelegator {
    private static TraceComponent tc = Tr.register(ClusterMemberDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public ClusterMemberDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl);
    }

    public String getType() {
        return "ClusterMember";
    }

    public AttributeList getAttributesMetaInfo(String string) throws InvalidConfigDataTypeException {
        AttributeList attributeList = super.getAttributesMetaInfo(string);
        AttributeList attributeList2 = new AttributeList();
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Name", "adjustPort"));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Type", "Boolean"));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        attributeList.add(new Attribute("adjustPort", attributeList2));
        return attributeList;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        try {
            Object object = ConfigServiceHelper.getAttributeValue(attributeList, "adjustPort");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "val: " + object);
            }
            if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                EndpointConfigHelper.setAdjustFlag(new Boolean(false));
            }
            ConfigServiceHelper.removeAttribute(attributeList, "adjustPort");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        super.setAttributes(session, objectName, attributeList);
        EndpointConfigHelper.setAdjustFlag(new Boolean(true));
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        String string = null;
        String string2 = null;
        ObjectName objectName2 = null;
        String string3 = null;
        try {
            ObjectName[] objectNameArray2;
            string = (String)this.baseConfigService.getAttribute(session, objectName, "memberName");
            string2 = (String)this.baseConfigService.getAttribute(session, objectName, "nodeName");
            super.deleteConfigData(session, objectName);
            objectNameArray = this.baseConfigService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(null, "Node", string2), null);
            if (objectNameArray.length > 0 && (objectNameArray2 = this.baseConfigService.queryConfigObjects(session, objectNameArray[0], ConfigServiceHelper.createObjectName(null, "Server", string), null)).length > 0) {
                objectName2 = objectNameArray2[0];
                string3 = (String)this.baseConfigService.getAttribute(session, objectName2, "clusterName");
                this.baseConfigService.deleteConfigData(session, objectName2);
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMG0028W", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "memberName = " + string + " nodeName = " + string2 + " clusterName = " + string3 + " clusterMemberObj = " + objectName2);
        }
        objectNameArray = null;
        try {
            objectNameArray = ClusterConfigHelper.getClusterObj(this.baseConfigService, session, string3);
        }
        catch (ConnectorException connectorException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData");
            }
            throw new ConfigServiceException(connectorException);
        }
        if (string2 != null && string3 != null && objectNameArray != null) {
            try {
                ClusterConfigHelper.deleteMemberTemplate(this.baseConfigService, session, string3, (ObjectName)objectNameArray, string2);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception thrown by deleteMemberTemplate");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteConfigData");
                }
                throw new ConfigServiceException(exception);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not try to delete member template!");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }
}

