/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public abstract class ConfigObjectDelegator
extends ConfigServiceDelegator {
    private static TraceComponent tc = Tr.register(ConfigObjectDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    protected final String PARENT = "parent";
    protected Set parentTypes = new HashSet();
    protected List childTypes = new ArrayList();

    public ConfigObjectDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl);
    }

    protected abstract ObjectName[] getChildren(Session var1, ObjectName var2, ChildTypeInfo var3) throws ConfigServiceException;

    protected abstract ObjectName createConfigObject(Session var1, ObjectName var2, ChildTypeInfo var3, AttributeList var4) throws ConfigServiceException;

    protected abstract ObjectName getParent(Session var1, ObjectName var2) throws ConfigServiceException;

    public AttributeList getRelationshipsMetaInfo(String string) throws InvalidConfigDataTypeException {
        Iterator iterator;
        AttributeList attributeList = new AttributeList();
        if (this.parentTypes.size() > 0) {
            iterator = new AttributeList();
            ((AttributeList)((Object)iterator)).add(new Attribute("_Attribute_MetaInfo_Name", "parent"));
            ((AttributeList)((Object)iterator)).add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
            ((AttributeList)((Object)iterator)).add(new Attribute("_Attribute_MetaInfo_Type", new ArrayList(this.parentTypes)));
            attributeList.add(new Attribute("parent", iterator));
        }
        if (tc.isDebugEnabled() && this.parentTypes.size() > 0) {
            iterator = this.parentTypes.iterator();
            while (iterator.hasNext()) {
                Tr.debug(tc, "parent ", iterator.next());
            }
        }
        iterator = this.childTypes.iterator();
        while (iterator.hasNext()) {
            ChildTypeInfo childTypeInfo = (ChildTypeInfo)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "child ", childTypeInfo);
            }
            AttributeList attributeList2 = new AttributeList();
            attributeList2.add(new Attribute("_Attribute_MetaInfo_Name", childTypeInfo.getRelationshipName()));
            attributeList2.add(new Attribute("_Attribute_MetaInfo_Type", childTypeInfo.getChildDelegator().getType()));
            attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Collection", new Boolean(childTypeInfo.isCollection())));
            attributeList.add(new Attribute(childTypeInfo.getRelationshipName(), attributeList2));
        }
        return attributeList;
    }

    public ObjectName[] getRelationship(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{objectName, string});
        }
        if (string.equals("parent")) {
            ObjectName objectName2 = this.getParent(session, objectName);
            objectNameArray = new ObjectName[]{objectName2};
        } else {
            ChildTypeInfo childTypeInfo = this.getChildInfo(string);
            objectNameArray = childTypeInfo.getChildDelegator().getChildren(session, objectName, childTypeInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, objectName, string, attributeList});
        }
        ChildTypeInfo childTypeInfo = null;
        try {
            childTypeInfo = this.getChildInfo(string);
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            // empty catch block
        }
        ObjectName objectName2 = childTypeInfo != null ? childTypeInfo.getChildDelegator().createConfigObject(session, objectName, childTypeInfo, attributeList) : this.baseConfigService.createConfigDataBasic(session, objectName, string, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", new Object[]{objectName2});
        }
        return objectName2;
    }

    public void removeElement(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException {
        try {
            ChildTypeInfo childTypeInfo = this.getChildInfo(string);
            throw new UnsupportedOperationException();
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            this.baseConfigService.removeElementBasic(session, objectName, string, object);
            return;
        }
    }

    protected final void registerChildType(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "regsiterChildType", new Object[]{string, this.getType()});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "child type", new Object[]{configObjectDelegator.getType()});
        }
        this.childTypes.add(new ChildTypeInfo(string, bl, configObjectDelegator));
        configObjectDelegator.registerParentType(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "regsiterChildType");
        }
    }

    protected final void registerParentType(ConfigObjectDelegator configObjectDelegator) {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "regsiterParentType", new Object[]{configObjectDelegator.getType()});
        }
        if ((list = configObjectDelegator.getTypes()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "type ", string);
            }
        }
        if (list != null) {
            this.parentTypes.addAll(list);
        } else {
            this.parentTypes.add(configObjectDelegator.getType());
        }
    }

    protected ObjectName getMOFParent(Session session, ObjectName objectName) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        return docAccessor.getParent(session, configDataId);
    }

    protected ChildTypeInfo getChildInfo(String string) throws InvalidAttributeNameException {
        ChildTypeInfo childTypeInfo = null;
        Iterator iterator = this.childTypes.iterator();
        while (iterator.hasNext()) {
            ChildTypeInfo childTypeInfo2 = (ChildTypeInfo)iterator.next();
            if (!childTypeInfo2.getRelationshipName().equals(string)) continue;
            childTypeInfo = childTypeInfo2;
            break;
        }
        if (childTypeInfo == null) {
            throw new InvalidAttributeNameException(string);
        }
        return childTypeInfo;
    }

    protected List getTypedDocuments(RepositoryContext repositoryContext, String string) {
        List list = repositoryContext.getAllList(true);
        ArrayList<WorkSpaceFile> arrayList = new ArrayList<WorkSpaceFile>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
            if (!workSpaceFile.getFileName().equals(string)) continue;
            arrayList.add(workSpaceFile);
        }
        return arrayList;
    }

    protected ObjectName createObjectName(RepositoryContext repositoryContext) {
        return MOFUtil.createObjectName(repositoryContext);
    }

    protected static class ChildTypeInfo {
        private String relationshipName;
        private boolean isCollection;
        private ConfigObjectDelegator childDelegator;

        public ChildTypeInfo(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
            this.relationshipName = string;
            this.isCollection = bl;
            this.childDelegator = configObjectDelegator;
        }

        public String getRelationshipName() {
            return this.relationshipName;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public ConfigObjectDelegator getChildDelegator() {
            return this.childDelegator;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object != null && object instanceof ChildTypeInfo) {
                bl = this.relationshipName.equals(((ChildTypeInfo)object).relationshipName);
            }
            return bl;
        }

        public int hashcode() {
            return this.relationshipName.hashCode();
        }
    }
}

