/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.UnsupportedCryptoAlgorithmException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.SessionPropertyConstants;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigDocumentSaveException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.MalformedContainmentPathException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.management.configservice.AuthorizationGroupDelegator;
import com.ibm.ws.management.configservice.AuthorizationTableExtDelegator;
import com.ibm.ws.management.configservice.CMPConnectorFactoryDelegator;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.ClusterMemberDelegator;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceUtils;
import com.ibm.ws.management.configservice.DataSourceDelegator;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.HttpTransportDelegator;
import com.ibm.ws.management.configservice.InnerConfigObjectDelegator;
import com.ibm.ws.management.configservice.J2CActivationSpecDelegator;
import com.ibm.ws.management.configservice.J2CAdminObjectDelegator;
import com.ibm.ws.management.configservice.J2CConnectionFactoryDelegator;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.NodeDelegator;
import com.ibm.ws.management.configservice.PortletCachingDelegator;
import com.ibm.ws.management.configservice.ResourceProviderDelegator;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.SSLConfigDelegator;
import com.ibm.ws.management.configservice.SecureSocketLayerDelegator;
import com.ibm.ws.management.configservice.SecurityDelegator;
import com.ibm.ws.management.configservice.ServerClusterDelegator;
import com.ibm.ws.management.configservice.ServerDelegator;
import com.ibm.ws.management.configservice.ServletCachingDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.VariableMapDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.configservice.csmetadata.ConfigServiceMetadata;
import com.ibm.ws.management.configservice.csmetadata.ConnectionFactoryType;
import com.ibm.ws.management.configservice.csmetadata.ResourceProviderType;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.validation.ContextValidationMessages;
import com.ibm.ws.sm.validation.DocumentValidationMessages;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidatorValidationMessages;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ConfigServiceImpl
implements ConfigService,
SessionPropertyConstants {
    private static TraceComponent tc = Tr.register(ConfigServiceImpl.class, "management", "com.ibm.ws.management.resources.configservice");
    private static ConfigServiceImpl instance = null;
    private static HashMap sessionProps = new HashMap();
    private boolean forceEncode = false;
    private static String KEY_RING_PASSWORD = "KeyRingPassword";
    private final HashMap delegatorTable = new HashMap();
    private AppManagement appMgr = null;
    private boolean initialized = false;
    private Properties props;
    private static String PROPERTY_SET_ATTR_NAME = "propertySet";
    private static String WEBSPHERE_CONFIG_DATA_ID = "_Websphere_Config_Data_Id";
    private static String WEBSPHERE_CONFIG_DATA_TYPE = "_Websphere_Config_Data_Type";
    private static String SUPER_ADMIN_PASSWORD = "superAdminPassword";
    private static String J2EE_RESOURCE_PROPERTY_SET = "J2EEResourcePropertySet";
    private static String J2EE_RESOURCE_PROPERTY = "J2EEResourceProperty";
    private static String ATTRIBUTE_VALUE = "value";

    public ConfigServiceImpl(Properties properties) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceImpl");
        }
        instance = this;
        if (properties == null) {
            properties = new Properties();
        }
        this.props = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceImpl");
        }
    }

    private synchronized void initialize() {
        ConfigObjectDelegator configObjectDelegator;
        Object object;
        Object object2;
        if (this.initialized) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        this.initialized = true;
        String string = this.props.getProperty("location");
        if (string != null && string.equalsIgnoreCase("local")) {
            ModelMgr.initialize("ws-server");
        }
        try {
            RepositoryMetaDataFactory.initialize();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", "62", this);
            Tr.error(tc, "ADMG0011E", exception);
        }
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        this.registerDelegator(new NodeDelegator(this));
        this.registerDelegator(new ServerDelegator(this));
        this.registerDelegator(new AuthorizationTableExtDelegator(this));
        this.registerDelegator(new ServerClusterDelegator(this));
        this.registerDelegator(new DataSourceDelegator(this));
        this.registerDelegator(new ClusterMemberDelegator(this));
        this.registerDelegator(new SecurityDelegator(this));
        this.registerDelegator(new J2CConnectionFactoryDelegator(this));
        this.registerDelegator(new J2CAdminObjectDelegator(this));
        this.registerDelegator(new J2CActivationSpecDelegator(this));
        this.registerDelegator(new CMPConnectorFactoryDelegator(this));
        this.registerDelegator(new VariableMapDelegator(this));
        this.registerDelegator(new HttpTransportDelegator(this));
        this.registerDelegator(new SSLConfigDelegator(this));
        this.registerDelegator(new SecureSocketLayerDelegator(this));
        this.registerDelegator(new AuthorizationGroupDelegator(this));
        this.registerDelegator(new PortletCachingDelegator(this));
        this.registerDelegator(new ServletCachingDelegator(this));
        this.registerRootConfigObjectDelegator(null, repositoryMetaData.getContextType("cells"));
        this.registerRootConfigObjectDelegator(null, repositoryMetaData.getContextType("templates"));
        ConfigServiceMetadata configServiceMetadata = CSMetadataMgr.getConfigServiceMetadata();
        EList eList = configServiceMetadata.getResourceProviderTypes();
        for (int i = 0; i < eList.size(); ++i) {
            object2 = (String[])eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerType" + eList);
            }
            object = object2.getTypeName();
            configObjectDelegator = (RootObjectDelegator)this.getDelegator((String)(object = TypeRegistry.getShortType((String)object)));
            if (configObjectDelegator == null) continue;
            EList eList2 = object2.getConnectionFactoryTypes();
            for (int j = 0; j < eList2.size(); ++j) {
                ConnectionFactoryType connectionFactoryType = (ConnectionFactoryType)eList2.get(j);
                InnerConfigObjectDelegator innerConfigObjectDelegator = new InnerConfigObjectDelegator(this, TypeRegistry.getShortType(connectionFactoryType.getTypeName()), "factories");
                innerConfigObjectDelegator = (InnerConfigObjectDelegator)this.registerDelegatorIfNec(innerConfigObjectDelegator);
                configObjectDelegator.registerChildType(innerConfigObjectDelegator.getType(), true, innerConfigObjectDelegator);
            }
        }
        RootObjectDelegator rootObjectDelegator = (RootObjectDelegator)this.getDelegator("J2CResourceAdapter");
        if (rootObjectDelegator != null) {
            object2 = new InnerConfigObjectDelegator(this, "J2CAdminObject", null);
            object2 = (InnerConfigObjectDelegator)this.registerDelegatorIfNec((ConfigServiceDelegator)object2);
            rootObjectDelegator.registerChildType(((InnerConfigObjectDelegator)object2).getType(), true, (ConfigObjectDelegator)object2);
            object = new InnerConfigObjectDelegator(this, "J2CActivationSpec", null);
            object = (InnerConfigObjectDelegator)this.registerDelegatorIfNec((ConfigServiceDelegator)object);
            rootObjectDelegator.registerChildType(((InnerConfigObjectDelegator)object).getType(), true, (ConfigObjectDelegator)object);
        }
        try {
            object2 = TypeRegistry.getSubTypes("ServerComponent");
            for (int i = 0; i < ((String[])object2).length; ++i) {
                configObjectDelegator = new InnerConfigObjectDelegator(this, (String)object2[i], "components");
                this.registerTypeAtServer(((InnerConfigObjectDelegator)configObjectDelegator).getType(), true, configObjectDelegator);
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            FFDCFilter.processException((Throwable)invalidConfigDataTypeException, "com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", "91", this);
            Tr.error(tc, "ADMG0011E", invalidConfigDataTypeException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void registerRootConfigObjectDelegator(ConfigObjectDelegator configObjectDelegator, RepositoryContextType repositoryContextType) {
        Iterator iterator;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerRootConfigObjectDelegator", new Object[]{configObjectDelegator, repositoryContextType});
        }
        RepositoryDocumentType repositoryDocumentType = repositoryContextType.getRootDocumentType();
        List list = repositoryContextType.getChildDocumentTypes();
        RootObjectDelegator rootObjectDelegator = null;
        ConfigServiceMetadata configServiceMetadata = CSMetadataMgr.getConfigServiceMetadata();
        EList eList = configServiceMetadata.getResourceProviderTypes();
        ArrayList<String> arrayList = new ArrayList<String>(eList.size());
        Object object2 = eList.iterator();
        while (object2.hasNext()) {
            object = (ResourceProviderType)object2.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "providerType" + eList);
            }
            iterator = object.getTypeName();
            iterator = TypeRegistry.getShortType((String)((Object)iterator));
            arrayList.add((String)((Object)iterator));
        }
        if (repositoryDocumentType != null && repositoryDocumentType.getRootRefObjectTypes().length > 0) {
            Object object3;
            Object object4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rootDocumentType name ", repositoryDocumentType.getFilePattern());
            }
            rootObjectDelegator = new RootObjectDelegator(this, repositoryContextType);
            rootObjectDelegator = (RootObjectDelegator)this.registerDelegatorIfNec(rootObjectDelegator);
            object2 = rootObjectDelegator.getTypes();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Type of object  ", rootObjectDelegator.getType());
            }
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    iterator = (String)object.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating delegator  ", iterator);
                    }
                    object4 = new RootObjectDelegator(this, (String)((Object)iterator), repositoryContextType.getRootDocumentType());
                    object4 = (RootObjectDelegator)this.registerDelegatorIfNec((ConfigServiceDelegator)object4);
                    if (configObjectDelegator == null) continue;
                    configObjectDelegator.registerChildType(((RootObjectDelegator)object4).getType(), true, (ConfigObjectDelegator)object4);
                }
            }
            object = null;
            if (configObjectDelegator != null) {
                object = configObjectDelegator.getTypes();
            }
            if (object != null && object.size() > 0) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object4 = (String)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Child of  ", object4);
                    }
                    object3 = (RootObjectDelegator)this.getDelegator((String)object4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Child of  ", object3);
                    }
                    ((ConfigObjectDelegator)object3).registerChildType(rootObjectDelegator.getType(), true, rootObjectDelegator);
                }
            } else if (configObjectDelegator != null) {
                configObjectDelegator.registerChildType(rootObjectDelegator.getType(), true, rootObjectDelegator);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object4 = (RepositoryDocumentType)iterator.next();
                if (object4.equals(repositoryDocumentType) || (object3 = object4.getRootRefObjectTypes()) == null) continue;
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    RootObjectDelegator rootObjectDelegator2 = (RootObjectDelegator)this.getDelegator((String)object3[i]);
                    if (rootObjectDelegator2 == null) {
                        rootObjectDelegator2 = arrayList.contains(object3[i]) ? new ResourceProviderDelegator(this, (String)object3[i], (RepositoryDocumentType)object4) : new RootObjectDelegator(this, (String)object3[i], (RepositoryDocumentType)object4);
                        rootObjectDelegator2 = (RootObjectDelegator)this.registerDelegatorIfNec(rootObjectDelegator2);
                    }
                    rootObjectDelegator.registerChildType(rootObjectDelegator2.getType(), true, rootObjectDelegator2);
                }
            }
        }
        object2 = repositoryContextType.getChildContextTypes();
        object = object2.iterator();
        while (object.hasNext()) {
            iterator = (RepositoryContextType)object.next();
            this.registerRootConfigObjectDelegator(rootObjectDelegator, (RepositoryContextType)((Object)iterator));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerRootConfigObjectDelegator");
        }
    }

    AppManagement getAppManagement() {
        if (this.appMgr == null) {
            try {
                this.appMgr = AdminServiceFactory.getAdminService() != null ? AppManagementProxy.getJMXProxyForServer() : AppManagementProxy.getLocalProxy();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.getAppManagement", "193", this);
                Tr.error(tc, "ADMG0011E", new Object[]{exception});
            }
        }
        return this.appMgr;
    }

    public void registerTypeAtCell(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
        configObjectDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(configObjectDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Cell")).registerChildType(string, bl, configObjectDelegator);
    }

    public void registerTypeAtNode(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
        configObjectDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(configObjectDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Node")).registerChildType(string, bl, configObjectDelegator);
    }

    public void registerTypeAtServer(String string, boolean bl, ConfigObjectDelegator configObjectDelegator) {
        configObjectDelegator = (ConfigObjectDelegator)this.registerDelegatorIfNec(configObjectDelegator);
        ((ConfigObjectDelegator)this.getDelegator("Server")).registerChildType(string, bl, configObjectDelegator);
    }

    public void setProperties(Session session, HashMap hashMap) throws ConfigServiceException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, hashMap});
        }
        this.initialize();
        Integer n = hashMap.put("VALIDATION_LEVEL", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validationLevel", n);
        }
        Boolean bl = hashMap.put("ENABLE_CROSS_VALIDATION", null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableCrossValidation", bl);
        }
        if (n != null || bl != null) {
            object2 = WorkspaceHelper.getValidationManager(session);
            object = object2.getPolicy();
            if (bl != null) {
                object.setIncludeCross(bl);
            }
            if (NO_VALIDATION.equals(n)) {
                object.setIncludeExtracted(false);
                object.setIncludeParentChain(false);
                object.setIncludeLocalSiblings(false);
                object.setIncludeAll(false);
            } else if (LOW_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(true);
                object.setIncludeParentChain(false);
                object.setIncludeLocalSiblings(false);
                object.setIncludeAll(false);
            } else if (MEDIUM_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(true);
                object.setIncludeParentChain(true);
                object.setIncludeLocalSiblings(false);
                object.setIncludeAll(false);
            } else if (HIGH_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(true);
                object.setIncludeParentChain(true);
                object.setIncludeLocalSiblings(true);
                object.setIncludeAll(false);
            } else if (HIGHEST_LEVEL_VALIDATION.equals(n)) {
                object.setIncludeExtracted(false);
                object.setIncludeParentChain(false);
                object.setIncludeLocalSiblings(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "set enable to be all");
                }
                object.setIncludeAll(true);
            }
            try {
                object.affectUpdate();
            }
            catch (ValidationManagerException validationManagerException) {
                FFDCFilter.processException((Throwable)validationManagerException, "com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", "213", this);
                throw new ConfigServiceException(validationManagerException);
            }
        }
        object2 = (Locale)hashMap.get("LOCALE");
        object = (Properties)sessionProps.get(session);
        if (object == null) {
            object = new Properties();
            sessionProps.put(session, object);
        }
        if (object2 != null) {
            ((Properties)object).put("LOCALE", object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    Object getSessionProperty(Session session, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionProperty", new Object[]{session, string});
        }
        Properties properties = (Properties)sessionProps.get(session);
        Object object = null;
        if (properties != null) {
            object = properties.get(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionProperty");
        }
        return object;
    }

    public ValidationResult validate(Session session, ObjectName objectName) throws ConfigServiceException {
        RepositoryContext repositoryContext;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, objectName});
        }
        this.initialize();
        if (objectName == null) {
            object = WorkspaceHelper.getWorkspace(session);
            repositoryContext = object.getRootContext();
        } else {
            object = ConfigServiceHelper.getConfigDataId(objectName);
            repositoryContext = WorkspaceHelper.getContext(session, (ConfigDataId)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "context" + repositoryContext.getURI());
        }
        try {
            object = WorkspaceHelper.getValidationManager(session);
            ContextValidationMessages contextValidationMessages = object.getResults(repositoryContext);
            ValidationResult validationResult = new ValidationResult();
            Locale locale = (Locale)this.getSessionProperty(session, "LOCALE");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client locale", locale);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Iterator iterator = contextValidationMessages.getDocumentMessages();
            while (iterator.hasNext()) {
                DocumentValidationMessages documentValidationMessages = (DocumentValidationMessages)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "documentMsgs", documentValidationMessages);
                }
                Iterator iterator2 = documentValidationMessages.getValidatorMessages();
                while (iterator2.hasNext()) {
                    ValidatorValidationMessages validatorValidationMessages = (ValidatorValidationMessages)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validatorMsgs", validatorValidationMessages);
                    }
                    Iterator iterator3 = validatorValidationMessages.getMessages();
                    while (iterator3.hasNext()) {
                        IMessage iMessage = (IMessage)iterator3.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "msg", iMessage);
                        }
                        String string = iMessage.getText(locale);
                        Object object2 = iMessage.getTargetObject();
                        if (object2 instanceof EObject) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "targetObject", object2);
                            }
                            try {
                                object2 = MOFUtil.createObjectName((EObject)object2);
                            }
                            catch (Exception exception) {
                                object2 = object2.toString();
                            }
                        } else if (object2 != null) {
                            object2 = object2.toString();
                        }
                        ValidationResult.ValidationMessage validationMessage = new ValidationResult.ValidationMessage(string, object2, iMessage.getSeverity(), iMessage.getLineNumber());
                        validationResult.addMessage(documentValidationMessages.getDocumentFullUri(), validatorValidationMessages.getValidatorClassName(), validationMessage);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate", validationResult);
            }
            return validationResult;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.ConfigServiceImpl.ConfigServiceImpl", "277", this);
            String string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0017E", new Object[]{session, objectName}, null);
            throw new ConfigServiceException(exception, string);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        this.initialize();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        List list = workSpace.getModifiedList();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = ((WorkSpaceFile)list.get(i)).getURI();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", stringArray);
        }
        return stringArray;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        this.initialize();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        try {
            map = workSpace.checkSynchState();
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException((Throwable)workSpaceException, "com.ibm.ws.management.configservice.ConfigServiceImpl.getConflictDocuments", "164", this);
            throw new ConfigServiceException(workSpaceException, workSpaceException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", map);
        }
        return map;
    }

    public void save(Session session, boolean bl) throws ConfigServiceException {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "save", session);
            }
            this.initialize();
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            Subject subject = SecurityHelper.retrieveSubject();
            boolean bl2 = false;
            try {
                Object object;
                Object object2;
                Object object3;
                Subject subject2 = null;
                if (AdminServiceFactory.getAdminService() != null && subject != null) {
                    object3 = workSpace.getModifiedList();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = ((WorkSpaceFile)object2.next()).getURI();
                        if (!RestrictedAccess.isRestricted((String)object)) continue;
                        bl2 = true;
                        break;
                    }
                    if ((object2 = AdminAuthorizerFactory.getAdminAuthorizer()) != null && object2.isFineGrainedAdminSecurity()) {
                        bl2 = true;
                    }
                    if (bl2) {
                        try {
                            subject2 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public Object run() {
                                    return SecurityHelper.getOwnedSubject();
                                }
                            });
                        }
                        catch (Exception exception) {
                            throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
                        }
                    }
                }
                if (bl2 && subject2 != null) {
                    object3 = workSpace;
                    boolean bl3 = bl;
                    try {
                        ContextManagerFactory.getInstance().runAsSpecified(subject2, new PrivilegedExceptionAction((WorkSpace)object3, bl3){
                            private final /* synthetic */ WorkSpace val$workspaceFinal;
                            private final /* synthetic */ boolean val$overwriteOnConflictFinal;
                            {
                                this.val$workspaceFinal = workSpace;
                                this.val$overwriteOnConflictFinal = bl;
                            }

                            public Object run() throws Exception {
                                Object var1_1 = null;
                                Map map = this.val$workspaceFinal.checkSynchState();
                                ArrayList arrayList = new ArrayList(map.keySet());
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    Object e2 = iterator.next();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "conflict uri" + e2);
                                    }
                                    if (this.val$overwriteOnConflictFinal) {
                                        map.put(e2, ConflictResolution.OVER_WRITE);
                                        continue;
                                    }
                                    map.remove(e2);
                                }
                                this.val$workspaceFinal.synch(map);
                                return var1_1;
                            }
                        });
                        break block16;
                    }
                    catch (Exception exception) {
                        throw new ConfigServiceException(exception);
                    }
                }
                object3 = workSpace.checkSynchState();
                object2 = new ArrayList(object3.keySet());
                object = object2.iterator();
                while (object.hasNext()) {
                    Object e2 = object.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "conflict uri" + e2);
                    }
                    if (bl) {
                        object3.put(e2, ConflictResolution.OVER_WRITE);
                        continue;
                    }
                    object3.remove(e2);
                }
                workSpace.synch((Map)object3);
            }
            catch (WorkSpaceException workSpaceException) {
                FFDCFilter.processException((Throwable)workSpaceException, "com.ibm.ws.management.configservice.ConfigServiceImpl.save", "191", this);
                throw new ConfigServiceException(workSpaceException, workSpaceException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save", session);
        }
    }

    public void discard(Session session) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "discard", session);
            }
            this.initialize();
            try {
                WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
                ValidationManagerRegistry validationManagerRegistry = ValidationHelper.getRegistry();
                validationManagerRegistry.release(WorkspaceHelper.getWorkspace(session));
                workSpaceManager.removeWorkSpace(session.toString());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.ConfigServiceImpl.discard", "207", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "unexpected exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard");
        }
    }

    private ConfigServiceDelegator registerDelegatorIfNec(ConfigServiceDelegator configServiceDelegator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerDelegatorIfNec", configServiceDelegator);
        }
        if (this.delegatorTable.get(configServiceDelegator.getType()) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "register delegator for type " + configServiceDelegator.getType());
            }
            this.delegatorTable.put(configServiceDelegator.getType(), configServiceDelegator);
        } else {
            configServiceDelegator = (ConfigServiceDelegator)this.delegatorTable.get(configServiceDelegator.getType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerDelegatorIfNec", configServiceDelegator);
        }
        return configServiceDelegator;
    }

    public void registerDelegator(ConfigServiceDelegator configServiceDelegator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerDelegator", new Object[]{configServiceDelegator.getType(), configServiceDelegator});
        }
        this.delegatorTable.put(configServiceDelegator.getType(), configServiceDelegator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerDelegator");
        }
    }

    public String[] getSupportedConfigObjectTypes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        this.initialize();
        Set set = TypeRegistry.getAllTypes();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", stringArray);
        }
        return stringArray;
    }

    public AttributeList getAttributesMetaInfo(String string) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", string);
        }
        this.initialize();
        AttributeList attributeList = null;
        ConfigServiceDelegator configServiceDelegator = (ConfigServiceDelegator)this.delegatorTable.get(string);
        attributeList = configServiceDelegator == null ? this.getAttributesMetaInfoBasic(string) : configServiceDelegator.getAttributesMetaInfo(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", attributeList);
        }
        return attributeList;
    }

    public AttributeList getRelationshipsMetaInfo(String string) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", string);
        }
        this.initialize();
        AttributeList attributeList = null;
        ConfigServiceDelegator configServiceDelegator = (ConfigServiceDelegator)this.delegatorTable.get(string);
        attributeList = configServiceDelegator == null ? this.getRelationshipsMetaInfoBasic(string) : configServiceDelegator.getRelationshipsMetaInfo(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", attributeList);
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] queryTemplates(Session session, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "qeuryTemplates", new Object[]{session, string});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        ObjectName[] objectNameArray = null;
        try {
            RepositoryContext repositoryContext;
            Object object;
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session2);
            try {
                object = TemplateManagerFactory.getManager(workSpace);
                repositoryContext = object.getRootTemplateContext();
            }
            catch (WorkSpaceException workSpaceException) {
                throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
            }
            object = MOFUtil.createObjectName(repositoryContext);
            objectNameArray = this.getAllBasic(session2, (ObjectName)object, string, false);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", objectNameArray);
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] queryConfigObjects(Session session, ObjectName objectName, ObjectName objectName2, QueryExp queryExp) throws ConfigServiceException {
        ObjectName[] objectNameArray;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "queryConfigObjects", new Object[]{session, objectName, objectName2, queryExp});
            }
            this.initialize();
            Session session2 = session;
            if (session2 == null) {
                session2 = new Session();
            }
            objectNameArray = null;
            try {
                ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName2);
                if (configDataId != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configId", configDataId);
                    }
                    ObjectName objectName3 = null;
                    try {
                        objectName3 = WorkspaceHelper.getDocAccessor(session2, configDataId).resolveObjectName(session2, configDataId);
                    }
                    catch (Exception exception) {
                        objectName3 = null;
                    }
                    if (objectName3 == null) {
                        ObjectName[] objectNameArray2 = null;
                        return objectNameArray2;
                    }
                    if (ConfigServiceHelper.getDisplayName(objectName3) == null && ConfigServiceHelper.getDisplayName(objectName2) != null) {
                        objectName3 = ConfigServiceHelper.createObjectName(ConfigServiceHelper.getConfigDataId(objectName3), ConfigServiceHelper.getConfigDataType(objectName3), ConfigServiceHelper.getDisplayName(objectName2));
                    }
                    objectNameArray = new ObjectName[]{objectName3};
                    break block16;
                }
                ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName2);
                String string = ConfigServiceHelper.getDisplayName(objectName2);
                ObjectName[] objectNameArray3 = configServiceDelegator == null ? this.getAllBasic(session2, objectName, ConfigServiceHelper.getConfigDataType(objectName2), true) : (configServiceDelegator instanceof RootObjectDelegator && string != null ? ((RootObjectDelegator)configServiceDelegator).getAll(session2, objectName, string) : configServiceDelegator.getAll(session2, objectName));
                ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>(objectNameArray3.length);
                for (int i = 0; i < objectNameArray3.length; ++i) {
                    if (string != null && !string.equals(ConfigServiceHelper.getDisplayName(objectNameArray3[i]))) continue;
                    arrayList.add(objectNameArray3[i]);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName4 = (ObjectName)iterator.next();
                    if (this.checkAccess(session2, objectName4)) continue;
                    iterator.remove();
                }
                objectNameArray = new ObjectName[arrayList.size()];
                arrayList.toArray(objectNameArray);
            }
            finally {
                if (session == null) {
                    this.discard(session2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, string});
        }
        return this.resolve(session, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] resolve(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, objectName, string});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        ArrayList arrayList = new ArrayList();
        try {
            AttributeList attributeList;
            boolean bl;
            block13: {
                bl = false;
                try {
                    if (string.indexOf("/") != -1 || string.indexOf("[") != -1) {
                        attributeList = this.parseXPathContainment(string);
                        this.resolveXPath(session2, objectName, attributeList, arrayList);
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Exception caught while parsing XPath", throwable);
                }
            }
            if (!bl) {
                attributeList = this.parseContainmentPath(string);
                Attribute attribute = (Attribute)attributeList.remove(0);
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, attribute.getName(), (String)attribute.getValue());
                if (objectName2 == null) {
                    throw new MalformedContainmentPathException(string, attribute.getName());
                }
                ObjectName[] objectNameArray2 = this.queryConfigObjects(session2, objectName, objectName2, null);
                for (int i = 0; objectNameArray2 != null && i < objectNameArray2.length; ++i) {
                    this.resolve(session2, objectNameArray2[i], (AttributeList)attributeList.clone(), arrayList);
                }
            }
            objectNameArray = new ObjectName[arrayList.size()];
            arrayList.toArray(objectNameArray);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", objectNameArray);
        }
        return objectNameArray;
    }

    private boolean doesAttrListContainSuperAdminPassword(AttributeList attributeList) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesAttrListContainSuperAdminPassword ", new Boolean(bl));
        }
        if (null != attributeList) {
            for (int i = 0; i < attributeList.size(); ++i) {
                String string;
                String string2;
                Attribute attribute = (Attribute)attributeList.get(i);
                Tr.debug(tc, "attr.getName()=" + attribute.getName());
                Tr.debug(tc, "attr.getValue()=" + attribute.getValue());
                if (null == attribute || null == (string2 = attribute.getName()) || !string2.equals("name") || null == attribute.getValue() || !(string = attribute.getValue().toString()).equals(SUPER_ADMIN_PASSWORD)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesAttrListContainSuperAdminPassword ", new Boolean(bl));
        }
        return bl;
    }

    private boolean shouldModifyEncodedSuperAdminPassword(Session session, ObjectName objectName) throws ConfigServiceException {
        ObjectName objectName2;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldModifyEncodedSuperAdminPassword", new Boolean(bl));
        }
        if (null != (objectName2 = this.findMatchingJ2EEResPropSetforJ2EEResProperty(session, objectName))) {
            boolean bl2 = bl = this.isPropertySetAResEnvProvAttr(session, objectName2) && this.isSuperAdminPasswordAlreadyEncoded(session, objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shouldModifyEncodedSuperAdminPassword", new Boolean(bl));
        }
        return bl;
    }

    private boolean isSuperAdminPasswordAlreadyEncoded(Session session, ObjectName objectName) throws ConfigServiceException {
        String string;
        ObjectName objectName2;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSuperAdminPasswordAlreadyEncoded", new Boolean(bl));
        }
        if (null != (objectName2 = this.findMatchingJ2EEResPropSetforJ2EEResProperty(session, objectName))) {
            bl = this.isPropertySetAResEnvProvAttr(session, objectName2);
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resPropId=", configDataId);
        }
        if ((string = configDataId.toString()).indexOf(J2EE_RESOURCE_PROPERTY) != -1) {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            String string2 = null;
            String string3 = null;
            try {
                string2 = (String)configService.getAttribute(session, objectName, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrName=", string2);
                }
                if (null != string2 && string2.equals(SUPER_ADMIN_PASSWORD)) {
                    string3 = (String)configService.getAttribute(session, objectName, "value");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attrValue=", string3);
                    }
                    if (null != string3) {
                        String string4 = PasswordUtil.getCryptoAlgorithm(string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "algorithm=" + string4);
                            Tr.debug(tc, "PasswordUtil.isValidCryptoAlgorithm(algorithm)=" + PasswordUtil.isValidCryptoAlgorithm(string4));
                        }
                        if (null != string4 && PasswordUtil.isValidCryptoAlgorithm(string4)) {
                            bl = true;
                        }
                    }
                }
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.configservice.ConfigServiceImpl.isSuperAdminPasswordAlreadyEncoded", "1123", this);
                connectorException.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSuperAdminPasswordAlreadyEncoded", new Boolean(bl));
        }
        return bl;
    }

    private boolean isObjectNameAPropSet(ObjectName objectName) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isObjectNameAPropSet ", new Boolean(bl));
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        String string = configDataId.toString();
        int n = string.indexOf(J2EE_RESOURCE_PROPERTY_SET);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "parentIdString=" + string);
            Tr.debug(tc, "J2EE_RESOURCE_PROPERTY_SET=" + J2EE_RESOURCE_PROPERTY_SET);
            Tr.debug(tc, "index=" + n);
        }
        if (n != -1) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isObjectNameAPropSet ", new Boolean(bl));
        }
        return bl;
    }

    private boolean doesAttrListContainAJ2EEResProp(AttributeList attributeList) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesAttrListContainAJ2EEResProp ", new Boolean(bl));
        }
        if (null != attributeList) {
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                if (null == attribute) continue;
                String string = attribute.getName();
                Object object = attribute.getValue();
                Tr.debug(tc, "attrName=" + string);
                if (string.toLowerCase().indexOf("password") != -1) {
                    if (object != null && object instanceof AttributeList) {
                        Tr.debug(tc, "attrValue= " + ConfigServiceUtils.maskPasswordInAttrList((AttributeList)object));
                    } else if (object != null && object instanceof ArrayList) {
                        Tr.debug(tc, "attrValue= " + ConfigServiceUtils.maskPasswordInArrayList((ArrayList)object));
                    } else if (object != null && object instanceof String) {
                        Tr.debug(tc, "attrValue=****");
                    }
                }
                if (null == string || !string.equals(WEBSPHERE_CONFIG_DATA_TYPE) || null == object || !object.toString().equals(J2EE_RESOURCE_PROPERTY)) continue;
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesAttrListContainAJ2EEResProp ", new Boolean(bl));
        }
        return bl;
    }

    private Attribute decodeValueInTheAttributeList(AttributeList attributeList) throws UnsupportedCryptoAlgorithmException, InvalidPasswordDecodingException {
        Attribute attribute = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeValueInTheAttributeList");
        }
        if (null != attributeList) {
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute2 = (Attribute)attributeList.get(i);
                if (null == attribute2) continue;
                String string = attribute2.getName();
                Object object = attribute2.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name=" + string);
                    Tr.debug(tc, "value=" + object);
                }
                if (null == string || !string.equals(ATTRIBUTE_VALUE) || null == object || object.getClass() != (class$java$lang$String == null ? ConfigServiceImpl.class$("java.lang.String") : class$java$lang$String)) continue;
                String string2 = PasswordUtil.getCryptoAlgorithm(object.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "algorithm=" + string2);
                    Tr.debug(tc, "PasswordUtil.isValidCryptoAlgorithm(algorithm)=" + PasswordUtil.isValidCryptoAlgorithm(string2));
                }
                if (null == string2 || !PasswordUtil.isValidCryptoAlgorithm(string2)) continue;
                attribute2 = new Attribute(string, PasswordUtil.decode(object.toString()));
                attributeList.remove(i);
                attributeList.add(i, attribute2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeValueInTheAttributeList");
        }
        return attribute;
    }

    private ObjectName findMatchingJ2EEResPropSetforJ2EEResProperty(Session session, ObjectName objectName) throws ConfigServiceException {
        ObjectName objectName2 = null;
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findMatchingJ2EEPropSetforJ2EEProperty", objectName2);
        }
        if (null != objectName) {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            String string = configDataId.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "j2EEResPropConfigDataId=" + configDataId);
                Tr.debug(tc, "j2EEResPropConfigDataIdString=" + string);
            }
            String string2 = null;
            int n = string.indexOf(J2EE_RESOURCE_PROPERTY);
            if (-1 != n) {
                string2 = string.substring(n, string.length() - 1);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "j2EEResPropId=" + string2);
            }
            if (null != string2) {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                String string3 = this.getQueryScopeString(configService, session, objectName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeStr=" + string3);
                }
                ObjectName[] objectNameArray = null;
                ObjectName objectName3 = null;
                String string4 = null;
                if (null != string3) {
                    int n2;
                    int n3 = string3.indexOf("J2EEResourcePropertySet=ID#") + 27;
                    int n4 = string3.indexOf(":J2EEResourceProperty=ID#");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "beginIndex=" + n3);
                        Tr.debug(tc, "endIndex=" + n4);
                    }
                    if (n3 != -1 && n4 != -1) {
                        string4 = string3.substring(n3, n4);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "propertySetId=" + string4);
                    }
                    if (-1 != (n2 = string3.indexOf("ResourceEnvironmentProvider="))) {
                        string3 = string3.substring(0, n2 - 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Now scopeStr=" + string3);
                        }
                        string3 = string3 + ":ResourceEnvironmentProvider=:J2EEResourcePropertySet=";
                        Tr.debug(tc, "Appended scopeStr=" + string3);
                        try {
                            objectNameArray = configService.resolve(session, string3);
                        }
                        catch (ConnectorException connectorException) {
                            FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.configservice.ConfigServiceImpl.findMatchingJ2EEResPropSetforJ2EEResProperty", "1308", this);
                            connectorException.printStackTrace();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Value of scopes=" + objectNameArray);
                        }
                        if (objectNameArray != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "scopes.length=" + objectNameArray.length);
                                Tr.debug(tc, "propertySetId=" + string4);
                            }
                            if (null != string4) {
                                for (int i = 0; i < objectNameArray.length; ++i) {
                                    objectName3 = objectNameArray[i];
                                    String string5 = objectName3.getKeyProperty("_Websphere_Config_Data_Id");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "j2EEResPropSet=" + string5);
                                    }
                                    if (string5.indexOf(string4) == -1) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found matching J2EEResourcePropertySet=" + string5);
                                    }
                                    objectName2 = objectName3;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findMatchingJ2EEPropSetforJ2EEProperty foundFlag=" + bl + " ", objectName2);
        }
        return objectName2;
    }

    private boolean isPropertySetAResEnvProvAttr(Session session, ObjectName objectName) throws ConfigServiceException {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPropertySetAResEnvProvAttr", new Object[]{new Boolean(bl), objectName});
        }
        if (this.isObjectNameAPropSet(objectName)) {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            String string = configDataId.toString();
            int n = string.indexOf(J2EE_RESOURCE_PROPERTY_SET);
            String string2 = null;
            if (n != -1) {
                string2 = string.substring(n, string.length() - 1);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "propertySetId=" + string2);
            }
            if (null != string2) {
                String string3 = this.getQueryScopeString(configService, session, objectName);
                int n2 = string3.indexOf("ResourceEnvironmentProvider=");
                int n3 = string3.indexOf(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resEnvProvIndex=" + n2);
                    Tr.debug(tc, "propSetIndex=" + n3);
                }
                if (n2 != -1 && n2 < n3) {
                    bl = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPropertySetAResEnvProvAttr", new Object[]{new Boolean(bl), objectName});
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createConfigDataByTemplate(Session session, ObjectName objectName, String string, AttributeList attributeList, ObjectName objectName2) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataByTemplate", new Object[]{session, objectName, string, ConfigServiceUtils.maskPasswordInAttrList(attributeList), objectName2});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        ObjectName objectName3 = null;
        try {
            ConfigServiceDelegator configServiceDelegator;
            if (this.doesAttrListContainSuperAdminPassword(attributeList) && this.isObjectNameAPropSet(objectName) && this.isPropertySetAResEnvProvAttr(session, objectName)) {
                this.encodePasswords(attributeList, 0, SUPER_ADMIN_PASSWORD);
            } else {
                Tr.debug(tc, "not encoding attrList");
            }
            if (objectName2 != null) {
                ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Template", objectName2);
            }
            objectName3 = (configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName)) == null ? this.createConfigDataBasic(session2, objectName, string, attributeList) : configServiceDelegator.createConfigData(session2, objectName, string, attributeList);
            bl = true;
        }
        finally {
            if (session == null) {
                if (bl) {
                    try {
                        this.save(session2, false);
                    }
                    catch (ConfigDocumentSaveException configDocumentSaveException) {
                        FFDCFilter.processException((Throwable)configDocumentSaveException, "com.ibm.ws.management.configservice.ConfigServiceImpl.createConfigData", "359", this);
                        Tr.error(tc, "ADMG0011E", configDocumentSaveException);
                    }
                }
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", objectName3);
        }
        return objectName3;
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, String string2, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, objectName, string, string2, ConfigServiceUtils.maskPasswordInAttrList(attributeList)});
        }
        this.initialize();
        if (string2 != null && string2.length() > 0) {
            ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Type", string2);
        }
        ObjectName objectName2 = this.createConfigDataByTemplate(session, objectName, string, attributeList, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", objectName2);
        }
        return objectName2;
    }

    private AttributeList encodePasswords(AttributeList attributeList, int n, String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "ConfigServiceImpl.encodePasswords");
        }
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        boolean bl = false;
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "---------------------------------------------------------");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute number: " + n + "." + i);
            }
            if ((attribute = (Attribute)attributeList.get(i)) != null) {
                String string2;
                String string3 = attribute.getName();
                if (this.forceEncode) {
                    bl = true;
                    this.forceEncode = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " isPassword = true, forceEncode reset to false");
                    }
                }
                if (bl && string3.equalsIgnoreCase("value") && attribute.getValue() != null) {
                    bl = false;
                    try {
                        string2 = PasswordUtil.encode((String)attribute.getValue());
                        attributeList.remove(i);
                        attribute = new Attribute(string3, string2);
                        attributeList.add(i, attribute);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.ConfigServiceImpl.encodePasswords", "62", this);
                        Tr.error(tc, "", exception);
                    }
                }
                if (string3.equalsIgnoreCase("name") && ((string2 = (String)attribute.getValue()) != null && (string2.indexOf("password") != -1 || string2.indexOf("Password") != -1) && (null == string || string.equals("")) || null != string && string.equals(string2))) {
                    bl = true;
                }
            }
            attribute = this.parseAttribute(attribute, n);
            attributeList2.add(i, attribute);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "ConfigServiceImpl.encodePasswords");
        }
        return attributeList2;
    }

    private Attribute parseAttribute(Attribute attribute, int n) {
        if (attribute == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  attribute is null.");
                Tr.exit(tc, "parseAttribute");
            }
            return null;
        }
        String string = attribute.getName();
        Object object = attribute.getValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " name: " + string);
        }
        if (object == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  value is null.");
            }
        } else {
            Class<?> clazz = object.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  type of value: " + clazz.getName());
            }
            if (clazz == AttributeList.class) {
                object = this.encodePasswords((AttributeList)object, n + 1, null);
                return new Attribute(string, object);
            }
            if (clazz == ArrayList.class) {
                ArrayList arrayList = (ArrayList)object;
                ArrayList arrayList2 = new ArrayList(arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object object2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "        ----------------------------------------------");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "        Array list element: " + n + "." + i);
                    }
                    if ((object2 = arrayList.get(i)) != null) {
                        clazz = object2.getClass();
                        if (clazz == (class$javax$management$AttributeList == null ? ConfigServiceImpl.class$("javax.management.AttributeList") : class$javax$management$AttributeList)) {
                            object2 = this.encodePasswords((AttributeList)object2, n + 1, null);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "  list element value.toString is " + object.toString());
                        }
                    }
                    arrayList2.add(i, object2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "parseAttributes");
                }
                return new Attribute(string, arrayList2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "  value.toString is " + object.toString());
                Tr.exit(tc, "parseAttribute");
            }
            return new Attribute(string, object);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "parseAttributes");
        }
        return new Attribute(string, object);
    }

    private String getQueryScopeString(ConfigService configService, Session session, ObjectName objectName) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getQueryScopeString ", objectName);
        }
        String string = null;
        try {
            string = ConfigServiceUtils.convertConfigIdToConfigScope(objectName, session, configService);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.ConfigServiceImpl.getQueryScopeString", "1802", this);
            exception.printStackTrace();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getQueryScopeString ", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, objectName, ConfigServiceUtils.maskPasswordInAttrList(attributeList)});
        }
        boolean bl = this.shouldModifyEncodedSuperAdminPassword(session, objectName);
        String string = objectName.getKeyProperty("_Websphere_Config_Data_Id");
        String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
        if (string != null && string.indexOf("J2CConnectionFactory") != -1) {
            attributeList = this.encodePasswords(attributeList, 0, null);
        } else if (bl || this.doesAttrListContainSuperAdminPassword(attributeList) && this.isObjectNameAPropSet(objectName)) {
            if (bl || this.isPropertySetAResEnvProvAttr(session, objectName)) {
                attributeList = this.encodePasswords(attributeList, 0, SUPER_ADMIN_PASSWORD);
            }
        } else if (null != string2 && string2.equals(KEY_RING_PASSWORD)) {
            this.forceEncode = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " forceEncode is now true");
            }
            attributeList = this.encodePasswords(attributeList, 0, "");
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl2 = false;
        try {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.setAttributesBasic(session2, objectName, attributeList);
            } else {
                configServiceDelegator.setAttributes(session2, objectName, attributeList);
            }
            bl2 = true;
        }
        finally {
            if (session == null) {
                if (bl2) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{session, objectName, string, object, new Integer(n)});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.addElementBasic(session2, objectName, string, object, n);
            } else {
                configServiceDelegator.addElement(session2, objectName, string, object, n);
            }
            bl = true;
        }
        finally {
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeElement", new Object[]{session, objectName, string, object});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.removeElementBasic(session2, objectName, string, object);
            } else {
                configServiceDelegator.removeElement(session2, objectName, string, object);
            }
            bl = true;
        }
        finally {
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, objectName, stringArray});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.unsetAttributesBasic(session2, objectName, stringArray);
            } else {
                configServiceDelegator.unsetAttributes(session2, objectName, stringArray);
            }
            bl = true;
        }
        finally {
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, objectName, ConfigServiceUtils.maskPasswordInAttrList(attributeList)});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        if (this.shouldModifyEncodedSuperAdminPassword(session, objectName)) {
            attributeList = this.encodePasswords(attributeList, 0, SUPER_ADMIN_PASSWORD);
        }
        boolean bl = false;
        try {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.resetAttributesBasic(session2, objectName, attributeList);
            } else {
                configServiceDelegator.resetAttributes(session2, objectName, attributeList);
            }
            bl = true;
        }
        finally {
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                }
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        AttributeList attributeList;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)});
            }
            this.initialize();
            Session session2 = session;
            if (session2 == null) {
                session2 = new Session();
            }
            boolean bl2 = false;
            try {
                ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
                attributeList = configServiceDelegator == null ? this.getAttributesBasic(session2, objectName, stringArray, bl) : configServiceDelegator.getAttributes(session2, objectName, stringArray, bl);
                ObjectName objectName2 = null;
                if (null != attributeList && this.doesAttrListContainAJ2EEResProp(attributeList) && null != objectName) {
                    objectName2 = this.findMatchingJ2EEResPropSetforJ2EEResProperty(session2, objectName);
                }
                if (null == objectName2 || !this.isPropertySetAResEnvProvAttr(session2, objectName2)) break block11;
                try {
                    this.decodeValueInTheAttributeList(attributeList);
                }
                catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
                    FFDCFilter.processException((Throwable)((Object)unsupportedCryptoAlgorithmException), "com.ibm.ws.management.configservice.ConfigServiceImpl.getAttributes", "2086", this);
                    unsupportedCryptoAlgorithmException.printStackTrace();
                    throw new ConfigServiceException((Throwable)((Object)unsupportedCryptoAlgorithmException));
                }
                catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                    FFDCFilter.processException((Throwable)((Object)invalidPasswordDecodingException), "com.ibm.ws.management.configservice.ConfigServiceImpl.getAttributes", "2091", this);
                    invalidPasswordDecodingException.printStackTrace();
                    throw new ConfigServiceException((Throwable)((Object)invalidPasswordDecodingException));
                }
            }
            finally {
                if (session == null) {
                    this.discard(session2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", ConfigServiceUtils.maskPasswordInAttrList(attributeList));
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        Object object;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAttribute", new Object[]{session, objectName, string});
            }
            this.initialize();
            Session session2 = session;
            if (session2 == null) {
                session2 = new Session();
            }
            object = null;
            try {
                ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
                object = configServiceDelegator == null ? this.getAttributeBasic(session2, objectName, string) : configServiceDelegator.getAttribute(session2, objectName, string);
                if (null == string || !string.equals(SUPER_ADMIN_PASSWORD) || object == null || object.getClass() != Attribute.class || !((Attribute)object).getName().equals("value")) break block13;
                ObjectName objectName2 = null;
                if (null != objectName) {
                    objectName2 = this.findMatchingJ2EEResPropSetforJ2EEResProperty(session2, objectName);
                }
                if (!this.isPropertySetAResEnvProvAttr(session2, objectName2)) break block13;
                Attribute attribute = (Attribute)object;
                String string2 = attribute.getName();
                Object object2 = attribute.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name=" + string2);
                    Tr.debug(tc, "value=" + object2);
                }
                if (null == string2 || !string2.equals(ATTRIBUTE_VALUE) || null == object2 || object2.getClass() != String.class) break block13;
                String string3 = PasswordUtil.getCryptoAlgorithm(object2.toString());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "algorithm=" + string3);
                    Tr.debug(tc, "PasswordUtil.isValidCryptoAlgorithm(algorithm)=" + PasswordUtil.isValidCryptoAlgorithm(string3));
                }
                if (null == string3 || !PasswordUtil.isValidCryptoAlgorithm(string3)) break block13;
                try {
                    attribute = new Attribute(string2, PasswordUtil.decode(object2.toString()));
                }
                catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
                    FFDCFilter.processException((Throwable)((Object)unsupportedCryptoAlgorithmException), "com.ibm.ws.management.configservice.ConfigServiceImpl.getAttributes", "2086", this);
                    unsupportedCryptoAlgorithmException.printStackTrace();
                    throw new ConfigServiceException((Throwable)((Object)unsupportedCryptoAlgorithmException));
                }
                catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                    FFDCFilter.processException((Throwable)((Object)invalidPasswordDecodingException), "com.ibm.ws.management.configservice.ConfigServiceImpl.getAttributes", "2091", this);
                    invalidPasswordDecodingException.printStackTrace();
                    throw new ConfigServiceException((Throwable)((Object)invalidPasswordDecodingException));
                }
                object = attribute;
            }
            finally {
                if (session == null) {
                    this.discard(session2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return object;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigServiceImpl.getAttribute.new", new Object[]{session, objectName, string, new Boolean(bl)});
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit  - ConfigServiceImpl.getAttribute.new", new Object[]{session, objectName, string, new Boolean(bl)});
            }
            return this.getAttribute(session, objectName, string);
        }
        AttributeList attributeList = this.getAttributes(session, objectName, new String[]{string}, false);
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException(attributeNotFoundException, "com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", "39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit  - ConfigServiceImpl.getAttribute.new", new Object[]{session, objectName, string, new Boolean(bl)});
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        String string;
        ConfigDataId configDataId;
        boolean bl;
        Session session2;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
            }
            this.initialize();
            session2 = session;
            if (session2 == null) {
                session2 = new Session();
            }
            bl = false;
            configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            string = null;
            try {
                string = ConfigServiceHelper.getConfigDataType(objectName);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Exception ", exception.getMessage());
            }
        }
        try {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
            if (configServiceDelegator == null) {
                this.deleteConfigDataBasic(session2, objectName);
            } else {
                configServiceDelegator.deleteConfigData(session2, objectName);
            }
            bl = true;
            try {
                String string2 = configDataId.toString();
                this.notifyAuthzGroup(this, session2, string2, string);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception ", exception.getMessage());
                }
            }
        }
        finally {
            if (session == null) {
                if (bl) {
                    this.save(session2, false);
                } else {
                    this.discard(session2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getRelationships(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{session, objectName, stringArray});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        AttributeList attributeList = new AttributeList();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    ObjectName[] objectNameArray = this.getRelationship(session2, objectName, stringArray[i]);
                    attributeList.add(new Attribute(stringArray[i], objectNameArray));
                    continue;
                }
                catch (InvalidAttributeNameException invalidAttributeNameException) {
                    FFDCFilter.processException((Throwable)invalidAttributeNameException, "com.ibm.ws.management.configservice.ConfigServiceImpl.getRelationships", "611", this);
                }
            }
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", attributeList);
        }
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getRelationship(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{session, objectName, string});
        }
        this.initialize();
        Session session2 = session;
        if (session2 == null) {
            session2 = new Session();
        }
        ObjectName[] objectNameArray = null;
        try {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session2, objectName);
            objectNameArray = configServiceDelegator == null ? this.getRelationshipBasic(session2, objectName, string) : configServiceDelegator.getRelationship(session2, objectName, string);
        }
        finally {
            if (session == null) {
                this.discard(session2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", objectNameArray);
        }
        return objectNameArray;
    }

    public AttributeList getRelationshipsMetaInfoBasic(String string) throws InvalidConfigDataTypeException {
        TypeRegistry.getMetaObject(string);
        return new AttributeList();
    }

    public AttributeList getAttributesMetaInfoBasic(String string) throws InvalidConfigDataTypeException {
        return MOFUtil.getAttributesMetaInfo((EObject)TypeRegistry.getMetaObject(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName createConfigDataBasic(Session session, ObjectName objectName, String string, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataBasic", new Object[]{session, objectName, string, attributeList});
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            ObjectName objectName2 = docAccessor.createConfigData(session, configDataId, string, attributeList, false);
            docAccessor.localSave();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigDataBasic", objectName2);
            }
            ObjectName objectName3 = objectName2;
            return objectName3;
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributesBasic(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.setAttributes(session, configDataId, attributeList);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementBasic(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.addElementAt(session, configDataId, string, object, n, false);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementBasic(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.removeElement(session, configDataId, string, object);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetAttributesBasic(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.unsetAttributes(session, configDataId, stringArray);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAttributesBasic(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = null;
        try {
            docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
            docAccessor.resetAttributes(session, configDataId, attributeList);
            docAccessor.localSave();
        }
        finally {
            if (docAccessor != null) {
                docAccessor.cleanup();
            }
        }
    }

    public AttributeList getAttributesBasic(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesBasic - session, configData, String[], boolean - ", new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        AttributeList attributeList = docAccessor.getAttributes(session, configDataId, stringArray, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesBasic - session, configData, String[], boolean - ", ConfigServiceUtils.maskPasswordInAttrList(attributeList));
        }
        return attributeList;
    }

    public Object getAttributeBasic(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        return docAccessor.getAttribute(session, configDataId, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfigDataBasic(Session session, ObjectName objectName) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            docAccessor.deleteConfigData(session, configDataId);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
    }

    public ObjectName[] getRelationshipBasic(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipBasic", new Object[]{session, objectName, string});
        }
        if (string.equals("parent")) {
            EObject eObject = MOFUtil.convertToEObject(session, objectName);
            EObject eObject2 = eObject.eContainer();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent", eObject2);
            }
            if (eObject2 != null) {
                ObjectName[] objectNameArray = new ObjectName[]{MOFUtil.createObjectName(eObject2)};
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getRelationshipBasic", objectNameArray);
                }
                return objectNameArray;
            }
        }
        throw new UnsupportedOperationException();
    }

    public ObjectName[] getAllBasic(Session session, ObjectName objectName, String string, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllBasic", objectName);
        }
        ObjectName[] objectNameArray = null;
        if (objectName == null || WorkspaceHelper.isScopeContext(session, objectName)) {
            ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
            Collection collection = WorkspaceHelper.getScopeContexts(session, objectName);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "context", repositoryContext.getURI());
                }
                List list = repositoryContext.getAllList(true);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "file", workSpaceFile);
                    }
                    if (!workSpaceFile.toString().endsWith("xml")) continue;
                    boolean bl2 = true;
                    if (bl) {
                        bl2 = WorkspaceHelper.isConfigDocument(repositoryContext.getType(), workSpaceFile.getFileName());
                    }
                    if (!bl2) continue;
                    DocAccessor docAccessor = null;
                    try {
                        docAccessor = WorkspaceHelper.getDocAccessor(session, workSpaceFile);
                    }
                    catch (Exception exception) {
                        docAccessor = null;
                        continue;
                    }
                    ObjectName[] objectNameArray2 = docAccessor.getTypedObjects(session, string);
                    for (int i = 0; objectNameArray2 != null && i < objectNameArray2.length; ++i) {
                        arrayList.add(objectNameArray2[i]);
                    }
                }
            }
            objectNameArray = new ObjectName[arrayList.size()];
            arrayList.toArray(objectNameArray);
        } else {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
            EObject eObject = docAccessor.lookup(configDataId);
            objectNameArray = docAccessor.getTypedObjects(string, eObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", objectNameArray);
        }
        return objectNameArray;
    }

    ConfigServiceDelegator getDelegator(String string) {
        return (ConfigServiceDelegator)this.delegatorTable.get(string);
    }

    private String generateRelationshipName(ConfigServiceDelegator configServiceDelegator) {
        String string = configServiceDelegator.getType();
        return string;
    }

    private void resolve(Session session, ObjectName objectName, AttributeList attributeList, List list) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, objectName, attributeList, list});
        }
        if (attributeList.size() > 0) {
            Attribute attribute = (Attribute)attributeList.get(0);
            String string = attribute.getName();
            String string2 = (String)attribute.getValue();
            try {
                ObjectName[] objectNameArray = this.getRelationship(session, objectName, string);
                attributeList.remove(0);
                for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
                    if (string2 != null) {
                        if (!string2.equals(ConfigServiceHelper.getDisplayName(objectNameArray[i]))) continue;
                        this.resolve(session, objectNameArray[i], new AttributeList(attributeList), list);
                        continue;
                    }
                    this.resolve(session, objectNameArray[i], new AttributeList(attributeList), list);
                }
            }
            catch (InvalidAttributeNameException invalidAttributeNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigServiceImpl.resolve() has caught InvalidAttributeNameException");
                }
                DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(objectName));
                docAccessor.resolve(session, objectName, attributeList, list);
            }
        } else {
            list.add(objectName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exiting ConfigServiceImpl.resolve().  The current function argument values are : ", new Object[]{session, objectName, attributeList, list});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve");
        }
    }

    private void resolveXPath(Session session, ObjectName objectName, AttributeList attributeList, List list) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveXPath", new Object[]{session, objectName, attributeList, list});
        }
        if (attributeList.size() > 0) {
            Attribute attribute = (Attribute)attributeList.get(0);
            String string = attribute.getName();
            Attribute attribute2 = this.getPredicateAttribute((String)attribute.getValue());
            try {
                ObjectName[] objectNameArray;
                if (objectName == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resolve Root element " + string);
                    }
                    ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, string);
                    objectNameArray = this.queryConfigObjects(session, null, objectName2, null);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Resolve element " + string + " parent: " + ConfigServiceHelper.getDisplayName(objectName));
                    }
                    objectNameArray = this.getRelationship(session, objectName, string);
                }
                attributeList.remove(0);
                boolean bl = false;
                for (int i = 0; objectNameArray != null && i < objectNameArray.length; ++i) {
                    block16: {
                        ArrayList arrayList = new ArrayList();
                        if (attribute2 != null) {
                            try {
                                String string2 = attribute2.getName();
                                if (string2.startsWith("@")) {
                                    bl = this.matchXPathAttribute(session, objectNameArray[i], attribute2);
                                    break block16;
                                }
                                ObjectName[] objectNameArray2 = this.getRelationship(session, objectNameArray[i], attribute2.getName());
                                String string3 = (String)attribute2.getValue();
                                for (int j = 0; j < objectNameArray2.length; ++j) {
                                    if (string3 != null && !string3.equals(ConfigServiceHelper.getDisplayName(objectNameArray2[i]))) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            catch (InvalidAttributeNameException invalidAttributeNameException) {
                                bl = this.matchXPathAttribute(session, objectNameArray[i], attribute2);
                            }
                        }
                    }
                    if (attribute2 != null && !bl) continue;
                    this.resolveXPath(session, objectNameArray[i], attributeList, list);
                }
            }
            catch (InvalidAttributeNameException invalidAttributeNameException) {
                DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, ConfigServiceHelper.getConfigDataId(objectName));
                docAccessor.resolveXPath(session, objectName, attributeList, list);
            }
        } else {
            list.add(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveXPath", list);
        }
    }

    private boolean matchXPathAttribute(Session session, ObjectName objectName, Attribute attribute) {
        boolean bl;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveXPathAttribute", new Object[]{session, objectName, attribute});
            }
            bl = false;
            String string = attribute.getName();
            if (string.startsWith("@")) {
                string = string.substring(1);
            }
            String string2 = (String)attribute.getValue();
            try {
                String string3;
                Object object = this.getAttribute(session, objectName, string);
                if (object instanceof AttributeList) {
                    ObjectName objectName2 = ConfigServiceHelper.createObjectName((AttributeList)object);
                    string3 = ConfigServiceHelper.getDisplayName(objectName2);
                } else {
                    string3 = object.toString();
                }
                if (string2 == null || string3.equals(string2)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception captured, assume no matching attribute");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveXPathAttribute", new Boolean(bl));
        }
        return bl;
    }

    private AttributeList parseContainmentPath(String string) throws MalformedContainmentPathException, InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseContainmentPath", string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        AttributeList attributeList = new AttributeList();
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token", string2);
            }
            String string3 = (n = string2.indexOf(61)) == -1 ? string2 : string2.substring(0, n);
            string3 = string3.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "key", string3);
            }
            TypeRegistry.getMetaObject(string3);
            if (string3.length() == 0) {
                throw new MalformedContainmentPathException(string, string2);
            }
            String string4 = n == -1 || n == string2.length() - 1 ? "" : string2.substring(n + 1);
            if ((string4 = string4.trim()).startsWith("\"")) {
                string4 = string4.substring(1);
            }
            if (string4.endsWith("\"")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            if (string4.length() == 0) {
                string4 = null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value", string4);
            }
            attributeList.add(new Attribute(string3, string4));
        }
        if (attributeList.size() == 0) {
            throw new MalformedContainmentPathException(string, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseContainmentPath", attributeList);
        }
        return attributeList;
    }

    private AttributeList parseXPathContainment(String string) throws MalformedContainmentPathException, InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseXPathContainment", string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        AttributeList attributeList = new AttributeList();
        String string2 = null;
        String string3 = null;
        ArrayList arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4 == null && string4 == "") continue;
            int n = string4.indexOf("[");
            if (n != -1) {
                string2 = string4.substring(0, string4.indexOf("["));
                string3 = string4.substring(n + 1, string4.indexOf("]"));
            } else {
                string2 = string4;
            }
            if (string2 == null || string2.length() == 0) {
                throw new MalformedContainmentPathException(string, string4);
            }
            attributeList.add(new Attribute(string2, string3));
        }
        if (attributeList.size() == 0) {
            throw new MalformedContainmentPathException(string, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseXPathContainment", attributeList);
        }
        return attributeList;
    }

    private Attribute getPredicateAttribute(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPredicateAttribute", string);
        }
        Attribute attribute = null;
        if (string != null && string != "") {
            String string2 = string.substring(0, string.indexOf("="));
            String string3 = string.substring(string.indexOf("=") + 2, string.lastIndexOf("'"));
            AttributeList attributeList = new AttributeList();
            attribute = new Attribute(string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPredicateAttribute", attribute);
        }
        return attribute;
    }

    public static ConfigServiceImpl getInstance() {
        return instance;
    }

    private boolean checkAccess(Session session, ObjectName objectName) {
        Object object;
        if (objectName == null) {
            return true;
        }
        String string = ConfigServiceHelper.getConfigDataId(objectName).toString();
        String string2 = null;
        try {
            object = MOFUtil.convertToEObject(session, objectName);
            string2 = object.eResource().getURI().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = AdminAuthorizerFactory.getAdminAuthorizer();
        if (object != null) {
            if (string2 != null && string2.endsWith("admin-authz.xml")) {
                return object.checkAccess(string, "adminsecuritymanager");
            }
            return object.checkAccess(string, "monitor");
        }
        return true;
    }

    private void notifyAuthzGroup(ConfigService configService, Session session, String string, String string2) throws Exception {
        final ConfigService configService2 = configService;
        final Session session2 = session;
        final String string3 = string;
        final String string4 = string2;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.removeResourceFromAuthorizationGroup(configService2, session2, string3, string4);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }
}

