/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class ConfigServiceServerProxy
implements ConfigService {
    private static TraceComponent tc = Tr.register(ConfigServiceServerProxy.class, "management", "com.ibm.ws.management.resources.configservice");
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    protected static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    protected ConfigService _configService;

    public ConfigServiceServerProxy(ConfigService configService) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceServerProxy", configService);
        }
        this._configService = configService;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceServerProxy");
        }
    }

    public void setProperties(final Session session, final HashMap hashMap) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, hashMap});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("setProperties", new String[]{"com.ibm.websphere.management.Session", "java.util.HashMap"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"setProperties", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.setProperties(session, hashMap);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.setProperties", "88");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public ValidationResult validate(final Session session, final ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, objectName});
        }
        ValidationResult validationResult = null;
        try {
            validationResult = (ValidationResult)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ValidationResult validationResult = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("validate", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"validate", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    validationResult = ConfigServiceServerProxy.this._configService.validate(session, objectName);
                    return validationResult;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.validate", "122");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", validationResult);
        }
        return validationResult;
    }

    public void save(final Session session, final boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save", new Object[]{session, new Boolean(bl)});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl2 = ConfigServiceServerProxy.securityCheck("save", new String[]{"com.ibm.websphere.management.Session", "boolean"});
                    if (!bl2) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"save", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.save(session, bl);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.save", "160");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save", session);
        }
    }

    public void discard(final Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discard", session);
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("discard", new String[]{"com.ibm.websphere.management.Session"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"discard", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.discard(session);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.discard", "195");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard", session);
        }
    }

    public String[] getUnsavedChanges(final Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        String[] stringArray = null;
        try {
            stringArray = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    String[] stringArray = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getUnsavedChanges", new String[]{"com.ibm.websphere.management.Session"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getUnsavedChanges", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    stringArray = ConfigServiceServerProxy.this._configService.getUnsavedChanges(session);
                    return stringArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getUnsavedChanges", "229");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", stringArray);
        }
        return stringArray;
    }

    public Map getConflictDocuments(final Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        Map map = null;
        try {
            map = (Map)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    Map map = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getConflictDocuments", new String[]{"com.ibm.websphere.management.Session"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getConflictDocuments", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    map = ConfigServiceServerProxy.this._configService.getConflictDocuments(session);
                    return map;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getConflictDocuments", "267");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", map);
        }
        return map;
    }

    public String[] getSupportedConfigObjectTypes() throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        String[] stringArray = null;
        try {
            stringArray = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    String[] stringArray = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getSupportedConfigObjectTypes", null);
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getSupportedConfigObjectTypes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    stringArray = ConfigServiceServerProxy.this._configService.getSupportedConfigObjectTypes();
                    return stringArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getSupportedConfigObjectTypes", "307");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", stringArray);
        }
        return stringArray;
    }

    public AttributeList getAttributesMetaInfo(final String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", string);
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList attributeList = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getAttributesMetaInfo", new String[]{"java.lang.String"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getAttributesMetaInfo", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    attributeList = ConfigServiceServerProxy.this._configService.getAttributesMetaInfo(string);
                    return attributeList;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getAttributesMetaInfo", "348");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", attributeList);
        }
        return attributeList;
    }

    public AttributeList getRelationshipsMetaInfo(final String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", string);
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList attributeList = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getRelationshipsMetaInfo", new String[]{"java.lang.String"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getRelationshipsMetaInfo", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    attributeList = ConfigServiceServerProxy.this._configService.getRelationshipsMetaInfo(string);
                    return attributeList;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getRelationshipsMetaInfo", "386");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", attributeList);
        }
        return attributeList;
    }

    public ObjectName[] queryConfigObjects(final Session session, final ObjectName objectName, final ObjectName objectName2, final QueryExp queryExp) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryConfigObjects", new Object[]{session, objectName, objectName2, queryExp});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] objectNameArray = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("queryConfigObjects", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.ObjectName", "javax.management.QueryExp"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"queryConfigObjects", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    objectNameArray = ConfigServiceServerProxy.this._configService.queryConfigObjects(session, objectName, objectName2, queryExp);
                    return objectNameArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.queryConfigObjects", "424");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] queryTemplates(final Session session, final String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryTemplates", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] objectNameArray = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("queryTemplates", new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"queryTemplates", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    objectNameArray = ConfigServiceServerProxy.this._configService.queryTemplates(session, string);
                    return objectNameArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.queryTemplates", "460");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(final Session session, final String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] objectNameArray = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("resolve", new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"resolve", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    objectNameArray = ConfigServiceServerProxy.this._configService.resolve(session, string);
                    return objectNameArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.resolve", "499");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        boolean bl = ConfigServiceServerProxy.securityCheck("resolve", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (!bl) {
            throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"resolve", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
        }
        objectNameArray = this._configService.resolve(session, objectName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName createConfigDataByTemplate(final Session session, final ObjectName objectName, final String string, final AttributeList attributeList, final ObjectName objectName2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataByTemplate", new Object[]{session, objectName, string, attributeList, objectName2});
        }
        ObjectName objectName3 = null;
        try {
            objectName3 = (ObjectName)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName objectName3 = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("createConfigDataByTemplate", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "javax.management.AttributeList", "javax.management.ObjectName"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"createConfigDataByTemplate", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    objectName3 = ConfigServiceServerProxy.this._configService.createConfigDataByTemplate(session, objectName, string, attributeList, objectName2);
                    return objectName3;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.createConfigDataByTemplate", "557");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", objectName3);
        }
        return objectName3;
    }

    public ObjectName createConfigData(final Session session, final ObjectName objectName, final String string, final String string2, final AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, objectName, string, string2, attributeList});
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = (ObjectName)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName objectName2 = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("createConfigData", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.String", "javax.management.AttributeList"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"createConfigData", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    objectName2 = ConfigServiceServerProxy.this._configService.createConfigData(session, objectName, string, string2, attributeList);
                    return objectName2;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.createConfigData", "602");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", objectName2);
        }
        return objectName2;
    }

    public void setAttributes(final Session session, final ObjectName objectName, final AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, objectName, attributeList});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("setAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"setAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.setAttributes(session, objectName, attributeList);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.setAttributes", "642");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void addElement(final Session session, final ObjectName objectName, final String string, final Object object, final int n) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{session, objectName, string, object, new Integer(n)});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("addElement", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object", "int"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"addElement", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.addElement(session, objectName, string, object, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.addElement", "678");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    public void removeElement(final Session session, final ObjectName objectName, final String string, final Object object) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeElement", new Object[]{session, objectName, string, object});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("removeElement", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"removeElement", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.removeElement(session, objectName, string, object);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.removeElement", "713");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    public void unsetAttributes(final Session session, final ObjectName objectName, final String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, objectName, stringArray});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("unsetAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"unsetAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.unsetAttributes(session, objectName, stringArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.unsetAttributes", "748");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(final Session session, final ObjectName objectName, final AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, objectName, attributeList});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("resetAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"resetAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.resetAttributes(session, objectName, attributeList);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.resetAttributes", "785");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(final Session session, final ObjectName objectName, final String[] stringArray, final boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList attributeList = null;
                    boolean bl2 = ConfigServiceServerProxy.securityCheck("getAttributes", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"});
                    if (!bl2) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getAttributes", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    attributeList = ConfigServiceServerProxy.this._configService.getAttributes(session, objectName, stringArray, bl);
                    return attributeList;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getAttributes", "823");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributeList);
        }
        return attributeList;
    }

    public Object getAttribute(final Session session, final ObjectName objectName, final String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, objectName, string});
        }
        Object object = null;
        try {
            object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    Object object = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getAttribute", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getAttribute", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    object = ConfigServiceServerProxy.this._configService.getAttribute(session, objectName, string);
                    return object;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getAttribute", "859");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return object;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigureServiceProxy.getAttribute", new Object[]{session, objectName, string, new Boolean(bl)});
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
            }
            return this.getAttribute(session, objectName, string);
        }
        AttributeList attributeList = this.getAttributes(session, objectName, new String[]{string}, false);
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException(attributeNotFoundException, "com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", "39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
        }
        return object;
    }

    public void deleteConfigData(final Session session, final ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    boolean bl = ConfigServiceServerProxy.securityCheck("deleteConfigData", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"deleteConfigData", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    ConfigServiceServerProxy.this._configService.deleteConfigData(session, objectName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.deleteConfigData", "919");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public AttributeList getRelationships(final Session session, final ObjectName objectName, final String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{session, objectName, stringArray});
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    AttributeList attributeList = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getRelationships", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getRelationships", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    attributeList = ConfigServiceServerProxy.this._configService.getRelationships(session, objectName, stringArray);
                    return attributeList;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getRelationships", "956");
            throw new ConfigServiceException(exception);
        }
        return attributeList;
    }

    public ObjectName[] getRelationship(final Session session, final ObjectName objectName, final String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{session, objectName, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ConfigServiceException, ConnectorException {
                    ObjectName[] objectNameArray = null;
                    boolean bl = ConfigServiceServerProxy.securityCheck("getRelationship", new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
                    if (!bl) {
                        throw new ConfigServiceException(new RoleBasedAppException(nls.getFormattedMessage("ADMN0022E", new Object[]{"getRelationship", "ConfigService"}, "Access denied for the {0} operation on {1} MBean")));
                    }
                    objectNameArray = ConfigServiceServerProxy.this._configService.getRelationship(session, objectName, string);
                    return objectNameArray;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            if (exception instanceof ConnectorException) {
                throw (ConnectorException)exception;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown by doPriv() block but not declared in throws clause: " + exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.ConfigServiceServerProxy.getRelationship", "991");
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", objectNameArray);
        }
        return objectNameArray;
    }

    protected static boolean securityCheck(String string, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "securityCheck");
        }
        return true;
    }
}

