/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.templates.TemplateConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

public class ConfigServiceUtils {
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.configservice";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ConfigServiceUtils.class, "ConfigServiceUtils", "com.ibm.ws.management.resources.configservice");

    public static List listMatchingServerTemplatesForNode(ConfigService configService, Session session, String string, String string2) throws Exception {
        return TemplateConfigHelper.listMatchingServerTemplatesForNode(configService, session, string, string2);
    }

    public static List listMatchingServersForNode(ConfigService configService, Session session, String string) throws Exception {
        return TemplateConfigHelper.listMatchingServersForNode(configService, session, string);
    }

    public static List listAvailableClusterMemberNodes(ConfigService configService, Session session, String string, String string2) throws Exception {
        return TemplateConfigHelper.listAvailableClusterMemberNodes(configService, session, string, string2);
    }

    public static List listAvailableClusterMemberNodes(ConfigService configService, Session session, String string) throws Exception {
        return TemplateConfigHelper.listAvailableClusterMemberNodes(configService, session, string);
    }

    public static String convertConfigScopeToConfigId(ObjectName objectName, String string, Session session, ConfigService configService) throws Exception {
        if (!string.contains("=")) {
            return string;
        }
        ObjectName objectName2 = ConfigServiceUtils.convertConfigScopeToConfigObject(objectName, string, session, configService);
        if (objectName2 != null) {
            return ConfigServiceHelper.getConfigDataId(objectName2).toString();
        }
        return null;
    }

    public static ObjectName convertConfigScopeToConfigObject(ObjectName objectName, String string, Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertConfigScopeToConfigId", new Object[]{objectName, string, session, configService});
        }
        String string2 = new String(string);
        StringTokenizer stringTokenizer = null;
        stringTokenizer = string.contains(":") ? new StringTokenizer(string2, ":") : new StringTokenizer(string2, "=");
        ObjectName objectName2 = objectName;
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (string.contains(":")) {
                string4 = stringTokenizer.nextToken();
            }
            StringTokenizer stringTokenizer2 = null;
            stringTokenizer2 = string.contains(":") ? new StringTokenizer(string4, "=") : stringTokenizer;
            string5 = stringTokenizer2.nextToken();
            if (stringTokenizer2.hasMoreTokens()) {
                string6 = stringTokenizer2.nextToken();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type and val", new Object[]{string5, string6});
            }
            if (string6 == null || !string6.contains("#")) {
                string3 = string5 + "=";
                if (string6 != null) {
                    string3 = string3 + string6;
                }
                objectName2 = configService.resolve(session, objectName2, string3)[0];
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "new obj", objectName2);
                continue;
            }
            string3 = string5 + "=";
            ObjectName[] objectNameArray = configService.resolve(session, objectName2, string3);
            objectName2 = null;
            for (int i = 0; i < objectNameArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking obj", objectNameArray[i]);
                }
                String string7 = ConfigServiceHelper.getConfigDataId(objectNameArray[i]).toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking cId", string7);
                }
                if (string6.startsWith("ID#")) {
                    if (!string7.contains(string6.substring(3))) continue;
                    objectName2 = objectNameArray[i];
                    continue block0;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking obj", objectNameArray[i]);
                }
                int n = string6.indexOf("#");
                String string8 = string6.substring(0, n);
                String string9 = string6.substring(n + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking for attrName and attrValue", new Object[]{string8, string9});
                }
                String string10 = (String)configService.getAttribute(session, objectNameArray[i], string8);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrValue for this object is ", string10);
                }
                if (!string10.equals(string9)) continue;
                objectName2 = objectNameArray[i];
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertConfigScopeToConfigId", new Object[]{objectName2});
        }
        return objectName2;
    }

    public static String convertConfigIdToConfigScope(ObjectName objectName, Session session, ConfigService configService) throws Exception {
        return ConfigServiceUtils.convertConfigIdToConfigScope(ConfigServiceHelper.getConfigDataId(objectName).toString(), session, configService);
    }

    public static String convertConfigIdToConfigScope(String string, Session session, ConfigService configService) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertConfigIdToConfigScope", new Object[]{string, session, configService});
        }
        String string2 = null;
        if (string.indexOf("/") < 0 && string.indexOf("|") < 0) {
            return string;
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(new ConfigDataId(string));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objName=", objectName);
        }
        objectName = configService.queryConfigObjects(session, null, objectName, null)[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objName=", objectName);
        }
        String string3 = ConfigServiceHelper.getConfigDataType(objectName);
        String string4 = ConfigServiceUtils.getConfigUniqueId(string);
        EObject eObject = MOFUtil.convertToEObject(session, objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "eObj=", eObject);
        }
        string2 = ConfigServiceUtils.getRootObjectScope(string);
        String string5 = ConfigServiceUtils.getRootObjectType(string);
        String string6 = string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ObjectName objectName2 = objectName;
        while (!string6.equals(string5)) {
            String string7 = null;
            string7 = string6 + "=" + "ID#" + ConfigServiceUtils.getConfigUniqueId(ConfigServiceHelper.getConfigDataId(objectName2).toString());
            arrayList.add(string7);
            EObject eObject2 = eObject.eContainer();
            if (eObject2 == null) break;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObj=", eObject2);
            }
            objectName2 = MOFUtil.createObjectName(eObject2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pObj=", objectName2);
            }
            string6 = ConfigServiceHelper.getConfigDataType(objectName2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentType=", string6);
            }
            eObject = eObject2;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            string2 = string2 + ":" + arrayList.get(i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertConfigIdToConfigScope", new Object[]{string2});
        }
        return string2;
    }

    public static String getRootObjectScope(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootObjectScope", new Object[]{string});
        }
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = new String(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/|");
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5 = stringTokenizer.nextToken();
            Object var6_6 = null;
            if (string5.equals("cells")) {
                stringBuffer = stringBuffer.append("Cell=");
                string4 = stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(string4);
                continue;
            }
            if (string5.equals("nodes")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.append(":");
                }
                stringBuffer = stringBuffer.append("Node=");
                string4 = stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(string4);
                continue;
            }
            if (string5.equals("servers")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.append(":");
                }
                stringBuffer = stringBuffer.append("Server=");
                string4 = stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(string4);
                continue;
            }
            if (string5.equals("clusters")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.append(":");
                }
                stringBuffer = stringBuffer.append("ServerCluster=");
                string4 = stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(string4);
                continue;
            }
            if (string5.equals("deployments")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.append(":");
                }
                stringBuffer = stringBuffer.append("Deployment=");
                string4 = stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(string4);
                continue;
            }
            if (string5.equals("coregroups")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.append(":");
                }
                stringBuffer = stringBuffer.append("CoreGroup=");
                string4 = stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(string4);
                continue;
            }
            if (string5.equals("nodegroups")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer = stringBuffer.append(":");
                }
                stringBuffer = stringBuffer.append("NodeGroup=");
                string4 = stringTokenizer.nextToken();
                stringBuffer = stringBuffer.append(string4);
                continue;
            }
            if (!string5.equals("authorizationgroups")) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer = stringBuffer.append(":");
            }
            stringBuffer = stringBuffer.append("AuthorizationGroup=");
            string4 = stringTokenizer.nextToken();
            stringBuffer = stringBuffer.append(string4);
        }
        string2 = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootObjectScope", string2);
        }
        return string2;
    }

    public static String getRootObjectType(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRootObjectType", string);
        }
        String string2 = null;
        int n = string.lastIndexOf("/");
        int n2 = string.indexOf("/");
        if (n2 == n) {
            n2 = string.indexOf("(");
            n2 = n2 == -1 || n2 > n ? 0 : ++n2;
            string2 = string.substring(n2, n);
            return ConfigServiceUtils.convertContextToType(string2);
        }
        while (true) {
            int n3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start", new Integer(n2));
            }
            if ((n3 = string.indexOf("/", n2 + 1)) >= n) break;
            n2 = n3;
        }
        if (n2 > 0 && n > 0 && n > n2) {
            string2 = string.substring(n2 + 1, n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", string2);
            }
        }
        string2 = ConfigServiceUtils.convertContextToType(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRootObjectType", string2);
        }
        return string2;
    }

    public static String convertContextToType(String string) {
        String string2 = null;
        if (string.equals("cells")) {
            string2 = "Cell";
        } else if (string.equals("nodes")) {
            string2 = "Node";
        } else if (string.equals("servers")) {
            string2 = "Server";
        } else if (string.equals("clusters")) {
            string2 = "ServerCluster";
        } else if (string.equals("applications")) {
            string2 = "Deployment";
        } else if (string.equals("deployments")) {
            string2 = "Deployment";
        } else if (string.equals("coregroups")) {
            string2 = "CoreGroup";
        } else if (string.equals("nodegroups")) {
            string2 = "NodeGroup";
        } else if (string.equals("authorizationgroups")) {
            string2 = "AuthorizationGroup";
        }
        return string2;
    }

    public static String getConfigType(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigType", string);
        }
        String string2 = null;
        int n = string.lastIndexOf("#");
        int n2 = string.lastIndexOf("_");
        if (n > 0 && n2 > 0 && n2 > n) {
            string2 = string.substring(n + 1, n2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigType", string2);
        }
        return string2;
    }

    public static String getConfigUniqueId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigUniqueId", string);
        }
        String string2 = null;
        int n = string.lastIndexOf("#");
        if (n > 0) {
            string2 = string.substring(n + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "id", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigUniqueId", string2);
        }
        return string2;
    }

    public static AttributeList maskPasswordInAttrList(AttributeList attributeList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "maskPasswordInAttrList");
        }
        AttributeList attributeList2 = new AttributeList();
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            String string = ((Attribute)attributeList.get(i)).getName();
            Object object = ((Attribute)attributeList.get(i)).getValue();
            if (string != null && object != null) {
                if (object instanceof ArrayList) {
                    object = ConfigServiceUtils.maskPasswordInArrayList((ArrayList)object);
                }
                if (object instanceof AttributeList) {
                    object = ConfigServiceUtils.maskPasswordInAttrList((AttributeList)object);
                }
                if (string.toLowerCase().indexOf("password") != -1 && !object.equals("") && object instanceof String) {
                    object = "****";
                }
            }
            attributeList2.add(new Attribute(string, object));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "maskPasswordInAttrList");
        }
        return attributeList2;
    }

    public static ArrayList maskPasswordInArrayList(ArrayList arrayList) {
        Object e2;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "maskPasswordInArrayList");
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        ArrayList<AttributeList> arrayList3 = new ArrayList<AttributeList>();
        for (n = 0; arrayList != null && n < arrayList.size(); ++n) {
            ArrayList arrayList4;
            e2 = arrayList.get(n);
            if (e2 instanceof AttributeList) {
                arrayList4 = ConfigServiceUtils.maskPasswordInAttrList((AttributeList)e2);
                arrayList3.add((AttributeList)arrayList4);
            }
            if (!(e2 instanceof ArrayList)) continue;
            arrayList4 = ConfigServiceUtils.maskPasswordInArrayList((ArrayList)e2);
            arrayList3.add((AttributeList)arrayList4);
        }
        for (n = 0; arrayList3 != null && n < arrayList3.size(); ++n) {
            e2 = arrayList3.get(n);
            if (e2 == null) continue;
            arrayList2.add(e2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "maskPasswordInArrayList");
        }
        return arrayList2;
    }
}

