/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigDocumentSaveException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.InvalidSessionException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.management.exception.SessionTimeoutException;
import com.ibm.websphere.management.exception.VersionNotMatchException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigServiceUtils;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.MetadataFilter;
import com.ibm.ws.management.configservice.RequiredAttributesRegistry;
import com.ibm.ws.management.configservice.SpecialAttributeRegistry;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.Bundle;

public class DocAccessor {
    private static TraceComponent tc;
    private Resource res;
    private static List bundlesProvidingConfig;
    AdminAuthorizer aa = SecurityHelper.getHelper().getAdminAuthorizer();

    public DocAccessor(Resource resource) {
        this.res = resource;
    }

    public ObjectName createConfigData(Session session, ConfigDataId configDataId, String string, AttributeList attributeList, boolean bl) throws ConfigServiceException {
        Object object;
        EObject eObject = this.lookup(configDataId);
        ObjectName objectName = ConfigServiceHelper.createObjectName(configDataId);
        Properties properties = MOFUtil.getNodeProperties(WorkspaceHelper.getWorkspace(session), objectName);
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, bl, properties);
        if (SpecialAttributeRegistry.isReadOnlyAttribute(eStructuralFeature)) {
            throw new ReadOnlyAttributeException(string);
        }
        String string2 = this.getDocumentUri();
        if (!this.checkAccess(string2, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{string, "  ", string2}, null));
        }
        EObject eObject2 = MOFUtil.createRefObject(WorkspaceHelper.getContext(this.res), (EObject)eStructuralFeature.getEType(), attributeList);
        RequiredAttributesRegistry.checkRequiredAttributes(eObject2, properties);
        if (eStructuralFeature.isMany()) {
            object = (List)eObject.eGet(eStructuralFeature);
            SpecialAttributeRegistry.checkUnique((EClass)eStructuralFeature.getEType(), (List)object, eObject2);
            object.add(eObject2);
        } else {
            eObject.eSet(eStructuralFeature, (Object)eObject2);
        }
        object = MOFUtil.createObjectName(eObject2);
        return object;
    }

    public ObjectName createRootConfigObject(Session session, String string, AttributeList attributeList) throws ConfigServiceException {
        EClass eClass = TypeRegistry.getMetaObject(string);
        String string2 = this.getDocumentUri();
        if (!this.checkAccess(string2, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{" ", "  ", string2}, null));
        }
        EObject eObject = MOFUtil.createRefObject(WorkspaceHelper.getContext(this.res), (EObject)eClass, attributeList);
        Properties properties = this.getNodeProperties(session);
        RequiredAttributesRegistry.checkRequiredAttributes(eObject, properties);
        SpecialAttributeRegistry.checkUnique(eClass, (List)this.res.getContents(), eObject);
        this.res.getContents().add((Object)eObject);
        MOFUtil.objectAdded(WorkspaceHelper.getContext(this.res), eObject, new MOFUtil.ReferenceHandler(), new Stack());
        ObjectName objectName = MOFUtil.createObjectName(eObject);
        return objectName;
    }

    public void setAttributes(Session session, ConfigDataId configDataId, AttributeList attributeList) throws ConfigServiceException {
        this.checkAttributeListVersion(attributeList);
        EObject eObject = this.lookup(configDataId);
        String string = this.getDocumentUri();
        if (!this.checkAccess(string, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{" ", "  ", string}, null));
        }
        MOFUtil.setAttributes(WorkspaceHelper.getContext(this.res), eObject, attributeList);
    }

    public ObjectName addElementAt(Session session, ConfigDataId configDataId, String string, Object object, int n, boolean bl) throws ConfigServiceException {
        EObject eObject = this.lookup(configDataId);
        String string2 = this.getDocumentUri();
        if (!this.checkAccess(string2, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{string, "  ", string2}, null));
        }
        Object object2 = MOFUtil.addElementAt(WorkspaceHelper.getContext(this.res), eObject, string, object, n, bl);
        ObjectName objectName = null;
        if (object2 instanceof EObject) {
            EObject eObject2 = (EObject)object2;
            Properties properties = this.getNodeProperties(session);
            RequiredAttributesRegistry.checkRequiredAttributes(eObject2, properties);
            objectName = MOFUtil.createObjectName(eObject2);
        }
        return objectName;
    }

    public void removeElement(Session session, ConfigDataId configDataId, String string, Object object) throws ConfigServiceException {
        EObject eObject = this.lookup(configDataId);
        String string2 = this.getDocumentUri();
        if (!this.checkAccess(string2, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{string, "  ", string2}, null));
        }
        MOFUtil.removeElement(WorkspaceHelper.getContext(this.res), eObject, string, object);
    }

    public void unsetAttributes(Session session, ConfigDataId configDataId, String[] stringArray) throws ConfigServiceException {
        EObject eObject = this.lookup(configDataId);
        EClass eClass = eObject.eClass();
        String string = this.getDocumentUri();
        if (!this.checkAccess(string, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{" ", "  ", string}, null));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            MOFUtil.unsetAttribute(eObject, stringArray[i]);
        }
    }

    public void resetAttributes(Session session, ConfigDataId configDataId, AttributeList attributeList) throws ConfigServiceException {
        this.checkAttributeListVersion(attributeList);
        EObject eObject = this.lookup(configDataId);
        String string = this.getDocumentUri();
        if (!this.checkAccess(string, "configurator")) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{" ", "  ", string}, null));
        }
        MOFUtil.resetAttributes(WorkspaceHelper.getContext(this.res), eObject, attributeList);
    }

    public ObjectName[] getRootObjects(Session session) throws ConfigDataNotFoundException {
        EList eList = this.res.getContents();
        ObjectName[] objectNameArray = new ObjectName[eList.size()];
        String string = this.getDocumentUri();
        if (!this.checkAccess(string, "monitor")) {
            return null;
        }
        for (int i = 0; i < eList.size(); ++i) {
            EObject eObject = (EObject)eList.get(i);
            objectNameArray[i] = MOFUtil.createObjectName(eObject);
        }
        return objectNameArray;
    }

    public ObjectName[] getTypedObjects(Session session, String string) throws InvalidConfigDataTypeException {
        Class clazz;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypedObjects", new Object[]{session, string});
        }
        if (!this.checkAccess(string2 = this.getDocumentUri(), "monitor")) {
            return null;
        }
        EList eList = this.res.getContents();
        try {
            clazz = this.getConfigClass(TypeRegistry.getFullyQualifiedType(string));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.DocAccessor.getTypedObjects", "279", this);
            throw new InvalidConfigDataTypeException(exception, string);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; eList != null && i < eList.size(); ++i) {
            EObject eObject = (EObject)eList.get(i);
            this.getTypedObjects(clazz, eObject, arrayList);
        }
        ObjectName[] objectNameArray = new ObjectName[arrayList.size()];
        arrayList.toArray(objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypedObjects", objectNameArray);
        }
        return objectNameArray;
    }

    private Class getConfigClass(final String string) throws ClassNotFoundException {
        Object object;
        Class clazz;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConfigClass", string);
            }
            clazz = null;
            Iterator iterator = bundlesProvidingConfig.iterator();
            while (iterator.hasNext() && clazz == null) {
                object = (Bundle)iterator.next();
                if (object == null) {
                    return Class.forName(string);
                }
                try {
                    clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Bundle)object, string){
                        private final /* synthetic */ Bundle val$bundle;
                        private final /* synthetic */ String val$className;
                        {
                            this.val$bundle = bundle;
                            this.val$className = string;
                        }

                        public Object run() throws ClassNotFoundException {
                            return this.val$bundle.loadClass(this.val$className);
                        }
                    });
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to load class " + string + " from bundle " + object.getSymbolicName(), exception);
                }
            }
            if (clazz == null) {
                try {
                    clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws ClassNotFoundException {
                            return Class.forName(string, true, (ClassLoader)ExtClassLoader.getInstance());
                        }
                    });
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) break block11;
                    Tr.event(tc, "unable to load class " + string + "using Extension " + "classloader", exception);
                }
            }
        }
        if (clazz == null) {
            object = new ClassNotFoundException(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigClass", object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigClass", clazz);
        }
        return clazz;
    }

    public ObjectName[] getTypedObjects(String string, EObject eObject) throws InvalidConfigDataTypeException {
        Class clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypedObjects", new Object[]{string, eObject});
        }
        try {
            clazz = this.getConfigClass(TypeRegistry.getFullyQualifiedType(string));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.DocAccessor.getTypedObjects", "279", this);
            throw new InvalidConfigDataTypeException(exception, string);
        }
        ArrayList arrayList = new ArrayList();
        this.getTypedObjects(clazz, eObject, arrayList);
        ObjectName[] objectNameArray = new ObjectName[arrayList.size()];
        arrayList.toArray(objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypedObjects", objectNameArray);
        }
        return objectNameArray;
    }

    private void getTypedObjects(Class clazz, EObject eObject, List list) throws InvalidConfigDataTypeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypedObjects", new Object[]{clazz, eObject});
        }
        if (clazz.isInstance(eObject)) {
            if (MetadataFilter.isValidType(eObject.eClass(), MOFUtil.getNodeProperties(eObject))) {
                list.add(MOFUtil.createObjectName(eObject));
            }
        } else {
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                Object e2 = treeIterator.next();
                if (!clazz.isInstance(e2) || !(e2 instanceof EObject) || !MetadataFilter.isValidType(((EObject)e2).eClass(), MOFUtil.getNodeProperties((EObject)e2))) continue;
                list.add(MOFUtil.createObjectName((EObject)e2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypedObjects");
        }
    }

    public Object getAttribute(Session session, ConfigDataId configDataId, String string) throws ConfigServiceException {
        EObject eObject = this.lookup(configDataId);
        String string2 = this.getDocumentUri();
        String string3 = "monitor";
        if (string2.endsWith("admin-authz.xml")) {
            string3 = "adminsecuritymanager";
        }
        if (!this.checkAccess(string2, string3)) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{" ", " ", string2}, null));
        }
        Object object = MOFUtil.getAttribute(eObject, string, true);
        object = this.clearRestrictedAttribute(this.getDocumentUri(), TypeRegistry.getTypeShortName((EClassifier)eObject.eClass()), string, object);
        return object;
    }

    public ObjectName getParent(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException {
        EObject eObject = this.lookup(configDataId);
        String string = this.getDocumentUri();
        if (!this.checkAccess(string, "monitor")) {
            return null;
        }
        EObject eObject2 = eObject.eContainer();
        return MOFUtil.createObjectName(eObject2);
    }

    public ObjectName[] getRelationship(Session session, ConfigDataId configDataId, String string) throws InvalidAttributeNameException, ConfigDataNotFoundException, ConfigServiceException {
        ObjectName[] objectNameArray;
        ObjectName objectName = ConfigServiceHelper.createObjectName(configDataId);
        Properties properties = MOFUtil.getNodeProperties(WorkspaceHelper.getWorkspace(session), objectName);
        EObject eObject = this.lookup(configDataId);
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, true, properties);
        Object object = eObject.eGet(eStructuralFeature);
        String string2 = this.getDocumentUri();
        if (!this.checkAccess(string2, "monitor")) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            objectNameArray = new ObjectName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                EObject eObject2 = (EObject)list.get(i);
                objectNameArray[i] = MOFUtil.createObjectName(eObject2);
            }
        } else if (object instanceof EObject) {
            objectNameArray = new ObjectName[]{MOFUtil.createObjectName((EObject)object)};
        } else {
            throw new InvalidAttributeNameException(new String[]{string});
        }
        return objectNameArray;
    }

    public ObjectName resolveObjectName(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException, ConfigDocumentLoadException, InvalidSessionException, SessionTimeoutException {
        EObject eObject = this.lookup(configDataId);
        String string = this.getDocumentUri();
        if (!this.checkAccess(string, "monitor")) {
            return null;
        }
        return MOFUtil.createObjectName(eObject);
    }

    public void resolve(Session session, ObjectName objectName, AttributeList attributeList, List list) throws ConfigServiceException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, objectName, attributeList, list});
        }
        if (!this.checkAccess(string = this.getDocumentUri(), "monitor")) {
            return;
        }
        if (attributeList.size() == 0) {
            list.add(objectName);
        } else {
            EObject eObject = this.lookup(ConfigServiceHelper.getConfigDataId(objectName));
            EList eList = eObject.eContents();
            Attribute attribute = (Attribute)attributeList.remove(0);
            String string2 = attribute.getName();
            String string3 = (String)attribute.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objectName", string3);
            }
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = MOFUtil.createObjectName((EObject)iterator.next());
                if (!string2.equals(ConfigServiceHelper.getConfigDataType(objectName2)) || string3 != null && !string3.equals(ConfigServiceHelper.getDisplayName(objectName2))) continue;
                this.resolve(session, objectName2, attributeList, list);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve");
        }
    }

    public void resolveXPath(Session session, ObjectName objectName, AttributeList attributeList, List list) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveXPath", new Object[]{session, objectName, attributeList, list});
        }
        if (attributeList.size() > 0) {
            EObject eObject = this.lookup(ConfigServiceHelper.getConfigDataId(objectName));
            EList eList = eObject.eContents();
            Attribute attribute = (Attribute)attributeList.remove(0);
            String string = attribute.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type", string);
            }
            Attribute attribute2 = this.getPredicateAttribute((String)attribute.getValue());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "predicate", attribute2);
            }
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = MOFUtil.createObjectName((EObject)iterator.next());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "childType", ConfigServiceHelper.getConfigDataType(objectName2));
                }
                if (!string.equals(ConfigServiceHelper.getConfigDataType(objectName2))) continue;
                String string2 = (String)this.getAttribute(session, ConfigServiceHelper.getConfigDataId(objectName2), attribute2.getName());
                if (attribute2 != null && !string2.equals(attribute2.getValue())) continue;
                this.resolveXPath(session, objectName2, attributeList, list);
            }
        } else {
            list.add(objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveXPath");
        }
    }

    public AttributeList getAttributes(Session session, ConfigDataId configDataId, String[] stringArray, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configDataId, stringArray});
        }
        EObject eObject = this.lookup(configDataId);
        AttributeList attributeList = MOFUtil.getAttributes(eObject, stringArray, bl);
        String string = this.getDocumentUri();
        String string2 = "monitor";
        if (string.endsWith("admin-authz.xml")) {
            string2 = "adminsecuritymanager";
        }
        if (!this.checkAccess(string, string2)) {
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0035E", new Object[]{" ", " ", string}, null));
        }
        this.clearRestrictedAttributes(this.getDocumentUri(), attributeList);
        attributeList.add(new Attribute("_Websphere_Config_Data_Version", this.getDocumentDigest()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", ConfigServiceUtils.maskPasswordInAttrList(attributeList));
        }
        return attributeList;
    }

    public void deleteConfigData(Session session, ConfigDataId configDataId) throws ConfigDataNotFoundException {
        EObject eObject = this.lookup(configDataId);
        String string = this.getDocumentUri();
        if (!this.checkAccess(string, "configurator")) {
            throw new ConfigDataNotFoundException(string, configDataId, new Exception("Access Denied"));
        }
        MOFUtil.delete(eObject);
        if (this.res.getContents().size() == 0) {
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(this.res);
            this.res.getResourceSet().getResources().remove((Object)this.res);
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(this.res.getURI().path());
            try {
                repositoryContext.notifyChanged(2, arrayList);
            }
            catch (WorkSpaceException workSpaceException) {
                throw new ConfigDataNotFoundException(string, configDataId, workSpaceException);
            }
            this.res = null;
        }
    }

    public String getDocumentUri() {
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(this.res);
        return repositoryContext.getURI() + '/' + this.res.getURI();
    }

    public void localSave() throws ConfigDocumentSaveException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localSave");
        }
        if (this.res == null) {
            return;
        }
        try {
            if (this.res.isModified()) {
                this.res.save(new HashMap());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.DocAccessor.localSave", "454", this);
            throw new ConfigDocumentSaveException(this.getDocumentUri(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localSave");
        }
    }

    public void cleanup() {
        if (this.res == null) {
            return;
        }
        if (this.res.isModified() && this.res.getResourceSet() != null) {
            this.res.getResourceSet().getResources().remove((Object)this.res);
        }
    }

    public EObject lookup(ConfigDataId configDataId) throws ConfigDataNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup", configDataId);
        }
        URI uRI = MOFUtil.getURI(configDataId);
        EObject eObject = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ref id", uRI.fragment());
        }
        if (!uRI.hasFragment()) {
            if (this.res.getContents().size() > 0) {
                eObject = (EObject)this.res.getContents().get(0);
            }
        } else {
            eObject = this.res.getEObject(uRI.fragment());
        }
        if (eObject == null) {
            throw new ConfigDataNotFoundException(this.getDocumentUri(), configDataId, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookup", eObject);
        }
        return eObject;
    }

    Resource getResource() {
        return this.res;
    }

    private void clearRestrictedAttributes(String string, AttributeList attributeList) throws ConfigServiceException {
        if (SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable(string)) {
            this.clearRestrictedAttributesBase(string, attributeList);
        }
    }

    private Object clearRestrictedAttribute(String string, String string2, String string3, Object object) throws ConfigServiceException {
        Object object2 = object;
        if (SecurityContext.isSecurityEnabled() && !RestrictedAccess.isReadable(string)) {
            object2 = this.clearRestrictedAttributeBase(string, string2, string3, object);
        }
        return object;
    }

    private void clearRestrictedAttributesBase(String string, AttributeList attributeList) throws ConfigServiceException {
        String string2 = null;
        try {
            string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (string2 != null) {
            for (int i = 0; i < attributeList.size(); ++i) {
                String string3;
                Object object;
                Attribute attribute = (Attribute)attributeList.get(i);
                Object object2 = attribute.getValue();
                if (object2 == (object = this.clearRestrictedAttributeBase(string, string2, string3 = attribute.getName(), object2))) continue;
                attributeList.set(i, new Attribute(string3, object));
            }
        }
    }

    private Object clearRestrictedAttributeBase(String string, String string2, String string3, Object object) throws ConfigServiceException {
        if (object instanceof AttributeList) {
            this.clearRestrictedAttributesBase(string, (AttributeList)object);
        } else if (object instanceof List) {
            if (!RestrictedAccess.isReadable(string, TypeRegistry.getFullyQualifiedType(string2), string3)) {
                RoleBasedAuthorizer roleBasedAuthorizer;
                try {
                    roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
                }
                catch (Exception exception) {
                    throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
                }
                if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                    ((List)object).clear();
                }
            } else {
                Iterator iterator = ((List)object).iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!(e2 instanceof AttributeList)) continue;
                    this.clearRestrictedAttributesBase(string, (AttributeList)e2);
                }
            }
        } else if (!RestrictedAccess.isReadable(string, TypeRegistry.getFullyQualifiedType(string2), string3)) {
            RoleBasedAuthorizer roleBasedAuthorizer;
            try {
                roleBasedAuthorizer = SecurityHelper.getHelper().getConfigurator().getRoleBasedAuthorizer("admin-authz", "scope");
            }
            catch (Exception exception) {
                throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null));
            }
            if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                object = null;
            }
        }
        return object;
    }

    private void checkAttributeListVersion(AttributeList attributeList) throws VersionNotMatchException {
        DocumentDigest documentDigest = null;
        try {
            documentDigest = (DocumentDigest)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Version");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        documentDigest = null;
        if (documentDigest != null && !((Object)documentDigest).equals(this.getDocumentDigest())) {
            throw new VersionNotMatchException();
        }
    }

    private DocumentDigest getDocumentDigest() {
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(this.res);
        return null;
    }

    private Attribute getPredicateAttribute(String string) {
        if (string != null && string != "") {
            if (string.startsWith("@")) {
                string = string.substring(1);
            }
            String string2 = string.substring(0, string.indexOf("="));
            String string3 = string.substring(string.indexOf("=") + 2, string.lastIndexOf("'"));
            AttributeList attributeList = new AttributeList();
            return new Attribute(string2, string3);
        }
        return null;
    }

    private Properties getNodeProperties(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties");
        }
        Properties properties = null;
        try {
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(this.res);
            if (repositoryContext == null) {
                return properties;
            }
            ObjectName objectName = MOFUtil.createObjectName(repositoryContext);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "context = " + repositoryContext);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objName = " + objectName);
            }
            Properties properties2 = ConfigServiceHelper.getObjectLocation(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "obj props = " + properties2);
            }
            String string = properties2.getProperty("node");
            String string2 = properties2.getProperty("server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeName = " + string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName = " + string2);
            }
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            try {
                ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
                if (string != null && managedObjectMetadataHelper != null) {
                    properties = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string);
                }
            }
            catch (Exception exception) {
                Tr.warning(tc, "Could not getNodeProperties for node: " + string, exception);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node props = " + properties);
            }
            if (string == null && string2 != null) {
                properties = new Properties();
                properties.setProperty("com.ibm.websphere.baseProductVersion", "5.0.0.0");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting nodeProps to null");
            }
            properties = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeProperties", properties);
        }
        return properties;
    }

    private boolean checkAccess(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAccess ", new Object[]{string, string2});
        }
        boolean bl = true;
        Object var4_4 = null;
        if (this.aa != null) {
            if (string.endsWith("admin-authz.xml") && string2.equals("configurator")) {
                string2 = "adminsecuritymanager";
            } else if (string.endsWith("authorizationgroup.xml") && string2.equals("configurator")) {
                string2 = "adminsecuritymanager";
            }
            bl = this.aa.checkAccess(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAccess ", new Boolean(bl));
        }
        return bl;
    }

    static {
        String string;
        tc = Tr.register(DocAccessor.class, "management", "com.ibm.ws.management.resources.configservice");
        bundlesProvidingConfig = new ArrayList();
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".server-config");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            for (int i = 0; i < iExtensionArray.length; ++i) {
                bundlesProvidingConfig.add(Platform.getBundle((String)iExtensionArray[i].getNamespace()));
            }
        }
    }
}

