/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.serverindex.DistinguishedEndpointConstants;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerTypeConstants;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndPointConfigThreadLocal;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EndpointConfigHelper
implements DistinguishedEndpointConstants,
ServerTypeConstants {
    private static TraceComponent tc = Tr.register(EndpointConfigHelper.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final List emptyArray = new ArrayList(0);
    private static final ServerindexFactory serverIndexFactory;
    private static EndPointConfigThreadLocal thisThread;
    private static String propertyFile;
    private static String skipPorts;
    private static List skipList;
    private static Properties props;
    private static final IpcPackage ipcPckg;
    private static Map endpointMap;
    private static Map serverTypeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertyFile(String string) {
        InputStream inputStream = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadPropertyFile ", string);
            }
            if ((inputStream = ExtClassLoader.getSystemClassLoader().getResourceAsStream("port_skip.props")) != null) {
                props.load(inputStream);
                skipPorts = (String)props.get("com.ibm.websphere.createservercommand.skipports");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Skip Port list taken from property file: ", skipPorts);
                }
                if (skipPorts != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(skipPorts, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            skipList.add(new Integer(stringTokenizer.nextToken().trim()));
                        }
                        catch (Throwable throwable) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Skip port is not in proper format, put \",\" as a seperator. ignoring this entry..");
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Skip ports list: " + skipList);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Property file (optional) not found in classpath:", string);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException reading from property file.", throwable);
            }
        }
        finally {
            block24: {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block24;
                    Tr.debug(tc, "Exception while closing inputstream");
                }
            }
            inputStream = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadPropertyFile ", string);
            }
        }
    }

    static void getAllEndpointMetaInfo(EClassifier eClassifier, AttributeList attributeList) {
        String string;
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllEndpointMetaInfo", eClassifier);
        }
        if ((distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string = TypeRegistry.getTypeShortName(eClassifier))) != null) {
            for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
                String string2 = distinguishedEndpointInfoArray[i].getEndpointName();
                AttributeList attributeList2 = EndpointConfigHelper.getEndpointMetaInfo(string2);
                attributeList.add(new Attribute(string2, attributeList2));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllEndpointMetaInfo");
        }
    }

    static List getEndpointAttributeNames(EClassifier eClassifier) {
        ArrayList<String> arrayList;
        String string;
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointAttributeNames", eClassifier);
        }
        if ((distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string = TypeRegistry.getTypeShortName(eClassifier))) != null) {
            arrayList = new ArrayList<String>(distinguishedEndpointInfoArray.length);
            for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
                arrayList.add(distinguishedEndpointInfoArray[i].getEndpointName());
            }
        } else {
            arrayList = emptyArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointAttributeNames", arrayList);
        }
        return arrayList;
    }

    static boolean isEndpointAttribute(EClassifier eClassifier, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEndpointAttribute", new Object[]{eClassifier, string});
        }
        String string2 = TypeRegistry.getTypeShortName(eClassifier);
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string2);
        boolean bl = false;
        if (distinguishedEndpointInfoArray != null) {
            for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
                if (!distinguishedEndpointInfoArray[i].getEndpointName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEndpointAttribute," + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getEndpointAttribute(EObject eObject, String string, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointAttribute", new Object[]{eObject, string, new Boolean(bl)});
        }
        String string2 = TypeRegistry.getTypeShortName((EClassifier)eObject.eClass());
        DocAccessor docAccessor = EndpointConfigHelper.getServerIndexAccessor(eObject);
        Resource resource = docAccessor.getResource();
        Object object = null;
        Resource resource2 = resource;
        synchronized (resource2) {
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
            String string3 = repositoryContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", string3);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            ServerEntry serverEntry = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                if (!serverEntry2.getServerName().equals(string3)) continue;
                serverEntry = serverEntry2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "matched", serverEntry);
                break;
            }
            if (serverEntry != null) {
                object = EndpointConfigHelper.getNamedEndpoint(serverEntry, string, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointAttribute", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setServerType(RepositoryContext repositoryContext, EClassifier eClassifier) throws ConfigServiceException {
        String string = TypeRegistry.getTypeShortName(eClassifier);
        String string2 = (String)serverTypeMap.get(string);
        if (string2 != null) {
            RepositoryContext repositoryContext2 = repositoryContext.getParent();
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
            Resource resource = docAccessor.getResource();
            Object var7_7 = null;
            Resource resource2 = resource;
            synchronized (resource2) {
                String string3 = repositoryContext.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serverName", string3);
                }
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                EList eList = serverIndex.getServerEntries();
                ServerEntry serverEntry = null;
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                    if (!serverEntry2.getServerName().equals(string3)) continue;
                    serverEntry = serverEntry2;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "matched", serverEntry);
                    break;
                }
                if (serverEntry == null) {
                    serverEntry = EndpointConfigHelper.createServerEntry(repositoryContext2, string3);
                }
                if (string2 != null) {
                    string2 = "DEPLOYMENT_MANAGER".equals(string2) ? "DEPLOYMENT_MANAGER" : ("NODE_AGENT".equals(string2) ? "NODE_AGENT" : ("APPLICATION_SERVER".equals(string2) && (serverEntry.getServerType() == null || serverEntry.getServerType().equals("MESSAGE_BROKER")) ? "APPLICATION_SERVER" : ("MESSAGE_BROKER".equals(string2) && serverEntry.getServerType() == null ? "MESSAGE_BROKER" : serverEntry.getServerType())));
                    serverEntry.setServerType(string2);
                }
                docAccessor.localSave();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerType");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getServerType(RepositoryContext repositoryContext) throws ConfigServiceException {
        Resource resource;
        String string = null;
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            String string2 = repositoryContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", string2);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            ServerEntry serverEntry = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                if (!serverEntry2.getServerName().equals(string2)) continue;
                serverEntry = serverEntry2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "matched", serverEntry);
                break;
            }
            if (serverEntry != null) {
                string = serverEntry.getServerType();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerEntry", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setEndpointAttribute(RepositoryContext repositoryContext, EClassifier eClassifier, String string, AttributeList attributeList, MOFUtil.ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEndpointAttribute", new Object[]{repositoryContext, eClassifier, string, attributeList});
        }
        String string2 = TypeRegistry.getTypeShortName(eClassifier);
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
        Resource resource = docAccessor.getResource();
        Object var10_10 = null;
        Resource resource2 = resource;
        synchronized (resource2) {
            String string3 = repositoryContext.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName", string3);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            ServerEntry serverEntry = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry2 = (ServerEntry)iterator.next();
                if (!serverEntry2.getServerName().equals(string3)) continue;
                serverEntry = serverEntry2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "matched", serverEntry);
                break;
            }
            if (serverEntry == null) {
                serverEntry = EndpointConfigHelper.createServerEntry(repositoryContext2, string3);
            }
            EndpointConfigHelper.setNamedEndpoint(serverEntry, string2, string, attributeList, referenceHandler, stack);
            docAccessor.localSave();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEndpointAttribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteEndpoints(RepositoryContext repositoryContext, String string, EClassifier eClassifier) throws ConfigServiceException {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteEndpoints", new Object[]{repositoryContext, string, eClassifier});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            try {
                ServerIndex serverIndex;
                ServerEntry serverEntry;
                EList eList = resource.getContents();
                if (eList != null && eList.size() > 0 && (serverEntry = EndpointConfigHelper.lookupServerEntry(serverIndex = (ServerIndex)eList.get(0), string)) != null) {
                    List list = EndpointConfigHelper.getEndpointAttributeNames(eClassifier);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        NamedEndPoint namedEndPoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, (String)iterator.next());
                        if (namedEndPoint == null) continue;
                        MOFUtil.deleteEObject((EObject)namedEndPoint);
                    }
                    docAccessor.localSave();
                }
            }
            finally {
                docAccessor.cleanup();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteEndpoints");
        }
    }

    static EClassifier getEndpointMetaObj() {
        return ipcPckg.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerEntry createServerEntry(RepositoryContext repositoryContext, String string, ObjectName objectName) throws ConfigServiceException {
        ServerEntry serverEntry;
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerEntry", new Object[]{repositoryContext, string, objectName});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            try {
                ServerIndex serverIndex;
                EList eList = resource.getContents();
                if (eList.size() == 0) {
                    serverIndex = serverIndexFactory.createServerIndex();
                    eList.add(serverIndex);
                } else {
                    serverIndex = (ServerIndex)resource.getContents().get(0);
                }
                serverEntry = EndpointConfigHelper.lookupServerEntry(serverIndex, string);
                if (serverEntry == null) {
                    Object object;
                    Object object2;
                    DocAccessor docAccessor2;
                    EndPoint endPoint;
                    Session session;
                    Object object3;
                    if (objectName != null) {
                        ServerEntry serverEntry2;
                        object3 = repositoryContext.getWorkSpace();
                        session = WorkspaceHelper.getConfigSession(objectName);
                        if (session != null) {
                            object3 = WorkspaceHelper.getWorkspace(session);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "template workspace", object3);
                        }
                        if ((serverEntry2 = EndpointConfigHelper.lookupServerEntry((ServerIndex)(endPoint = (ServerIndex)(docAccessor2 = WorkspaceHelper.getDocAccessor((RepositoryContext)(object2 = (object = WorkspaceHelper.getContext((WorkSpace)object3, ConfigServiceHelper.getConfigDataId(objectName))).getParent()), "serverindex.xml")).getResource().getContents().get(0)), ConfigServiceHelper.getDisplayName(objectName))) != null) {
                            serverEntry = (ServerEntry)RefObjectHelperFactory.getRefObjectHelper().clone((EObject)serverEntry2);
                        }
                    }
                    if (serverEntry == null) {
                        serverEntry = serverIndexFactory.createServerEntry();
                    }
                    serverEntry.setServerName(string);
                    object3 = serverIndex.getHostName();
                    session = serverEntry.getSpecialEndpoints();
                    object = new ArrayList();
                    object2 = session.iterator();
                    while (object2.hasNext()) {
                        docAccessor2 = (NamedEndPoint)object2.next();
                        endPoint = docAccessor2.getEndPoint();
                        if (endPoint == null) continue;
                        int n = endPoint.getPort();
                        if (n != 0) {
                            int n2;
                            endPoint.setPort(0);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Actual port generated " + n);
                            }
                            if (skipList.size() > 0) {
                                boolean bl;
                                do {
                                    n2 = EndpointConfigHelper.adjustPort(repositoryContext, n, (List)object);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adjusted port: " + n2);
                                    }
                                    bl = false;
                                    if (!skipList.contains(new Integer(n2))) continue;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Port- " + n2 + " is in skip port list-> adjusting port..");
                                    }
                                    n = ++n2;
                                    bl = true;
                                } while (bl);
                            } else {
                                n2 = EndpointConfigHelper.adjustPort(repositoryContext, n, (List)object);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adjusted port: " + n2);
                                }
                            }
                            endPoint.setPort(n2);
                            object.add(new Integer(n2));
                        }
                        if ("*".equals(endPoint.getHost())) continue;
                        endPoint.setHost((String)object3);
                    }
                    serverIndex.getServerEntries().add((Object)serverEntry);
                }
                docAccessor.localSave();
            }
            finally {
                docAccessor.cleanup();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerEntry", serverEntry);
        }
        return serverEntry;
    }

    static ServerEntry createServerEntry(RepositoryContext repositoryContext, String string) throws ConfigServiceException {
        return EndpointConfigHelper.createServerEntry(repositoryContext, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteServerEntry(RepositoryContext repositoryContext, String string) throws ConfigServiceException {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerEntry", new Object[]{repositoryContext, string});
        }
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            try {
                EList eList = resource.getContents();
                if (eList.size() > 0) {
                    ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                    ServerEntry serverEntry = EndpointConfigHelper.lookupServerEntry(serverIndex, string);
                    if (serverEntry != null) {
                        MOFUtil.deleteEObject((EObject)serverEntry);
                    }
                    docAccessor.localSave();
                }
            }
            finally {
                docAccessor.cleanup();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteServerEntry");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getDeployedApplications(Session session, ObjectName objectName) throws ConfigServiceException {
        Resource resource;
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(objectName)).getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            ServerEntry serverEntry = EndpointConfigHelper.lookupServerEntry((ServerIndex)resource.getContents().get(0), ConfigServiceHelper.getDisplayName(objectName));
            ArrayList arrayList = new ArrayList(serverEntry.getDeployedApplications());
            return arrayList;
        }
    }

    private static DocAccessor getServerIndexAccessor(EObject eObject) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndexAccessor", eObject);
        }
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverContext", repositoryContext);
        }
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext2, "serverindex.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndexAccessor", docAccessor);
        }
        return docAccessor;
    }

    private static ServerEntry lookupServerEntry(ServerIndex serverIndex, String string) {
        EList eList = serverIndex.getServerEntries();
        ServerEntry serverEntry = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry2 = (ServerEntry)iterator.next();
            if (!serverEntry2.getServerName().equals(string)) continue;
            serverEntry = serverEntry2;
            break;
        }
        return serverEntry;
    }

    private static Object getNamedEndpoint(ServerEntry serverEntry, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamedEndpoint", new Object[]{serverEntry, string});
        }
        Serializable serializable = null;
        NamedEndPoint namedEndPoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, string);
        if (namedEndPoint != null) {
            if (bl) {
                try {
                    serializable = MOFUtil.getAttributes((EObject)namedEndPoint.getEndPoint(), null, true);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception caught when getting attributes", exception);
                    }
                }
            } else {
                serializable = MOFUtil.createObjectName((EObject)namedEndPoint.getEndPoint());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamedEndpoint", serializable);
        }
        return serializable;
    }

    private static NamedEndPoint lookupNamedEndpoint(ServerEntry serverEntry, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupNamedEndpoint", new Object[]{serverEntry, string});
        }
        NamedEndPoint namedEndPoint = null;
        EList eList = serverEntry.getSpecialEndpoints();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint2 = (NamedEndPoint)iterator.next();
            if (!string.equals(namedEndPoint2.getEndPointName())) continue;
            namedEndPoint = namedEndPoint2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamedEndpoint", namedEndPoint);
        }
        return namedEndPoint;
    }

    private static void setNamedEndpoint(ServerEntry serverEntry, String string, String string2, AttributeList attributeList, MOFUtil.ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        NamedEndPoint namedEndPoint;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNamedEndpoint", new Object[]{serverEntry, string2, attributeList});
        }
        EList eList = serverEntry.getSpecialEndpoints();
        NamedEndPoint namedEndPoint2 = null;
        EObject eObject = eList.iterator();
        while (eObject.hasNext()) {
            namedEndPoint = (NamedEndPoint)eObject.next();
            if (!string2.equals(namedEndPoint.getEndPointName())) continue;
            namedEndPoint2 = namedEndPoint;
            break;
        }
        if (attributeList == null) {
            if (namedEndPoint2 != null) {
                MOFUtil.deleteEObject(namedEndPoint2);
            }
        } else {
            for (eObject = serverEntry.eContainer(); eObject != null && !(eObject instanceof ServerIndex); eObject = eObject.eContainer()) {
            }
            namedEndPoint = (ServerIndex)eObject;
            if (namedEndPoint2 == null) {
                namedEndPoint2 = serverIndexFactory.createNamedEndPoint();
                namedEndPoint2.setEndPointName(string2);
                eList.add(namedEndPoint2);
                if (EndpointConfigHelper.isUniqueEndpoint(string, string2)) {
                    namedEndPoint.getEndPointRefs().add((Object)namedEndPoint2);
                }
            }
            if (namedEndPoint2.getEndPoint() == null) {
                EndPoint endPoint = ipcPckg.getIpcFactory().createEndPoint();
                endPoint.setPort(-1);
                namedEndPoint2.setEndPoint(endPoint);
            }
            EndpointConfigHelper.fillDefaultEndpoint((ServerIndex)namedEndPoint, serverEntry, string, string2, attributeList);
            MOFUtil.setAttributes(WorkspaceHelper.getContext(serverEntry.eResource()), (EObject)namedEndPoint2.getEndPoint(), attributeList, referenceHandler, stack);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNamedEndpoint");
        }
    }

    private static AttributeList getEndpointMetaInfo(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndpointMetaInfo", string);
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("_Attribute_MetaInfo_Name", string));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Default_Value", null));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        String string2 = TypeRegistry.getTypeShortName((EClassifier)ipcPckg.getEndPoint());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "typeName", string2);
        }
        attributeList.add(new Attribute("_Attribute_MetaInfo_Type", string2));
        try {
            String[] stringArray = TypeRegistry.getSubTypes(string2);
            if (stringArray != null && stringArray.length > 0) {
                attributeList.add(new Attribute("_Attribute_MetaInfo_Subtypes", Arrays.asList(stringArray)));
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            // empty catch block
        }
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpointMetaInfo", attributeList);
        }
        return attributeList;
    }

    private static int defaultEndpoint(String string, String string2) {
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string);
        int n = 0;
        for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
            if (!distinguishedEndpointInfoArray[i].getEndpointName().equals(string2)) continue;
            n = distinguishedEndpointInfoArray[i].getDefaultPort();
            break;
        }
        return n;
    }

    private static boolean isUniqueEndpoint(String string, String string2) {
        DistinguishedEndpointInfo[] distinguishedEndpointInfoArray = (DistinguishedEndpointInfo[])endpointMap.get(string);
        boolean bl = false;
        for (int i = 0; i < distinguishedEndpointInfoArray.length; ++i) {
            if (!distinguishedEndpointInfoArray[i].getEndpointName().equals(string2)) continue;
            bl = distinguishedEndpointInfoArray[i].isUnique();
            break;
        }
        return bl;
    }

    public static synchronized void setAdjustFlag(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointConfigThreadLocal, " + bl);
        }
        thisThread.set(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointConfigThreadLocal");
        }
    }

    public static int adjustPort(RepositoryContext repositoryContext, int n, List arrayList) throws ConfigServiceException {
        Boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustPort," + n);
        }
        if (!(bl = (Boolean)thisThread.get()).booleanValue()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "adjustPort," + n);
            }
            return n;
        }
        if (n == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "adjustPort," + n);
            }
            return n;
        }
        try {
            Object object;
            if (arrayList == null || arrayList.size() == 0) {
                Serializable serializable;
                ObjectName[] objectNameArray;
                Serializable serializable2;
                Object object2;
                if (arrayList == null) {
                    arrayList = new ArrayList<Serializable>();
                }
                if (repositoryContext.getType().getName().equals("servers")) {
                    repositoryContext = repositoryContext.getParent();
                }
                if (!AdminHelper.getPlatformHelper().isZOS()) {
                    Object object3;
                    Object object4;
                    if (!repositoryContext.getType().getName().equals("nodes")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "should never happen");
                        }
                        return n;
                    }
                    object = repositoryContext.getType();
                    object2 = object.getRootDocumentType();
                    serializable2 = new ConfigDataId(repositoryContext.getURI(), object2.getFilePattern());
                    objectNameArray = ConfigServiceHelper.createObjectName(serializable2, object2.getRootRefObjectTypes()[0], repositoryContext.getName());
                    ConfigServiceImpl configServiceImpl = ConfigServiceImpl.getInstance();
                    serializable = new Session(repositoryContext.getWorkSpace().getUserName(), true);
                    String string = (String)configServiceImpl.getAttribute((Session)serializable, (ObjectName)objectNameArray, "hostName");
                    String string2 = null;
                    if (string != null) {
                        string2 = EndpointConfigHelper.getHostIPAddress(string);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The hostname of this node is null - should not happen");
                    }
                    ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node");
                    ObjectName[] objectNameArray2 = configServiceImpl.resolve((Session)serializable, null, "Cell=:Node=");
                    ArrayList<ObjectName> arrayList2 = new ArrayList<ObjectName>();
                    for (int i = 0; i < objectNameArray2.length; ++i) {
                        object4 = (String)configServiceImpl.getAttribute((Session)serializable, objectNameArray2[i], "hostName");
                        object3 = null;
                        if (object4 != null) {
                            object3 = EndpointConfigHelper.getHostIPAddress((String)object4);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The hostname of the node " + objectNameArray2[i] + "is null - should not happen");
                        }
                        if (string2 == null || object3 == null) {
                            if (!string.equals(object4)) continue;
                            arrayList2.add(objectNameArray2[i]);
                            continue;
                        }
                        if (!string2.equals(object3)) continue;
                        arrayList2.add(objectNameArray2[i]);
                    }
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        object4 = (ObjectName)iterator.next();
                        object3 = configServiceImpl.getRelationship((Session)serializable, (ObjectName)object4, "ServerIndex")[0];
                        ObjectName[] objectNameArray3 = configServiceImpl.resolve((Session)serializable, (ObjectName)object3, "EndPoint=");
                        for (int i = 0; i < objectNameArray3.length; ++i) {
                            Integer n2 = (Integer)configServiceImpl.getAttribute((Session)serializable, objectNameArray3[i], "port");
                            if (n2 == null) continue;
                            arrayList.add(n2);
                        }
                    }
                } else {
                    if (repositoryContext.getType().getName().equals("nodes")) {
                        repositoryContext = repositoryContext.getParentContext();
                    }
                    if (!repositoryContext.getType().getName().equals("cells")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "z/OS - not scanning at cell level");
                        }
                        return n;
                    }
                    object = MOFUtil.createObjectName(repositoryContext);
                    object2 = ConfigServiceImpl.getInstance();
                    serializable2 = new Session(repositoryContext.getWorkSpace().getUserName(), true);
                    objectNameArray = object2.queryConfigObjects((Session)serializable2, (ObjectName)object, ConfigServiceHelper.createObjectName(null, "EndPoint"), null);
                    for (int i = 0; i < objectNameArray.length; ++i) {
                        serializable = (Integer)object2.getAttribute((Session)serializable2, objectNameArray[i], "port");
                        if (serializable == null) continue;
                        arrayList.add(serializable);
                    }
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (n != (Integer)object.next()) continue;
                ++n;
                n = EndpointConfigHelper.adjustPort(repositoryContext, n, arrayList);
                break;
            }
        }
        catch (ConfigServiceException configServiceException) {
            throw configServiceException;
        }
        catch (AdminException adminException) {
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustPort," + n);
        }
        return n;
    }

    private static String getHostIPAddress(String string) throws InvalidAttributeValException {
        InetAddress inetAddress = null;
        try {
            inetAddress = string.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = "UnknownHostException caught when getting the host IP address: homename = " + string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2, unknownHostException);
            }
            return null;
        }
        catch (Exception exception) {
            String string3 = "A exception caught when getting the host IP address: homename = " + string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string3, exception);
            }
            return null;
        }
        return inetAddress.getHostAddress();
    }

    private static void fillDefaultEndpoint(ServerIndex serverIndex, ServerEntry serverEntry, String string, String string2, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillDefaultEndpoint", new Object[]{serverIndex, string2, attributeList});
        }
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, "host");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (object == null) {
            ConfigServiceHelper.setAttributeValue(attributeList, "host", serverIndex.getHostName());
        }
        object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, "port");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (object == null) {
            EndPoint endPoint;
            int n = -1;
            NamedEndPoint namedEndPoint = EndpointConfigHelper.lookupNamedEndpoint(serverEntry, string2);
            if (namedEndPoint != null && (endPoint = namedEndPoint.getEndPoint()) != null) {
                n = endPoint.getPort();
                endPoint.setPort(0);
            }
            if (n == -1) {
                n = EndpointConfigHelper.defaultEndpoint(string, string2);
            }
            n = EndpointConfigHelper.adjustPort(WorkspaceHelper.getContext(serverIndex.eResource()), n, null);
            ConfigServiceHelper.setAttributeValue(attributeList, "port", new Integer(n));
        }
    }

    static {
        thisThread = new EndPointConfigThreadLocal();
        propertyFile = "port_skip.props";
        skipPorts = null;
        skipList = new ArrayList();
        props = new Properties();
        EndpointConfigHelper.loadPropertyFile(propertyFile);
        serverIndexFactory = ServerindexFactory.eINSTANCE;
        ipcPckg = IpcFactory.eINSTANCE.getIpcPackage();
        endpointMap = new HashMap();
        endpointMap.put("SystemMessageServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("DRS_CLIENT_ADDRESS", 7873, false)});
        endpointMap.put("JMSServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("JMSSERVER_DIRECT_ADDRESS", 5559, false), new DistinguishedEndpointInfo("JMSSERVER_QUEUED_ADDRESS", 5558, false)});
        if (AdminHelper.getPlatformHelper().isZOS()) {
            endpointMap.put("NameServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("BOOTSTRAP_ADDRESS", 9810, false), new DistinguishedEndpointInfo("ORB_LISTENER_ADDRESS", 9810, false), new DistinguishedEndpointInfo("ORB_SSL_LISTENER_ADDRESS", 0, false)});
            endpointMap.put("LocationServiceDaemon", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS", 9021, false), new DistinguishedEndpointInfo("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS", 9022, false), new DistinguishedEndpointInfo("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS", 9023, false)});
        } else {
            endpointMap.put("NameServer", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("BOOTSTRAP_ADDRESS", 9810, false)});
            endpointMap.put("ObjectRequestBroker", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("ORB_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("SAS_SSL_SERVERAUTH_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("CSIV2_SSL_SERVERAUTH_LISTENER_ADDRESS", 0, false), new DistinguishedEndpointInfo("CSIV2_SSL_MUTUALAUTH_LISTENER_ADDRESS", 0, false)});
        }
        endpointMap.put("NodeAgent", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("NODE_DISCOVERY_ADDRESS", 7272, true)});
        endpointMap.put("CellManager", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("CELL_MULTICAST_DISCOVERY_ADDRESS", 5000, true), new DistinguishedEndpointInfo("CELL_DISCOVERY_ADDRESS", 7277, true)});
        endpointMap.put("SOAPConnector", new DistinguishedEndpointInfo[]{new DistinguishedEndpointInfo("SOAP_CONNECTOR_ADDRESS", 8880, false)});
        serverTypeMap = new HashMap();
        serverTypeMap.put("ApplicationServer", "APPLICATION_SERVER");
        serverTypeMap.put("JMSServer", "MESSAGE_BROKER");
        serverTypeMap.put("NodeAgent", "NODE_AGENT");
        serverTypeMap.put("CellManager", "DEPLOYMENT_MANAGER");
    }

    private static class DistinguishedEndpointInfo {
        private String endpointName;
        private int defaultPort;
        private boolean isUnique;

        DistinguishedEndpointInfo(String string, int n, boolean bl) {
            this.endpointName = string;
            this.defaultPort = n;
            this.isUnique = bl;
        }

        public String getEndpointName() {
            return this.endpointName;
        }

        public int getDefaultPort() {
            return this.defaultPort;
        }

        public boolean isUnique() {
            return this.isUnique;
        }
    }
}

