/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;

public class InnerConfigObjectDelegator
extends ConfigObjectDelegator {
    private static TraceComponent tc = Tr.register(InnerConfigObjectDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    private String type;
    private String mofAttribute;

    public InnerConfigObjectDelegator(ConfigServiceImpl configServiceImpl, String string, String string2) {
        super(configServiceImpl);
        this.type = string;
        this.mofAttribute = string2;
    }

    public String getType() {
        return this.type;
    }

    public ObjectName[] getAll(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", objectName);
        }
        ObjectName[] objectNameArray = null;
        if (objectName == null || WorkspaceHelper.isScopeContext(session, objectName)) {
            ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
            ArrayList arrayList2 = new ArrayList();
            this.getFileNames(this, arrayList2);
            Collection collection = WorkspaceHelper.getScopeContexts(session, objectName);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
                Iterator iterator2 = arrayList2.iterator();
                while (iterator2.hasNext()) {
                    List list = this.getTypedDocuments(repositoryContext, (String)iterator2.next());
                    Iterator iterator3 = list.iterator();
                    while (iterator3.hasNext()) {
                        try {
                            WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator3.next();
                            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, workSpaceFile);
                            ObjectName[] objectNameArray2 = docAccessor.getTypedObjects(session, this.getType());
                            for (int i = 0; objectNameArray2 != null && i < objectNameArray2.length; ++i) {
                                arrayList.add(objectNameArray2[i]);
                            }
                        }
                        catch (ConfigDocumentLoadException configDocumentLoadException) {
                            Tr.error(tc, "ADMG0003E", configDocumentLoadException);
                        }
                    }
                }
            }
            objectNameArray = new ObjectName[arrayList.size()];
            arrayList.toArray(objectNameArray);
        } else {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
            EObject eObject = docAccessor.lookup(configDataId);
            objectNameArray = docAccessor.getTypedObjects(this.type, eObject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", objectNameArray);
        }
        return objectNameArray;
    }

    protected ObjectName getParent(Session session, ObjectName objectName) throws ConfigServiceException {
        return this.getMOFParent(session, objectName);
    }

    protected ObjectName[] getChildren(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo) throws ConfigServiceException {
        ObjectName[] objectNameArray;
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        try {
            ObjectName[] objectNameArray2 = docAccessor.getRelationship(session, configDataId, this.mofAttribute);
            ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
            for (int i = 0; i < objectNameArray2.length; ++i) {
                if (!ConfigServiceHelper.getConfigDataType(objectNameArray2[i]).equals(childTypeInfo.getChildDelegator().getType())) continue;
                arrayList.add(objectNameArray2[i]);
            }
            objectNameArray = new ObjectName[arrayList.size()];
            arrayList.toArray(objectNameArray);
        }
        catch (ConfigDataNotFoundException configDataNotFoundException) {
            FFDCFilter.processException((Throwable)configDataNotFoundException, "com.ibm.ws.management.configservice.InnerConfigObjectDelegator.getChildren", "93", this);
            return new ObjectName[0];
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        ObjectName objectName2;
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        this.dupJndi(session, objectName, null, attributeList);
        ConfigServiceHelper.setAttributeValue(attributeList, "_Websphere_Config_Data_Type", this.getType());
        try {
            objectName2 = childTypeInfo.isCollection() ? docAccessor.addElementAt(session, configDataId, this.mofAttribute, attributeList, -1, true) : docAccessor.createConfigData(session, configDataId, this.mofAttribute, attributeList, true);
            docAccessor.localSave();
        }
        finally {
            docAccessor.cleanup();
        }
        return objectName2;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        WorkspaceHelper.getDocAccessor(session, configDataId);
        this.dupJndi(session, this.getParent(session, objectName), objectName, attributeList);
        super.setAttributes(session, objectName, attributeList);
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        WorkspaceHelper.getDocAccessor(session, configDataId);
        this.dupJndi(session, this.getParent(session, objectName), objectName, attributeList);
        super.resetAttributes(session, objectName, attributeList);
    }

    private void getFileNames(ConfigObjectDelegator configObjectDelegator, List list) {
        Iterator iterator = configObjectDelegator.parentTypes.iterator();
        while (iterator.hasNext()) {
            ConfigServiceDelegator configServiceDelegator = this.baseConfigService.getDelegator((String)iterator.next());
            if (configServiceDelegator == null || !(configServiceDelegator instanceof ConfigObjectDelegator)) continue;
            if (configServiceDelegator instanceof RootObjectDelegator) {
                list.add(((RootObjectDelegator)configServiceDelegator).getFileName());
                continue;
            }
            this.getFileNames((ConfigObjectDelegator)configServiceDelegator, list);
        }
    }

    void dupJndi(Session session, ObjectName objectName, ObjectName objectName2, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dupJndi", new Object[]{objectName, attributeList});
        }
        boolean bl = false;
        String string = null;
        try {
            string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "jndiName");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jndiName", string);
            }
            if (string != null) {
                ObjectName objectName3 = this.baseConfigService.getRelationship(session, objectName, "parent")[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scope", objectName3);
                }
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("lookupResources");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("scope", objectName3);
                adminCommand.setParameter("jndiName", string);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    List list = (List)commandResult.getResult();
                    int n = list.size();
                    switch (n) {
                        case 0: {
                            bl = false;
                            break;
                        }
                        case 1: {
                            if (objectName2 != null) {
                                bl = !ConfigServiceHelper.getConfigDataId((ObjectName)list.get(0)).equals(ConfigServiceHelper.getConfigDataId(objectName2));
                                break;
                            }
                            bl = true;
                            break;
                        }
                        default: {
                            bl = true;
                            break;
                        }
                    }
                } else {
                    throw commandResult.getException();
                }
                if (bl) {
                    throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0037E", new Object[]{this.type, "jndiName", string}, null));
                }
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
        }
        catch (ConfigServiceException configServiceException) {
            throw configServiceException;
        }
        catch (Throwable throwable) {
            throw new ConfigServiceException(throwable, "unexpected exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dupJndi");
        }
    }
}

