/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.models.base.resources.J2EEResourceFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.SystemAttributes;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.ReadOnlyAttributeException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.loggingservice.ras.ServiceLog;
import com.ibm.websphere.models.config.process.ServerComponent;
import com.ibm.websphere.models.config.rolebasedauthz.GroupExt;
import com.ibm.websphere.models.config.rolebasedauthz.SubjectExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigServiceUtils;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MetadataFilter;
import com.ibm.ws.management.configservice.RequiredAttributesRegistry;
import com.ibm.ws.management.configservice.SpecialAttributeRegistry;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MOFUtil {
    private static TraceComponent tc = Tr.register(MOFUtil.class, "management", "com.ibm.ws.management.resources.configservice");
    private static final Class[] innerConfigObjectTypes = new Class[]{ServerComponent.class, J2EEResourceFactory.class};

    public static EStructuralFeature getAttributeMetaObj(EObject eObject, String string, boolean bl) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj((EClass)eObject, string, new Stack(), bl, null);
    }

    private static EStructuralFeature getAttributeMetaObjNoException(EObject eObject, String string, boolean bl) {
        return MOFUtil.getAttributeMetaObjNoException((EClass)eObject, string, new Stack(), bl, null);
    }

    public static EStructuralFeature getAttributeMetaObj(EObject eObject, String string, boolean bl, Properties properties) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj((EClass)eObject, string, new Stack(), bl, properties);
    }

    public static EObject newRefObject(RepositoryContext repositoryContext, EObject eObject, ObjectName objectName) throws ConfigServiceException {
        EObject eObject2 = WorkspaceHelper.getTemplate(repositoryContext.getWorkSpace(), (EClassifier)eObject, objectName);
        if (eObject2 == null) {
            eObject2 = MOFUtil.newInstance(eObject);
        }
        return eObject2;
    }

    public static EObject convertToEObject(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToEObject", new Object[]{session, objectName});
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
        EObject eObject = docAccessor.lookup(configDataId);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToEObject", eObject);
        }
        return eObject;
    }

    public static EObject newInstance(EObject eObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newInstance", eObject);
        }
        EClass eClass = (EClass)eObject;
        EObject eObject2 = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newInstance", eObject2);
        }
        return eObject2;
    }

    public static void validateConfigData(EObject eObject, AttributeList attributeList, Properties properties) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        Stack stack = new Stack();
        MOFUtil.validateAttributeList(eObject, attributeList, attributeList, stack, properties);
    }

    public static void setAttributes(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{repositoryContext, eObject, attributeList});
        }
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        Object object = attributeList.iterator();
        while (object.hasNext()) {
            EStructuralFeature eStructuralFeature;
            String string = ((Attribute)object.next()).getName();
            if (SystemAttributes.isSystemAttribute(string) || EndpointConfigHelper.isEndpointAttribute((EClassifier)eObject.eClass(), string) || !SpecialAttributeRegistry.isReadOnlyAttribute(eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false, properties))) continue;
            throw new ReadOnlyAttributeException(string);
        }
        MOFUtil.validateConfigData((EObject)eObject.eClass(), attributeList, properties);
        object = new ReferenceHandler();
        MOFUtil.setAttributes(repositoryContext, eObject, attributeList, (ReferenceHandler)object, new Stack());
        ((ReferenceHandler)object).update(repositoryContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes", null);
        }
    }

    public static void resetAttributes(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{eObject, attributeList});
        }
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        MOFUtil.validateConfigData((EObject)eObject.eClass(), attributeList, properties);
        List list = MOFUtil.getAllAttributeMetaObjs(eObject.eClass(), properties);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            MOFUtil.unsetAttribute(eObject, eStructuralFeature.getName());
        }
        MOFUtil.setAttributes(repositoryContext, eObject, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public static void unsetAttribute(EObject eObject, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttribute", new Object[]{eObject, string});
        }
        Properties properties = MOFUtil.getNodeProperties(eObject);
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false, properties);
        if (SpecialAttributeRegistry.isReadOnlyAttribute(eStructuralFeature)) {
            throw new ReadOnlyAttributeException(string);
        }
        if (EndpointConfigHelper.isEndpointAttribute((EClassifier)eObject.eClass(), string)) {
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
            EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, null, new ReferenceHandler(), new Stack());
        } else if (eStructuralFeature.isMany()) {
            List list = (List)eObject.eGet(eStructuralFeature);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof EObject)) continue;
                RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
                MOFUtil.objectRemoved(repositoryContext, (EObject)e2, new ReferenceHandler(), new Stack());
            }
            ((List)eObject.eGet(eStructuralFeature)).clear();
        } else {
            Object object = eObject.eGet(eStructuralFeature);
            if (object instanceof EObject) {
                RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
                MOFUtil.objectRemoved(repositoryContext, (EObject)object, new ReferenceHandler(), new Stack());
            }
            eObject.eUnset(eStructuralFeature);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttribute");
        }
    }

    public static Object addElementAt(RepositoryContext repositoryContext, EObject eObject, String string, Object object, int n, boolean bl) throws ConfigServiceException {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute(string, arrayList));
        Stack<String> stack = new Stack<String>();
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, bl, properties);
        MOFUtil.validateAttribute(eStructuralFeature, arrayList, attributeList, stack, properties);
        stack.clear();
        stack.push(string);
        List list = (List)eObject.eGet(eStructuralFeature);
        if (object instanceof ObjectName && !MOFUtil.isComposite(eStructuralFeature)) {
            try {
                ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)object);
                object2 = MOFUtil.lookup(repositoryContext, configDataId, MOFUtil.getAttributePath(stack));
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.management.configservice.MOFUtil.addElementAt", "183");
                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack), exception);
            }
        } else if (object instanceof AttributeList && eStructuralFeature instanceof EReference) {
            ReferenceHandler referenceHandler = new ReferenceHandler();
            EObject eObject2 = MOFUtil.createRefObject(repositoryContext, (EObject)eStructuralFeature.getEType(), (AttributeList)object, referenceHandler, stack);
            SpecialAttributeRegistry.checkUnique(((EReference)eStructuralFeature).getEReferenceType(), list, eObject2);
            object2 = eObject2;
            referenceHandler.update(repositoryContext);
        } else if (eStructuralFeature instanceof EAttribute) {
            object2 = object;
        } else {
            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
        }
        if (n < 0 || n >= list.size()) {
            list.add(object2);
        } else {
            list.add(n, object2);
        }
        if (object2 instanceof EObject) {
            MOFUtil.objectAdded(repositoryContext, (EObject)object2, new ReferenceHandler(), stack);
        }
        return object2;
    }

    public static void removeElement(RepositoryContext repositoryContext, EObject eObject, String string, Object object) throws ConfigServiceException {
        Object object2;
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false, properties);
        if (!eStructuralFeature.isMany()) {
            throw new InvalidAttributeValException(new String[]{string});
        }
        if (eStructuralFeature instanceof EReference && object instanceof ObjectName) {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)object);
            object2 = MOFUtil.lookup(repositoryContext, configDataId, new String[]{string});
        } else if (eStructuralFeature instanceof EAttribute) {
            object2 = object;
        } else {
            throw new InvalidAttributeValException(new String[]{string});
        }
        if (object2 instanceof EObject && MOFUtil.isComposite(eStructuralFeature)) {
            MOFUtil.deleteEObject((EObject)object2);
            MOFUtil.objectRemoved(repositoryContext, (EObject)object2, new ReferenceHandler(), new Stack());
        } else {
            ((List)eObject.eGet(eStructuralFeature)).remove(object2);
        }
    }

    public static EObject createRefObject(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRefObject", new Object[]{repositoryContext, eObject, attributeList});
        }
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Properties", properties);
        }
        MOFUtil.validateConfigData(eObject, attributeList, properties);
        ReferenceHandler referenceHandler = new ReferenceHandler();
        EObject eObject2 = MOFUtil.createRefObject(repositoryContext, eObject, attributeList, referenceHandler, new Stack());
        referenceHandler.update(repositoryContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRefObject", new Object[]{eObject2});
        }
        return eObject2;
    }

    public static AttributeList getAttributes(EObject eObject, String[] stringArray, boolean bl) throws ConfigServiceException {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{eObject, stringArray});
        }
        Properties properties = MOFUtil.getNodeProperties(eObject);
        EClass eClass = eObject.eClass();
        if (stringArray == null) {
            EStructuralFeature eStructuralFeature;
            int n;
            list = MOFUtil.getAllAttributeMetaObjs(eClass, properties);
            List list2 = EndpointConfigHelper.getEndpointAttributeNames((EClassifier)eClass);
            stringArray = new String[list.size() + list2.size()];
            for (n = 0; n < list.size(); ++n) {
                eStructuralFeature = (EStructuralFeature)list.get(n);
                stringArray[n] = eStructuralFeature.getName();
            }
            eStructuralFeature = list2.iterator();
            while (eStructuralFeature.hasNext()) {
                stringArray[n] = (String)eStructuralFeature.next();
                ++n;
            }
        }
        list = new AttributeList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "ADDING ATTRIBUTE: " + stringArray[i]);
                }
                ((AttributeList)list).add(new Attribute(stringArray[i], MOFUtil.getAttribute(eObject, stringArray[i], bl)));
                continue;
            }
            catch (ConfigServiceException configServiceException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception", configServiceException);
                }
                FFDCFilter.processException(configServiceException, "com.ibm.ws.management.configservice.MOFUtil.getAttributes", "271");
                throw configServiceException;
            }
        }
        ((AttributeList)list).add(new Attribute("_Websphere_Config_Data_Id", MOFUtil.createConfigDataId(eObject)));
        ((AttributeList)list).add(new Attribute("_Websphere_Config_Data_Type", TypeRegistry.getTypeShortName((EClassifier)eClass)));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", ConfigServiceUtils.maskPasswordInAttrList((AttributeList)list));
        }
        return list;
    }

    public static Object getAttribute(EObject eObject, String string, boolean bl) throws ConfigServiceException {
        EClass eClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{eObject, string});
        }
        Properties properties = MOFUtil.getNodeProperties(eObject);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Properties", properties);
        }
        if (EndpointConfigHelper.isEndpointAttribute((EClassifier)(eClass = eObject.eClass()), string)) {
            Object object = EndpointConfigHelper.getEndpointAttribute(eObject, string, bl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAttribute", object);
            }
            return object;
        }
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eClass, string, false, properties);
        Serializable serializable = eObject.eGet(eStructuralFeature);
        Object object = serializable;
        if (serializable != null) {
            if (eStructuralFeature.isMany()) {
                List list = serializable;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                if (eStructuralFeature instanceof EAttribute) {
                    if (eStructuralFeature.getEType() instanceof EEnum) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Enumerator enumerator = (Enumerator)iterator.next();
                            String string2 = enumerator == null ? null : enumerator.getName();
                            arrayList.add(string2);
                        }
                    } else {
                        arrayList.addAll(list);
                    }
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        EObject eObject2 = (EObject)iterator.next();
                        if (!MOFUtil.isValidType(eObject2)) continue;
                        if (bl && MOFUtil.isComposite(eStructuralFeature)) {
                            arrayList.add(MOFUtil.getAttributes(eObject2, null, bl));
                            continue;
                        }
                        arrayList.add(MOFUtil.createObjectName(eObject2));
                    }
                }
                serializable = arrayList;
            } else if (eStructuralFeature instanceof EReference) {
                if (MOFUtil.isValidType((EObject)serializable)) {
                    serializable = bl && MOFUtil.isComposite(eStructuralFeature) ? MOFUtil.getAttributes((EObject)serializable, null, bl) : MOFUtil.createObjectName((EObject)serializable);
                }
            } else if (eStructuralFeature.getEType() instanceof EEnum) {
                serializable = ((Object)serializable).toString();
            }
            if (serializable instanceof AttributeList) {
                object = ConfigServiceUtils.maskPasswordInAttrList((AttributeList)serializable);
            }
            if (serializable instanceof ArrayList) {
                object = ConfigServiceUtils.maskPasswordInArrayList(serializable);
            }
            if (serializable instanceof String && !((Object)serializable).equals("") && eStructuralFeature.getName().equals("password")) {
                object = "****";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return serializable;
    }

    public static void delete(EObject eObject) {
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(eObject.eResource());
        MOFUtil.deleteEObject(eObject);
        MOFUtil.objectRemoved(repositoryContext, eObject, new ReferenceHandler(), new Stack());
    }

    static void deleteEObject(EObject eObject) {
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            MOFUtil.clearReferences(eObject2);
        }
        MOFUtil.clearReferences(eObject);
        EcoreUtil.remove((EObject)eObject);
    }

    private static void clearReferences(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource != null) {
            Collection collection = EcoreUtil.UsageCrossReferencer.find((EObject)eObject, (ResourceSet)resource.getResourceSet());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iterator.next();
                EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                if (eStructuralFeature.isMany()) {
                    EObject eObject2 = setting.getEObject();
                    List list = (List)eObject2.eGet(eStructuralFeature);
                    list.remove(eObject);
                    continue;
                }
                setting.set(null);
            }
        }
    }

    public static AttributeList getAttributesMetaInfo(EObject eObject) {
        return MOFUtil.getAttributesMetaInfo(eObject, null);
    }

    public static AttributeList getAttributesMetaInfo(EObject eObject, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", eObject);
        }
        AttributeList attributeList = new AttributeList();
        List list = MOFUtil.getAllAttributeMetaObjs((EClass)eObject, properties);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            attributeList.add(new Attribute(eStructuralFeature.getName(), MOFUtil.getAttributeMetaInfo(TypeRegistry.getTypeShortName((EClassifier)eObject), eStructuralFeature, properties)));
        }
        EndpointConfigHelper.getAllEndpointMetaInfo((EClassifier)((EClass)eObject), attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", attributeList);
        }
        return attributeList;
    }

    public static ObjectName createObjectName(RepositoryContext repositoryContext) {
        RepositoryDocumentType repositoryDocumentType = repositoryContext.getType().getRootDocumentType();
        String string = null;
        String string2 = null;
        if (repositoryDocumentType != null) {
            string = repositoryDocumentType.getRootRefObjectTypes()[0];
            string2 = repositoryDocumentType.getFilePattern();
        }
        String string3 = repositoryContext.getName();
        ConfigDataId configDataId = new ConfigDataId(repositoryContext.getURI(), string2);
        return WorkspaceHelper.createObjectName(configDataId, string, string3, MOFUtil.getConfigSession(repositoryContext));
    }

    public static ObjectName createObjectName(EObject eObject) {
        ConfigDataId configDataId = MOFUtil.createConfigDataId(eObject);
        String string = TypeRegistry.getTypeShortName((EClassifier)eObject.eClass());
        String string2 = null;
        EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObjNoException((EObject)eObject.eClass(), "name", false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrFeature", eStructuralFeature);
        }
        if (eStructuralFeature != null) {
            string2 = (String)eObject.eGet(eStructuralFeature);
        }
        if (string2 == null) {
            eStructuralFeature = MOFUtil.getAttributeMetaObjNoException((EObject)eObject.eClass(), "memberName", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrFeature", eStructuralFeature);
            }
            if (eStructuralFeature != null && TypeRegistry.getTypeShortName(eStructuralFeature.getEType()).equals("String") && !eStructuralFeature.isMany()) {
                string2 = (String)eObject.eGet(eStructuralFeature);
            }
        }
        if (string2 == null) {
            eStructuralFeature = MOFUtil.getAttributeMetaObjNoException((EObject)eObject.eClass(), "serverName", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrFeature", eStructuralFeature);
            }
            if (eStructuralFeature != null && TypeRegistry.getTypeShortName(eStructuralFeature.getEType()).equals("String") && !eStructuralFeature.isMany()) {
                string2 = (String)eObject.eGet(eStructuralFeature);
            }
        }
        Session session = MOFUtil.getConfigSession(eObject);
        return WorkspaceHelper.createObjectName(configDataId, string, string2, session);
    }

    public static ConfigDataId createConfigDataId(EObject eObject) {
        ConfigDataId configDataId = null;
        Resource resource = eObject.eResource();
        if (resource != null) {
            URI uRI = resource.getURI();
            uRI = uRI.appendFragment(resource.getURIFragment(eObject));
            String string = uRI.toString();
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet instanceof ContextResourceSet) {
                String string2 = WorkspaceHelper.getContext(resource).getURI();
                configDataId = new ConfigDataId(string2, string);
            } else {
                configDataId = ConfigDataId.createLocalId(string);
            }
        }
        return configDataId;
    }

    static Session getConfigSession(EObject eObject) {
        ResourceSet resourceSet;
        Session session = null;
        Resource resource = eObject.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) instanceof ContextResourceSet) {
            session = MOFUtil.getConfigSession(WorkspaceHelper.getContext(resource));
        }
        return session;
    }

    static Session getConfigSession(RepositoryContext repositoryContext) {
        return new Session(repositoryContext.getWorkSpace().getUserName(), true);
    }

    static URI getURI(ConfigDataId configDataId) {
        String string = configDataId.getHref();
        URI uRI = URI.createURI((String)string);
        return uRI;
    }

    static void objectRemoved(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectRemoved", new Object[]{repositoryContext, eObject});
        }
        if (repositoryContext.getType().getName().equals("servers")) {
            MOFUtil.objectRemovedBasic(repositoryContext, eObject, referenceHandler, stack);
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                MOFUtil.objectRemovedBasic(repositoryContext, (EObject)treeIterator.next(), referenceHandler, stack);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectRemoved");
        }
    }

    private static void objectRemovedBasic(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        try {
            EClass eClass = eObject.eClass();
            List list = EndpointConfigHelper.getEndpointAttributeNames((EClassifier)eClass);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, null, referenceHandler, stack);
            }
        }
        catch (ConfigServiceException configServiceException) {
            Tr.warning(tc, "ADMG0022W", new Object[]{configServiceException, repositoryContext.getName()});
        }
    }

    static void objectAdded(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectAdded", new Object[]{repositoryContext, eObject});
        }
        if (repositoryContext.getType().getName().equals("servers")) {
            MOFUtil.objectAddedBasic(repositoryContext, eObject, referenceHandler, stack);
            TreeIterator treeIterator = eObject.eAllContents();
            while (treeIterator.hasNext()) {
                MOFUtil.objectAddedBasic(repositoryContext, (EObject)treeIterator.next(), referenceHandler, stack);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectAdded");
        }
    }

    private static void objectAddedBasic(RepositoryContext repositoryContext, EObject eObject, ReferenceHandler referenceHandler, Stack stack) {
        EClass eClass;
        try {
            eClass = eObject.eClass();
            List list = EndpointConfigHelper.getEndpointAttributeNames((EClassifier)eClass);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, new AttributeList(), referenceHandler, stack);
            }
            if ("servers".equals(repositoryContext.getType().getName())) {
                EndpointConfigHelper.setServerType(repositoryContext, (EClassifier)eObject.eClass());
            }
        }
        catch (ConfigServiceException configServiceException) {
            Tr.warning(tc, "ADMG0022W", new Object[]{configServiceException, repositoryContext.getName()});
        }
        if (eObject instanceof EndPoint) {
            try {
                eClass = (EndPoint)eObject;
                int n = eClass.getPort();
                if (n != 0) {
                    eClass.setPort(0);
                    eClass.setPort(EndpointConfigHelper.adjustPort(repositoryContext, n, null));
                }
            }
            catch (ConfigServiceException configServiceException) {
                Tr.warning(tc, "ADMG0022W", new Object[]{configServiceException, repositoryContext.getName()});
            }
        }
    }

    private static List getAllAttributeMetaObjs(EClass eClass, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllAttributeMetaObjs", new Object[]{eClass, properties});
        }
        ArrayList arrayList = new ArrayList(eClass.getEAllAttributes());
        MetadataFilter.filterAttributes(arrayList, properties);
        ArrayList arrayList2 = new ArrayList(eClass.getEAllReferences());
        arrayList.addAll(arrayList2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            if (MOFUtil.isValidAttribute(eStructuralFeature, properties)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing Attribute: ", new Object[]{eStructuralFeature.getName()});
            }
            iterator.remove();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllAttributeMetaObjs", new Object[]{arrayList});
        }
        return arrayList;
    }

    private static EStructuralFeature getAttributeMetaObj(EClass eClass, String string, Stack stack, boolean bl, Properties properties) throws InvalidAttributeNameException {
        EStructuralFeature eStructuralFeature;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeMetaObj", new Object[]{eClass, string, properties});
        }
        if ((eStructuralFeature = MOFUtil.getAttributeMetaObjNoException(eClass, string, stack, bl, properties)) == null) {
            throw new InvalidAttributeNameException(MOFUtil.getAttributePath(stack));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeMetaObj", eStructuralFeature);
        }
        return eStructuralFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EStructuralFeature getAttributeMetaObjNoException(EClass eClass, String string, Stack stack, boolean bl, Properties properties) {
        EStructuralFeature eStructuralFeature;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeMetaObjNoException", new Object[]{eClass, string, properties});
        }
        try {
            if (stack == null) {
                stack = new Stack<String>();
            }
            stack.push(string);
            eStructuralFeature = eClass.getEStructuralFeature(string);
            if (eStructuralFeature != null && !MOFUtil.isValidAttribute(eStructuralFeature, bl, properties)) {
                eStructuralFeature = null;
            }
        }
        finally {
            stack.pop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeMetaObjNoException", eStructuralFeature);
        }
        return eStructuralFeature;
    }

    private static EStructuralFeature getAttributeMetaObj(EClass eClass, String string, Stack stack, Properties properties) throws InvalidAttributeNameException {
        return MOFUtil.getAttributeMetaObj(eClass, string, stack, false, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateAttributeList(EObject object, AttributeList attributeList, AttributeList attributeList2, Stack stack, Properties properties) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAttributeList", new Object[]{object, attributeList});
        }
        String string = null;
        try {
            string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
            object2 = TypeRegistry.getMetaObject(string, properties);
            if (((EClassifier)object).getInstanceClass().isAssignableFrom(object2.getInstanceClass())) {
                object = object2;
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type is not specified");
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            FFDCFilter.processException(invalidConfigDataTypeException, "com.ibm.ws.management.configservice.MOFUtil.validateAttributeList", "497");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "specified type is not valid", new Object[]{string, invalidConfigDataTypeException});
            }
            throw new InvalidAttributeNameException("specified type is not valid: " + string + "  " + invalidConfigDataTypeException);
        }
        object2 = attributeList.iterator();
        while (object2.hasNext()) {
            Attribute attribute = (Attribute)object2.next();
            String string2 = attribute.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name", string2);
            }
            Object object3 = attribute.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "val", object3);
            }
            if (EndpointConfigHelper.isEndpointAttribute((EClassifier)object, string2)) {
                try {
                    stack.push(string2);
                    if (object3 != null && !(object3 instanceof AttributeList)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    MOFUtil.validateAttributeList((EObject)EndpointConfigHelper.getEndpointMetaObj(), (AttributeList)object3, attributeList2, stack, properties);
                    continue;
                }
                finally {
                    stack.pop();
                    continue;
                }
            }
            if (SystemAttributes.isSystemAttribute(string2)) continue;
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj(object, string2, false, properties);
            MOFUtil.validateAttribute(eStructuralFeature, object3, attributeList2, stack, properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAttributeList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAttribute(EStructuralFeature eStructuralFeature, Object object, AttributeList attributeList, Stack stack, Properties properties) throws InvalidAttributeNameException, InvalidAttributeValException, ReadOnlyAttributeException {
        block26: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateAttribute", new Object[]{eStructuralFeature, object});
            }
            if (object == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateAttribute");
                }
                return;
            }
            try {
                stack.push(eStructuralFeature.getName());
                EClassifier eClassifier = eStructuralFeature.getEType();
                if (!MOFUtil.isComposite(eStructuralFeature)) {
                    if (eStructuralFeature.isMany() && object instanceof List) {
                        Iterator iterator = ((List)object).iterator();
                        while (iterator.hasNext()) {
                            Object e2 = iterator.next();
                            if (eStructuralFeature instanceof EAttribute) {
                                if ((!(eClassifier instanceof EEnum) || e2 instanceof String) && (eClassifier instanceof EEnum || eClassifier.isInstance(e2))) continue;
                                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                            }
                            if (!(e2 instanceof ObjectName)) {
                                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                            }
                            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)e2);
                            if (!configDataId.isLocal() || ConfigServiceHelper.lookup(attributeList, configDataId) != null) continue;
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                    } else {
                        if (!(object instanceof ObjectName)) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)object);
                        if (configDataId.isLocal() && ConfigServiceHelper.lookup(attributeList, configDataId) == null) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                    }
                    break block26;
                }
                if (eStructuralFeature instanceof EReference && object instanceof AttributeList) {
                    MOFUtil.validateAttributeList((EObject)eClassifier, (AttributeList)object, attributeList, stack, properties);
                    break block26;
                }
                if (eStructuralFeature.isMany() && object instanceof List) {
                    Iterator iterator = ((List)object).iterator();
                    while (iterator.hasNext()) {
                        Object e3 = iterator.next();
                        if (eStructuralFeature instanceof EAttribute) {
                            if ((!(eClassifier instanceof EEnum) || e3 instanceof String) && (eClassifier instanceof EEnum || eClassifier.isInstance(e3))) continue;
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                        MOFUtil.validateAttributeList((EObject)eClassifier, (AttributeList)e3, attributeList, stack, properties);
                    }
                    break block26;
                }
                if (eStructuralFeature instanceof EAttribute) {
                    Object object2;
                    if (eClassifier instanceof EEnum && !(object instanceof String) || !(eClassifier instanceof EEnum) && !eClassifier.isInstance(object)) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    if (eClassifier instanceof EEnum) {
                        object2 = (EEnum)eClassifier;
                        Enumerator enumerator = null;
                        EEnumLiteral eEnumLiteral = object2.getEEnumLiteral((String)object);
                        if (eEnumLiteral != null) {
                            enumerator = eEnumLiteral.getInstance();
                        }
                        if (enumerator == null) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                        String string = MOFUtil.getNodeMajorVersion(properties);
                        if (string != null && string.equals("5") && "type".equals(eStructuralFeature.getName()) && "com.ibm.ejs.models.base.resources.jms.GenericJMSConnectionFactory".equals(((EClass)eStructuralFeature.eContainer()).getInstanceClassName()) && "UNIFIED".equals((String)object)) {
                            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                        }
                    }
                    if (!(!eStructuralFeature.getName().equals("name") || ServiceLog.class.isAssignableFrom(eStructuralFeature.getContainerClass()) || J2EEResourceFactory.class.isAssignableFrom(eStructuralFeature.getContainerClass()) || GroupExt.class.isAssignableFrom(eStructuralFeature.getContainerClass()) || UserExt.class.isAssignableFrom(eStructuralFeature.getContainerClass()) || SubjectExt.class.isAssignableFrom(eStructuralFeature.getContainerClass()) || ConfigServiceHelper.checkIfNameValid((String)(object2 = (String)object)))) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    break block26;
                }
                throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
            }
            finally {
                stack.pop();
            }
        }
        if (object == null && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAttribute");
        }
    }

    static void setAttributes(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList, ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{eObject, attributeList});
        }
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (SystemAttributes.isSystemAttribute(attribute.getName())) continue;
            MOFUtil.setAttribute(repositoryContext, eObject, attribute.getName(), attribute.getValue(), referenceHandler, stack, properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    static void setAttribute(RepositoryContext repositoryContext, EObject eObject, String string, Object object, ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        MOFUtil.setAttribute(repositoryContext, eObject, string, object, referenceHandler, stack, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAttribute(RepositoryContext repositoryContext, EObject eObject, String string, Object object, ReferenceHandler referenceHandler, Stack stack, Properties properties) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttribute", new Object[]{eObject, string, object, properties});
        }
        try {
            stack.push(string);
            if (EndpointConfigHelper.isEndpointAttribute((EClassifier)eObject.eClass(), string)) {
                if (object != null && !(object instanceof AttributeList)) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                }
                EndpointConfigHelper.setEndpointAttribute(repositoryContext, (EClassifier)eObject.eClass(), string, (AttributeList)object, referenceHandler, stack);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setAttribute");
                }
                return;
            }
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), string, false, properties);
            if (object == null) {
                if (eStructuralFeature.isMany()) {
                    List list = (List)eObject.eGet(eStructuralFeature);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        if (!(e2 instanceof EObject)) continue;
                        MOFUtil.objectRemoved(repositoryContext, (EObject)e2, referenceHandler, stack);
                    }
                    list.clear();
                } else {
                    Object object2 = eObject.eGet(eStructuralFeature);
                    if (object2 instanceof EObject) {
                        MOFUtil.objectRemoved(repositoryContext, eObject, referenceHandler, stack);
                    }
                    eObject.eUnset(eStructuralFeature);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setAttribute");
                }
                return;
            }
            if (!MOFUtil.isComposite(eStructuralFeature)) {
                if (eStructuralFeature.isMany() && !(object instanceof List)) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                }
                referenceHandler.addDeferredUpdate(eObject, eStructuralFeature, object, MOFUtil.getAttributePath(stack));
            } else if (eStructuralFeature.isMany() && object instanceof List) {
                List list = (List)eObject.eGet(eStructuralFeature);
                list.clear();
                Iterator iterator = ((List)object).iterator();
                while (iterator.hasNext()) {
                    AttributeList attributeList;
                    Object object3 = iterator.next();
                    if (eStructuralFeature instanceof EReference && object3 instanceof AttributeList) {
                        attributeList = (AttributeList)object3;
                        EClassifier eClassifier = eStructuralFeature.getEType();
                        EObject eObject2 = MOFUtil.createRefObject(repositoryContext, (EObject)eClassifier, (AttributeList)object3, referenceHandler, stack);
                        list.add(eObject2);
                        MOFUtil.objectAdded(repositoryContext, eObject2, referenceHandler, stack);
                        continue;
                    }
                    if (object3 != null && eStructuralFeature.getEType() instanceof EEnum && (object3 = (attributeList = (EEnum)eStructuralFeature.getEType()).getEEnumLiteral((String)object3).getInstance()) == null) {
                        throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                    }
                    list.add(object3);
                }
            } else if (eStructuralFeature instanceof EReference && object instanceof AttributeList) {
                EObject eObject3 = MOFUtil.createRefObject(repositoryContext, (EObject)eStructuralFeature.getEType(), (AttributeList)object, referenceHandler, stack);
                eObject.eSet(eStructuralFeature, (Object)eObject3);
                MOFUtil.objectAdded(repositoryContext, eObject3, referenceHandler, stack);
            } else if (eStructuralFeature instanceof EAttribute) {
                EEnum eEnum;
                if (eStructuralFeature.getEType() instanceof EEnum && (object = (eEnum = (EEnum)eStructuralFeature.getEType()).getEEnumLiteral((String)object).getInstance()) == null) {
                    throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
                }
                eObject.eSet(eStructuralFeature, object);
            }
        }
        finally {
            stack.pop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
    }

    private static EObject createRefObject(RepositoryContext repositoryContext, EObject eObject, AttributeList attributeList, ReferenceHandler referenceHandler, Stack stack) throws ConfigServiceException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRefObject", new Object[]{eObject, attributeList});
        }
        Properties properties = MOFUtil.getNodeProperties(repositoryContext);
        String string = null;
        try {
            string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
            object = TypeRegistry.getMetaObject(string, properties);
            if (((EClassifier)eObject).getInstanceClass().isAssignableFrom(object.getInstanceClass())) {
                eObject = object;
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            FFDCFilter.processException(invalidConfigDataTypeException, "com.ibm.ws.management.configservice.MOFUtil.createRefObject", "725");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "specified type is not valid", new Object[]{string, invalidConfigDataTypeException});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.configservice.MOFUtil.createRefObject", "728");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", exception);
            }
            throw new InvalidAttributeValException(MOFUtil.getAttributePath(stack));
        }
        object = null;
        try {
            object = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Template");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        EObject eObject2 = MOFUtil.newRefObject(repositoryContext, eObject, (ObjectName)object);
        MOFUtil.setAttributes(repositoryContext, eObject2, attributeList, referenceHandler, stack);
        ConfigDataId configDataId = null;
        try {
            configDataId = (ConfigDataId)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Id");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (configDataId != null && configDataId.isLocal()) {
            referenceHandler.addLocalRefObject(configDataId, eObject2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRefObject", eObject2);
        }
        return eObject2;
    }

    static AttributeList getAttributeMetaInfo(String string, EStructuralFeature eStructuralFeature, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeMetaInfo", new Object[]{eStructuralFeature, properties});
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("_Attribute_MetaInfo_Name", eStructuralFeature.getName()));
        EClassifier eClassifier = eStructuralFeature.getEType();
        Object object = eStructuralFeature.getDefaultValue();
        if (object != null && eClassifier instanceof EEnum) {
            object = object.toString();
        }
        if (object != null && !(object instanceof Serializable)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "defaultValue is not serializable:", object);
            }
            object = null;
        }
        String[] stringArray = MetadataFilter.getValidRanges(eStructuralFeature, properties);
        attributeList.add(new Attribute("_Attribute_MetaInfo_Default_Value", object));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Collection", new Boolean(eStructuralFeature.isMany())));
        String string2 = TypeRegistry.getTypeShortName(eClassifier);
        attributeList.add(new Attribute("_Attribute_MetaInfo_Type", string2));
        try {
            String[] stringArray2 = TypeRegistry.getSubTypes(string2, properties);
            if (stringArray2 != null && stringArray2.length > 0) {
                attributeList.add(new Attribute("_Attribute_MetaInfo_Subtypes", Arrays.asList(stringArray2)));
            }
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            // empty catch block
        }
        boolean bl = eStructuralFeature instanceof EReference;
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Object", new Boolean(bl)));
        Set set = RequiredAttributesRegistry.getRequiredAttributes(string);
        boolean bl2 = set != null && set.contains(eStructuralFeature.getName());
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Required", new Boolean(bl2)));
        attributeList.add(new Attribute("_Attribute_MetaInfo_Is_Reference", new Boolean(!MOFUtil.isComposite(eStructuralFeature))));
        if (eClassifier instanceof EEnum) {
            AttributeList attributeList2 = new AttributeList();
            EEnum eEnum = (EEnum)eClassifier;
            EList eList = eEnum.getELiterals();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                EEnumLiteral eEnumLiteral = (EEnumLiteral)iterator.next();
                attributeList2.add(new Attribute(eEnumLiteral.getName(), new Integer(eEnumLiteral.getValue())));
            }
            attributeList.add(new Attribute("_Attribute_MetaInfo_Enum_Info", attributeList2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeMetaInfo", attributeList);
        }
        return attributeList;
    }

    private static String[] getAttributePath(Stack stack) {
        String[] stringArray = new String[stack.size()];
        stack.toArray(stringArray);
        return stringArray;
    }

    private static boolean isValidAttribute(EStructuralFeature eStructuralFeature, boolean bl, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidAttribute", new Object[]{eStructuralFeature, new Boolean(bl), properties});
        }
        boolean bl2 = true;
        if (properties != null) {
            bl2 = MetadataFilter.isValidAttr(eStructuralFeature, properties);
        }
        if (bl2) {
            if (eStructuralFeature.isVolatile()) {
                bl2 = false;
            } else {
                Class clazz = eStructuralFeature.getEType().getInstanceClass();
                if (clazz == null) {
                    bl2 = !bl;
                } else {
                    for (int i = 0; i < innerConfigObjectTypes.length; ++i) {
                        if (!MOFUtil.isComposite(eStructuralFeature) || !innerConfigObjectTypes[i].isAssignableFrom(clazz)) continue;
                        bl2 = bl;
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidAttribute, " + bl2);
        }
        return bl2;
    }

    private static boolean isValidAttribute(EStructuralFeature eStructuralFeature, Properties properties) {
        return MOFUtil.isValidAttribute(eStructuralFeature, false, properties);
    }

    private static boolean isValidType(EObject eObject) {
        return MetadataFilter.isValidType(eObject.eClass(), MOFUtil.getNodeProperties(eObject));
    }

    private static boolean isComposite(EStructuralFeature eStructuralFeature) {
        boolean bl = true;
        if (eStructuralFeature instanceof EReference) {
            bl = ((EReference)eStructuralFeature).isContainment();
        }
        return bl;
    }

    private static EObject lookup(RepositoryContext repositoryContext, ConfigDataId configDataId, String[] stringArray) throws InvalidAttributeValException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookup", new Object[]{repositoryContext, configDataId});
        }
        if (repositoryContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "lookup", null);
            }
            return null;
        }
        try {
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext.getWorkSpace(), configDataId);
            EObject eObject = docAccessor.lookup(configDataId);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "lookup", eObject);
            }
            return eObject;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.configservice.MOFUtil.lookup", "848");
            throw new InvalidAttributeValException(stringArray, exception);
        }
    }

    protected static Properties getNodeProperties(EObject eObject) {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties", eObject);
        }
        if (eObject instanceof EAttribute) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "It's an attribute");
            }
            eObject = eObject.eClass();
        }
        if ((objectName = MOFUtil.createObjectName(eObject)) == null || ConfigServiceHelper.getConfigDataId(objectName) == null || ConfigServiceHelper.getConfigDataId(objectName).isLocal()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objname null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeProperties", null);
            }
            return null;
        }
        return MOFUtil.getNodeProperties(WorkspaceHelper.getWorkspace(eObject), objectName);
    }

    protected static Properties getNodeProperties(RepositoryContext repositoryContext) {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties - context", repositoryContext);
        }
        if ((objectName = MOFUtil.createObjectName(repositoryContext)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objname null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeProperties", null);
            }
            return null;
        }
        return MOFUtil.getNodeProperties(repositoryContext.getWorkSpace(), objectName);
    }

    protected static Properties getNodeProperties(WorkSpace workSpace, ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeProperties - objname", objectName);
        }
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = null;
        Properties properties2 = null;
        if (properties.getProperty("node") != null) {
            string = properties.getProperty("node");
            try {
                ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
                if (managedObjectMetadataHelper != null) {
                    properties2 = managedObjectMetadataHelper.getAccessor().getMetadataProperties(string);
                } else {
                    Tr.warning(tc, "Do not have a MetadataHelper");
                }
            }
            catch (Exception exception) {
                Tr.warning(tc, "Could not getNodeProperties for node: " + string, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeProperties - objname", properties2);
        }
        return properties2;
    }

    protected static boolean isNodeVersion5(WorkSpace workSpace, String string) {
        try {
            String string2 = workSpace.getMetadataHelper().getNodeMajorVersion(string);
            return string2.equals("5");
        }
        catch (Exception exception) {
            Tr.warning(tc, "Could not getNodeBaseProductVersion for node: " + string, exception);
            return false;
        }
    }

    protected static String getNodeMajorVersion(Properties properties) {
        int n;
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("com.ibm.websphere.baseProductVersion");
        string.trim();
        String string2 = null;
        if (string != null && string.length() > 0 && (n = (string2 = string).indexOf(46)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    protected static boolean mixedCluster(ConfigService configService, Session session, ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mixedCluster", new Object[]{configService, session, objectName});
        }
        try {
            ObjectName[] objectNameArray = null;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
            objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string = (String)configService.getAttribute(session, objectNameArray[i], "memberName");
                String string2 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
                String string3 = workSpace.getMetadataHelper().getNodeMajorVersion(string2);
                if (!string3.equals("5")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is a cluster member " + string + " on node " + string2 + " That is not version 6.0 or above");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "mixedCluster true");
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mixedCluster false");
            }
            return false;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception " + exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mixedCluster false");
            }
            return false;
        }
    }

    protected static boolean canCreateMember(ConfigService configService, Session session, String string, ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canCreateMember", new Object[]{configService, session, objectName});
        }
        boolean bl = false;
        try {
            ObjectName[] objectNameArray = null;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "ClusterMember");
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
            objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            String string2 = workSpace.getMetadataHelper().getNodeMajorVersion(string);
            if (objectNameArray.length == 0) {
                bl = true;
            }
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string3 = (String)configService.getAttribute(session, objectNameArray[i], "memberName");
                String string4 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
                String string5 = workSpace.getMetadataHelper().getNodeMajorVersion(string4);
                if (string5.compareTo(string2) > 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is a matching member " + string3 + " on node " + string4);
                }
                bl = true;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "canCreateMember " + new Boolean(bl));
                }
                return bl;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception " + exception.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "canCreateMember " + new Boolean(bl));
            }
            return bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canCreateMember " + new Boolean(bl));
        }
        return bl;
    }

    static class ReferenceHandler {
        private List deferredUpdates = new ArrayList();
        private HashMap localRefObjs = new HashMap();

        ReferenceHandler() {
        }

        public void addLocalRefObject(ConfigDataId configDataId, EObject eObject) {
            this.localRefObjs.put(configDataId, eObject);
        }

        public void addDeferredUpdate(EObject eObject, EStructuralFeature eStructuralFeature, Object object, String[] stringArray) {
            DeferredUpdateInfo deferredUpdateInfo = new DeferredUpdateInfo();
            deferredUpdateInfo.refObj = eObject;
            deferredUpdateInfo.feature = eStructuralFeature;
            deferredUpdateInfo.value = object;
            deferredUpdateInfo.attributePath = stringArray;
            this.deferredUpdates.add(deferredUpdateInfo);
        }

        public void update(RepositoryContext repositoryContext) throws InvalidAttributeValException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "update", repositoryContext);
            }
            Iterator iterator = this.deferredUpdates.iterator();
            while (iterator.hasNext()) {
                Object object;
                DeferredUpdateInfo deferredUpdateInfo = (DeferredUpdateInfo)iterator.next();
                if (deferredUpdateInfo.feature.isMany()) {
                    object = (List)deferredUpdateInfo.value;
                    List list = (List)deferredUpdateInfo.refObj.eGet(deferredUpdateInfo.feature);
                    list.clear();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object e2 = iterator2.next();
                        if (!(e2 instanceof ObjectName)) {
                            throw new InvalidAttributeValException(deferredUpdateInfo.attributePath);
                        }
                        list.add(this.getReferredObj(repositoryContext, ConfigServiceHelper.getConfigDataId((ObjectName)e2), deferredUpdateInfo.attributePath));
                    }
                    continue;
                }
                if (!(deferredUpdateInfo.value instanceof ObjectName)) {
                    throw new InvalidAttributeValException(deferredUpdateInfo.attributePath);
                }
                object = this.getReferredObj(repositoryContext, ConfigServiceHelper.getConfigDataId((ObjectName)deferredUpdateInfo.value), deferredUpdateInfo.attributePath);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "referredObj", object);
                }
                deferredUpdateInfo.refObj.eSet(deferredUpdateInfo.feature, object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "update");
            }
        }

        private Object getReferredObj(RepositoryContext repositoryContext, ConfigDataId configDataId, String[] stringArray) throws InvalidAttributeValException {
            EObject eObject = null;
            if (configDataId.isLocal()) {
                eObject = (EObject)this.localRefObjs.get(configDataId);
                if (eObject == null) {
                    throw new InvalidAttributeValException(stringArray, (Exception)new ConfigDataNotFoundException(null, configDataId, null));
                }
            } else {
                eObject = MOFUtil.lookup(repositoryContext, configDataId, stringArray);
            }
            return eObject;
        }

        static class DeferredUpdateInfo {
            public EObject refObj;
            public EStructuralFeature feature;
            public Object value;
            public String[] attributePath;

            DeferredUpdateInfo() {
            }
        }
    }
}

