/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.models.config.coregroup.impl.CoregroupFactoryImpl;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class NodeAgentConfigHelper {
    private static final String svCGS = "coregroups";
    private static final String svCoreGroupConfigFile = "coregroup.xml";

    private NodeAgentConfigHelper() {
    }

    public static String getNDCoreGroupURI(String string, String string2) {
        String string3 = "coregroups/" + string2 + "/" + svCoreGroupConfigFile;
        return string3;
    }

    public static void addNode(CoreGroup coreGroup, CoreGroup coreGroup2, String string, Vector vector) throws Exception {
        if (coreGroup == null) {
            throw new Exception("Null ND core group object provided");
        }
        if (coreGroup2 == null) {
            throw new Exception("Null base core group object provided");
        }
        if (string == null) {
            throw new Exception("Null nodeName object provided");
        }
        CoregroupFactoryImpl coregroupFactoryImpl = new CoregroupFactoryImpl();
        EList eList = coreGroup.getCoreGroupServers();
        EList eList2 = coreGroup2.getCoreGroupServers();
        if (eList2 != null) {
            int n = eList2.size();
            for (int i = 0; i < n; ++i) {
                CoreGroupServer coreGroupServer = (CoreGroupServer)eList2.get(i);
                String string2 = coreGroupServer.getServerName();
                System.out.println("found server " + coreGroupServer.getNodeName() + " " + string2);
                CoreGroupServer coreGroupServer2 = coregroupFactoryImpl.createCoreGroupServer();
                coreGroupServer2.setNodeName(string);
                coreGroupServer2.setServerName(string2);
                eList.add(coreGroupServer2);
                vector.addElement(string2);
            }
        }
    }

    public static void addNodeAgentProcess(CoreGroup coreGroup, String string, String string2) throws Exception {
        if (coreGroup == null) {
            throw new Exception("Null ND core group object provided");
        }
        if (string == null) {
            throw new Exception("Null nodeName object provided");
        }
        EList eList = coreGroup.getCoreGroupServers();
        CoregroupFactoryImpl coregroupFactoryImpl = new CoregroupFactoryImpl();
        CoreGroupServer coreGroupServer = coregroupFactoryImpl.createCoreGroupServer();
        coreGroupServer.setNodeName(string);
        coreGroupServer.setServerName(string2);
        eList.add(coreGroupServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNode(ConfigService configService, Session session, String string) throws Exception {
        boolean bl = false;
        try {
            if (session == null) {
                session = new Session("removeNodeFromCoreGroups", false);
                bl = true;
            }
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "CoreGroup", null);
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectNameArray[i], "coreGroupServers");
                if (arrayList == null) continue;
                int n = arrayList.size();
                for (int j = 0; j < n; ++j) {
                    AttributeList attributeList = (AttributeList)arrayList.get(j);
                    String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
                    if (!string.equals(string2)) continue;
                    ObjectName objectName2 = ConfigServiceHelper.createObjectName(attributeList);
                    configService.deleteConfigData(session, objectName2);
                }
            }
        }
        finally {
            if (bl) {
                configService.save(session, true);
            }
        }
    }

    public static void removeNode(CoreGroup coreGroup, String string) throws Exception {
        if (coreGroup == null) {
            throw new Exception("Null ND core groups object provided");
        }
        if (string == null) {
            throw new Exception("Null nodeName object provided");
        }
        EList eList = coreGroup.getCoreGroupServers();
        if (eList != null) {
            int n = eList.size();
            for (int i = n - 1; i > -1; --i) {
                CoreGroupServer coreGroupServer = (CoreGroupServer)eList.get(i);
                if (!string.equals(coreGroupServer.getNodeName())) continue;
                eList.remove(i);
            }
        }
    }
}

