/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeDelegator
extends RootObjectDelegator {
    private static final String HOST_NAME = "hostName";
    private static final String HOST_NAME_TYPE = "String";
    private static TraceComponent tc = Tr.register(NodeDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public NodeDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes"));
    }

    public AttributeList getAttributesMetaInfo(String string) throws InvalidConfigDataTypeException {
        AttributeList attributeList = super.getAttributesMetaInfo(string);
        AttributeList attributeList2 = new AttributeList();
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Name", HOST_NAME));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Type", HOST_NAME_TYPE));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.FALSE));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        attributeList.add(new Attribute(HOST_NAME, attributeList2));
        return attributeList;
    }

    protected ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, objectName, childTypeInfo, attributeList});
        }
        if (System.getProperties().get("ConfigService.TestMode") == null) {
            String string = TraceNLS.getStringFromBundle("com.ibm.ws.management.resources.configservice", "ADMG0023W");
            throw new UnsupportedOperationException(string);
        }
        attributeList = (AttributeList)attributeList.clone();
        String string = this.removeHostNameAttr(attributeList);
        ObjectName objectName2 = super.createConfigObject(session, objectName, childTypeInfo, attributeList);
        this.setHostName(session, objectName2, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", objectName2);
        }
        return objectName2;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, objectName, attributeList});
        }
        attributeList = (AttributeList)attributeList.clone();
        String string = this.removeHostNameAttr(attributeList);
        super.setAttributes(session, objectName, attributeList);
        this.setHostName(session, objectName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, objectName, stringArray});
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(HOST_NAME)) {
                this.setHostName(session, objectName, null);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        super.unsetAttributes(session, objectName, stringArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, objectName, attributeList});
        }
        attributeList = (AttributeList)attributeList.clone();
        String string = this.removeHostNameAttr(attributeList);
        super.resetAttributes(session, objectName, attributeList);
        this.setHostName(session, objectName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException {
        AttributeList attributeList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        boolean bl2 = false;
        if (stringArray == null) {
            bl2 = true;
        } else {
            attributeList = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(HOST_NAME)) {
                    bl2 = true;
                    continue;
                }
                attributeList.add(stringArray[i]);
            }
            stringArray = new String[attributeList.size()];
            attributeList.toArray(stringArray);
        }
        attributeList = super.getAttributes(session, objectName, stringArray, bl);
        if (bl2) {
            Object object = this.getHostName(session, objectName);
            attributeList.add(new Attribute(HOST_NAME, object));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributeList);
        }
        return attributeList;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, objectName, string});
        }
        Object object = HOST_NAME.equals(string) ? this.getHostName(session, objectName) : super.getAttribute(session, objectName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHostName(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHostName", new Object[]{session, objectName, string});
        }
        if (string == null || string.length() == 0) {
            return;
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource = docAccessor.getResource();
        try {
            Resource resource2 = resource;
            synchronized (resource2) {
                EList eList = resource.getContents();
                if (eList.size() == 0) {
                    eList.add(MOFUtil.newInstance((EObject)TypeRegistry.getMetaObject("ServerIndex")));
                }
                ServerIndex serverIndex = (ServerIndex)eList.get(0);
                serverIndex.setHostName(string);
                docAccessor.localSave();
            }
        }
        finally {
            docAccessor.cleanup();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHostName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getHostName(Session session, ObjectName objectName) throws ConfigServiceException {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostName", new Object[]{session, objectName});
        }
        String string = null;
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, "serverindex.xml");
        Resource resource2 = resource = docAccessor.getResource();
        synchronized (resource2) {
            EList eList = resource.getContents();
            if (eList.size() != 0) {
                ServerIndex serverIndex = (ServerIndex)eList.get(0);
                string = serverIndex.getHostName();
            }
        }
        return string;
    }

    private String removeHostNameAttr(AttributeList attributeList) throws InvalidAttributeValException {
        String string = null;
        try {
            Object object = ConfigServiceHelper.getAttributeValue(attributeList, HOST_NAME);
            if (object != null && !(object instanceof String)) {
                throw new InvalidAttributeValException(HOST_NAME);
            }
            string = (String)object;
            ConfigServiceHelper.removeAttribute(attributeList, HOST_NAME);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return string;
    }
}

