/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.MetadataFilter;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.csmetadata.ConfigServiceMetadata;
import com.ibm.ws.management.configservice.csmetadata.CsmetadataFactory;
import com.ibm.ws.management.configservice.csmetadata.CsmetadataPackage;
import com.ibm.ws.management.configservice.csmetadata.EMFAttribute;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RequiredAttributesRegistry
extends DefaultHandler {
    static final List newReqAttrs = Arrays.asList("ActivitySessionService.defaultTimeout", "WorkAreaService.maxReceiveSize", "WorkAreaService.maxSendSize", "WorkAreaPartition.maxReceiveSize", "WorkAreaPartition.maxSendSize", "TimerManagerInfo.jndiName", "TimerManagerInfo.numAlarmThreads", "WorkManagerInfo.maxThreads", "WorkManagerInfo.minThreads", "WorkManagerInfo.threadPriority", "WorkManagerInfo.jndiName", "WorkManagerInfo.numAlarmThreads", "SchedulerConfiguration.workManagers", "SchedulerConfiguration.pollInterval", "SchedulerConfiguration.tablePrefix", "SchedulerConfiguration.jndiName", "SchedulerConfiguration.datasourceJNDIName", "ObjectPool.poolImplClassName", "ObjectPool.poolClassName", "ObjectPoolManagerInfo.jndiName", "CacheInstance.cacheSize", "CacheInstance.defaultPriority", "CacheInstance.enableDiskOffload", "CacheInstance.jndiName");
    private static TraceComponent tc = Tr.register(RequiredAttributesRegistry.class, "management", "com.ibm.ws.management.resources.configservice");
    private static RequiredAttributesRegistry instance = null;
    private XMLReader parser;
    private Stack context = new Stack();
    private Hashtable requiredAttrsTable = new Hashtable();

    public RequiredAttributesRegistry() throws Exception {
        this.parser = XMLReaderFactory.createXMLReader();
        this.parser.setEntityResolver(this);
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
    }

    private void generate(String[] stringArray) throws Exception {
        this.parseValidationFile(stringArray[0]);
        this.dump(stringArray[1]);
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("trace");
            Object var2_3 = null;
            ManagerAdmin.configureClientTrace(string, "stdout", null, true, null, false);
            ModelMgr.initialize("ws-server");
            instance.generate(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseValidationFile(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseValidationFile", string);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            InputSource inputSource = new InputSource(fileInputStream);
            this.parser.parse(inputSource);
            inputSource.setSystemId(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.configservice.RequiredAttributesRegistry.parseValidationFile", "164");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception", exception);
            }
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseValidationFile");
        }
    }

    public static Set getRequiredAttributes(String string) {
        HashSet<String> hashSet = (HashSet<String>)RequiredAttributesRegistry.instance.requiredAttrsTable.get(string);
        EClass eClass = null;
        try {
            eClass = TypeRegistry.getMetaObject(string);
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            return null;
        }
        EList eList = eClass.getEAllSuperTypes();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EClass eClass2 = (EClass)iterator.next();
            String string2 = TypeRegistry.getTypeShortName((EClassifier)eClass2);
            Set set = (Set)RequiredAttributesRegistry.instance.requiredAttrsTable.get(string2);
            if (set == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>(set);
                continue;
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                if (hashSet.contains(string3)) continue;
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    public static void checkRequiredAttributes(EObject eObject) throws RequiredAttributeNotFoundException {
        RequiredAttributesRegistry.checkRequiredAttributes(eObject, null);
    }

    public static void checkRequiredAttributes(EObject eObject, Properties properties) throws RequiredAttributeNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "haveAllRequiredAttributes", eObject);
        }
        RequiredAttributesRegistry.checkRequiredAttributesBasic(eObject, properties);
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            RequiredAttributesRegistry.checkRequiredAttributesBasic(eObject2, properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "haveAllRequiredAttributes");
        }
    }

    private static void checkRequiredAttributesBasic(EObject eObject, Properties properties) throws RequiredAttributeNotFoundException {
        EClass eClass;
        String string;
        Set set;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRequiredAttributesBasic", eObject);
        }
        if ((set = RequiredAttributesRegistry.getRequiredAttributes(string = TypeRegistry.getTypeShortName((EClassifier)(eClass = eObject.eClass())))) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attrName", string2);
                }
                try {
                    EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(string2);
                    if (eStructuralFeature == null || eObject.eGet(eStructuralFeature) != null) continue;
                    String string3 = string + '.' + string2;
                    if (newReqAttrs.contains(string3)) {
                        Tr.warning(tc, "ADMG0020E", new Object[]{string3});
                        continue;
                    }
                    if (!RequiredAttributesRegistry.isAttrRequiredForNode(eStructuralFeature, properties)) continue;
                    throw new RequiredAttributeNotFoundException(string3);
                }
                catch (RequiredAttributeNotFoundException requiredAttributeNotFoundException) {
                    throw requiredAttributeNotFoundException;
                }
                catch (Exception exception) {
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRequiredAttributesBasic");
        }
    }

    private void addRequiredAttribute(String string, String string2) {
        HashSet<String> hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredAttribute", new Object[]{string, string2});
        }
        if ((hashSet = (HashSet<String>)this.requiredAttrsTable.get(string)) == null) {
            hashSet = new HashSet<String>(5);
            this.requiredAttrsTable.put(string, hashSet);
        }
        hashSet.add(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredAttribute");
        }
    }

    private void dump(String string) {
        CsmetadataPackage csmetadataPackage = CsmetadataPackage.eINSTANCE;
        try {
            XMLResourceImpl xMLResourceImpl = new XMLResourceImpl();
            XMLMapImpl xMLMapImpl = new XMLMapImpl();
            HashMap<String, XMLMapImpl> hashMap = new HashMap<String, XMLMapImpl>(1);
            hashMap.put("XML_MAP", xMLMapImpl);
            xMLResourceImpl.setURI(URI.createURI((String)string));
            EList eList = xMLResourceImpl.getContents();
            ConfigServiceMetadata configServiceMetadata = CsmetadataFactory.eINSTANCE.createConfigServiceMetadata();
            eList.add(configServiceMetadata);
            Set set = this.requiredAttrsTable.entrySet();
            EList eList2 = configServiceMetadata.getRequiredAttributes();
            Object object = set.iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String string2 = (String)entry.getKey();
                try {
                    Iterator iterator = ((Set)entry.getValue()).iterator();
                    while (iterator.hasNext()) {
                        EMFAttribute eMFAttribute = CsmetadataFactory.eINSTANCE.createEMFAttribute();
                        eMFAttribute.setTypeName(TypeRegistry.getFullyQualifiedType(string2));
                        String string3 = (String)iterator.next();
                        eMFAttribute.setAttrName(string3);
                        eList2.add(eMFAttribute);
                    }
                }
                catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
                    invalidConfigDataTypeException.printStackTrace();
                }
            }
            object = new FileOutputStream(string);
            xMLResourceImpl.save((OutputStream)object, hashMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object parseForm(Attributes attributes2) throws SAXException {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseForm", attributes2);
        }
        String string2 = attributes2.getValue("name");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "val", string2);
        }
        string = (n = (string = string2.substring(string2.lastIndexOf(46) + 1)).lastIndexOf("DetailForm")) == -1 ? null : string.substring(0, n).trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseForm", string);
        }
        return string;
    }

    private Object parseField(Attributes attributes2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseField", attributes2);
        }
        String string = attributes2.getValue("depends");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "val", string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.trim().equals("required")) {
                string2 = attributes2.getValue("property");
                if (this.findFormType() != null) {
                    this.addRequiredAttribute(this.findFormType(), string2);
                }
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseField", string2);
        }
        return string2;
    }

    private String findFormType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findFormType");
        }
        String string = null;
        int n = 0;
        int n2 = this.context.size() - 1;
        while (n2 >= 0) {
            ContextElement contextElement = (ContextElement)this.context.get(n2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "e:" + contextElement.getName());
            }
            if (contextElement.getName().equals("form")) {
                string = (String)contextElement.getValue();
                break;
            }
            --n2;
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findFormType", string);
        }
        return string;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startElement", new Object[]{string, string2, string3, attributes2});
        }
        Object object = null;
        if (string2.equals("form")) {
            object = this.parseForm(attributes2);
        } else if (string2.equals("field")) {
            object = this.parseField(attributes2);
        }
        this.context.push(new ContextElement(string2, object));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startElement", string2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endElement", string2);
        }
        this.context.pop();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endElement", string2);
        }
    }

    private static boolean isAttrRequiredForNode(EStructuralFeature eStructuralFeature, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAttrRequiredForNode", eStructuralFeature + " node props = " + properties);
        }
        boolean bl = true;
        try {
            if (properties != null) {
                bl = MetadataFilter.isValidAttr(eStructuralFeature, properties);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAttrRequiredForNode", new Boolean(bl));
        }
        return bl;
    }

    static {
        try {
            instance = new RequiredAttributesRegistry();
            EList eList = CSMetadataMgr.getConfigServiceMetadata().getRequiredAttributes();
            for (int i = 0; i < eList.size(); ++i) {
                EMFAttribute eMFAttribute = (EMFAttribute)eList.get(i);
                instance.addRequiredAttribute(TypeRegistry.getShortType(eMFAttribute.getTypeName()), eMFAttribute.getAttrName());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.configservice.RequiredAttributesRegistry", "80");
        }
    }

    private class ContextElement {
        private String elementName;
        private Object val;

        public ContextElement(String string) {
            this(string, null);
        }

        public ContextElement(String string, Object object) {
            this.elementName = string;
            this.val = object;
        }

        public String getName() {
            return this.elementName;
        }

        public Object getValue() {
            return this.val;
        }
    }
}

