/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeValException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.management.exception.RequiredAttributeNotFoundException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class RootObjectDelegator
extends ConfigObjectDelegator {
    private static TraceComponent tc = Tr.register(RootObjectDelegator.class, "management", "com.ibm.ws.management.resources.configservice");
    private String type;
    private List types;
    private RepositoryDocumentType documentType;
    private RepositoryContextType contextType = null;
    private boolean isRootDocumentType;

    public RootObjectDelegator(ConfigServiceImpl configServiceImpl, RepositoryContextType repositoryContextType) {
        this(configServiceImpl, repositoryContextType.getRootDocumentType().getRootRefObjectTypes()[0], repositoryContextType.getRootDocumentType());
        this.isRootDocumentType = true;
        this.contextType = repositoryContextType;
    }

    public RootObjectDelegator(ConfigServiceImpl configServiceImpl, String string, RepositoryDocumentType repositoryDocumentType) {
        super(configServiceImpl);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RootObjectDelegator", new Object[]{configServiceImpl, string, repositoryDocumentType});
        }
        this.type = string;
        String[] stringArray = null;
        try {
            stringArray = TypeRegistry.getSubTypes(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "all types ");
        }
        arrayList.add(string);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "type ", string2);
        }
        if (stringArray != null && stringArray.length > 0) {
            this.types = arrayList;
        }
        this.documentType = repositoryDocumentType;
        this.isRootDocumentType = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RootObjectDelegator");
        }
    }

    public List getTypes() {
        return this.types;
    }

    public void setTypes(List list) {
        this.types = list;
    }

    public String getType() {
        return this.type;
    }

    public String getFileName() {
        return this.documentType.getFilePattern();
    }

    public boolean isRootDocumentType() {
        return this.isRootDocumentType;
    }

    public ObjectName[] getAll(Session session, ObjectName objectName, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", new Object[]{session, objectName, string});
        }
        if (!this.isRootDocumentType() || string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAll");
            }
            return this.getAll(session, objectName);
        }
        Collection collection = WorkspaceHelper.getScopeContexts(session, objectName);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ObjectName[] objectNameArray = collection.iterator();
        while (objectNameArray.hasNext()) {
            Object object;
            RepositoryContext repositoryContext = (RepositoryContext)objectNameArray.next();
            if (repositoryContext.getType().equals(this.contextType) && string.equals(repositoryContext.getName())) {
                object = this.createObjectName(repositoryContext);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "selected", object);
                }
                arrayList.add(object);
                continue;
            }
            try {
                object = repositoryContext.findContext(this.contextType.getName(), string);
                if (object == null) continue;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                    ObjectName objectName2 = this.createObjectName(repositoryContext2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "selected", objectName2);
                    }
                    arrayList.add(objectName2);
                }
            }
            catch (WorkSpaceException workSpaceException) {
                throw new ConfigServiceException(workSpaceException);
            }
        }
        objectNameArray = new ObjectName[arrayList.size()];
        arrayList.toArray(objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] getAll(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAll", objectName);
        }
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        Collection collection = WorkspaceHelper.getScopeContexts(session, objectName);
        ObjectName[] objectNameArray = collection.iterator();
        while (objectNameArray.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)objectNameArray.next();
            if (this.isRootDocumentType) {
                this.findAllMyTypeChildrenContext(repositoryContext, arrayList);
                continue;
            }
            List list = this.getTypedDocuments(repositoryContext, this.getFileName());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, workSpaceFile);
                    ObjectName[] objectNameArray2 = docAccessor.getRootObjects(session);
                    for (int i = 0; objectNameArray2 != null && i < objectNameArray2.length; ++i) {
                        if (!this.getType().equals(ConfigServiceHelper.getConfigDataType(objectNameArray2[i]))) continue;
                        arrayList.add(objectNameArray2[i]);
                    }
                }
                catch (ConfigDocumentLoadException configDocumentLoadException) {
                    Tr.error(tc, "ADMG0003E", configDocumentLoadException);
                }
            }
        }
        objectNameArray = new ObjectName[arrayList.size()];
        arrayList.toArray(objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAll", objectNameArray);
        }
        return objectNameArray;
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        block11: {
            String string;
            ConfigDataId configDataId;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
                }
                configDataId = ConfigServiceHelper.getConfigDataId(objectName);
                string = null;
                try {
                    string = ConfigServiceHelper.getConfigDataType(objectName);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Exception ", exception.getMessage());
                }
            }
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
            if (this.isRootDocumentType) {
                try {
                    repositoryContext.delete(true);
                }
                catch (WorkSpaceException workSpaceException) {
                    FFDCFilter.processException((Throwable)workSpaceException, "com.ibm.ws.management.configservice.RootObjectDelegator.deleteConfigData", "100", this);
                    throw new ConfigServiceException(workSpaceException, workSpaceException.getMessage());
                }
            } else {
                this.baseConfigService.deleteConfigDataBasic(session, objectName);
            }
            try {
                String string2 = configDataId.toString();
                this.notifyAuthzGroup(this.baseConfigService, session, string2, string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Exception ", exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    protected ObjectName getParent(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getParent", objectName);
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        ObjectName objectName2 = this.isRootDocumentType ? this.createObjectName(repositoryContext.getParent()) : this.createObjectName(repositoryContext);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getParent", objectName2);
        }
        return objectName2;
    }

    protected ObjectName[] getChildren(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo) throws ConfigServiceException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChildren", new Object[]{objectName, childTypeInfo});
        }
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        if (this.isRootDocumentType) {
            objectNameArray = repositoryContext.getChildren();
            Iterator iterator = objectNameArray.iterator();
            while (iterator.hasNext()) {
                RepositoryDocumentType repositoryDocumentType;
                RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "childContext", repositoryContext2.getName());
                }
                if ((repositoryDocumentType = repositoryContext2.getType().getRootDocumentType()) == null || !repositoryDocumentType.equals(this.documentType)) continue;
                arrayList.add(this.createObjectName(repositoryContext2));
            }
        } else if (repositoryContext.isAvailable(this.documentType.getFilePattern())) {
            objectNameArray = new ConfigDataId(repositoryContext.getURI(), this.documentType.getFilePattern());
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, (ConfigDataId)objectNameArray);
            try {
                ObjectName[] objectNameArray2 = docAccessor.getRootObjects(session);
                for (int i = 0; objectNameArray2 != null && i < objectNameArray2.length; ++i) {
                    if (!ConfigServiceHelper.getConfigDataType(objectNameArray2[i]).equals(this.getType())) continue;
                    arrayList.add(objectNameArray2[i]);
                }
            }
            catch (ConfigDataNotFoundException configDataNotFoundException) {
                FFDCFilter.processException((Throwable)configDataNotFoundException, "com.ibm.ws.management.configservice.RootObjectDelegator.getChildren", "152", this);
            }
        }
        objectNameArray = new ObjectName[arrayList.size()];
        arrayList.toArray(objectNameArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChildren", objectNameArray);
        }
        return objectNameArray;
    }

    protected String getName(AttributeList attributeList) throws InvalidAttributeValException {
        String string;
        try {
            string = ConfigServiceHelper.getAttributeValue(attributeList, "name").toString();
            if (!ConfigServiceHelper.checkIfNameValid(string)) {
                throw new InvalidAttributeValException(string);
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, objectName});
        }
        String string = this.getName(attributeList);
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        RepositoryContext repositoryContext2 = null;
        ObjectName objectName2 = null;
        if (this.isRootDocumentType) {
            try {
                if (string == null || string.length() == 0) {
                    throw new RequiredAttributeNotFoundException("name");
                }
                serializable = this.getTemplate(session, attributeList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template", serializable);
                }
                object = null;
                if (serializable != null) {
                    object = WorkspaceHelper.getConfigSession((ObjectName)serializable);
                }
                if (object == null) {
                    object = session;
                }
                WorkSpace workSpace = WorkspaceHelper.getWorkspace((Session)object);
                TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
                RepositoryContext repositoryContext3 = null;
                if (serializable != null) {
                    repositoryContext3 = WorkspaceHelper.getContext(workSpace, ConfigServiceHelper.getConfigDataId((ObjectName)serializable));
                }
                if (repositoryContext3 == null) {
                    repositoryContext = repositoryContext2 = repositoryContext.create(this.contextType, string);
                } else {
                    Template template = templateManager.getTemplate(repositoryContext3);
                    repositoryContext = repositoryContext2 = templateManager.createContext(repositoryContext, string, template, new HashMap(0));
                    repositoryContext.delete(this.documentType.getFilePattern());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "context", repositoryContext);
                }
            }
            catch (WorkSpaceException workSpaceException) {
                FFDCFilter.processException((Throwable)workSpaceException, "com.ibm.ws.management.configservice.RootObjectDelegator.createConfigObject", "182", this);
                throw new ConfigServiceException(workSpaceException, workSpaceException.getMessage());
            }
        }
        serializable = new ConfigDataId(repositoryContext.getURI(), this.documentType.getFilePattern());
        object = WorkspaceHelper.getDocAccessor(session, serializable);
        boolean bl = false;
        try {
            objectName2 = ((DocAccessor)object).createRootConfigObject(session, this.getType(), attributeList);
            ((DocAccessor)object).localSave();
            bl = true;
        }
        catch (InvalidConfigDataTypeException invalidConfigDataTypeException) {
            FFDCFilter.processException((Throwable)invalidConfigDataTypeException, "com.ibm.ws.management.configservice.RootObjectDelegator.createConfigObject", "194", this);
            Tr.error(tc, "ADMG0011E", invalidConfigDataTypeException);
        }
        finally {
            block26: {
                ((DocAccessor)object).cleanup();
                if (!bl && repositoryContext2 != null) {
                    try {
                        repositoryContext2.delete(true);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block26;
                        Tr.debug(tc, "unable to delete the context", exception);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", objectName2);
        }
        return objectName2;
    }

    protected ObjectName getTemplate(Session session, AttributeList attributeList) throws ConfigServiceException {
        ObjectName objectName = null;
        try {
            try {
                objectName = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Template");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                ObjectName objectName2;
                ObjectName[] objectNameArray;
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
                RepositoryContext repositoryContext = templateManager.getRootTemplateContext().findContext("default");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "defaultTemplate", repositoryContext);
                }
                if ((objectNameArray = this.baseConfigService.getAllBasic(session, objectName2 = MOFUtil.createObjectName(repositoryContext), this.getType(), true)).length > 0) {
                    objectName = objectNameArray[0];
                }
            }
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException((Throwable)workSpaceException, "com.ibm.ws.management.configservice.RootObjectDelegator.createConfigObject", "268", this);
            throw new ConfigServiceException(workSpaceException, workSpaceException.getMessage());
        }
        return objectName;
    }

    protected void setDocumentType(RepositoryDocumentType repositoryDocumentType) {
        this.documentType = repositoryDocumentType;
    }

    private void findAllMyTypeChildrenContext(RepositoryContext repositoryContext, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAllMyTypeChildrenContext", repositoryContext);
        }
        if (repositoryContext.getType().getName().equals(this.contextType.getName())) {
            list.add(this.createObjectName(repositoryContext));
        } else {
            List list2 = repositoryContext.getChildren();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "child", repositoryContext2);
                }
                if (repositoryContext2.getType().getName().equals(this.contextType.getName())) {
                    ObjectName objectName = this.createObjectName(repositoryContext2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "selected", objectName);
                    }
                    list.add(objectName);
                    continue;
                }
                this.findAllMyTypeChildrenContext(repositoryContext2, list);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAllMyTypeChildrenContext", list);
        }
    }

    private void notifyAuthzGroup(ConfigService configService, Session session, String string, String string2) throws Exception {
        final ConfigService configService2 = configService;
        final Session session2 = session;
        final String string3 = string;
        final String string4 = string2;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.removeResourceFromAuthorizationGroup(configService2, session2, string3, string4);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ConfigServiceException(privilegedActionException.getException());
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }
}

